/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.util.List;
import java.util.Stack;
import org.ow2.dsrg.fm.tbpjava.checker.AutomatonState;
import org.ow2.dsrg.fm.tbpjava.checker.VariablesEvaluation;
import org.ow2.dsrg.fm.tbplib.ltsa.Edge;
import org.ow2.dsrg.fm.tbplib.ltsa.State;

public final class AutomatonWalker {
    private Stack<AutomatonProcessingState> statesToProcess = new Stack();

    public void setStateToExplore(AutomatonState sourceAS, VariablesEvaluation variables, State state) {
        if (state.getEdges().isEmpty()) {
            return;
        }
        if (sourceAS.getAutomaton().getFin().equals(state)) {
            return;
        }
        AutomatonProcessingState newState = new AutomatonProcessingState(sourceAS, variables, state);
        if (this.cycleDetection(newState)) {
            this.statesToProcess.push(newState);
        }
    }

    public void setEdgeToExplore(AutomatonState sourceAS, VariablesEvaluation variables, Edge edge) {
        State newState = new State();
        newState.addEdge(edge);
        this.setStateToExplore(sourceAS, variables, newState);
    }

    public EdgeToProcess getNextStateToExplore(EdgeToProcess result) {
        if (this.statesToProcess.isEmpty()) {
            return null;
        }
        AutomatonProcessingState startAPS = this.statesToProcess.peek();
        List edges = startAPS.getState().getEdges();
        if (result == null) {
            result = new EdgeToProcess();
        }
        result.setAs(startAPS.getAs());
        result.setEdge((Edge)edges.get(startAPS.getProcessedEdges()));
        result.setVariables(startAPS.getVariables());
        startAPS.nextEdgeProcessed();
        if (edges.size() == startAPS.getProcessedEdges()) {
            this.statesToProcess.pop();
        }
        return result;
    }

    public void clean() {
        this.statesToProcess.clear();
    }

    private boolean cycleDetection(AutomatonProcessingState as) {
        for (AutomatonProcessingState savedAS : this.statesToProcess) {
            if (!savedAS.isSame(as)) continue;
            return false;
        }
        return true;
    }

    private static final class AutomatonProcessingState {
        private AutomatonState as;
        private State state;
        private int processedEdges;
        private VariablesEvaluation variables;

        public AutomatonProcessingState(AutomatonState as, VariablesEvaluation variables, State state) {
            assert (as != null);
            assert (state != null);
            this.as = as;
            this.state = state;
            this.variables = variables;
            this.processedEdges = 0;
        }

        public final AutomatonState getAs() {
            return this.as;
        }

        public final State getState() {
            return this.state;
        }

        public final int getProcessedEdges() {
            return this.processedEdges;
        }

        public final void nextEdgeProcessed() {
            assert (this.processedEdges < this.state.getEdges().size());
            if (this.processedEdges >= this.state.getEdges().size()) {
                throw new RuntimeException("Error in processing state automaton states - some edges processed multiple times");
            }
            ++this.processedEdges;
        }

        public final VariablesEvaluation getVariables() {
            return this.variables;
        }

        public boolean isSame(AutomatonProcessingState other) {
            assert (other != null);
            if (other == this) {
                return true;
            }
            return this.as == other.as && this.state == other.state && this.variables.equalsValues(other.variables);
        }
    }

    public static final class EdgeToProcess {
        private AutomatonState as;
        private Edge edge;
        private VariablesEvaluation variables;

        public EdgeToProcess() {
            this.as = null;
            this.edge = null;
            this.variables = null;
        }

        public EdgeToProcess(AutomatonState as, Edge edge, VariablesEvaluation variables) {
            this.as = as;
            this.edge = edge;
            this.variables = variables;
        }

        public final AutomatonState getAs() {
            return this.as;
        }

        public final Edge getEdge() {
            return this.edge;
        }

        public final VariablesEvaluation getVariables() {
            return this.variables;
        }

        public final void setAs(AutomatonState as) {
            this.as = as;
        }

        public final void setEdge(Edge edge) {
            this.edge = edge;
        }

        public final void setVariables(VariablesEvaluation variables) {
            this.variables = variables;
        }
    }
}

