/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ow2.dsrg.fm.tbplib.EventTable;
import org.ow2.dsrg.fm.tbplib.EventTableImpl;
import org.ow2.dsrg.fm.tbplib.ltsa.Automaton;
import org.ow2.dsrg.fm.tbplib.ltsa.Edge;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAAutomaton;
import org.ow2.dsrg.fm.tbplib.ltsa.State;
import org.ow2.dsrg.fm.tbplib.util.DOTPrintStream;

public class AutomatonToDot {
    private static int nodeid = 0;

    public static void toDot(Automaton a, EventTable et, OutputStream stream) {
        Set finals = a.getFinalStates();
        HashSet<State> visited = new HashSet<State>();
        HashMap<State, Integer> s_to_i = new HashMap<State, Integer>();
        ArrayDeque stack = new ArrayDeque();
        DOTPrintStream out = new DOTPrintStream(stream);
        out.println("node [height=0.2 width=0.2 shape = circle];");
        State start = a.getStartState();
        AutomatonToDot.printNode(out, start, finals, start, s_to_i, (EventTableImpl)et);
        visited.add(start);
        stack.push(start.getEdges().iterator());
        while (!stack.isEmpty()) {
            Iterator peek = (Iterator)stack.peek();
            if (peek.hasNext()) {
                State next = ((Edge)peek.next()).getTarget();
                if (visited.contains(next)) continue;
                AutomatonToDot.printNode(out, next, finals, start, s_to_i, (EventTableImpl)et);
                visited.add(next);
                stack.push(next.getEdges().iterator());
                continue;
            }
            stack.pop();
        }
        out.DOTclose();
        nodeid = 0;
    }

    private static int getId(State s, Map<State, Integer> s_to_i) {
        Integer integer = s_to_i.get(s);
        if (integer == null) {
            s_to_i.put(s, nodeid);
            integer = nodeid++;
        }
        return integer;
    }

    private static void printNode(DOTPrintStream out, State ds, Set<State> finals, State start, Map<State, Integer> s_to_i, EventTableImpl et) {
        out.peripheries = ds.equals(start) ? 2 : 1;
        out.filled = finals.contains(ds);
        int dsid = AutomatonToDot.getId(ds, s_to_i);
        out.node(dsid, ds.toString());
        for (Edge e : ds.getEdges()) {
            EventTableImpl.Event event = et.getEvent(e.getSymbol());
            String edge_label = Integer.toString(e.getSymbol());
            edge_label = edge_label + " Event=" + event;
            edge_label = edge_label + " EventClass=" + (event != null ? event.getClass().getSimpleName() : "???");
            edge_label = edge_label + " " + e.toString();
            out.edge(dsid, AutomatonToDot.getId(e.getTarget(), s_to_i), edge_label);
        }
        out.peripheries = 1;
        out.filled = false;
    }

    public static void toDot(LTSAAutomaton a, OutputStream stream) {
        HashSet<State> visited = new HashSet<State>();
        HashMap<State, Integer> s_to_i = new HashMap<State, Integer>();
        ArrayDeque stack = new ArrayDeque();
        DOTPrintStream out = new DOTPrintStream(stream);
        out.println("node [height=0.2 width=0.2 shape = circle];");
        State start = a.getStart();
        AutomatonToDot.printLSTANode(out, start, start, s_to_i);
        visited.add(start);
        stack.push(start.getEdges().iterator());
        while (!stack.isEmpty()) {
            Iterator peek = (Iterator)stack.peek();
            if (peek.hasNext()) {
                State next = ((Edge)peek.next()).getTarget();
                if (visited.contains(next)) continue;
                AutomatonToDot.printLSTANode(out, next, start, s_to_i);
                visited.add(next);
                stack.push(next.getEdges().iterator());
                continue;
            }
            stack.pop();
        }
        out.DOTclose();
        nodeid = 0;
    }

    private static void printLSTANode(DOTPrintStream out, State ds, State start, Map<State, Integer> s_to_i) {
        out.peripheries = ds.equals(start) ? 2 : 1;
        out.filled = false;
        int dsid = AutomatonToDot.getId(ds, s_to_i);
        out.node(dsid, ds.toString());
        for (Edge e : ds.getEdges()) {
            String edge_label = e.getData() == null ? "NULL" : e.getData().toString();
            edge_label = edge_label + " " + e.toString();
            out.edge(dsid, AutomatonToDot.getId(e.getTarget(), s_to_i), edge_label);
        }
        out.peripheries = 1;
        out.filled = false;
    }
}

