/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava.checker;

import org.ow2.dsrg.fm.tbplib.ltsa.Edge;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAAutomaton;
import org.ow2.dsrg.fm.tbplib.ltsa.State;

public final class AutomatonState {
    private final int threadNum;
    private final LTSAAutomaton automaton;
    private final State state;
    private final Edge edge;
    private final boolean edgeActionProcessed;
    private final int hashCode;
    private final int HASH_CONSTANT = 37;

    public AutomatonState(LTSAAutomaton automaton, State state, int threadNum) {
        assert (state != null);
        this.automaton = automaton;
        this.state = state;
        this.threadNum = threadNum;
        this.edge = null;
        this.edgeActionProcessed = true;
        this.hashCode = this.calculateHashCode();
    }

    public AutomatonState(AutomatonState source, Edge edge, boolean edgeActionProcessed) {
        assert (edge != null);
        this.automaton = source.automaton;
        this.state = edge == null ? null : edge.getTarget();
        this.threadNum = source.threadNum;
        this.edge = edge;
        this.edgeActionProcessed = edgeActionProcessed;
        this.hashCode = this.calculateHashCode();
    }

    private AutomatonState(int threadNum, LTSAAutomaton automaton, State state, Edge edge, boolean edgeActionProcessed) {
        assert (edge == null || state.equals(edge.getTarget()));
        this.threadNum = threadNum;
        this.automaton = automaton;
        this.state = state;
        this.edge = edge;
        this.edgeActionProcessed = edgeActionProcessed;
        this.hashCode = this.calculateHashCode();
    }

    public AutomatonState edgeActionProcessed() {
        assert (!this.edgeActionProcessed);
        return new AutomatonState(this.threadNum, this.automaton, this.state, this.edge, true);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.hashCode != obj.hashCode()) {
            return false;
        }
        AutomatonState other = (AutomatonState)obj;
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        return this.threadNum == other.threadNum;
    }

    public final int getThreadNum() {
        return this.threadNum;
    }

    public final LTSAAutomaton getAutomaton() {
        return this.automaton;
    }

    public final State getState() {
        return this.state;
    }

    public final Edge getEdge() {
        return this.edge;
    }

    public final boolean getEdgeActionProcessed() {
        return this.edgeActionProcessed;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append("state=");
        sb.append(this.state);
        sb.append(", automaton=");
        sb.append(this.automaton);
        sb.append(", edge=");
        sb.append(this.edge);
        sb.append("[" + (this.edge == null ? "null" : this.edge.getData()) + "]");
        sb.append(']');
        return sb.toString();
    }

    private final int calculateHashCode() {
        int result = 0;
        result = result * 37 + (this.edgeActionProcessed ? 1 : 0);
        result = result * 37 + (this.edge != null ? this.edge.hashCode() : 0);
        result = result * 37 + this.state.hashCode();
        result = result * 37 + this.threadNum;
        return result;
    }
}

