/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.dsrg.fm.tbpjava;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.RecognitionException;
import org.ow2.dsrg.fm.tbpjava.envgen.CodeGenerator;
import org.ow2.dsrg.fm.tbpjava.envgen.Indenter;
import org.ow2.dsrg.fm.tbpjava.envgen.ProvisionToString;
import org.ow2.dsrg.fm.tbpjava.envgen.StubGenerator;
import org.ow2.dsrg.fm.tbpjava.envgen.VisitorTypeCheck;
import org.ow2.dsrg.fm.tbpjava.utils.Configuration;
import org.ow2.dsrg.fm.tbpjava.utils.LineCouningOutputStream;
import org.ow2.dsrg.fm.tbpjava.utils.Type2String;
import org.ow2.dsrg.fm.tbplib.EventTable;
import org.ow2.dsrg.fm.tbplib.EventTableImpl;
import org.ow2.dsrg.fm.tbplib.ltsa.LTSAComponentSpecification;
import org.ow2.dsrg.fm.tbplib.parsed.ParsedComponentSpecification;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedAccept;
import org.ow2.dsrg.fm.tbplib.parsed.TBPParsedProvisionContainerNode;
import org.ow2.dsrg.fm.tbplib.parser.ParserFacade;
import org.ow2.dsrg.fm.tbplib.resolved.ResolvedComponentSpecification;

public class EnvGenerator {
    private static final boolean DEBUG = false;
    public static final String CLASS_NAME_SEPARAROT_COMPONENT_PROVISION = "_";
    public static final String PROPERTY_COMPONENT_INSTANCE = "comp";
    public static final String PROPERTY_INTERFACES_PREXIF = "iface_";
    public static final String METHOD_GENERATED_PROTOCOL_NAME = "runEnvironment";
    public static final String SOFA_SERVER_FULL_NAME = "org.objectweb.dsrg.sofa.SOFAServer";
    public static final String SOFA_CLIENT_FULL_NAME = "org.objectweb.dsrg.sofa.SOFAClient";
    public static final String FRACTAL_BINDING_CONTROLER_FULL_NAME = "org.objectweb.fractal.api.control.BindingController";
    public static final String METHOD_MAIN_INSTANCE_NAME = "inst";
    public static final String PROVISIONS_ANONYMOUS_SUFFIX = "anon_";
    public static final boolean EXCEPTIONS_STOP_ON_EXCEPTION = true;
    private int cntAnonynousProvisions = 0;
    private PrintStream infoStream = null;
    private Configuration config = null;
    private ParsedComponentSpecification spec = null;

    public EnvGenerator(Configuration config, PrintStream outStream) {
        this.config = config;
        this.infoStream = outStream;
    }

    public ParsedComponentSpecification getComponentSpecification() {
        return this.spec;
    }

    public LTSAComponentSpecification getComponentLTSA() {
        EventTableImpl et = new EventTableImpl();
        ResolvedComponentSpecification resolve = this.spec.resolve((EventTable)et);
        LTSAComponentSpecification result = resolve.makeLTSA((EventTable)et);
        return result;
    }

    public Map<String, EnvironmentDescription> generateEnvironments() {
        this.spec = null;
        try {
            this.spec = ParserFacade.parseFile((String)this.config.getEnvProtocol());
        }
        catch (IOException e) {
            this.infoStream.println("Invalid input file name");
            return null;
        }
        catch (RecognitionException e) {
            this.infoStream.println("Syntax error in specification file");
            return null;
        }
        VisitorTypeCheck specCheck = new VisitorTypeCheck(this.config, this.infoStream);
        if (specCheck.completeCheck(this.spec)) {
            return null;
        }
        HashMap<String, EnvironmentDescription> result = new HashMap<String, EnvironmentDescription>();
        this.spec.limitReentrancy(this.config.getComponentReentrancyLimit());
        List provisions = this.spec.getProvisions();
        for (TBPParsedProvisionContainerNode node : provisions) {
            this.infoStream.println("Processing " + node.getName() + " provision.");
            EnvironmentDescription ed = this.generateEnvironment(node);
            if (ed == null) continue;
            result.put(ed.mainClassName, ed);
        }
        return result;
    }

    private void checkExistenceNonparametricConstructor(String className, boolean notFoundWarning) {
        Class<?> checkedClass = null;
        try {
            checkedClass = Thread.currentThread().getContextClassLoader().loadClass(Type2String.removeGenerics(className));
        }
        catch (ClassNotFoundException e) {
            if (notFoundWarning) {
                this.infoStream.println("Info - Class " + Type2String.removeGenerics(className) + " cannot be found. Cann't check existence of nonparametric constructor.");
            } else {
                this.infoStream.println("Error - Class " + Type2String.removeGenerics(className) + " cannot be found.");
            }
            return;
        }
        try {
            checkedClass.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            if (notFoundWarning) {
                this.infoStream.println("Info - Class " + className + " cannot accessed (Security manager blocks access). Cann't check existence of nonparametric constructor.");
            } else {
                this.infoStream.println("Error -  Class " + className + " cannot accessed (Security manager blocks access).");
            }
        }
        catch (NoSuchMethodException e) {
            this.infoStream.println("Error - Class " + className + " has to have a non-parametric constructor.");
        }
    }

    private EnvironmentDescription generateEnvironment(TBPParsedProvisionContainerNode node) {
        String envClassName;
        if (node == null) {
            return null;
        }
        String provisionName = node.getName();
        if (provisionName == null) {
            ++this.cntAnonynousProvisions;
            provisionName = PROVISIONS_ANONYMOUS_SUFFIX + Integer.toString(this.cntAnonynousProvisions);
        }
        String envClassFullName = envClassName = this.config.getComponentName() + CLASS_NAME_SEPARAROT_COMPONENT_PROVISION + provisionName;
        String pkgComponent = this.config.getComponentImplementationClasses().get(0);
        if ((pkgComponent = StubGenerator.getPackage(Type2String.removeGenerics(pkgComponent))) != null) {
            envClassFullName = pkgComponent + "." + envClassName;
        }
        String envFileName = this.config.getEnvTargetDir() + CodeGenerator.patchName(envClassFullName.replace('.', '/')) + ".java";
        EnvironmentDescription result = new EnvironmentDescription();
        result.mainClassName = envClassFullName;
        this.prepareEnvironmentDescription(true, result);
        if (this.config.getEnvGenerate()) {
            LineCouningOutputStream outFile = null;
            try {
                StubGenerator.generateDirectoryStructureForFile(envFileName);
                outFile = new LineCouningOutputStream(envFileName);
            }
            catch (FileNotFoundException e) {
                this.infoStream.println("Error - File (" + envFileName + ") creation error.");
                return null;
            }
            this.infoStream.println(new ProvisionToString(ProvisionToString.Style.STYLE_COMPACT, false).visitParsedProvisionContainerNode(node));
            Indenter indenter = new Indenter(outFile.getPrintStream());
            CodeGenerator provisionParser = new CodeGenerator(this.infoStream, outFile, indenter, result, this.config);
            this.genInitialClassCode(outFile, indenter, envClassName, envClassFullName, pkgComponent);
            this.genProperties(outFile, indenter, result);
            this.genConstructor(outFile, indenter, envClassName, result);
            this.genProtocolCode(outFile, indenter, provisionParser, node, result);
            this.genMain(outFile, indenter, envClassName);
            this.genEndingClassCode(outFile, indenter);
            outFile.close();
        } else {
            this.genConstructor(null, null, envClassName, result);
        }
        return result;
    }

    private boolean prepareEnvironmentDescription(boolean notFoundWarning, EnvironmentDescription envDesc) {
        boolean result = this.prepareEnvironmentDescriptionProvidedInterfaces(notFoundWarning, envDesc);
        if (!result) {
            result = this.generateEnvironmentDescriptionRequiredInterfaces(notFoundWarning, envDesc);
        }
        return result;
    }

    private boolean generateEnvironmentDescriptionRequiredInterfaces(boolean notFoundWarning, EnvironmentDescription envDesc) {
        Configuration.RequiredInterfaceSettingMethod method = this.config.getEnvRequierdItfcSettingMethod();
        switch (method) {
            case SETTERS: {
                HashMap interfaceNameToClass = new HashMap();
                for (Map.Entry<String, String> entry : this.config.getComponentRequiredInterfaces().entrySet()) {
                    Class<?> itfsImplClass = this.getClass(entry.getValue(), "Component required interface " + entry.getValue() + "not found. Cannot verify setters of the component", "", false);
                    if (itfsImplClass == null) continue;
                    if (!itfsImplClass.isInterface()) {
                        this.infoStream.println("Error - " + entry.getValue() + " is not interface. Wrong definition of required interfaces. Check configuration.");
                        continue;
                    }
                    interfaceNameToClass.put(entry.getKey(), itfsImplClass);
                }
                if (interfaceNameToClass.size() != this.config.getComponentRequiredInterfaces().size()) {
                    return true;
                }
                for (String string : this.config.getComponentImplementationClasses()) {
                    String compFieldName = envDesc.compImpl2envFieldName.get(string);
                    Class<?> compImplClass = this.getClass(string, "Component class " + string + " not found. Cannot create component to required interface mapping", "", notFoundWarning);
                    if (compImplClass == null) continue;
                    for (Map.Entry<String, String> reqItfsEntry : this.config.getComponentRequiredInterfaces().entrySet()) {
                        Class reqItfsClass = (Class)interfaceNameToClass.get(reqItfsEntry.getKey());
                        try {
                            int modifiers;
                            Method setter = compImplClass.getMethod("set" + reqItfsEntry.getKey(), reqItfsClass);
                            if (setter == null || Modifier.isAbstract(modifiers = setter.getModifiers()) || !Modifier.isPublic(modifiers)) continue;
                            if (envDesc.reqItfs2envFielName.containsKey(reqItfsEntry.getKey())) {
                                this.infoStream.println("Error - Setter for " + reqItfsEntry.getKey() + " is implemented by more component classes. Only a single instance for each provided interface type is permitted.");
                                return true;
                            }
                            envDesc.reqItfs2envFielName.put(reqItfsEntry.getKey(), compFieldName);
                        }
                        catch (NoSuchMethodException e) {}
                    }
                }
                if (envDesc.reqItfs2envFielName.size() == this.config.getComponentRequiredInterfaces().size()) break;
                for (Map.Entry entry : this.config.getComponentRequiredInterfaces().entrySet()) {
                    if (envDesc.reqItfs2envFielName.containsKey(entry.getKey())) continue;
                    this.infoStream.println("Error - " + (String)entry.getKey() + " interface cannot be set for any component. No public set" + (String)entry.getKey() + "(" + (String)entry.getValue() + ") method found.");
                }
                return true;
            }
            case SOFA2_CLIENT: {
                String primaryComponentClassName = this.config.getComponentImplementationClasses().get(0);
                String primaryCompFieldName = envDesc.compImpl2envFieldName.get(primaryComponentClassName);
                assert (primaryCompFieldName != null);
                for (String reqItfs : this.config.getComponentRequiredInterfaces().keySet()) {
                    envDesc.reqItfs2envFielName.put(reqItfs, primaryCompFieldName);
                }
                Class<?> clazz = this.getClass(primaryComponentClassName, "Component class " + primaryComponentClassName + " not found", "Cannot check whether component implements SOFAClient interfaces.", notFoundWarning);
                if (clazz == null) {
                    return !notFoundWarning;
                }
                Class<?> ifaceSofaClientClass = this.getClass(SOFA_CLIENT_FULL_NAME, "Interface org.objectweb.dsrg.sofa.SOFAClient not found.", "Cannot check that interface is implemented by component.", notFoundWarning);
                if (ifaceSofaClientClass == null) {
                    return !notFoundWarning;
                }
                if (ifaceSofaClientClass.isAssignableFrom(clazz)) break;
                this.infoStream.println("Error - Interface org.objectweb.dsrg.sofa.SOFAClient is not implemented by component.");
                return true;
            }
            case FRACTAL: {
                String primaryComponentClassName = this.config.getComponentImplementationClasses().get(0);
                String primaryCompFieldName = envDesc.compImpl2envFieldName.get(primaryComponentClassName);
                assert (primaryCompFieldName != null);
                for (String reqItfs : this.config.getComponentRequiredInterfaces().keySet()) {
                    envDesc.reqItfs2envFielName.put(reqItfs, primaryCompFieldName);
                }
                Class<?> clazz = this.getClass(primaryComponentClassName, "Component class " + primaryComponentClassName + " not found", "Cannot check whether component implements Fractor BindingControler interfaces.", notFoundWarning);
                if (clazz == null) {
                    return !notFoundWarning;
                }
                Class<?> ifaceFractalBindingControler = this.getClass(FRACTAL_BINDING_CONTROLER_FULL_NAME, "Interface org.objectweb.fractal.api.control.BindingController not found.", "Cannot check that interface is implemented by component.", notFoundWarning);
                if (ifaceFractalBindingControler == null) {
                    return !notFoundWarning;
                }
                if (ifaceFractalBindingControler.isAssignableFrom(clazz)) break;
                this.infoStream.println("Error - Interface org.objectweb.fractal.api.control.BindingController is not implemented by component.");
                return true;
            }
            case FIELDS: {
                HashMap interfaceNameToClass = new HashMap();
                for (Map.Entry<String, String> entry : this.config.getComponentRequiredInterfaces().entrySet()) {
                    Class<?> itfsImplClass = this.getClass(entry.getValue(), "Component required interface " + entry.getValue() + "not found. Cannot fields of the component", "", false);
                    if (itfsImplClass == null) continue;
                    if (!itfsImplClass.isInterface()) {
                        this.infoStream.println("Error - " + entry.getValue() + " is not interface. Wrong definition of required interfaces. Check configuration.");
                        continue;
                    }
                    interfaceNameToClass.put(entry.getKey(), itfsImplClass);
                }
                if (interfaceNameToClass.size() != this.config.getComponentRequiredInterfaces().size()) {
                    return true;
                }
                for (String string : this.config.getComponentImplementationClasses()) {
                    String compFieldName = envDesc.compImpl2envFieldName.get(string);
                    Class<?> compImplClass = this.getClass(string, "Component class " + string + " not found. Cannot create component to required interface mapping", "", notFoundWarning);
                    if (compImplClass == null) continue;
                    for (Map.Entry<String, String> reqItfsEntry : this.config.getComponentRequiredInterfaces().entrySet()) {
                        Class reqItfsClass = (Class)interfaceNameToClass.get(reqItfsEntry.getKey());
                        try {
                            int modifiers;
                            Field field = compImplClass.getField(reqItfsEntry.getKey());
                            if (field == null || !Modifier.isPublic(modifiers = field.getModifiers()) || !field.getType().isAssignableFrom(reqItfsClass)) continue;
                            if (envDesc.reqItfs2envFielName.containsKey(reqItfsEntry.getKey())) {
                                this.infoStream.println("Error - Field " + reqItfsEntry.getKey() + " can be found in more compoent classes. Only one public field with this name is permited within all component classes.");
                                return true;
                            }
                            envDesc.reqItfs2envFielName.put(reqItfsEntry.getKey(), compFieldName);
                        }
                        catch (NoSuchFieldException e) {
                            String compPkg = StubGenerator.getPackage(string);
                            String envPkg = StubGenerator.getPackage(envDesc.mainClassName);
                            if (!(compPkg == null && envPkg == null || compPkg != null && compPkg.equals(envPkg))) continue;
                            try {
                                Field field = compImplClass.getDeclaredField(reqItfsEntry.getKey());
                                int modifiers = field.getModifiers();
                                if (Modifier.isPrivate(modifiers) || Modifier.isProtected(modifiers) || !field.getType().isAssignableFrom(reqItfsClass)) continue;
                                if (envDesc.reqItfs2envFielName.containsKey(reqItfsEntry.getKey())) {
                                    this.infoStream.println("Error - Field " + reqItfsEntry.getKey() + " can be found in more compoent classes. Only one public field with this name is permited within all component classes.");
                                    return true;
                                }
                                envDesc.reqItfs2envFielName.put(reqItfsEntry.getKey(), compFieldName);
                            }
                            catch (NoSuchFieldException e2) {}
                        }
                    }
                }
                if (envDesc.reqItfs2envFielName.size() == this.config.getComponentRequiredInterfaces().size()) break;
                for (Map.Entry entry : this.config.getComponentRequiredInterfaces().entrySet()) {
                    if (envDesc.reqItfs2envFielName.containsKey(entry.getKey())) continue;
                    this.infoStream.println("Error - " + (String)entry.getKey() + " interface cannot be set for any component. No component has public field with " + (String)entry.getKey() + " name and " + (String)entry.getValue() + " type.");
                }
                return true;
            }
            default: {
                throw new RuntimeException("Internal error - Unknown value of enum " + Configuration.RequiredInterfaceSettingMethod.class.getName() + " value is" + (Object)((Object)method));
            }
        }
        return false;
    }

    private boolean prepareEnvironmentDescriptionProvidedInterfaces(boolean notFoundWarning, EnvironmentDescription result) {
        if (this.config.getEnvProvidedItfsAccesMethod() == Configuration.ProvidedInterfaceAccessMethod.COMPONENT_CLASSES) {
            for (String componentClassName : this.config.getComponentImplementationClasses()) {
                result.compImpl2envFieldName.put(componentClassName, PROPERTY_INTERFACES_PREXIF + CodeGenerator.patchName(componentClassName));
            }
            HashMap interfaceNameToClass = new HashMap();
            for (Map.Entry<String, String> entry : this.config.getComponentProvidedInterfaces().entrySet()) {
                Class<?> itfsImplClass = this.getClass(entry.getValue(), "Component provided interface " + entry.getValue() + "not found. Cannot create component classes to provided interface mapping", "", false);
                if (itfsImplClass == null) continue;
                if (!itfsImplClass.isInterface()) {
                    this.infoStream.println("Error - " + entry.getValue() + " is not interface. Wrong definition of provided interfaces. Check configuration.");
                    continue;
                }
                interfaceNameToClass.put(entry.getKey(), itfsImplClass);
            }
            if (interfaceNameToClass.size() != this.config.getComponentProvidedInterfaces().size()) {
                return true;
            }
            for (String string : this.config.getComponentImplementationClasses()) {
                String compFieldName = result.compImpl2envFieldName.get(string);
                Class<?> compImplClass = this.getClass(string, "Component class " + string + " not found. Cannot create component to provided interface mapping", "", notFoundWarning);
                if (compImplClass == null) continue;
                for (Map.Entry itfsPair : interfaceNameToClass.entrySet()) {
                    if (!((Class)itfsPair.getValue()).isAssignableFrom(compImplClass)) continue;
                    if (result.provItfs2envFieldName.containsKey(itfsPair.getKey())) {
                        this.infoStream.println("Error - " + (String)itfsPair.getKey() + " is implemented by more component classes. Only single instance for each provided interface type is permitted.");
                        return true;
                    }
                    result.provItfs2envFieldName.put((String)itfsPair.getKey(), compFieldName);
                }
            }
            if (result.provItfs2envFieldName.size() != this.config.getComponentProvidedInterfaces().size()) {
                for (Map.Entry entry : this.config.getComponentProvidedInterfaces().entrySet()) {
                    if (result.provItfs2envFieldName.containsKey(entry.getKey())) continue;
                    this.infoStream.println("Error - " + (String)entry.getKey() + " interface is not implemented by any component class.");
                }
                return true;
            }
        } else if (this.config.getEnvProvidedItfsAccesMethod() == Configuration.ProvidedInterfaceAccessMethod.SEPARATE_CLASSES) {
            for (String ifaceName : this.config.getComponentProvidedInterfaces().keySet()) {
                String string = PROPERTY_INTERFACES_PREXIF + CodeGenerator.patchName(ifaceName);
                result.provItfs2envFieldName.put(ifaceName, PROPERTY_INTERFACES_PREXIF + CodeGenerator.patchName(string));
            }
            String primaryComponentClassName = this.config.getComponentImplementationClasses().get(0);
            result.compImpl2envFieldName.put(primaryComponentClassName, PROPERTY_COMPONENT_INSTANCE);
            Class<?> checkedComponentClass = this.getClass(primaryComponentClassName, "Component class " + primaryComponentClassName + " not found", "Cannot check provided interfaces validity.", notFoundWarning);
            if (checkedComponentClass == null) {
                return !notFoundWarning;
            }
            Class<?> clazz = this.getClass(SOFA_SERVER_FULL_NAME, "Interface org.objectweb.dsrg.sofa.SOFAServer not found.", "Cannot check that interface is implemented by component.", notFoundWarning);
            if (clazz == null) {
                return !notFoundWarning;
            }
            if (!clazz.isAssignableFrom(checkedComponentClass)) {
                this.infoStream.println("Error - Interface org.objectweb.dsrg.sofa.SOFAServer is not implemented by component.");
                return true;
            }
        } else {
            throw new RuntimeException("Internal error - Unknown value of enum " + Configuration.ProvidedInterfaceAccessMethod.class.getName() + " value is" + (Object)((Object)this.config.getEnvProvidedItfsAccesMethod()));
        }
        return false;
    }

    private Class<?> getClass(String className, String errorMessage, String infoMessageSuffix, boolean warningIfClassNotFound) {
        Class<?> result = null;
        try {
            result = Thread.currentThread().getContextClassLoader().loadClass(Type2String.removeGenerics(className));
        }
        catch (ClassNotFoundException e) {
            if (warningIfClassNotFound) {
                this.infoStream.println("Info - " + errorMessage + " " + infoMessageSuffix);
            } else {
                this.infoStream.println("Error - " + errorMessage);
            }
            return null;
        }
        return result;
    }

    private void genInitialClassCode(LineCouningOutputStream outFile, Indenter indenter, String envClassName, String fullClassName, String pkgComponent) {
        pkgComponent = pkgComponent != null ? "package " + pkgComponent + ";" : "// default package;";
        if (this.config.getEnvGenerate()) {
            indenter.indent();
            outFile.println("// EnvGenerator");
            indenter.indent();
            outFile.println(pkgComponent);
            indenter.indent();
            outFile.println();
            indenter.indent();
            outFile.println("import gov.nasa.jpf.jvm.Verify;");
            indenter.indent();
            outFile.println("import org.ow2.dsrg.fm.tbpjava.envgen.EnvValueSets;");
            indenter.indent();
            outFile.println();
            indenter.indent();
            outFile.println("public class " + envClassName + " {");
            indenter.addLevel();
        }
    }

    private void genProperties(LineCouningOutputStream outFile, Indenter indenter, EnvironmentDescription result) {
        indenter.indent();
        outFile.println();
        indenter.indent();
        outFile.println("private EnvValueSets envValues;");
        indenter.indent();
        outFile.println();
        for (Map.Entry<String, String> fieldEntry : result.compImpl2envFieldName.entrySet()) {
            indenter.indent();
            outFile.println("private " + fieldEntry.getKey() + " " + fieldEntry.getValue() + ";");
        }
        indenter.indent();
        outFile.println();
        if (this.config.getEnvProvidedItfsAccesMethod() == Configuration.ProvidedInterfaceAccessMethod.SEPARATE_CLASSES) {
            indenter.indent();
            outFile.println();
            for (String provIfaceName : this.config.getComponentProvidedInterfaces().keySet()) {
                String provIfaceType = this.config.getComponentProvidedInterfaces().get(provIfaceName);
                String provIfacePropertyName = result.provItfs2envFieldName.get(provIfaceName);
                indenter.indent();
                outFile.println("private " + provIfaceType + " " + provIfacePropertyName + ";");
            }
        }
    }

    private void genConstructor(LineCouningOutputStream outFile, Indenter indenter, String envClassName, EnvironmentDescription envDesc) {
        if (this.config.getEnvGenerate()) {
            String interfaceName;
            String envFieldName;
            String reqItfsName;
            Iterator<Object> i$;
            indenter.indent();
            outFile.println();
            indenter.indent();
            outFile.println("public " + envClassName + "() {");
            indenter.addLevel();
            indenter.indent();
            outFile.println("try {");
            indenter.addLevel();
            indenter.indent();
            outFile.println();
            indenter.indent();
            outFile.println("envValues= new " + this.config.getEnvValueSets() + "();");
            indenter.indent();
            outFile.println();
            for (Map.Entry<String, String> implClassEntry : envDesc.compImpl2envFieldName.entrySet()) {
                indenter.indent();
                outFile.println(implClassEntry.getValue() + " = new " + this.generateComponentConstructorCall(implClassEntry.getKey()) + ";");
            }
            if (this.config.getEnvRequierdItfcSettingMethod() == Configuration.RequiredInterfaceSettingMethod.SETTERS) {
                i$ = this.config.getComponentRequiredInterfaces().keySet().iterator();
                while (i$.hasNext()) {
                    String setterName = reqItfsName = (String)i$.next();
                    envFieldName = envDesc.reqItfs2envFielName.get(reqItfsName);
                    indenter.indent();
                    outFile.println(envFieldName + ".set" + setterName + "( new " + StubGenerator.getGeneratedClassFullName(reqItfsName, this.config) + Type2String.getGenerics(this.config.getComponentRequiredInterfaces().get(reqItfsName)) + "(" + "envValues" + "));");
                }
            } else if (this.config.getEnvRequierdItfcSettingMethod() == Configuration.RequiredInterfaceSettingMethod.SOFA2_CLIENT) {
                i$ = this.config.getComponentRequiredInterfaces().keySet().iterator();
                while (i$.hasNext()) {
                    interfaceName = reqItfsName = (String)i$.next();
                    envFieldName = envDesc.reqItfs2envFielName.get(reqItfsName);
                    indenter.indent();
                    outFile.println(envFieldName + ".setRequired(" + interfaceName + "( new " + StubGenerator.getGeneratedClassFullName(reqItfsName, this.config) + Type2String.getGenerics(this.config.getComponentRequiredInterfaces().get(reqItfsName)) + "(" + "envValues" + "));");
                }
            } else if (this.config.getEnvRequierdItfcSettingMethod() == Configuration.RequiredInterfaceSettingMethod.FRACTAL) {
                i$ = this.config.getComponentRequiredInterfaces().keySet().iterator();
                while (i$.hasNext()) {
                    interfaceName = reqItfsName = (String)i$.next();
                    envFieldName = envDesc.reqItfs2envFielName.get(reqItfsName);
                    indenter.indent();
                    outFile.println(envFieldName + ".bindFc(\"" + interfaceName + "\", new " + StubGenerator.getGeneratedClassFullName(reqItfsName, this.config) + Type2String.getGenerics(this.config.getComponentRequiredInterfaces().get(reqItfsName)) + "(" + "envValues" + "));");
                }
            } else if (this.config.getEnvRequierdItfcSettingMethod() == Configuration.RequiredInterfaceSettingMethod.FIELDS) {
                i$ = this.config.getComponentRequiredInterfaces().keySet().iterator();
                while (i$.hasNext()) {
                    interfaceName = reqItfsName = (String)i$.next();
                    envFieldName = envDesc.reqItfs2envFielName.get(reqItfsName);
                    indenter.indent();
                    outFile.println(envFieldName + "." + interfaceName + " = new " + StubGenerator.getGeneratedClassFullName(reqItfsName, this.config) + Type2String.getGenerics(this.config.getComponentRequiredInterfaces().get(reqItfsName)) + "(" + "envValues" + ");");
                }
            } else {
                throw new RuntimeException("Internal error - Unknown value of enum " + Configuration.RequiredInterfaceSettingMethod.class.getName() + " value is" + (Object)((Object)this.config.getEnvRequierdItfcSettingMethod()));
            }
            indenter.indent();
            outFile.println();
        }
        if (this.config.getEnvProvidedItfsAccesMethod() == Configuration.ProvidedInterfaceAccessMethod.SEPARATE_CLASSES) {
            for (Map.Entry<String, String> provIfaceEntry : envDesc.provItfs2envFieldName.entrySet()) {
                if (this.config.getEnvRequierdItfcSettingMethod() == Configuration.RequiredInterfaceSettingMethod.SOFA2_CLIENT) {
                    String primaryComponentClassName = this.config.getComponentImplementationClasses().get(0);
                    String primaryComponentFieldName = envDesc.compImpl2envFieldName.get(primaryComponentClassName);
                    assert (primaryComponentFieldName != null);
                    indenter.indent();
                    outFile.println(provIfaceEntry.getValue() + " = " + primaryComponentFieldName + ".getProvided(\"" + provIfaceEntry.getKey() + "\";");
                    continue;
                }
                if (this.config.getEnvRequierdItfcSettingMethod() == Configuration.RequiredInterfaceSettingMethod.SETTERS || this.config.getEnvRequierdItfcSettingMethod() == Configuration.RequiredInterfaceSettingMethod.FRACTAL || this.config.getEnvRequierdItfcSettingMethod() == Configuration.RequiredInterfaceSettingMethod.FIELDS) {
                    throw new RuntimeException("Internal error - Unsupported configuration combination. " + Configuration.ProvidedInterfaceAccessMethod.SEPARATE_CLASSES.toString() + " can be used onyl with " + (Object)((Object)Configuration.RequiredInterfaceSettingMethod.SOFA2_CLIENT));
                }
                throw new RuntimeException("Internal error - Unknown value of enum " + Configuration.RequiredInterfaceSettingMethod.class.getName() + " value is" + (Object)((Object)this.config.getEnvRequierdItfcSettingMethod()));
            }
        } else if (this.config.getEnvProvidedItfsAccesMethod() != Configuration.ProvidedInterfaceAccessMethod.COMPONENT_CLASSES) {
            throw new RuntimeException("Internal error - Unknown value of enum " + Configuration.ProvidedInterfaceAccessMethod.class.getName() + " value is" + (Object)((Object)this.config.getEnvProvidedItfsAccesMethod()));
        }
        indenter.removeLevel();
        indenter.indent();
        outFile.println("} catch (Throwable e) {");
        indenter.addLevel();
        indenter.indent();
        outFile.println("throw new RuntimeException(e);");
        indenter.removeLevel();
        indenter.indent();
        outFile.println("}");
        indenter.removeLevel();
        indenter.indent();
        outFile.println("}");
    }

    private String generateComponentConstructorCall(String className) {
        Class<?> compImplClass = this.getClass(className, "Component class " + className + " not found. Cannot generate constructor call", "", true);
        if (compImplClass == null) {
            return className + "(); // Error - EnvGenerator cannot found " + className + " class. Assuming non-parametric constructor exists.";
        }
        try {
            Constructor<?> constructor = compImplClass.getConstructor(new Class[0]);
            int constructorModifier = constructor.getModifiers();
            if (Modifier.isPublic(constructorModifier)) {
                return className + "()";
            }
        }
        catch (SecurityException e) {
            this.infoStream.println("Error -  Class " + className + " cannot be accessed (Security manager blocks access).");
            return className + "(); // Error - EnvGenerator cannot get constructors of " + className + " class. Assuming non-parametric constructor exists.";
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            Constructor<?>[] constructors = compImplClass.getConstructors();
            Arrays.sort(constructors, 0, constructors.length, new Comparator<Constructor<?>>(){

                @Override
                public int compare(Constructor<?> left, Constructor<?> right) {
                    int leftParams = left.getParameterTypes().length;
                    int rightParams = right.getParameterTypes().length;
                    int result = rightParams - leftParams;
                    if (result == 0) {
                        String leftStr = left.toGenericString();
                        String rightStr = right.toGenericString();
                        result = leftStr.compareTo(rightStr);
                    }
                    return result;
                }
            });
            for (Constructor<?> constructor : constructors) {
                int constructorModifier = constructor.getModifiers();
                if (!Modifier.isPublic(constructorModifier)) continue;
                StringBuffer result = new StringBuffer();
                result.append(className);
                result.append('(');
                Type[] params = constructor.getGenericParameterTypes();
                for (int i = 0; i < params.length; ++i) {
                    result.append(StubGenerator.genCodeObtainingValue(params[i], this.config.getComponentName(), className, "__CONSTRUCTOR__"));
                    if (i >= params.length - 1) continue;
                    result.append(", ");
                }
                result.append(')');
                return result.toString();
            }
        }
        catch (SecurityException e) {
            this.infoStream.println("Error -  Class " + className + " cannot be accessed (Security manager blocks access).");
            return "null; throw new RuntimeException(\"Error - EnvGenerator cannot get constructors of " + className + " class. Cannot generate proper constructor call.\")";
        }
        return "null; throw new RuntimeException(\"Error - no suitable (public) constructor in " + className + " class found. Cannot generate proper constructor call.\")";
    }

    private void genProtocolCode(LineCouningOutputStream outFile, Indenter indenter, CodeGenerator provisionParser, TBPParsedProvisionContainerNode node, EnvironmentDescription envDesc) {
        Indenter.IndentLevel originalLevel = indenter.getIndentLevel();
        indenter.indent();
        outFile.println();
        indenter.indent();
        outFile.println("public void runEnvironment() {");
        indenter.addLevel();
        indenter.indent();
        outFile.println("try {");
        provisionParser.generateCode(node);
        indenter.restoreIndentLevel(originalLevel);
        indenter.addLevel();
        indenter.indent();
        outFile.println("} catch (Throwable e) {");
        indenter.addLevel();
        indenter.indent();
        outFile.println("throw new RuntimeException(e);");
        indenter.removeLevel();
        indenter.indent();
        outFile.println("}");
        indenter.restoreIndentLevel(originalLevel);
        indenter.indent();
        outFile.println("}");
    }

    private void genMain(LineCouningOutputStream outFile, Indenter indenter, String envClassName) {
        indenter.indent();
        outFile.println();
        indenter.indent();
        outFile.println("public static void main(String[] args) {");
        indenter.addLevel();
        indenter.indent();
        outFile.println(envClassName + " " + METHOD_MAIN_INSTANCE_NAME + " = new " + envClassName + "();");
        indenter.indent();
        outFile.println("inst.runEnvironment();");
        indenter.removeLevel();
        indenter.indent();
        outFile.println("}");
    }

    private void genEndingClassCode(LineCouningOutputStream outFile, Indenter indenter) {
        indenter.indent();
        outFile.println();
        indenter.removeLevel();
        indenter.indent();
        outFile.println("}");
        indenter.indent();
        outFile.println();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Invalid argments number");
            System.out.println("envGenerator usage");
            System.out.println("  envGenerator configurationFile Optional-ParametersOverwriteingConfigurationFileDefaules");
            return;
        }
        String configuratioFile = args[0];
        String[] overwritingsParameters = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            overwritingsParameters[i - 1] = args[i];
        }
        Configuration config = new Configuration(overwritingsParameters, configuratioFile, System.out);
        if (config.isConfigurationError()) {
            System.out.println("Configuration contais errors.");
            return;
        }
        EnvGenerator generator = new EnvGenerator(config, System.out);
        generator.generateEnvironments();
        for (String reqItfsName : config.getComponentRequiredInterfaces().keySet()) {
            StubGenerator sb = new StubGenerator(config, reqItfsName, System.out);
            sb.generateStub();
        }
    }

    public static class EnvironmentDescription {
        public String mainClassName;
        public Map<String, String> provItfs2envFieldName = new HashMap<String, String>();
        public Map<String, String> compImpl2envFieldName = new HashMap<String, String>();
        public Map<String, String> reqItfs2envFielName = new HashMap<String, String>();
        public Map<Integer, TBPParsedAccept> line2ProvidedCall = new HashMap<Integer, TBPParsedAccept>();
    }
}

