/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class LocalResourceSaveableComparison
extends SaveableComparison
implements IPropertyChangeListener {
    private final ICompareInput input;
    private final CompareEditorInput editorInput;
    private boolean isSaving;
    private IContentChangeListener contentChangeListener;
    private ITypedElement fileElement;
    private IDocument document;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public LocalResourceSaveableComparison(ICompareInput input, CompareEditorInput editorInput) {
        this(input, editorInput, input.getLeft());
    }

    public LocalResourceSaveableComparison(ICompareInput input, CompareEditorInput editorInput, ITypedElement fileElement) {
        this.input = input;
        this.editorInput = editorInput;
        this.fileElement = fileElement;
        this.initializeContentChangeListeners();
    }

    protected void initializeHashing() {
        Object document;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((document = this.getAdapter(clazz)) != null) {
            this.document = (IDocument)document;
        }
    }

    private void initializeContentChangeListeners() {
        ITypedElement te = this.getFileElement();
        if (te instanceof IContentChangeNotifier) {
            if (this.contentChangeListener == null) {
                this.contentChangeListener = new IContentChangeListener(){

                    public void contentChanged(IContentChangeNotifier source) {
                        try {
                            if (!LocalResourceSaveableComparison.this.isSaving) {
                                LocalResourceSaveableComparison.this.performSave((IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                        catch (CoreException e) {
                            TeamUIPlugin.log(e);
                        }
                    }
                };
            }
            ((IContentChangeNotifier)te).addContentChangeListener(this.contentChangeListener);
        }
    }

    public void dispose() {
        ITypedElement left;
        ITypedElement te;
        if (this.contentChangeListener != null && (te = this.getFileElement()) instanceof IContentChangeNotifier) {
            ((IContentChangeNotifier)te).removeContentChangeListener(this.contentChangeListener);
        }
        if ((left = this.getFileElement()) instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)left).discardBuffer();
        }
    }

    private ITypedElement getFileElement() {
        return this.fileElement;
    }

    protected void performSave(IProgressMonitor monitor) throws CoreException {
        if (this.checkForUpdateConflicts()) {
            return;
        }
        try {
            this.isSaving = true;
            monitor.beginTask(null, 100);
            this.flushViewers(Policy.subMonitorFor(monitor, 40));
            ITypedElement left = this.getFileElement();
            if (left instanceof LocalResourceTypedElement) {
                LocalResourceTypedElement te = (LocalResourceTypedElement)left;
                te.commit(Policy.subMonitorFor(monitor, 60));
            }
        }
        finally {
            this.fireInputChange();
            this.setDirty(false);
            this.isSaving = false;
            monitor.done();
        }
    }

    protected void flushViewers(IProgressMonitor monitor) throws CoreException {
        this.editorInput.saveChanges(monitor);
    }

    protected abstract void fireInputChange();

    private boolean checkForUpdateConflicts() {
        if (this.hasSaveConflict()) {
            if (Utils.RUNNING_TESTS) {
                return !Utils.TESTING_FLUSH_ON_COMPARE_INPUT_CHANGE;
            }
            MessageDialog dialog = new MessageDialog(TeamUIPlugin.getStandardDisplay().getActiveShell(), TeamUIMessages.SyncInfoCompareInput_0, null, TeamUIMessages.SyncInfoCompareInput_1, 3, new String[]{TeamUIMessages.SyncInfoCompareInput_2, IDialogConstants.CANCEL_LABEL}, 0);
            int retval = dialog.open();
            switch (retval) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasSaveConflict() {
        ITypedElement left = this.getFileElement();
        if (left instanceof LocalResourceTypedElement) {
            LocalResourceTypedElement te = (LocalResourceTypedElement)left;
            return !te.isSynchronized();
        }
        return false;
    }

    public boolean isDirty() {
        return this.editorInput.isSaveNeeded();
    }

    protected void setDirty(boolean dirty) {
        this.editorInput.setDirty(dirty);
    }

    protected void performRevert(IProgressMonitor monitor) {
        ITypedElement left = this.getFileElement();
        if (left instanceof LocalResourceTypedElement) {
            ((LocalResourceTypedElement)left).discardBuffer();
        }
    }

    public String getName() {
        return this.input.getName();
    }

    public String getToolTipText() {
        return this.editorInput.getToolTipText();
    }

    public ImageDescriptor getImageDescriptor() {
        Image image = this.input.getImage();
        if (image != null) {
            return ImageDescriptor.createFromImage((Image)image);
        }
        return TeamUIPlugin.getImageDescriptor("eview16/synch_synch.gif");
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getProperty();
        if ("DIRTY_STATE".equals(propertyName)) {
            boolean changed = false;
            Object newValue = e.getNewValue();
            if (newValue instanceof Boolean) {
                changed = (Boolean)newValue;
            }
            this.setDirty(changed);
        }
    }

    public int hashCode() {
        if (this.document != null) {
            return this.document.hashCode();
        }
        return this.input.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Saveable)) {
            return false;
        }
        if (this.document != null) {
            Saveable saveable = (Saveable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object otherDocument = saveable.getAdapter((Class)clazz);
            if (this.document == null && otherDocument == null) {
                return false;
            }
            return this.document != null && this.document.equals(otherDocument);
        }
        if (obj instanceof LocalResourceSaveableComparison) {
            LocalResourceSaveableComparison rscm = (LocalResourceSaveableComparison)((Object)obj);
            return rscm.input.equals(this.input);
        }
        return false;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz;
        LocalResourceTypedElement lrte;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            if (this.document != null) {
                return this.document;
            }
            if (this.fileElement instanceof LocalResourceTypedElement && (lrte = (LocalResourceTypedElement)this.fileElement).isConnected()) {
                IDocumentProvider provider;
                IEditorInput input;
                ISharedDocumentAdapter sda;
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("org.eclipse.compare.ISharedDocumentAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((sda = (ISharedDocumentAdapter)Utils.getAdapter((Object)lrte, clazz3)) != null && (input = sda.getDocumentKey((Object)lrte)) != null && (provider = SharedDocumentAdapter.getDocumentProvider((IEditorInput)input)) != null) {
                    return provider.getDocument((Object)input);
                }
            }
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.IEditorInput");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz && this.fileElement instanceof LocalResourceTypedElement) {
            lrte = (LocalResourceTypedElement)this.fileElement;
            return new FileEditorInput((IFile)lrte.getResource());
        }
        return super.getAdapter(adapter);
    }

    public ICompareInput getInput() {
        return this.input;
    }

    public boolean isConnectedToSharedDocument() {
        if (this.fileElement instanceof LocalResourceTypedElement) {
            LocalResourceTypedElement lrte = (LocalResourceTypedElement)this.fileElement;
            return lrte.isConnected();
        }
        return false;
    }
}

