/*
 * Decompiled with CFR 0.152.
 */
package klaper.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum WorkloadType implements Enumerator
{
    NULL(0, "NULL", "NULL"),
    OPEN(1, "OPEN", "OPEN"),
    CLOSED(2, "CLOSED", "CLOSED");

    public static final int NULL_VALUE = 0;
    public static final int OPEN_VALUE = 1;
    public static final int CLOSED_VALUE = 2;
    private static final WorkloadType[] VALUES_ARRAY;
    public static final List<WorkloadType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new WorkloadType[]{NULL, OPEN, CLOSED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static WorkloadType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WorkloadType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WorkloadType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WorkloadType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WorkloadType get(int value) {
        switch (value) {
            case 0: {
                return NULL;
            }
            case 1: {
                return OPEN;
            }
            case 2: {
                return CLOSED;
            }
        }
        return null;
    }

    private WorkloadType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

