/*
 * Decompiled with CFR 0.152.
 */
package recoder.util;

import recoder.util.Order;

public class Sorting {
    public static void heapSort(Object[] a) {
        Sorting.heapSort(a, Order.NATURAL);
    }

    public static void heapSort(Object[] a, Order ord) {
        int m = (a.length - 1) / 2;
        while (m >= 0) {
            int j;
            int i = m;
            while ((j = 2 * i + 1) < a.length) {
                int k = j + 1;
                if (ord.greater(a[i], a[j])) {
                    j = i;
                }
                if (k < a.length && ord.greater(a[k], a[j])) {
                    j = k;
                }
                if (i == j) break;
                Object swap = a[i];
                a[i] = a[j];
                a[j] = swap;
                i = j;
            }
            --m;
        }
        m = a.length - 1;
        while (m >= 1) {
            int j;
            Object swap = a[0];
            a[0] = a[m];
            a[m] = swap;
            int i = 0;
            while ((j = 2 * i + 1) < m) {
                int k = j + 1;
                if (ord.greater(a[i], a[j])) {
                    j = i;
                }
                if (k < m && ord.greater(a[k], a[j])) {
                    j = k;
                }
                if (i == j) break;
                swap = a[i];
                a[i] = a[j];
                a[j] = swap;
                i = j;
            }
            --m;
        }
    }

    public static void insertionSort(Object[] a) {
        Sorting.insertionSort(a, Order.NATURAL);
    }

    public static void insertionSort(Object[] a, Order ord) {
        int i = 1;
        while (i < a.length) {
            Object x = a[i];
            int j = i - 1;
            while (j >= 0 && ord.greater(a[j], x)) {
                a[j + 1] = a[j];
                --j;
            }
            a[j + 1] = x;
            ++i;
        }
    }

    protected static void insertionSort(Object[] a, int le, int ri, Order ord) {
        int i = le + 1;
        while (i <= ri) {
            Object x = a[i];
            int j = i - 1;
            while (j >= le && ord.greater(a[j], x)) {
                a[j + 1] = a[j];
                --j;
            }
            a[j + 1] = x;
            ++i;
        }
    }

    protected static final Object median(Object x, Object y, Object z, Order o) {
        return o.less(x, y) ? (o.less(y, z) ? y : (o.less(x, z) ? z : x)) : (o.less(y, z) ? y : (o.less(z, x) ? z : x));
    }

    public static void quickSort(Object[] a) {
        Sorting.quickSort(a, 0, a.length - 1, Order.NATURAL);
    }

    public static void quickSort(Object[] a, Order ord) {
        Sorting.quickSort(a, 0, a.length - 1, ord);
    }

    protected static void quickSort(Object[] a, int le, int ri, Order ord) {
        if (ri > le) {
            int i = le;
            int j = ri;
            Object x = Sorting.median(a[le], a[ri], a[(le + ri) / 2], ord);
            while (true) {
                if (ord.less(a[i], x)) {
                    ++i;
                    continue;
                }
                while (ord.less(x, a[j])) {
                    --j;
                }
                if (i <= j) {
                    Object h = a[i];
                    a[i] = a[j];
                    a[j] = h;
                    ++i;
                    --j;
                }
                if (i > j) break;
            }
            if (j < le + 16) {
                Sorting.insertionSort(a, le, j, ord);
            } else {
                Sorting.quickSort(a, le, j, ord);
            }
            if (ri < i + 16) {
                Sorting.insertionSort(a, i, ri, ord);
            } else {
                Sorting.quickSort(a, i, ri, ord);
            }
        }
    }

    public static boolean isOrdered(Object[] a) {
        return Sorting.isOrdered(a, Order.NATURAL);
    }

    public static boolean isOrdered(Object[] a, Order ord) {
        int i = a.length - 1;
        while (i > 0) {
            if (ord.greater(a[i - 1], a[i])) {
                return false;
            }
            --i;
        }
        return true;
    }
}

