/*
 * Decompiled with CFR 0.152.
 */
package recoder.util;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class FileUtils {
    private static File userDirectory;
    private static final String ARCHIVE_NAME;
    private static final String LIB_SUBDIR;

    static {
        if (System.getProperty("os.name").startsWith("Mac")) {
            ARCHIVE_NAME = "classes.jar";
            LIB_SUBDIR = "../Classes";
        } else if (System.getProperty("java.version").startsWith("1.1")) {
            ARCHIVE_NAME = "classes.zip";
            LIB_SUBDIR = "lib";
        } else {
            ARCHIVE_NAME = "rt.jar";
            LIB_SUBDIR = "lib";
        }
    }

    public static File getUserDirectory() {
        if (userDirectory == null) {
            userDirectory = new File(System.getProperty("user.dir"));
        }
        return userDirectory;
    }

    public static String getRelativePath(File start, File dest) {
        String destname;
        String startname;
        if (start.isFile()) {
            start = new File(start.getParent());
        }
        try {
            startname = start.getCanonicalPath();
            destname = dest.getCanonicalPath();
        }
        catch (IOException ioe) {
            return dest.getAbsolutePath();
        }
        if (startname.equals(destname)) {
            return ".";
        }
        int slen = startname.length();
        int dlen = destname.length();
        int maxlen = Math.min(slen, dlen);
        int index = 0;
        while (index < maxlen) {
            if (startname.charAt(index) != destname.charAt(index)) break;
            ++index;
        }
        if (index <= 1) {
            return destname;
        }
        StringBuilder result = new StringBuilder();
        if (index != slen) {
            while (index > 0 && startname.charAt(index) != File.separatorChar) {
                --index;
            }
            result.append("..").append(File.separatorChar);
            int dirs = ++index;
            while (dirs < slen) {
                if (startname.charAt(dirs) == File.separatorChar) {
                    result.append("..").append(File.separatorChar);
                }
                ++dirs;
            }
        } else {
            ++index;
        }
        if (index < dlen) {
            result.append(destname.substring(index));
        }
        return result.toString();
    }

    public static File getPathOfSystemClasses() {
        File result = null;
        String classpath = System.getProperty("java.class.path");
        if (classpath != null) {
            char sep = File.separatorChar;
            if (sep == '/') {
                classpath = classpath.replace('\\', sep);
            } else if (sep == '\\') {
                classpath = classpath.replace('/', sep);
            }
            StringTokenizer tok = new StringTokenizer(classpath, File.separator);
            while (tok.hasMoreTokens()) {
                classpath = tok.nextToken();
                if (!classpath.endsWith(String.valueOf(File.separator) + ARCHIVE_NAME)) continue;
                result = new File(classpath);
                if (result.exists()) break;
                result = null;
            }
        }
        if (result == null) {
            classpath = String.valueOf(System.getProperty("java.home")) + File.separator + LIB_SUBDIR + File.separator + ARCHIVE_NAME;
            result = new File(classpath);
        }
        if (!result.exists()) {
            result = null;
        }
        return result;
    }

    public static File getPathOfExtensionClassesDir() {
        File result = null;
        String classpath = String.valueOf(System.getProperty("java.home")) + File.separator + "lib" + File.separator + "ext";
        result = new File(classpath);
        if (!result.exists()) {
            result = null;
        }
        return result;
    }
}

