/*
 * Decompiled with CFR 0.152.
 */
package recoder.util;

import java.io.File;
import java.io.FilenameFilter;

public class FileCollector {
    private File[] stack = new File[8];
    private File current;
    private int count;

    public FileCollector(String root) {
        this(new File(root));
    }

    public FileCollector(File root) {
        this.stack[this.count++] = root;
    }

    private void growStack() {
        File[] newStack = new File[this.stack.length * 2];
        System.arraycopy(this.stack, 0, newStack, 0, this.count);
        this.stack = newStack;
    }

    public boolean next() {
        block0: while (this.count > 0) {
            this.current = this.stack[--this.count];
            while (this.current.isDirectory()) {
                String[] content = this.current.list();
                int i = content.length - 1;
                while (i >= 0) {
                    this.stack[this.count++] = new File(this.current, content[i]);
                    if (this.count == this.stack.length) {
                        this.growStack();
                    }
                    --i;
                }
                if (this.count == 0) break block0;
                this.current = this.stack[--this.count];
            }
            if (!this.current.exists()) continue;
            return true;
        }
        this.current = null;
        return false;
    }

    public boolean next(String suffix) {
        while (this.next()) {
            if (!this.current.getName().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public boolean next(FilenameFilter filter) {
        String pname = "";
        File pfile = null;
        while (this.next()) {
            String p = this.current.getParent();
            if (p == null) {
                p = "";
            }
            if (!pname.equals(p)) {
                pname = p;
                pfile = new File(pname);
            }
            if (!filter.accept(pfile, this.current.getName())) continue;
            return true;
        }
        return false;
    }

    public File getFile() {
        return this.current;
    }
}

