/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.transformation;

import application.Obfuscate;
import java.util.List;
import recoder.abstraction.ClassType;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.java.CompilationUnit;
import recoder.java.Identifier;
import recoder.java.ProgramElement;
import recoder.java.StatementBlock;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.modifier.Private;
import recoder.java.declaration.modifier.Public;
import recoder.java.declaration.modifier.VisibilityModifier;
import recoder.java.reference.MethodReference;
import recoder.java.reference.TypeReference;
import recoder.kit.MethodKit;
import recoder.kit.NoProblem;
import recoder.kit.transformation.java5to4.EnhancedFor2For;
import recoder.kit.transformation.java5to4.FloatingPoints;
import recoder.kit.transformation.java5to4.MakeConditionalCompatible;
import recoder.kit.transformation.java5to4.RemoveAnnotations;
import recoder.kit.transformation.java5to4.RemoveCoVariantReturnTypes;
import recoder.kit.transformation.java5to4.RemoveStaticImports;
import recoder.kit.transformation.java5to4.ReplaceEnumsNew;
import recoder.kit.transformation.java5to4.ResolveBoxing;
import recoder.kit.transformation.java5to4.ResolveGenericsNew;
import recoder.kit.transformation.java5to4.ResolveVarArgs;
import recoder.kit.transformation.java5to4.methodRepl.ApplyRetrotranslatorLibs;
import recoder.kit.transformation.java5to4.methodRepl.ReplaceEmptyCollections;
import recoder.service.ChangeHistory;
import recoder.service.NameInfo;
import recoder.testsuite.RecoderTestCase;

public class TransformationTests
extends RecoderTestCase {
    private boolean silent = true;

    public void testObfuscater() {
        this.setPath("test/transformation/obfuscate");
        this.runIt();
        Obfuscate of = new Obfuscate(this.sc);
        if (of.analyze() instanceof NoProblem) {
            of.transform();
        }
    }

    public void testReadOnly() {
        this.setPath("test/transformation/readOnly");
        this.runIt();
        List<TypeReference> trl = this.sc.getCrossReferenceSourceInfo().getReferences(this.sc.getNameInfo().getType("Test"));
        int i = 0;
        while (i < trl.size()) {
            TypeReference tr = trl.get(i);
            if (!this.silent) {
                System.out.println(tr.toSource());
            }
            ++i;
        }
    }

    private void defaultConstructorReferences(VisibilityModifier vm) {
        this.setPath("test/transformation/defaultCons");
        this.runIt();
        ChangeHistory ch = this.sc.getChangeHistory();
        NameInfo ni = this.sc.getNameInfo();
        ClassDeclaration cd = (ClassDeclaration)ni.getType("DefaultCons");
        ConstructorDeclaration cons = new ConstructorDeclaration(vm, new Identifier("DefaultCons"), null, null, new StatementBlock());
        cd.getMembers().add(cons);
        cd.makeParentRoleValid();
        ch.attached(cons);
        ch.updateModel();
        for (CompilationUnit cu : this.sc.getSourceFileRepository().getCompilationUnits()) {
            cu.validateAll();
        }
        int newref = this.sc.getCrossReferenceSourceInfo().getReferences(cons).size();
        MethodDeclaration md = (MethodDeclaration)cd.getMethods().get(0);
    }

    public void testDefaultConstructorReferences1() {
        this.defaultConstructorReferences(new Public());
    }

    public void testDefaultConstructorReferences2() {
        this.defaultConstructorReferences(new Private());
    }

    public void testReplaceEmptyCollections() {
        this.setPath("test/transformation/emptyCollections");
        this.runIt();
        ClassType coll = this.sc.getNameInfo().getClassType("java.util.Collections");
        this.checkFRefCnt(coll, "EMPTY_LIST", 0);
        this.checkFRefCnt(coll, "EMPTY_MAP", 0);
        this.checkFRefCnt(coll, "EMPTY_SET", 0);
        this.checkFRefCnt(coll, "emptyList", 2);
        this.checkFRefCnt(coll, "emptyMap", 2);
        this.checkFRefCnt(coll, "emptySet", 2);
        new ReplaceEmptyCollections(this.sc).execute();
        this.sc.getChangeHistory().updateModel();
        this.checkFRefCnt(coll, "EMPTY_LIST", 2);
        this.checkFRefCnt(coll, "EMPTY_MAP", 2);
        this.checkFRefCnt(coll, "EMPTY_SET", 2);
        this.checkFRefCnt(coll, "emptyList", 0);
        this.checkFRefCnt(coll, "emptyMap", 0);
        this.checkFRefCnt(coll, "emptySet", 0);
    }

    private void checkFRefCnt(ClassType coll, String memberName, int cnt) {
        boolean found = false;
        for (Field field : coll.getFields()) {
            if (!memberName.equals(field.getName())) continue;
            TransformationTests.assertTrue((cnt == this.sc.getCrossReferenceSourceInfo().getReferences(field).size() ? 1 : 0) != 0);
            found = true;
            break;
        }
        if (!found) {
            for (Method method : coll.getMethods()) {
                if (!memberName.equals(method.getName())) continue;
                TransformationTests.assertTrue((cnt == this.sc.getCrossReferenceSourceInfo().getReferences(method).size() ? 1 : 0) != 0);
                found = true;
                break;
            }
        }
        TransformationTests.assertTrue((boolean)found);
    }

    public void testXXX() throws Exception {
        String cuText = "import java.util.*;class X {\npublic int hashCode() {\nList<Collection> l = null;String s = null;return (l != null ? l : s).hashCode();}}";
        List<CompilationUnit> cus = this.runIt(cuText);
        new MakeConditionalCompatible(this.sc, cus).execute();
    }

    public void testZZZ() throws Exception {
        String cuText1 = "abstract class A<T> {abstract void foo(T t);}class B extends A<String> {void foo(String s) {}}class C<T> extends A<T> {void foo(String s) { }void foo(T t) { }}";
        List<CompilationUnit> cus = this.runIt(cuText1);
        new ResolveGenericsNew(this.sc, cus).execute();
    }

    public void testYASDF() throws Exception {
        String cuText1 = "class A<Q> {\n\t<A> A foo(Class<A> c) { return null; }\n}\nclass B {\n\tvoid bar(A a) {\n\t\tString s = a.foo(String.class);\n\t}\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText1);
        new ResolveGenericsNew(this.sc, cus).execute();
    }

    public void testQQQ() throws Exception {
        String cuText1 = "import java.io.*;\nclass A {\n<T extends Exception> int foo(Class<T> exc) throws T { return 0; }\nvoid bar() throws IOException {\nfoo(IOException.class);\nint i = foo(IOException.class);\n}\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText1);
        new ResolveGenericsNew(this.sc, cus).execute();
    }

    public void testWrongStaticImport() throws Exception {
        String cuText1 = "package a; \n public class X { protected int i; }\n";
        String cuText2 = "package b;\nimport static a.X.*;\nimport static a.X.i;\nclass Y extends a.X {\n\tvoid foo() { int j = i; }\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText1, cuText2);
        new RemoveStaticImports(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"packageb;classYextendsa.X{voidfoo(){intj=i;}}", (String)cus.get(1).toSource().replaceAll("( |\n)", ""));
    }

    public void testGenericsAndCovariant() throws Exception {
        String cuText1 = "class RAPII extends APII<String> implements RAPI { }\nclass APII<T> extends PII<T> { }\nclass PII<T> { T foo() { } }\ninterface RAPI extends RPI {}\ninterface RPI { String foo(); }";
        List<CompilationUnit> cus = this.runIt(cuText1);
        new ResolveGenericsNew(this.sc, cus).execute();
        new RemoveCoVariantReturnTypes(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"classRAPIIextendsAPIIimplementsRAPI{}classAPIIextendsPII{}classPII{Objectfoo(){}}interfaceRAPIextendsRPI{}interfaceRPI{Objectfoo();}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testChangeSigsWhenResolvingGenerics() throws Exception {
        String cuText1 = "interface I<T> { <A extends Number> A foo(Class<A> s, T t); }\ninterface J<T> extends I<T> { }\nabstract class A<T> implements I<T> {}class B extends A<String> {public <A extends Number> A foo(Class<A> s, String t) {}}\nclass C extends A<String> implements J<String> {public <A extends Number> A foo(Class<A> s, String t) {}}";
        List<CompilationUnit> cus = this.runIt(cuText1);
        new ResolveGenericsNew(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"interfaceI{Numberfoo(Classs,Objectt);}interfaceJextendsI{}abstractclassAimplementsI{}classBextendsA{publicNumberfoo(Classs,Objectt){}}classCextendsAimplementsJ{publicNumberfoo(Classs,Objectt){}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testApplicableMethodsIssue() throws Exception {
        String cuText1 = "import java.util.*;class A {\n\tvoid foo() {\t\tList<String> l = new ArrayList<String>();\n\t\tl.toArray(new String[0]);\t}}";
        List<CompilationUnit> cus = this.runIt(cuText1);
        MethodDeclaration md = (MethodDeclaration)cus.get(0).getTypeDeclarationAt(0).getMembers().get(0);
        MethodReference mr = (MethodReference)md.getBody().getBody().get(1);
        List<Method> m = this.sc.getSourceInfo().getMethods(mr);
    }

    public void testArrayIssue() throws Exception {
        String cuText1 = "abstract class A<T> {\tabstract void foo(T a);\n}\nclass B<T> extends A<T[]> {\n\tvoid foo(T a[]) { int i = a.length; }\n}";
        List<CompilationUnit> cus = this.runIt(cuText1);
        MethodDeclaration md = (MethodDeclaration)cus.get(0).getTypeDeclarationAt(1).getMembers().get(0);
        List<Method> redef = MethodKit.getAllRedefinedMethods(md);
        TransformationTests.assertEquals((int)1, (int)redef.size());
        new ResolveGenericsNew(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"abstractclassA{abstractvoidfoo(Objecta);}classBextendsA{voidfoo(Objecta){inti=((Object[])a).length;}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testJustAnotherCovariantIssue() throws Exception {
        String cuText1 = "class A {\n\tNumber foo() { return null;}\n}\nclass B extends A {\n\tInteger foo() { return null;}\n\tvoid bar(B b) { Number n = b.foo(); }\n\tvoid foobar(B b) { Integer i = b.foo(); }\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText1);
        new RemoveCoVariantReturnTypes(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"classA{Numberfoo(){returnnull;}}classBextendsA{Numberfoo(){returnnull;}voidbar(Bb){Numbern=b.foo();}voidfoobar(Bb){Integeri=((Integer)b.foo());}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testGenericsSignatureChanges() throws Exception {
        String cuText1 = "interface A<T, U> {\n\tvoid foo(T t, U u);\n}\ninterface B<T> extends A<T, String>{\n\tvoid foo(T t, String s);\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText1);
        new ResolveGenericsNew(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"interfaceA{voidfoo(Objectt,Objectu);}interfaceBextendsA{voidfoo(Objectt,Objects);}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testResolveGenericsWithVarArgsPresent() throws Exception {
        String cuText1 = "class A<T extends Number> {\n\tvoid foo(T ... t) {\n \t\tint i = t.length;\n\t\tt[0].intValue();\n\t\tbar(t);\n \t\tfoobar(t[0]);\n\t};\n\tvoid bar(Number[] o) { }\n\tvoid foobar(Number n) { }\n}\nclass Q {\n\tvoid foo(A<Integer> a) {\n\t\ta.foo(new Integer(3));\n\t}}";
        List<CompilationUnit> cus = this.runIt(cuText1);
        new ResolveGenericsNew(this.sc, cus).execute();
        this.sc.getChangeHistory().updateModel();
        TransformationTests.assertEquals((String)"classA{voidfoo(Number...t){inti=t.length;t[0].intValue();bar(t);foobar(t[0]);}voidbar(Number[]o){}voidfoobar(Numbern){}}classQ{voidfoo(Aa){a.foo(newInteger(3));}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testResolveGenericsWithVarArgsPresent_2() throws Exception {
        String cuText1 = "class A<T> {\n\tvoid foo(T ... t) {\n \t}\n}\nclass Q extends A<String> {\n\tvoid foo(String ... t) { }\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText1);
        new ResolveGenericsNew(this.sc, cus).execute();
        this.sc.getChangeHistory().updateModel();
        TransformationTests.assertEquals((String)"classA{voidfoo(Object...t){}}classQextendsA{voidfoo(Object...t){}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testCovariantWithMemberTypes() throws Exception {
        String cuText1 = "interface T { }\ninterface CT { CT foo(); }\nclass UT implements T { }\nclass N {\n\tstatic class UCT extends UT implements CT { UCT foo(); }\n}";
        List<CompilationUnit> cus = this.runIt(cuText1);
        new RemoveCoVariantReturnTypes(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"interfaceT{}interfaceCT{CTfoo();}classUTimplementsT{}classN{staticclassUCTextendsUTimplementsCT{CTfoo();}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testCovariantArraysAndClone() throws Exception {
        String cuText1 = "import recoder.list.generic.*;\nclass A {\tASTArrayList a1 = null;\n\tASTArrayList a2 = a1.clone();\n\tString[] t = new String[1];\n\tString[] s = t.clone();\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText1);
        new RemoveCoVariantReturnTypes(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"importrecoder.list.generic.*;classA{ASTArrayLista1=null;ASTArrayLista2=((ASTArrayList)a1.clone());String[]t=newString[1];String[]s=((String[])t.clone());}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testCovariantRelatedMethods() throws Exception {
        String cuText1 = "interface I { java.io.Serializable f(); }\ninterface J { Number f(); }\ninterface K { Number f(); }\nclass C implements I, J { public Number f() { return null; }}\nclass D implements J, K { public Number f() { return null; }}\nclass E { private J d = new K() { public Number f() { return null; }};}\n";
        List<CompilationUnit> cus = this.runIt(cuText1);
        new RemoveCoVariantReturnTypes(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"interfaceI{java.io.Serializablef();}interfaceJ{java.io.Serializablef();}interfaceK{java.io.Serializablef();}classCimplementsI,J{publicjava.io.Serializablef(){returnnull;}}classDimplementsJ,K{publicjava.io.Serializablef(){returnnull;}}classE{privateJd=newK(){publicjava.io.Serializablef(){returnnull;}};}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testConditionalWithBoxing() throws Exception {
        String cuText = "class A { void foo(String s) {\n\tBoolean b = null;\n\tboolean c = s == null ? false : b;\n}}";
        List<CompilationUnit> cus = this.runIt(cuText);
        new MakeConditionalCompatible(this.sc, cus).execute();
        new ResolveBoxing(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"classA{voidfoo(Strings){Booleanb=null;booleanc=s==null?false:(boolean)b.booleanValue();}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testBoxingIssue() throws Exception {
        String cuText = "class A<T> {\n\tvoid set(T i) { }\n\tT get() { return null; }\n\tvoid foo() {\n \t\tA<Integer> a = new A<Integer>();\n\t\ta.set(a.get() + 1);\n\t}\n}";
        List<CompilationUnit> cus = this.runIt(cuText);
        new ResolveGenericsNew(this.sc, cus).execute();
        new ResolveBoxing(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"classA{voidset(Objecti){}Objectget(){returnnull;}voidfoo(){Aa=newA();a.set(Integer.valueOf((((Integer)a.get()).intValue())+1));}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testBoxingIssue2() throws Exception {
        String cuText = "class A {\n\t{\n\t\tBoolean v = true;\n\t\tint i = (v) ? 1 : 0;\n\t}\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        new ResolveBoxing(this.sc, cus).execute();
        new ResolveBoxing(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"classA{{Booleanv=Boolean.valueOf(true);inti=(v.booleanValue())?1:0;}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testBoxingIssue3() throws Exception {
        String cuText = "class A {\n\tvoid foo(Number n) {\n\t\tdouble d = (n instanceof Float) ? (Float)n : (Double)n;\n\t}\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        new MakeConditionalCompatible(this.sc, cus).execute();
        new ResolveBoxing(this.sc, cus).execute();
        new ResolveBoxing(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"classA{voidfoo(Numbern){doubled=(ninstanceofFloat)?(double)((Float)n).floatValue():(double)((Double)n).doubleValue();}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testMakeSureVarArgsBeforeBoxing() throws Exception {
        String cuText = "class A {\n\tvoid bar(Object ... o) {\n\t\tbar(new Object(), true, 3);\n\t}\n\tvoid foo(boolean ... b) {\n\t\tfoo(true, false);\t}\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        new ResolveVarArgs(this.sc, cus).execute();
        new ResolveBoxing(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"classA{voidbar(Object[]o){bar(newObject[]{newObject(),Boolean.valueOf(true),Integer.valueOf(3)});}voidfoo(boolean[]b){foo(newboolean[]{true,false});}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testNewArray() throws Exception {
        String cuText = "class A {\n\tboolean [][] bs = new boolean[][] {{ true }, {false}};\tObject[] os = new Object[] { 3, 5};\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        new ResolveBoxing(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"classA{boolean[][]bs=newboolean[][]{{true},{false}};Object[]os=newObject[]{Integer.valueOf(3),Integer.valueOf(5)};}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testDoubleUnboxing() throws Exception {
        String cuText = "class X {\nInteger max;\nInteger foo(X lhs, X rhs) {\n\tboolean x = lhs.max == rhs.max;\n\treturn (lhs.max==null||rhs.max==null)?\n\t\t\t(lhs.max + rhs.max):\n\t\t\t\t(Integer)(lhs.max + rhs.max);\n\t}\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        new MakeConditionalCompatible(this.sc, cus).execute();
        new ResolveBoxing(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"classX{Integermax;Integerfoo(Xlhs,Xrhs){booleanx=lhs.max==rhs.max;return(lhs.max==null||rhs.max==null)?(Integer)(Integer.valueOf(lhs.max.intValue()+rhs.max.intValue())):(Integer)(Integer.valueOf(lhs.max.intValue()+rhs.max.intValue()));}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testCovariantIssue() throws Exception {
        String cuText = "class C {\n\tinterface F {\n\t\tObject m();\n\t}\n}\nclass B {\n\tvoid p() {\n\t\tnew C.F() { B m() { return null; }};\n\t}\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        new RemoveCoVariantReturnTypes(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"classC{interfaceF{Objectm();}}classB{voidp(){newC.F(){Objectm(){returnnull;}};}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testUnboxingIssue() throws Exception {
        String cuText = "class C {\n\tvoid foo(Integer i, Object[] arr) {\n\t\tObject o = arr[i];\n\t}\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        new ResolveBoxing(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"classC{voidfoo(Integeri,Object[]arr){Objecto=arr[i.intValue()];}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testUnboxAndBoxBackIssue() throws Exception {
        String cuText = "class A {\n\tInteger i;\n\tvoid foo() {\n\t\ti++;\n\t\tInteger j = --i;\n\t\tj = i++;\n\t\twhile (i-- > 0) { }\n\t}\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        new ResolveBoxing(this.sc, cus).execute();
        TransformationTests.assertEquals((String)"classA{Integeri;voidfoo(){i=Integer.valueOf(i.intValue()+1);Integerj=(i=Integer.valueOf(i.intValue()-1));j=((i=Integer.valueOf(i.intValue()+1))-1);while(((i=Integer.valueOf(i.intValue()-1))+1)>0){}}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testIncDecOperatorWithBoxing() throws Exception {
        String cuText = "class A {\n\tInteger i;\n\tvoid foo() {\n\t\ti++;\t}\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        TransformationTests.assertEquals((String)"java.lang.Integer", (String)this.sc.getSourceInfo().getType((ProgramElement)((MethodDeclaration)cus.get(0).getTypeDeclarationAt(0).getMembers().get(1)).getBody().getBody().get(0)).getFullName());
    }

    public void testIntegerValueOfIssue() throws Exception {
        this.sc.getProjectSettings().ensureExtensionClassesAreInPath();
        String cuText = "class A{\n\tvoid foo() {\n\t\tInteger i = 5;\n\t}\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        new MakeConditionalCompatible(this.sc, cus).execute();
        new EnhancedFor2For(this.sc, cus).execute();
        new ResolveGenericsNew(this.sc, cus).execute();
        new RemoveCoVariantReturnTypes(this.sc, cus).execute();
        new RemoveAnnotations(this.sc, cus).execute();
        new RemoveStaticImports(this.sc, cus).execute();
        new ResolveVarArgs(this.sc, cus).execute();
        new ResolveBoxing(this.sc, cus).execute();
        new ReplaceEnumsNew(this.sc).execute();
        new FloatingPoints(this.sc, cus).execute();
        new ApplyRetrotranslatorLibs(this.sc, "lib/").execute();
        TransformationTests.assertEquals((String)"classA{voidfoo(){Integeri=net.sf.retrotranslator.runtime.java.lang._Integer.valueOf(5);}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }
}

