/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.semantics;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import junit.framework.TestCase;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ModelException;
import recoder.ParserException;
import recoder.java.CompilationUnit;
import recoder.service.DefaultErrorHandler;
import recoder.service.ErrorHandler;
import recoder.service.SemanticsChecker;
import recoder.service.TypingException;
import recoder.testsuite.semantics.MethodTest;
import recoder.testsuite.semantics.NameTest;

public class SemanticsTest
extends TestCase {
    private CrossReferenceServiceConfiguration sc;

    private List<CompilationUnit> runIt(String ... cuTexts) throws ParserException {
        return this.runIt((ErrorHandler)null, cuTexts);
    }

    private List<CompilationUnit> runIt(ErrorHandler eh, String ... cuTexts) throws ParserException {
        this.sc = new CrossReferenceServiceConfiguration();
        this.sc.getProjectSettings().setErrorHandler(new ThrowingErrorHandler());
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        ArrayList<CompilationUnit> cus = new ArrayList<CompilationUnit>();
        String[] stringArray = cuTexts;
        int n = cuTexts.length;
        int n2 = 0;
        while (n2 < n) {
            String cuText = stringArray[n2];
            CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
            this.sc.getChangeHistory().attached(cu);
            cus.add(cu);
            ++n2;
        }
        if (eh != null) {
            this.sc.getProjectSettings().setErrorHandler(eh);
        }
        this.sc.getChangeHistory().updateModel();
        for (CompilationUnit cu : cus) {
            cu.validateAll();
        }
        return cus;
    }

    private void testRunOK(String cuText) {
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsTest.fail((String)e.getMessage());
        }
        new SemanticsChecker(this.sc).check(cu);
    }

    private void testRunFail(String cuText) {
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsTest.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsTest.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testMethodInvocation() {
        MethodTest mt = new MethodTest();
        this.testRunFail(mt.testThisInStaticMethod());
        this.testRunFail(mt.testStaticMethodInvocation2());
    }

    public void testName() {
        NameTest nt = new NameTest();
        this.testRunOK(nt.testFieldOK34());
        this.testRunOK(nt.testFieldOK35());
        this.testRunFail(nt.testField36());
        this.testRunFail(nt.testAccessModifier4());
        this.testRunFail(nt.testAccessModifier6());
        this.testRunFail(nt.testAccessModifier7());
        this.testRunFail(nt.testMethodModifier12());
        this.testRunFail(nt.testMethodModifier13());
        this.testRunOK(nt.testMethodModifierOK13());
        this.testRunFail(nt.testMethodModifier14());
        this.testRunFail(nt.testMethodModifier15());
        this.testRunFail(nt.testMethodModifier16());
        this.testRunOK(nt.testMethodModifierOK16());
        this.testRunFail(nt.testMethodModifier17());
        this.testRunFail(nt.testMethodModifier18());
        this.testRunFail(nt.testMethodModifier19());
        this.testRunFail(nt.testMethodModifier20());
        this.testRunFail(nt.testMethodModifier21());
        this.testRunFail(nt.testMethodModifier22());
        this.testRunFail(nt.testMethodModifier23());
    }

    public void testSubclass1() {
        String cuText = "class Point { int x, y; }final class WhitePoint extends Point  { int white; }class ColorPoint extends WhitePoint { int black; }//error! \n";
        this.testRunOK(cuText);
    }

    public void testSubclassOK1() {
        String cuText = "class Point { int x, y; }class WhitePoint extends Point  { int white; }class ColorPoint extends WhitePoint { int black; }//correct! \n";
        this.testRunOK(cuText);
    }

    public void testClassMethodMatch1() {
        String cuText = "class animal{\tint x = 0, y = 0 , age;\tvoid grow(int dx, int dy){ x += dx;y += dy;}\tint getX() {return x;}\tint getY() {return y;}}class ant extends animal{ \tfloat x = 0.0f , y = 0.0f;\tvoid grow (int dx, int dy){grow((float)dx,(float)dy);}\tvoid grow(float dx,float dy){x+= dx; y+= dy;}\tfloat getX(){return x;}\tfloat getY(){return y;}}";
        this.testRunOK(cuText);
    }

    public void testRawInnerTypes1() {
        String cuText = "class Outer<T>{\tclass Inner<S> {\t\tS s;\t}}class A {\tOuter.Inner<Double> x = null; // error!\n}";
        this.testRunFail(cuText);
    }

    public void testRawOuterTypes1() {
        String cuText = "class Outer<T>{\tclass Inner<S> {\t\tS s;\t}}class A {\tOuter<String>.Inner x = null; // error!\n}";
        this.testRunFail(cuText);
    }

    public void testRawOKTypes1() {
        String cuText = "class Outer<T>{\tclass Inner<S> {\t\tS s;\t}}class A {   Outer<Double>.Inner<Double> y = null; // ok!\n}";
        this.testRunOK(cuText);
    }

    public void testRawOKTypes2() {
        String cuText = "class A {class B<T> { void foo() { A.B<String> ab = new A.B<String>();}}}";
        this.testRunOK(cuText);
    }

    public void testIf() {
        String cuText = "class A {\n\tvoid foo() {\n\t\tif (new Object()) { }\t}\n}\n";
        this.testRunFail(cuText);
    }

    public void testEnhancedFor() {
        String cuText = "class A {\n\tvoid foo() {\n\t\tfor (String s: new Object[3]) {\n\t\t}\t}\n}\n";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsTest.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsTest.fail();
        }
        catch (TypingException e) {
            // empty catch block
        }
        cuText = "class A {\n\tvoid foo() {\n\t\tfor (String s: new String[3]) {\n\t\t}\t}\n}\n";
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsTest.fail((String)e.getMessage());
        }
        new SemanticsChecker(this.sc).check(cu);
        cuText = "class A {\n\tvoid foo() {\n\t\tfor (Object o: new String[3]) {\n\t\t}\t}\n}\n";
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsTest.fail((String)e.getMessage());
        }
        cuText = "class A {\n\tvoid foo() {\n\t\tfor (String s: new java.util.ArrayList<String>()) {\n\t\t}\t}\n}\n";
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsTest.fail((String)e.getMessage());
        }
        new SemanticsChecker(this.sc).check(cu);
        cuText = "class A {\n\tstatic final <E> void foo(java.util.Collection<E> c) {\n\t\tjava.util.List<E> list = new java.util.ArrayList<E>();\n\t\tfor (E e : c) {}\n\t}\n}\n";
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsTest.fail((String)e.getMessage());
        }
        new SemanticsChecker(this.sc).check(cu);
    }

    private static class SilentErrorHandler
    extends DefaultErrorHandler {
        private final int exp;
        private int errCnt = 0;

        SilentErrorHandler(int cnt) {
            this.exp = cnt;
        }

        @Override
        public void reportError(Exception e) {
            ++this.errCnt;
        }

        @Override
        public void modelUpdated(EventObject event) {
            this.isUpdating = false;
            SemanticsTest.assertEquals((int)this.exp, (int)this.errCnt);
        }
    }

    private static class ThrowingErrorHandler
    extends DefaultErrorHandler {
        private ThrowingErrorHandler() {
        }

        @Override
        public void reportError(Exception e) {
            throw (ModelException)e;
        }
    }
}

