/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.semantics;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import junit.framework.TestCase;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ModelException;
import recoder.ParserException;
import recoder.java.CompilationUnit;
import recoder.service.DefaultErrorHandler;
import recoder.service.ErrorHandler;
import recoder.service.SemanticsChecker;
import recoder.service.TypingException;

public class SemanticsChecks
extends TestCase {
    private CrossReferenceServiceConfiguration sc;

    private List<CompilationUnit> runIt(String ... cuTexts) throws ParserException {
        return this.runIt((ErrorHandler)null, cuTexts);
    }

    private List<CompilationUnit> runIt(ErrorHandler eh, String ... cuTexts) throws ParserException {
        this.sc = new CrossReferenceServiceConfiguration();
        this.sc.getProjectSettings().setErrorHandler(new ThrowingErrorHandler());
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        ArrayList<CompilationUnit> cus = new ArrayList<CompilationUnit>();
        String[] stringArray = cuTexts;
        int n = cuTexts.length;
        int n2 = 0;
        while (n2 < n) {
            String cuText = stringArray[n2];
            CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
            this.sc.getChangeHistory().attached(cu);
            cus.add(cu);
            ++n2;
        }
        if (eh != null) {
            this.sc.getProjectSettings().setErrorHandler(eh);
        }
        this.sc.getChangeHistory().updateModel();
        for (CompilationUnit cu : cus) {
            cu.validateAll();
        }
        return cus;
    }

    public void testMethodInvocationOK1() {
        String cuText = "class Addtion {\tstatic int get(){return get(1);}\tprivate static int get(int i) { return 2*i; }   public static void main(){\t\tthis.get();\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testMethodInvocation2() {
        String cuText = "class TestStatic {\tint i = 100;//non-static field \n\tint a;\tstatic void set() {\t\tint j = i; //error \n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testMethodInvocationOK2() {
        String cuText = "class TestStatic {\tstatic int i = 100;\tint a;\tstatic void set() {\t\tint j = i; //correct \n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testMethodInvocation3() {
        String cuText = "class IsStatic {\tabstract void is(){}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testMethodInvocationOK3a() {
        String cuText = "abstract class IsStatic {\tabstract void is (){}}interface TestStatic {\tabstract void is(){ }}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testMethodInvocationOK3b() {
        String cuText = "abstract class ant{\tabstract void run();}abstract class queen extends ant{\tvoid eat(){  }  //correct! \n}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testMethodInvocationOK6() {
        String cuText = "class Parent {\tParent() {}}class Child extends Parent{\tChild() { \t\tsuper(); \t}} ";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testMethodInvocationOK7() {
        String cuText = "class Naming {\tString name;\tNaming(String input) {        name = input;\t}\tNaming() {        this(\"mary\");//correct!\n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocationOK8() {
        String cuText = "class Parent {\tint number;\tstatic void print(){System.out.println(\"Parent\");}\tstatic void set(){} {        number = 1;\t}}class Children {\tpublic static void main() {        Parent.print(); //correct!\n\t     Parent.set();//correct!\n\t\t Parent one = new Parent();\t\t one.set();//correct!\n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation8() {
        String cuText = "class Parent {\tint number;\tvoid set(){} {        number = 1;\t}}class Children {\tpublic static void main() {\t     Parent.set();//error!\n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation9() {
        String cuText = "class Test {\tint number;\tvoid nostaticset(){\t\tnumber = 3;\t}\tstatic void testnostatic(){\t\tnostaticset();//error!\n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocationOK9() {
        String cuText = "class Test {\tint number;\tstatic void staticset(){} {       number = 1;\t}\tvoid nostaticset(){\t\tnumber = 3;\t}\tstatic void teststaticset(){\t\tstaticset();//correct!\n\t}\tvoid testnostaticset(){\t\tstaticset();//correct!\n\t\tnostaticset();//correct!\n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation10() {
        String cuText = "interface I{\tvoid write();\tvoid read();}abstract class X1 implements I {\tstatic int i=9;\tstatic void have(){}\tabstract void pick();}class X2 extends X1 {//error! lack of unimplement abstract method of X \n\tpublic void read() {  }\tpublic void write(){  }}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation11() {
        String cuText = "class Z{\tZ(){int z=10;}}class S extends Z {\tS (){super();}}abstract class X1  extends S{\tint i;\tX1(){super();}\tabstract void has();\tvoid put(){i = 9;}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation12() {
        String cuText = "abstract class IsAbstract{\tabstract final void one();//error \n\tabstract static void two();//error \n}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocationOK12() {
        String cuText = "abstract class IsAbstract{\tabstract public void one();//correct! \n\tabstract protected void two();//correct! \n\tabstract void three();//correct! \n}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocationOK13() {
        String cuText = "class outer{}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation14() {
        String cuText = "abstract class animal{\tpublic abstract String toString();}class ant extends animal{ \tint age;\tpublic String toString(){\t\treturn super.toString()+ age;//error!\n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocationOK14() {
        String cuText = "abstract class animal{\tpublic abstract String toString();\tprotected String objString(){\t\treturn super.toString();\t}}class ant extends animal{ \tint age;\tpublic String toString(){\t\treturn super.toString()+ age;//correct!\n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation15() {
        String cuText = "abstract class ant{\tabstract void run();}class queen extends ant{\tvoid run(){\t\tsuper.run();\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocationOK15() {
        String cuText = "abstract class ant{\tabstract void run();}class queen extends ant{\tvoid run(){\t\tsuper.hashCode();\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation17() {
        String cuText = "class A {int a;}class B extends A{int b;}class Test {\tstatic int test (B b){\t\treturn b.b;\t}\tstatic String test (A a){\t\treturn \"A\";\t}\tpublic static void main(String[] args){\t\tB testB = new B();\t\tString s = test(testB);//error!\n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation18() {
        String cuText = "class A {\tstatic void meet(){ }\tstatic A test(){return null;}\tpublic static void main ( ){\t\ttest().meet();//correct!\n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation19() {
        String cuText = "class StringTest {\tpublic static void main ( ){\t\tString s = \"check\";\t\tif (s.endsWith(\"k\")){//correct!\n\t\t\ts = \"ok!\";\t\t}\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation20() {
        String cuText = "class AAA {\tint charge(){return 7;}}class AA extends AAA{\tint charge(){return 5;}}class Battery extends AA{\tint charge(){return 0;}\tvoid test(){\t\tsuper.charge();\t\t((AA)this).charge();\t\t((AAA)this).charge();\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation21() {
        String cuText = "class Hello{\tvoid say(){}\tclass H{\t\tvoid say(){}\t}\tpublic static void main(){\t\tHello h = new Hello();\t\th.say();\t\th.new H().say();//correct! \n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation22() {
        String cuText = "class Hello{\tvoid say(){}\tclass H{\t\tvoid say(){}\t}\tpublic static void main(){\t\tHello.this.say();//error! \n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation23() {
        String cuText = "class Hello{\tvoid say(){}\tclass H{\t\tvoid say(){}\t}\tpublic static void main(){\t\tH.this.say();//error! \n\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation24() {
        String cuText = "class Hello{\tvoid say(){\t\tanswer();//correct!\n\t}\tvoid answer(){}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethodInvocation25() {
        String cuText = "import java.util.ArrayList;import java.util.List;class H{\tArrayList getList(){return new ArrayList();}\tvoid foo(){\t\tList list = foo();\t}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSubclass1() {
        String cuText = "class Point { int x, y; }final class WhitePoint extends Point  { int white; }class ColorPoint extends WhitePoint { int black; }//error! \n";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSubclassOK1() {
        String cuText = "class Point { int x, y; }class WhitePoint extends Point  { int white; }class ColorPoint extends WhitePoint { int black; }//correct! \n";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testClassMethodMatch1() {
        String cuText = "class animal{\tint x = 0, y = 0 , age;\tvoid grow(int dx, int dy){ x += dx;y += dy;}\tint getX() {return x;}\tint getY() {return y;}}class ant extends animal{ \tfloat x = 0.0f , y = 0.0f;\tvoid grow (int dx, int dy){grow((float)dx,(float)dy);}\tvoid grow(float dx,float dy){x+= dx; y+= dy;}\tfloat getX(){return x;}\tfloat getY(){return y;}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testRawInnerTypes1() {
        String cuText = "class Outer<T>{\tclass Inner<S> {\t\tS s;\t}}class A {\tOuter.Inner<Double> x = null; // error!\n}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (TypingException typingException) {
            // empty catch block
        }
    }

    public void testRawOuterTypes1() {
        String cuText = "class Outer<T>{\tclass Inner<S> {\t\tS s;\t}}class A {\tOuter<String>.Inner x = null; // error!\n}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (TypingException typingException) {
            // empty catch block
        }
    }

    public void testRawOKTypes1() {
        String cuText = "class Outer<T>{\tclass Inner<S> {\t\tS s;\t}}class A {   Outer<Double>.Inner<Double> y = null; // ok!\n}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (ModelException e) {
            SemanticsChecks.assertTrue((String)e.getMessage(), (boolean)true);
        }
    }

    public void testRawOKTypes2() {
        String cuText = "class A {class B<T> { void foo() { A.B<String> ab = new A.B<String>();}}}";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
        }
        catch (Exception e) {
            SemanticsChecks.assertTrue((String)e.getMessage(), (boolean)true);
        }
    }

    public void testIf() {
        String cuText = "class A {\n\tvoid foo() {\n\t\tif (new Object()) { }\t}\n}\n";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (TypingException typingException) {
            // empty catch block
        }
    }

    public void testEnhancedFor() {
        String cuText = "class A {\n\tvoid foo() {\n\t\tfor (String s: new Object[3]) {\n\t\t}\t}\n}\n";
        CompilationUnit cu = null;
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        try {
            new SemanticsChecker(this.sc).check(cu);
            SemanticsChecks.fail();
        }
        catch (TypingException e) {
            // empty catch block
        }
        cuText = "class A {\n\tvoid foo() {\n\t\tfor (String s: new String[3]) {\n\t\t}\t}\n}\n";
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        new SemanticsChecker(this.sc).check(cu);
        cuText = "class A {\n\tvoid foo() {\n\t\tfor (Object o: new String[3]) {\n\t\t}\t}\n}\n";
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        cuText = "class A {\n\tvoid foo() {\n\t\tfor (String s: new java.util.ArrayList<String>()) {\n\t\t}\t}\n}\n";
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        new SemanticsChecker(this.sc).check(cu);
        cuText = "class A {\n\tstatic final <E> void foo(java.util.Collection<E> c) {\n\t\tjava.util.List<E> list = new java.util.ArrayList<E>();\n\t\tfor (E e : c) {}\n\t}\n}\n";
        try {
            cu = this.runIt(cuText).get(0);
        }
        catch (ParserException e) {
            SemanticsChecks.fail((String)e.getMessage());
        }
        new SemanticsChecker(this.sc).check(cu);
    }

    private static class SilentErrorHandler
    extends DefaultErrorHandler {
        private final int exp;
        private int errCnt = 0;

        SilentErrorHandler(int cnt) {
            this.exp = cnt;
        }

        @Override
        public void reportError(Exception e) {
            ++this.errCnt;
        }

        @Override
        public void modelUpdated(EventObject event) {
            this.isUpdating = false;
            SemanticsChecks.assertEquals((int)this.exp, (int)this.errCnt);
        }
    }

    private static class ThrowingErrorHandler
    extends DefaultErrorHandler {
        private ThrowingErrorHandler() {
        }

        @Override
        public void reportError(Exception e) {
            throw (ModelException)e;
        }
    }
}

