/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.semantics;

import java.io.File;
import java.io.FileFilter;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ModelException;
import recoder.service.DefaultErrorHandler;
import recoder.testsuite.RecoderTestCase;

public class NewSemanticsChecks
extends RecoderTestCase {
    @Override
    protected void runIt() {
        this.sc.getProjectSettings().setErrorHandler(new ThrowingErrorHandler());
        super.runIt();
    }

    public void testValidPrograms() {
        this.runTests("test/semantics/valid", true);
    }

    public void testInvalidPrograms() {
        this.runTests("test/semantics/invalid", false);
    }

    private void runTests(String path, boolean validProgram) {
        File[] dirs;
        boolean successfull = true;
        File f = new File(path);
        if (!f.isDirectory()) {
            throw new RuntimeException();
        }
        File[] fileArray = dirs = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                File dir = fileArray[n2];
                try {
                    this.sc = new CrossReferenceServiceConfiguration();
                    this.setPath(dir.getPath());
                    this.runIt();
                    if (!validProgram) {
                        System.err.println("Invalid program " + dir + " ran through without error.");
                        successfull = false;
                    }
                }
                catch (ModelException e) {
                    if (!validProgram) break block6;
                    System.err.println("Valid program " + dir + " failed due to " + e.toString());
                    successfull = false;
                }
            }
            ++n2;
        }
        if (!successfull) {
            NewSemanticsChecks.fail((String)"There are programs that did not run through as expected; check stderr-output for details.");
        }
    }

    private static class ThrowingErrorHandler
    extends DefaultErrorHandler {
        private ThrowingErrorHandler() {
        }

        @Override
        public void reportError(Exception e) {
            throw (ModelException)e;
        }
    }
}

