/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.newFeatures;

import java.util.List;
import recoder.ParserException;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.convenience.Naming;
import recoder.java.CompilationUnit;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.reference.TypeReference;
import recoder.kit.TypeKit;
import recoder.testsuite.RecoderTestCase;

public class SmallFeatures
extends RecoderTestCase {
    public void testCrossReferenceIssues() throws ParserException {
        String cuText = "class A<T> {\n\tA<java.util.List> f1;\n\tA[] f2;\n\tA<java.util.List> f3;\n}";
        List<CompilationUnit> cus = this.runIt(cuText);
        TypeDeclaration typeA = cus.get(0).getTypeDeclarationAt(0);
        List<TypeReference> trs = this.sc.getCrossReferenceSourceInfo().getReferences(typeA);
        SmallFeatures.assertEquals((int)2, (int)trs.size());
        trs = this.sc.getCrossReferenceSourceInfo().getReferences(typeA, true);
        SmallFeatures.assertEquals((int)3, (int)trs.size());
        trs = this.sc.getCrossReferenceSourceInfo().getReferences(typeA, false);
        SmallFeatures.assertEquals((int)2, (int)trs.size());
        trs = this.sc.getCrossReferenceSourceInfo().getReferences(this.sc.getNameInfo().getClassType("java.util.List"));
        SmallFeatures.assertEquals((int)2, (int)trs.size());
    }

    public void testTypeKitCreateTypeReferenceForParamType() throws ParserException {
        String cuText = "import java.util.*;\n class A { void foo() { }}";
        MethodDeclaration md = (MethodDeclaration)this.runIt(cuText).get(0).getTypeDeclarationAt(0).getMembers().get(0);
        Type t = this.sc.getNameInfo().getType("java.util.HashMap<java.lang.String,? extends java.awt.AWTEvent>");
        TypeReference tr = TypeKit.createTypeReference(this.sc.getSourceInfo(), t, md);
        String s = String.valueOf(Naming.toPathName(tr)) + "<";
        boolean first = true;
        for (TypeArgumentDeclaration ta : tr.getTypeArguments()) {
            if (!first) {
                s = String.valueOf(s) + ",";
            }
            first = false;
            s = String.valueOf(s) + TypeArgument.DescriptionImpl.getFullDescription(ta, true);
        }
        s = String.valueOf(s) + ">";
        SmallFeatures.assertEquals((String)"HashMap<String,? extends java.awt.AWTEvent>", (String)s);
    }
}

