/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.newFeatures;

import java.util.Arrays;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import recoder.CrossReferenceServiceConfiguration;
import recoder.abstraction.ClassType;
import recoder.abstraction.Method;
import recoder.abstraction.Type;
import recoder.service.NameInfo;

public class NameInfoPatternMatcher
extends TestCase {
    public void testGetTypes() {
        CrossReferenceServiceConfiguration sc = new CrossReferenceServiceConfiguration();
        sc.getProjectSettings().ensureSystemClassesAreInPath();
        NameInfo ni = sc.getNameInfo();
        ni.getJavaLangObject();
        ni.getClassType("java.util.List");
        List<ClassType> cts = ni.getClassTypes("**Object");
        this.check(cts, "java.lang.Object");
        cts = ni.getClassTypes("*Object");
        this.check(cts, new String[0]);
    }

    private void check(List<ClassType> cts, String ... exp) {
        NameInfoPatternMatcher.assertEquals((int)exp.length, (int)cts.size());
        int i = 0;
        while (i < exp.length) {
            NameInfoPatternMatcher.assertEquals((String)exp[i], (String)cts.get(i).getFullName());
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void check2(List<Method> cts, String ... exp) {
        block5: {
            exps = Arrays.asList(exp);
            try {
                NameInfoPatternMatcher.assertEquals((int)exp.length, (int)cts.size());
                i = 0;
                while (i < exp.length) {
                    s = String.valueOf(cts.get(i).getFullName()) + "(" + this.makeSigString(cts.get(i).getSignature(), false) + ")";
                    NameInfoPatternMatcher.assertTrue((boolean)exps.contains(s));
                    ++i;
                }
                break block5;
            }
            catch (AssertionFailedError e) {
                i = 0;
                ** for (m : cts)
            }
lbl-1000:
            // 1 sources

            {
                System.out.println(String.valueOf(m.getFullName()) + "(" + this.makeSigString(cts.get(i).getSignature(), false) + ")");
                ++i;
                continue;
            }
lbl17:
            // 1 sources

            var9_11 = exp;
            var8_12 = exp.length;
            var7_9 = 0;
            while (var7_9 < var8_12) {
                s = var9_11[var7_9];
                System.out.println(s);
                ++var7_9;
            }
            throw e;
        }
    }

    private String makeSigString(List<Type> signature, boolean fullName) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Type t : signature) {
            if (!first) {
                result.append(',');
            } else {
                first = false;
            }
            if (fullName) {
                result.append(t.getFullName());
                continue;
            }
            result.append(t.getName());
        }
        return result.toString();
    }

    public void testGetMethods() {
        CrossReferenceServiceConfiguration sc = new CrossReferenceServiceConfiguration();
        sc.getProjectSettings().ensureSystemClassesAreInPath();
        NameInfo ni = sc.getNameInfo();
        ni.getJavaLangObject();
        ni.getClassType("java.util.List");
        List<Method> ms = ni.getMethods("**.equals(*)");
        this.check2(ms, "java.lang.Object.equals(Object)", "java.util.List.equals(Object)", "java.util.Collection.equals(Object)");
    }
}

