/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.java5test;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EventObject;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ParserException;
import recoder.abstraction.AnnotationUse;
import recoder.abstraction.ClassType;
import recoder.abstraction.Constructor;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.Type;
import recoder.abstraction.Variable;
import recoder.bytecode.AnnotationUseInfo;
import recoder.bytecode.MethodInfo;
import recoder.convenience.ForestWalker;
import recoder.convenience.Format;
import recoder.convenience.Naming;
import recoder.convenience.TreeWalker;
import recoder.java.Comment;
import recoder.java.CompilationUnit;
import recoder.java.Declaration;
import recoder.java.Expression;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.EnumConstantSpecification;
import recoder.java.declaration.EnumDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.VariableReference;
import recoder.kit.MiscKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.AmbiguousStaticFieldImportException;
import recoder.service.ConstantEvaluator;
import recoder.service.ErrorHandler;
import recoder.service.NameInfo;
import recoder.service.SourceInfo;
import recoder.service.UnresolvedReferenceException;
import recoder.testsuite.RecoderTestCase;
import recoder.util.Debug;
import recoder.util.HashCode;
import recoder.util.Index;
import recoder.util.Order;
import recoder.util.Sorting;

public class Java5Test
extends RecoderTestCase {
    private boolean silent = true;
    private static Object synchObj = new Object();
    static final Order UNIT_NAME_ORDER = new Order.CustomLexicalOrder(){

        @Override
        protected String toString(Object x) {
            return Naming.toCanonicalName((CompilationUnit)x);
        }
    };

    public void testComments() {
        this.setPath("test/java5/input/comments", "test/java5/output/comments");
        this.runIt();
        ForestWalker fw = new ForestWalker(this.sc.getSourceFileRepository().getCompilationUnits());
        while (fw.next()) {
            ProgramElement pe = fw.getProgramElement();
            ASTList<Comment> cl = pe.getComments();
            if (cl == null) continue;
            int i = 0;
            while (i < cl.size()) {
                Comment c = (Comment)cl.get(i);
                String name = pe.getClass().getSimpleName();
                c.getText().indexOf(name);
                ++i;
            }
        }
        this.reparseAndCompare("comments");
    }

    public void testAmbiguities() {
        this.setPath("test/java5/input/errortest");
        ErrorHandler defaultErrorHandler = this.sc.getProjectSettings().getErrorHandler();
        defaultErrorHandler.setErrorThreshold(9999);
        this.sc.getProjectSettings().setErrorHandler(new ErrorHandler(){
            private int errNum = 0;

            @Override
            public int getErrorThreshold() {
                return 9999;
            }

            @Override
            public void setErrorThreshold(int maxCount) {
                Debug.assertBoolean(false);
            }

            @Override
            public void modelUpdating(EventObject event) {
            }

            @Override
            public void modelUpdated(EventObject event) {
                Java5Test.assertTrue((String)("Not enough errors, only " + this.errNum), (this.errNum == 10 ? 1 : 0) != 0);
            }

            @Override
            public void reportError(Exception e) throws RuntimeException {
                switch (this.errNum++) {
                    case 0: {
                        Java5Test.assertTrue((boolean)(e instanceof AmbiguousStaticFieldImportException));
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        Java5Test.assertTrue((boolean)(e instanceof UnresolvedReferenceException));
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                    default: {
                        System.err.println("failing:\n    " + e.getMessage());
                        Java5Test.fail((String)"Too many errors");
                    }
                }
                if (!Java5Test.this.silent) {
                    System.out.print("ok: ");
                    String className = e.getClass().getName();
                    className = className.substring(className.lastIndexOf(46) + 1);
                    System.out.println("*** " + this.errNum + ": " + className);
                    System.out.println("    " + e.getMessage());
                    System.out.println();
                }
            }
        });
        this.runIt();
    }

    private String getAnnotationName(AnnotationUse au) {
        if (au instanceof AnnotationUseInfo) {
            AnnotationUseInfo aus = (AnnotationUseInfo)au;
            return this.sc.getByteCodeInfo().getAnnotationType(aus).getFullName();
        }
        AnnotationUseSpecification aus = (AnnotationUseSpecification)au;
        return this.sc.getSourceInfo().getAnnotationType(aus).getFullName();
    }

    public void testAnnotations() {
        this.setPath("test/java5/input/annotationtest", "test/java5/output/annotationtest");
        this.runIt();
        NameInfo ni = this.sc.getNameInfo();
        Package p = ni.getPackage("annotationtest");
        List<? extends AnnotationUse> ann = p.getPackageAnnotations();
        Java5Test.assertTrue((ann.size() == 1 ? 1 : 0) != 0);
        Java5Test.assertTrue((boolean)this.getAnnotationName(ann.get(0)).equals("annotationtest.Annot"));
        p = ni.getPackage("a");
        ann = p.getPackageAnnotations();
        Java5Test.assertTrue((ann.size() == 1 ? 1 : 0) != 0);
        Java5Test.assertTrue((boolean)this.getAnnotationName(ann.get(0)).equals("a.B"));
        Java5Test.assertTrue((ni.getType("annotationtest.package-info") == null ? 1 : 0) != 0);
        Java5Test.assertTrue((ni.getType("a.package-info") == null ? 1 : 0) != 0);
        ClassType ct = ni.getClassType("java.lang.annotation.Retention");
        Java5Test.assertTrue((ct != null ? 1 : 0) != 0);
        Java5Test.assertTrue((boolean)ct.isAnnotationType());
        Java5Test.assertTrue((ct.getAllSupertypes().size() == 3 ? 1 : 0) != 0);
        ct = ni.getClassType("a.C");
        List<Method> ml = ct.getMethods();
        StringBuilder output = new StringBuilder();
        int i = 0;
        int s = ml.size();
        while (i < s) {
            MethodInfo m = (MethodInfo)ml.get(i);
            String[] param = m.getParameterTypeNames();
            output.append(String.valueOf(m.getName()) + "(");
            boolean first = true;
            int j = 0;
            while (j < param.length) {
                if (!first) {
                    output.append(",");
                }
                first = false;
                AnnotationUseInfo[] annot = m.getAnnotationsForParam(j);
                int k = 0;
                while (k < annot.length) {
                    output.append(annot[k] + " ");
                    ++k;
                }
                output.append(param[j]);
                ++j;
            }
            output.append(")");
            ++i;
        }
        Java5Test.assertEquals((String)output.toString(), (String)"foo(@a.BC int)bar(@a.BC int,@a.CD @a.BC int,@a.BC @a.CD int)bar2(@a.BC int,int)");
        Java5Test.assertTrue((ni.getClassType("a.BC").getAllMethods().size() == 12 ? 1 : 0) != 0);
        this.reparseAndCompare("annotationtest");
    }

    public void testEnums() {
        this.setPath("test/java5/input/enumtest", "test/java5/output/enumtest");
        this.runIt();
        NameInfo ni = this.sc.getNameInfo();
        EnumDeclaration etd = (EnumDeclaration)ni.getType("enumtest.Color");
        Constructor c = etd.getConstructors().get(0);
        List<ConstructorReference> crl = this.sc.getCrossReferenceSourceInfo().getReferences(c);
        Java5Test.assertTrue((crl.size() == 3 ? 1 : 0) != 0);
        EnumConstantSpecification ecd = (EnumConstantSpecification)ni.getField("enumtest.jls.Operation.PLUS");
        Method m = ecd.getConstructorReference().getClassDeclaration().getMethods().get(0);
        int s = this.sc.getCrossReferenceSourceInfo().getReferences(m).size();
        Java5Test.assertTrue((s == 1 ? 1 : 0) != 0);
        this.reparseAndCompare("enumtest");
    }

    public void testGenerics() {
        this.setPath("test/java5/input/generictest", "test/java5/output/generictest");
        this.runIt();
        this.sc.getNameInfo().getType("a.BytecodeGenerics");
        NameInfo ni = this.sc.getNameInfo();
        TypeDeclaration td = (TypeDeclaration)ni.getType("generictest.D");
        int i = 0;
        while (i < td.getMethods().size()) {
            Method m = td.getMethods().get(i);
            if (m.getName().equals("foobar")) {
                MethodDeclaration md = (MethodDeclaration)m;
                Java5Test.assertTrue((boolean)"List<List<Map<String, List<String>>>>".equals(md.getTypeReference().toSource().trim()));
            }
            ++i;
        }
        this.reparseAndCompare("generictest");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reparseAndCompare(String path) {
        Object object = synchObj;
        synchronized (object) {
            try {
                StringWriter oldReport = new StringWriter(10000);
                this.createExtendedReport(oldReport);
                this.scrubOutputPath("test/java5/output/" + path + "/");
                this.writeBack();
                this.setPath("test/java5/output/" + path);
                this.runIt();
                StringWriter newReport = new StringWriter(10000);
                this.createExtendedReport(newReport);
                StringBuffer oldBuf = oldReport.getBuffer();
                StringBuffer newBuf = newReport.getBuffer();
                int i = 0;
                int rep = 5;
                while (i < Math.min(oldBuf.length(), newBuf.length()) && rep > 0) {
                    if (oldBuf.charAt(i) != newBuf.charAt(i)) {
                        if (i > 1 && oldBuf.charAt(i - 1) == '.') {
                            int j = i + 1;
                            while (Character.isDigit(oldBuf.charAt(j)) && Character.isDigit(newBuf.charAt(j)) && j < i + 10) {
                                ++j;
                            }
                            if (j - i > 6) {
                                i = j;
                            }
                        } else {
                            --rep;
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                Java5Test.fail();
            }
        }
    }

    private void scrubOutputPath(String path) {
        File myPath = new File(path);
        File[] list = myPath.listFiles();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            File current = list[i];
            if (current.isDirectory()) {
                this.scrubOutputPath(current.getAbsolutePath());
                current.delete();
            } else if (current.isFile() && current.getName().endsWith(".java")) {
                current.delete();
            }
            ++i;
        }
    }

    public void testPrettyPrinter() {
        this.setPath("test/java5/input/prettyprinting", "test/java5/output/prettyprinting");
        this.runIt();
        ClassDeclaration cd = (ClassDeclaration)this.sc.getNameInfo().getClassType("A");
        List<FieldSpecification> fl = cd.getFields();
        ASTArrayList<boolean> cml = new ASTArrayList<boolean>(true);
        cml.add((boolean)new Comment("/*comment to field spec 'a'*/", true));
        fl.get(0).setComments(cml);
        MiscKit.unindent(fl.get(0));
        this.reparseAndCompare("prettyprinting");
    }

    public void testParameterizedTypes() throws ParserException {
        CrossReferenceServiceConfiguration sc = new CrossReferenceServiceConfiguration();
        sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "class A<T> { T foo(String dummy, T param) throws T { new A<String>(); return null; }}";
        CompilationUnit cu = sc.getProgramFactory().parseCompilationUnit(cuText);
        sc.getChangeHistory().attached(cu);
        sc.getChangeHistory().updateModel();
        cu.validateAll();
        Type t = sc.getSourceInfo().getType(((MethodDeclaration)cu.getTypeDeclarationAt(0).getMembers().get(0)).getBody().getStatementAt(0));
        Java5Test.assertTrue((boolean)(t instanceof ParameterizedType));
    }

    protected void createExtendedReport(Writer out) throws IOException {
        List<CompilationUnit> units = this.sc.getSourceFileRepository().getCompilationUnits();
        Object[] uarray = new CompilationUnit[units.size()];
        int i = 0;
        while (i < uarray.length) {
            uarray[i] = units.get(i);
            ++i;
        }
        Sorting.heapSort(uarray, UNIT_NAME_ORDER);
        SourceInfo si = this.sc.getSourceInfo();
        Index decl2num = new Index(HashCode.IDENTITY);
        ConstantEvaluator.EvaluationResult res = new ConstantEvaluator.EvaluationResult();
        int i2 = 0;
        int n = 0;
        while (i2 < uarray.length) {
            TreeWalker tw = new TreeWalker((ProgramElement)uarray[i2]);
            while (tw.next()) {
                ProgramElement pe = tw.getProgramElement();
                if (pe instanceof Declaration) {
                    decl2num.put(pe, n);
                }
                ++n;
            }
            ++i2;
        }
        StringBuffer line = new StringBuffer(1024);
        int number = 1;
        int i3 = 0;
        while (i3 < uarray.length) {
            Object unit = uarray[i3];
            TreeWalker tw = new TreeWalker((ProgramElement)unit);
            SourceElement.Position oldPos = SourceElement.Position.UNDEFINED;
            while (tw.next()) {
                Type t;
                ProgramElement pe = tw.getProgramElement();
                line.append("(" + (pe.getComments() == null ? 0 : pe.getComments().size()) + " comments)");
                SourceElement.Position pos = pe.getFirstElement().getStartPosition();
                if (!pos.equals(oldPos)) {
                    oldPos = pos;
                }
                line.append(' ');
                String name = pe.getClass().getName();
                name = name.substring(name.lastIndexOf(46) + 1);
                int k = 0;
                int s = name.length();
                while (k < s) {
                    char c = name.charAt(k);
                    if (Character.isUpperCase(c)) {
                        line.append(c);
                    }
                    ++k;
                }
                if (pe instanceof CompilationUnit) {
                    line.append(Format.toString(" \"%u\"", pe));
                }
                if (pe instanceof Expression && (t = si.getType(pe)) != null) {
                    line.append(" :");
                    if (t instanceof ProgramElement) {
                        line.append(decl2num.get(t));
                    } else {
                        line.append(Format.toString("%N", t));
                    }
                    if (this.sc.getConstantEvaluator().isCompileTimeConstant((Expression)pe, res)) {
                        line.append(" ==" + res.toString());
                    }
                }
                int ref = -1;
                if (pe instanceof Constructor) {
                    ref = this.sc.getCrossReferenceSourceInfo().getReferences((Constructor)((Object)pe)).size();
                }
                if (pe instanceof Field) {
                    ref = this.sc.getCrossReferenceSourceInfo().getReferences((Field)((Object)pe)).size();
                }
                if (pe instanceof Method) {
                    ref = this.sc.getCrossReferenceSourceInfo().getReferences((Method)((Object)pe)).size();
                }
                if (pe instanceof Type) {
                    ref = this.sc.getCrossReferenceSourceInfo().getReferences((Type)((Object)pe)).size();
                }
                if (pe instanceof Variable) {
                    ref = this.sc.getCrossReferenceSourceInfo().getReferences((Variable)((Object)pe)).size();
                }
                if (ref != -1) {
                    line.append("(" + ref + " refs)");
                }
                ProgramModelElement dest = null;
                if (pe instanceof ConstructorReference) {
                    dest = si.getConstructor((ConstructorReference)pe);
                } else if (pe instanceof MethodReference) {
                    dest = si.getMethod((MethodReference)pe);
                } else if (pe instanceof VariableReference) {
                    dest = si.getVariable((VariableReference)pe);
                } else if (pe instanceof TypeReference) {
                    dest = si.getType((TypeReference)pe);
                } else if (pe instanceof PackageReference) {
                    dest = si.getPackage((PackageReference)pe);
                }
                if (dest != null) {
                    line.append(" ->");
                    if (dest instanceof ProgramElement) {
                        line.append(decl2num.get(dest));
                    } else {
                        line.append(Format.toString("%N", dest));
                    }
                }
                line.append("\n");
                out.write(line.toString());
                line.setLength(0);
                ++number;
            }
            ++i3;
        }
        out.flush();
    }
}

