/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.java5test;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.asm.Type;
import recoder.abstraction.ClassType;
import recoder.abstraction.ElementValuePair;
import recoder.abstraction.Method;
import recoder.bytecode.ASMBytecodeParser;
import recoder.bytecode.AnnotationPropertyInfo;
import recoder.bytecode.AnnotationUseInfo;
import recoder.bytecode.ClassFile;
import recoder.bytecode.EnumConstantReferenceInfo;
import recoder.bytecode.MethodInfo;
import recoder.bytecode.TypeParameterInfo;
import recoder.service.NameInfo;
import recoder.testsuite.RecoderTestCase;
import recoder.util.FileUtils;

public class ExtendedBytecodeTest
extends RecoderTestCase {
    public void testTypeVarException() throws Exception {
        this.setPath("test/java5/input/extendedBytecode/typeVarException");
        List<ClassType> exc = this.sc.getNameInfo().getClassType("X").getMethods().get(0).getExceptions();
        ExtendedBytecodeTest.assertEquals((int)3, (int)exc.size());
        ExtendedBytecodeTest.assertTrue((boolean)(exc.get(0) instanceof TypeParameterInfo));
        ExtendedBytecodeTest.assertTrue((boolean)exc.get(0).getName().equals("E"));
        ExtendedBytecodeTest.assertTrue((boolean)(exc.get(1) instanceof ClassFile));
        ExtendedBytecodeTest.assertTrue((boolean)exc.get(1).getFullName().equals("java.io.IOException"));
        ExtendedBytecodeTest.assertTrue((boolean)(exc.get(2) instanceof TypeParameterInfo));
        ExtendedBytecodeTest.assertTrue((boolean)exc.get(2).getName().equals("T"));
    }

    public void testClassTypeBound() throws Exception {
        this.setPath("test/java5/input/extendedBytecode/innerClassTypeBound");
        String cuText = "class SC {\n\tvoid foo(Y<Number> t) {\n\t\tt.foo().hello().equalsIgnoreCase(\"\");\n\t}\n}\n";
        this.runIt(cuText);
    }

    public void testInnerClassTypeBound() throws Exception {
        this.setPath("test/java5/input/extendedBytecode/innerClassTypeBound");
        String cuText = "class SC {\n\tvoid foo(X<Number>.Inner t) {\n\t\tt.foo().hello().equalsIgnoreCase(\"\");\n\t}\n}\n";
        this.runIt(cuText);
    }

    public void testInnerClassTypeBound_2() throws Exception {
        this.setPath("test/java5/input/extendedBytecode/innerClassTypeBound");
        String cuText = "class SC {\n\tvoid foo(X.Inner t) {\n\t\tt.foo().hello().equalsIgnoreCase(\"\");\n\t}\n}\n";
        this.runIt(new RecoderTestCase.SilentErrorHandler(1), cuText);
    }

    public void testInnerClassTypeBoundCompletelyInSourceCode() throws Exception {
        String cuText = "class X<E> {\n\tclass Inner {\n\t\tE hello() { return null; }\n\t\t<T extends X<String>.Inner> T foo() {\n\t\t\treturn null;\n\t\t}\n\t}\n}\nclass SC {\n\tvoid foo(X<Number>.Inner t) {\n\t\tt.foo().hello().equalsIgnoreCase(\"\");\n\t}\n}\n";
        this.runIt(cuText);
    }

    public void testInnerClassTypeBoundCompletelyInSourceCode_2() throws Exception {
        String cuText = "class X<E> {\n\tclass Inner {\n\t\tE hello() { return null; }\n\t\t<T extends X<String>.Inner> T foo() {\n\t\t\treturn null;\n\t\t}\n\t}\n}\nclass SC {\n\tvoid foo(X.Inner t) {\n\t\tt.foo().hello().equalsIgnoreCase(\"\");\n\t}\n}\n";
        this.runIt(new RecoderTestCase.SilentErrorHandler(1), cuText);
    }

    public void testAnnotations() throws Exception {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        ClassType override = this.sc.getNameInfo().getClassType("java.lang.Override");
        ExtendedBytecodeTest.assertEquals((int)2, (int)override.getAnnotations().size());
        this.sc.getNameInfo().getClassType("java.lang.String");
        Method deprMetho = this.sc.getNameInfo().getMethods("java.lang.String.String(byte[],int,int,int)", true).get(0);
        ExtendedBytecodeTest.assertEquals((int)1, (int)deprMetho.getAnnotations().size());
        ExtendedBytecodeTest.assertEquals((int)1, (int)this.sc.getNameInfo().getField("java.lang.Character.UnicodeBlock.SURROGATES_AREA").getAnnotations().size());
    }

    public void testAnnotations2() throws Exception {
        this.setPath("test/java5/input/extendedBytecode/annotation/");
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        NameInfo ni = this.sc.getNameInfo();
        ClassFile ct = (ClassFile)ni.getClassType("java.beans.ConstructorProperties");
        List<AnnotationUseInfo> ans = ct.getAnnotations();
        ExtendedBytecodeTest.assertEquals((String)"java.lang.annotation.Documented", (String)ans.get(0).getFullReferencedName());
        AnnotationUseInfo an = ans.get(1);
        ExtendedBytecodeTest.assertEquals((String)"java.lang.annotation.Target", (String)an.getFullReferencedName());
        List<ElementValuePair> evps = an.getElementValuePairs();
        ExtendedBytecodeTest.assertEquals((int)1, (int)evps.size());
        ExtendedBytecodeTest.assertEquals((String)"@java.lang.annotation.Documented", (String)ans.get(0).toString());
        ExtendedBytecodeTest.assertEquals((String)"@java.lang.annotation.Target(value={java.lang.annotation.ElementType.CONSTRUCTOR})", (String)ans.get(1).toString());
        ExtendedBytecodeTest.assertEquals((String)"@java.lang.annotation.Retention(value=java.lang.annotation.RetentionPolicy.RUNTIME)", (String)ans.get(2).toString());
        ct = (ClassFile)ni.getClassType("X");
        ans = ct.getFields().get(0).getAnnotations();
        an = ans.get(0);
        ExtendedBytecodeTest.assertEquals((String)"@javax.xml.bind.annotation.XmlElements(value={@javax.xml.bind.annotation.XmlElement(name=\"Text\",namespace=\"aNameSpace\",type=java.lang.Object.class)})", (String)an.toString());
        ct = (ClassFile)ni.getClassType("java.lang.management.LockInfo");
        an = ct.getConstructorInfos().get(0).getAnnotations().get(0);
        ExtendedBytecodeTest.assertEquals((String)"@java.beans.ConstructorProperties(value={\"className\",\"identityHashCode\"})", (String)an.toString());
        ct = (ClassFile)ni.getClassType("com.sun.xml.internal.ws.api.FeatureConstructor");
        Object defaultValue = ((AnnotationPropertyInfo)ct.getMethodInfos().get(0)).getDefaultValue();
        ExtendedBytecodeTest.assertTrue((boolean)(defaultValue instanceof Object[]));
        ExtendedBytecodeTest.assertEquals((int)0, (int)((Object[])defaultValue).length);
        ct = (ClassFile)ni.getClassType("javax.xml.ws.RespectBinding");
        ans = ct.getAnnotations();
        ExtendedBytecodeTest.assertEquals((String)"@java.lang.annotation.Target(value={java.lang.annotation.ElementType.TYPE})", (String)ans.get(0).toString());
        ExtendedBytecodeTest.assertEquals((String)"@java.lang.annotation.Retention(value=java.lang.annotation.RetentionPolicy.RUNTIME)", (String)ans.get(1).toString());
        ExtendedBytecodeTest.assertEquals((String)"@java.lang.annotation.Documented", (String)ans.get(2).toString());
        ExtendedBytecodeTest.assertEquals((String)"@javax.xml.ws.spi.WebServiceFeatureAnnotation(id=\"javax.xml.ws.RespectBindingFeature\",bean=javax.xml.ws.RespectBindingFeature.class)", (String)ans.get(3).toString());
        ct = (ClassFile)ni.getClassType("javax.annotation.Resource");
        for (MethodInfo mi : ct.getMethodInfos()) {
            AnnotationPropertyInfo api = (AnnotationPropertyInfo)mi;
            defaultValue = api.getDefaultValue();
            if (api.getName().equals("name")) {
                ExtendedBytecodeTest.assertTrue((boolean)(defaultValue instanceof String));
                ExtendedBytecodeTest.assertEquals((Object)"", (Object)defaultValue);
                continue;
            }
            if (api.getName().equals("type")) {
                ExtendedBytecodeTest.assertTrue((boolean)(defaultValue instanceof Type));
                ExtendedBytecodeTest.assertEquals((String)"java.lang.Object", (String)((Type)defaultValue).getClassName());
                continue;
            }
            if (api.getName().equals("authenticationType")) {
                ExtendedBytecodeTest.assertTrue((boolean)(defaultValue instanceof EnumConstantReferenceInfo));
                ExtendedBytecodeTest.assertEquals((String)"javax.annotation.Resource.AuthenticationType.CONTAINER", (String)defaultValue.toString());
                continue;
            }
            if (!api.getName().equals("shareable")) continue;
            ExtendedBytecodeTest.assertTrue((boolean)(defaultValue instanceof Boolean));
            ExtendedBytecodeTest.assertEquals((Object)Boolean.TRUE, (Object)defaultValue);
        }
    }

    public void testReadCompleteRTJar() throws Exception {
        File f = FileUtils.getPathOfSystemClasses();
        ZipFile zf = new ZipFile(f);
        Enumeration<? extends ZipEntry> zes = zf.entries();
        while (zes.hasMoreElements()) {
            ZipEntry ze = zes.nextElement();
            if (!ze.getName().endsWith(".class")) continue;
            InputStream is = zf.getInputStream(ze);
            new ASMBytecodeParser().parseClassFile(is, ze.getName(), true);
        }
    }
}

