/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.fixedbugs;

import java.io.FileInputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ModelException;
import recoder.ParserException;
import recoder.ProgramFactory;
import recoder.abstraction.ClassType;
import recoder.abstraction.ErasedConstructor;
import recoder.abstraction.Method;
import recoder.abstraction.Type;
import recoder.bytecode.ByteCodeParser;
import recoder.bytecode.MethodInfo;
import recoder.bytecode.ReflectionImport;
import recoder.convenience.CustomTreeWalker;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.JavaProgramFactory;
import recoder.java.StatementBlock;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.LocalVariableDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.declaration.modifier.Final;
import recoder.java.expression.Assignment;
import recoder.java.expression.operator.New;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.TypeReference;
import recoder.java.statement.LoopStatement;
import recoder.kit.MethodKit;
import recoder.kit.TypeKit;
import recoder.service.NameInfo;
import recoder.service.SemanticsChecker;
import recoder.service.SourceInfo;
import recoder.testsuite.RecoderTestCase;

public class FixedBugs
extends RecoderTestCase {
    public void testConstructorStartPosition() throws ParserException {
        ProgramFactory f = this.sc.getProgramFactory();
        CompilationUnit cu = f.parseCompilationUnit("public class Test\n{\nTest s;\npublic Test(Test s)\n{\nthis.s = s;\n}\n}");
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
        FixedBugs.assertTrue((((ConstructorDeclaration)this.sc.getNameInfo().getClassType("Test").getConstructors().get(0)).getStartPosition().getLine() == 4 ? 1 : 0) != 0);
    }

    public void testSingleLineCommentBug() throws ParserException {
        ProgramFactory f = this.sc.getProgramFactory();
        CompilationUnit cu = f.parseCompilationUnit("class A {\n\n\n//some comment\r\nA a; } class B {}");
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
        FieldDeclaration fd = (FieldDeclaration)((TypeDeclaration)cu.getDeclarations().get(0)).getMembers().get(0);
        TypeReference oldType = fd.getTypeReference();
        TypeReference newType = TypeKit.createTypeReference(this.sc.getProgramFactory(), "B");
        fd.replaceChild(oldType, newType);
        this.sc.getChangeHistory().replaced(oldType, newType);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
        String s = cu.toSource().replaceAll(" ", "");
        FixedBugs.assertTrue((boolean)s.equals("classA{\n\n\n//somecomment\nBa;\n}classB{\n}\n"));
    }

    public void testFieldTypes() throws ParserException {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        ProgramFactory f = this.sc.getProgramFactory();
        CompilationUnit cu = f.parseCompilationUnit("class B { } class G<E> { E field;   void m() { B b; b = new G<B>().field; } }");
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
        ClassDeclaration classB = (ClassDeclaration)cu.getDeclarations().get(0);
        ClassDeclaration classG = (ClassDeclaration)cu.getDeclarations().get(1);
        MethodDeclaration methodM = (MethodDeclaration)classG.getMethods().get(0);
        Assignment assignment = (Assignment)methodM.getBody().getChildAt(1);
        Expression rhs = (Expression)assignment.getChildAt(1);
        Type rhsType = this.sc.getSourceInfo().getType(rhs);
        FixedBugs.assertEquals((Object)rhsType, (Object)classB);
    }

    public void testBasicReflectionImport() {
        FixedBugs.assertTrue((ReflectionImport.getClassFile("java.lang.String") != null ? 1 : 0) != 0);
        FixedBugs.assertTrue((ReflectionImport.getClassFile("asdasdasd") == null ? 1 : 0) != 0);
    }

    public void testIncorrectFileEnd() {
        ProgramFactory f = this.sc.getProgramFactory();
        String cuText = "class B { }//";
        int i = 0;
        while (i < 4081) {
            cuText = String.valueOf(cuText) + " ";
            ++i;
        }
        i = 4081;
        while (i < 4087) {
            try {
                f.parseCompilationUnit(cuText);
                cuText = String.valueOf(cuText) + " ";
            }
            catch (ParserException pe) {
                FixedBugs.fail();
            }
            ++i;
        }
    }

    public void testBug1894463() throws ParserException {
        ProgramFactory f = this.sc.getProgramFactory();
        String cuText = "public class MockClass1 {\npublic class InnerClass {public class InnerInnerClass { }}}class MockClass2 {void test(MockClass1 mockClass1) {mockClass1.new InnerClass();MockClass1.InnerClass ic = new InnerClass();ic.new InnerInnerClass();new InnerClass();}public class InnerClass {}}";
        CompilationUnit cu = f.parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
        ClassDeclaration mock2 = (ClassDeclaration)this.sc.getNameInfo().getType("MockClass2");
        StatementBlock sb = ((MethodDeclaration)mock2.getMembers().get(0)).getBody();
        FixedBugs.assertTrue((boolean)((ClassDeclaration)this.sc.getCrossReferenceSourceInfo().getType((New)sb.getStatementAt(0))).getFullName().equals("MockClass1.InnerClass"));
        FixedBugs.assertTrue((boolean)((ClassDeclaration)this.sc.getCrossReferenceSourceInfo().getType((New)sb.getStatementAt(2))).getFullName().equals("MockClass1.InnerClass.InnerInnerClass"));
        FixedBugs.assertTrue((boolean)((ClassDeclaration)this.sc.getCrossReferenceSourceInfo().getType((New)sb.getStatementAt(3))).getFullName().equals("MockClass2.InnerClass"));
    }

    public void testBug1895973() throws ParserException {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        ProgramFactory f = this.sc.getProgramFactory();
        String cuText = "import java.util.ArrayList;\npublic class MockClass extends ArrayList<String> {\npublic String test() {\n// Recoder doesn't detect that 'get(0)' returns a String !\nreturn get(0).toLowerCase();\n}\n}\n";
        CompilationUnit cu = f.parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
    }

    public void testBug1911073() throws ParserException {
        String cuText = "class A {\n\tint l;\n\tvoid m() {\n\t\tswitch(l) {\n\t\t}\n\t}\n}\n";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        FixedBugs.assertTrue((boolean)cu.toSource().endsWith("        }\n    }\n}\n"));
    }

    public void testBug1936528() throws ParserException {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "class A {\nvoid method(String s, Object... params){ }\nvoid method(String s, Throwable t, Object... params){ \nmethod(\"toto\", new Exception());}}\n";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
    }

    public void testBug1936842() throws ParserException {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "import java.util.*;\nclass Mock\n{\nvoid method()\n{\nList l = new ArrayList();\nl.add(0);\nList<Object> l2 = new ArrayList<Object>();\nl2.add(0);\n}\n}\n";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
    }

    public void testCommentAttachment() throws ParserException {
        String cuText = "class A {\n\tvoid m(/*c1*/ int p /*c2*/) {\n\t\t//Comment\n\t\tint x = /*c3*/3;\n\t}\n}\n";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
        MethodDeclaration md = (MethodDeclaration)cu.getTypeDeclarationAt(0).getMembers().get(0);
        FixedBugs.assertTrue((md.getBody().getStatementAt(0).getComments().size() == 1 ? 1 : 0) != 0);
        FixedBugs.assertTrue((md.getParameterDeclarationAt(0).getComments().size() == 1 ? 1 : 0) != 0);
        FixedBugs.assertTrue((md.getParameterDeclarationAt(0).getVariableSpecification().getIdentifier().getComments().size() == 1 ? 1 : 0) != 0);
        FixedBugs.assertTrue((((VariableSpecification)((LocalVariableDeclaration)md.getBody().getStatementAt(0)).getVariableSpecifications().get(0)).getInitializer().getComments().size() == 1 ? 1 : 0) != 0);
    }

    public void testBug1948045() throws ParserException {
        String cuText = "public class FinalInnerClass {public void method(){final class InnerClass{}}}";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
        FixedBugs.assertTrue((((DeclarationSpecifier)((MethodDeclaration)cu.getTypeDeclarationAt(0).getMethods().get(0)).getTypes().get(0).getDeclarationSpecifiers().get(0)).getClass() == Final.class ? 1 : 0) != 0);
    }

    public void testBug1965975() throws ParserException {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "import java.util.List; class A { void m() { List<String> l; } }";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
        this.sc.getSourceInfo().getMethods((ClassType)this.sc.getSourceInfo().getType(((LocalVariableDeclaration)((MethodDeclaration)cu.getTypeDeclarationAt(0).getMethods().get(0)).getBody().getStatementAt(0)).getTypeReference()));
    }

    public void testBug1974988() throws ParserException {
        String declText = "@Annot String decl = \"Test\";";
        FieldDeclaration fd = new JavaProgramFactory().parseFieldDeclaration(declText);
        fd.deepClone();
    }

    public void testBug1988746() throws ParserException {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "class A { void setDouble(Double p) {Double toto = new Double(1) ;  Double titi = new Double(2) ;\tthis.setDouble(toto * titi);}}";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
    }

    public void testBug1996819() throws ParserException {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "class A { void m(String[] s) {\ts.clone(); ((Object)s).clone();}}";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
        MethodReference expr = (MethodReference)((MethodDeclaration)cu.getTypeDeclarationAt(0).getMethods().get(0)).getBody().getStatementAt(0);
        FixedBugs.assertTrue((boolean)this.sc.getSourceInfo().getType(expr).getName().equals("String[]"));
        Method cloneMethod = this.sc.getSourceInfo().getMethod(expr);
        Type clonedType = this.sc.getSourceInfo().getType(cloneMethod);
        FixedBugs.assertTrue((boolean)clonedType.getFullName().equals("java.lang.String[]"));
        FixedBugs.assertTrue((cloneMethod.getExceptions().size() == 0 ? 1 : 0) != 0);
        Method objCloneMethod = this.sc.getSourceInfo().getMethod((MethodReference)((MethodDeclaration)cu.getTypeDeclarationAt(0).getMethods().get(0)).getBody().getStatementAt(1));
        FixedBugs.assertTrue((objCloneMethod != cloneMethod ? 1 : 0) != 0);
        FixedBugs.assertTrue((boolean)MethodKit.getAllRedefinedMethods(cloneMethod).contains(objCloneMethod));
    }

    public void testBug2020825() throws ParserException {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "import java.util.*; class A<E> { class B extends ArrayList<E> {} B m() { new A<String>().m().get(0).toLowerCase(); return null; }}";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
    }

    public void testBug2013315() throws ParserException {
        this.sc.getProjectSettings().setProperty("input.path", "test/fixedBugs/Bug2013315");
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "class X {{Test instance = new Test();instance.myMap.get(\"\").shortValue(); }}";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
    }

    public void testBug2044230() throws ParserException {
        String cuText = "class A { public static final double MAX_VALUE = 0x1.fffffffffffffP+1023;}";
        this.sc.getProgramFactory().parseCompilationUnit(cuText);
    }

    public void testBug2045181() throws ParserException {
        String cuText = "package B; class A { static class InA {}}";
        String cu2Text = "package B;import B.A.*;class B extends InA {}";
        this.runIt(cuText, cu2Text);
    }

    public void testBug2045207() throws ParserException {
        String cuText = "class A {public <T> A(T p1, Class<T> p2) { }}";
        this.runIt(cuText);
    }

    public void testBug2045354() throws ParserException {
        String cuText = "import java.security.*;class A implements PrivilegedAction<String> {public String run() {\treturn null;}{ A a = new A(); String s; s = AccessController.doPrivileged(a); }}";
        this.runIt(cuText);
    }

    public void testBug2046005() throws ParserException {
        String cuText = "class A<T> {\n\t<T> T foo(Class<T> p) { return null;}}\nclass B {\n{\nfinal Class<String> v = String.class;\nA<?> a = null;\na.foo(v).toLowerCase();\n}\n}\n";
        this.runIt(cuText);
    }

    public void testBug2046005_2() throws ParserException {
        String cuText = "class A<T> {\n\t<T> T foo(Class<T> p) { return null;}}\nclass B {\n{\nfinal Class<String> v = String.class;\nA a = null;\na.foo(v).toLowerCase();\n}\n}\n";
        this.runIt(new RecoderTestCase.SilentErrorHandler(1), cuText);
    }

    public void testBug2046005_3() throws ParserException {
        String cuText = "class A<T> {\n\t<Q> Q foo(String s, Class<Q> c) { return null; }\t<T> T foo(Class<T> p) { return null;}}\nclass B {\n{\nfinal Class<String> v = String.class;\nA x = null;\nA<?> a = null;\na.foo(v).toLowerCase();\n}\n}\n";
        this.runIt(cuText);
    }

    public void testBug2046167() throws ParserException {
        String cuText = "package com.sun.org.apache.xerces.internal.impl.xs.identity;import com.sun.org.apache.xerces.internal.impl.xpath.XPathException;import com.sun.org.apache.xerces.internal.util.SymbolTable;import com.sun.org.apache.xerces.internal.xni.NamespaceContext;public class Field {public static class XPath    extends com.sun.org.apache.xerces.internal.impl.xpath.XPath {    public XPath() throws XPathException {        super(null, null, null);        com.sun.org.apache.xerces.internal.impl.xpath.XPath.Axis axis = null;        if (axis.type == XPath.Axis.ATTRIBUTE) {               throw new XPathException(null);        }    }}}";
        this.runIt(cuText);
    }

    public void testBug2046337() throws ParserException {
        String cuText = "class A { void foo() {new String[3].getClass();}}";
        CompilationUnit cus = this.runIt(cuText).get(0);
        ((Object)((Object)this)).getClass();
        ClassType t = (ClassType)cus.getFactory().getServiceConfiguration().getSourceInfo().getType(((MethodDeclaration)cus.getTypeDeclarationAt(0).getMembers().get(0)).getBody().getStatementAt(0));
        FixedBugs.assertTrue((boolean)t.getFullSignature().equals("java.lang.Class<? extends java.lang.String[]>"));
    }

    public void testExplicitGenInvokeParserTest() throws ParserException {
        String cuText = "class A{{java.util.Collections.<String, String[]>emptyMap();}}";
        this.runIt(cuText);
    }

    public void testCaptureOfIssue() throws ParserException {
        String cuText = "class A {void foo(Number n) { }void bar() {  java.util.Iterator<? extends Number> it = null;  foo(it.next());}}";
        this.runIt(cuText);
    }

    public void testEnumSupertypeBug() throws ParserException {
        String cuText = "enum A implements java.util.Comparator<Number> {; { Number[] n = null; java.util.Arrays.sort(n, this); }}";
        this.runIt(cuText);
    }

    public void testCaptureBugParamMatches() throws ParserException {
        String cuText = "import java.util.Comparator;class A {private static <T> void binarySearch0(T[] a, T key, Comparator<? super T> c) {\t    c.compare(key, key);}}";
        this.runIt(cuText);
    }

    public void testClassLiteralTypes() throws ParserException {
        String cuText = "class A {void m() {void.class.cast(null);int.class.cast(null);Integer.class.cast(null);}}";
        CompilationUnit cu = this.runIt(cuText).get(0);
        StatementBlock sb = ((MethodDeclaration)cu.getTypeDeclarationAt(0).getMembers().get(0)).getBody();
        SourceInfo si = cu.getFactory().getServiceConfiguration().getSourceInfo();
        FixedBugs.assertTrue((boolean)((ClassType)si.getType(sb.getStatementAt(0))).getFullSignature().equals("java.lang.Void"));
        FixedBugs.assertTrue((boolean)((ClassType)si.getType(sb.getStatementAt(1))).getFullSignature().equals("java.lang.Integer"));
        FixedBugs.assertTrue((boolean)((ClassType)si.getType(sb.getStatementAt(2))).getFullSignature().equals("java.lang.Integer"));
    }

    public void testValidateBug() throws ParserException {
        String cuText = "class A { {byte b; b = 5; Class<?> classes[]; classes = new Class[20];}}";
        this.runIt(cuText);
    }

    public void testTypeInferenceBug() throws ParserException {
        String cuText = "import java.util.Collection;class A { static class B<E> {E bar[];}static class C<E> extends B<E> {public void foo(Collection<? extends E> c) {      E[] a = null;      a = c.toArray(bar);}\t}}";
        this.runIt(cuText);
    }

    public void testAnonymousEnumInstanceParent() throws ParserException {
        String cuText = "public enum A {CONST { public int foo() { return 0; }};public int foo() { return -1; }}class B {void foo(A a) { foo(A.CONST); }}";
        this.runIt(cuText);
    }

    public void testValidateBug2() throws ParserException {
        String cuText = "public class A<E> extends java.util.AbstractQueue<E> {private final Object lock;private class B {public void foo() { final Object i = A.this.lock; }}}";
        this.runIt(cuText);
    }

    public void testBug2044375() throws ParserException {
        String cuText = "import java.util.HashMap;class A {  HashMap<String, Unknown<String, String>> field;  public Unknown<String, String> getChangeString(String s) {    return field.get(s);  }}";
        try {
            this.runIt(new RecoderTestCase.SilentErrorHandler(2), cuText);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testEnumValueOfReturnType() throws ParserException {
        String cuText = "public class A { void foo() { Class c = null; Enum.valueOf(c, \"WAITING\"); }}";
        CompilationUnit cu = this.runIt(cuText).get(0);
        SourceInfo si = cu.getFactory().getServiceConfiguration().getSourceInfo();
        Type t = si.getType(((MethodDeclaration)cu.getTypeDeclarationAt(0).getMembers().get(0)).getBody().getStatementAt(1));
        FixedBugs.assertEquals((String)t.getFullName(), (String)"java.lang.Enum");
    }

    public void testArraySupertypes() {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        ClassType ct = this.sc.getNameInfo().getClassType("java.lang.String[]");
        HashSet<String> supStr = new HashSet<String>();
        for (ClassType sup : ct.getSupertypes()) {
            supStr.add(sup.getFullSignature());
        }
        FixedBugs.assertTrue((supStr.size() == 4 ? 1 : 0) != 0);
        FixedBugs.assertTrue((boolean)supStr.contains("java.lang.Object[]"));
        FixedBugs.assertTrue((boolean)supStr.contains("java.io.Serializable[]"));
        FixedBugs.assertTrue((boolean)supStr.contains("java.lang.Comparable<java.lang.String>[]"));
        FixedBugs.assertTrue((boolean)supStr.contains("java.lang.CharSequence[]"));
    }

    public void testRHSUnboxing() throws ParserException {
        String cuText = "class A { {float num = 0;int i = 0;int[] args = null;\ti++;\tnum = Integer.valueOf(args[i]);}}";
        CompilationUnit cu = this.runIt(cuText).get(0);
        cu.validateAll();
    }

    public void testBug2071287() throws ParserException {
        String cuText = "class A {\nvoid m() {\n  {\n    for (;;) {\n      int n;\n    }\n  }\n  int n;\n}\n}\n";
        List<CompilationUnit> cul = this.runIt(cuText);
        for (CompilationUnit cu : cul) {
            cu.validateAll();
        }
        TreeWalker tw = new TreeWalker(cul.get(0));
        while (tw.next(LoopStatement.class)) {
            LoopStatement ls = (LoopStatement)tw.getProgramElement();
            LoopStatement repl = ls.deepClone();
            ls.getASTParent().replaceChild(ls, repl);
            this.sc.getChangeHistory().replaced(ls, repl);
        }
        this.sc.getChangeHistory().updateModel();
    }

    public void testBytecodeInnerClass() {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        ClassType itr = this.sc.getNameInfo().getClassType("java.util.AbstractList.Itr");
        FixedBugs.assertTrue((boolean)itr.isInner());
    }

    public void testBug2088980() throws ParserException {
        String cuText = "import java.util.*;class A {\tpublic <T> T methodCallingGenericMethod(T bean) {\t\tCollection<T> aList = new ArrayList<T>();\t\taList.add(Collections.singletonList(bean).get(0));\t}}";
        List<CompilationUnit> cus = this.runIt(cuText);
        for (CompilationUnit cu : cus) {
            cu.validateAll();
        }
    }

    public void testBug2132665() throws ParserException {
        String cuText = "import java.awt.Dialog;import java.awt.Frame;public class Main {public static void main(String[] args) {Frame frame = new Frame();new Dialog(frame){public void init(){//initme\n}}.init();}}";
        List<CompilationUnit> cus = this.runIt(cuText);
        for (CompilationUnit cu : cus) {
            cu.validateAll();
        }
        CustomTreeWalker ctw = new CustomTreeWalker(cus.get(0));
        ctw.next(MethodDeclaration.class);
        ctw.next(MethodDeclaration.class);
        MethodDeclaration method = (MethodDeclaration)ctw.getProgramElement();
        FixedBugs.assertNotNull((Object)method.getContainingClassType().getFullName());
    }

    public void testBug2134267() throws ParserException {
        this.sc.getProjectSettings().setProperty("input.path", "test/fixedBugs/Bug2134267/*.jar");
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "package runner;public class Main {public static void main(String[] args) {COM.AClass value = null;}}";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
    }

    public void testBug2155226() throws ParserException {
        String cuText = "class KnownBasicClass{}class TestFailed1 extends UnknownGenericClass<KnownBasicClass>{}";
        this.runIt(new RecoderTestCase.SilentErrorHandler(1), cuText);
    }

    public void testBug2230018() throws ParserException {
        String cuText = "import com.pkg.UnknownClass;class KnownBasicClass{    int nb = UnknownClass.CONSTANT;}";
        this.runIt(new RecoderTestCase.SilentErrorHandler(4), cuText);
    }

    public void testBug2230018_2() throws ParserException {
        String cuText = "package com.example.generics;import com.Blubb;public class ExtendsUnknownGeneric extends Toto<DynamicType>{  public void method()  {    String s = Blubb.CONSTANTE ;  }}";
        this.runIt(new RecoderTestCase.SilentErrorHandler(6), cuText);
    }

    public void testOverwritingWithPrimitives() throws ParserException {
        String cuText = "abstract class A<T> { abstract void foo(T a); }\nclass B extends A<Integer> {\n\tvoid foo(int a) {}\n}\nclass C extends B {\tvoid foo(long a) {\t}\n}";
        List<CompilationUnit> cus = this.runIt(cuText);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
        FixedBugs.assertEquals((int)MethodKit.getRedefinedMethods(cus.get(0).getTypeDeclarationAt(1).getMethods().get(0)).size(), (int)0);
        FixedBugs.assertEquals((int)this.sc.getSourceInfo().getAllMethods(cus.get(0).getTypeDeclarationAt(1)).size(), (int)13);
        FixedBugs.assertEquals((int)MethodKit.getRedefinedMethods(cus.get(0).getTypeDeclarationAt(2).getMethods().get(0)).size(), (int)0);
        FixedBugs.assertEquals((int)this.sc.getSourceInfo().getAllMethods(cus.get(0).getTypeDeclarationAt(2)).size(), (int)14);
    }

    public void testCrossReferencer() throws ParserException {
        String cuText = "class A {\n\tvoid foo(long a) {\t\tjava.util.LinkedList ll = new java.util.LinkedList();\n\t}}";
        List<CompilationUnit> cus = this.runIt(cuText);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
        FixedBugs.assertEquals((int)this.sc.getCrossReferenceSourceInfo().getReferences(this.sc.getNameInfo().getType("java.util.LinkedList")).size(), (int)2);
    }

    public void testBug2343547() throws Exception {
        new ByteCodeParser().parseClassFile(new FileInputStream("test/fixedBugs/Bug2343547/ICacheManager.class"));
    }

    public void testBug2510517() throws Exception {
    }

    public void testBug2523272() throws Exception {
        this.sc.getProjectSettings().setProperty("input.path", "test/fixedBugs/Bug2523272");
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        this.sc.getProjectSettings().setErrorHandler(new RecoderTestCase.SilentErrorHandler(0));
        String cuText = "class X { void foo(recoder.convenience.ASTIteratorListener o) {} }";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
        ClassType ct = this.sc.getNameInfo().getClassType("recoder.convenience.ASTIteratorListener");
        List<Type> sig = ct.getMethods().get(0).getSignature();
        FixedBugs.assertNotNull((Object)sig.get(0));
        FixedBugs.assertNotNull((Object)sig.get(1));
        FixedBugs.assertEquals((Object)sig.get(0), (Object)this.sc.getNameInfo().getUnknownClassType());
        FixedBugs.assertEquals((Object)sig.get(1), (Object)this.sc.getNameInfo().getUnknownClassType());
    }

    public void testBug2609084() throws Exception {
        this.sc.getProjectSettings().setProperty("input.path", "test/fixedBugs/Bug2609084");
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "class Y { String s; void foo(X<String> x) {s = x.o.toUpperCase(); } }";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
        FixedBugs.assertNotSame((Object)this.sc.getNameInfo().getClassType("X").getFields().get(0).getType(), (Object)this.sc.getNameInfo().getUnknownClassType());
    }

    public void testBug2808379() throws Exception {
        String cuText = "class A {\n\tstatic Object foo() { return null; }\n}\nclass B extends A {\n\tstatic String foo() { return null; }\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        FixedBugs.assertEquals((int)1, (int)MethodKit.getRedefiningMethods(this.sc.getCrossReferenceSourceInfo(), cus.get(0).getTypeDeclarationAt(0).getMethods().get(0)).size());
        FixedBugs.assertEquals((int)1, (int)MethodKit.getRedefinedMethods(cus.get(0).getTypeDeclarationAt(1).getMethods().get(0)).size());
    }

    public void testBug2813956() throws Exception {
        String cuText = "class Y<T> {\n\tpublic void foo(Class<T> c) { }\n}\nclass X extends Y {\n\tpublic void foo(Class c) { } \n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
        FixedBugs.assertEquals((int)1, (int)MethodKit.getAllRedefinedMethods(cus.get(0).getTypeDeclarationAt(1).getMethods().get(0)).size());
    }

    public void testBug2824786() throws Exception {
        String cuText = "import static a.X2.I;class X {\tI e = null;}";
        String cuText2 = "package a;public class X2 {\tpublic interface I { void foo(); }}";
        List<CompilationUnit> cus = this.runIt(cuText, cuText2);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
    }

    public void testBug2828305() throws Exception {
        String cuText = "class C {@Deprecated <A extends Number> A foo(A a) { return null; }}";
        List<CompilationUnit> cus = this.runIt(cuText);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
    }

    public void testBugImportButNoTypeDeclaration() throws Exception {
        String cuText = "package a;\n public class A { public @interface AA { String s(); }; static final String x = \"\";}";
        String cuText2 = "@A.AA(s = x) package a;\n import static a.A.x;";
        List<CompilationUnit> cus = this.runIt(cuText, cuText2);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
    }

    public void testBug2828368() throws Exception {
        String cuText = "class X {interface I { }class Y extends java.util.ArrayList<Number> implements I { }void g(I o) { }void g(java.util.Collection<String> p) { }void h() {\tg(new Y());}}";
        List<CompilationUnit> cus = this.runIt(cuText);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
    }

    public void test2828368_2() throws Exception {
        String cuText = "public class X { \tvoid foo() { new Y(new java.util.ArrayList()); }}";
        String cuText2 = "public class Y extends X {\tY(java.util.List<X> l) { }}";
        List<CompilationUnit> cus = this.runIt(cuText, cuText2);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
    }

    public void test2828368_3() throws Exception {
        String cuText = "public class S { \tS(java.util.Enumeration<? extends Number> p) { }\tvoid foo() {\t\tnew S(java.util.Collections.enumeration(new java.util.ArrayList()));\t}}";
        List<CompilationUnit> cus = this.runIt(cuText);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
    }

    public void testHidingTypeParameterDeclarationBug() throws Exception {
        String cuText = "import java.util.*;\nclass X {\n{\n\t\tX comp = null;\n\t\tList<String> nameList = null;\n\t\tcomp.compile(Y.from(nameList.toArray(new String[0])));\n\t}\n\tvoid compile(List<String> f) { }\n}\nclass Y<A> {\n\tstatic <A> List<A> from(A[] array) { return null; }\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
    }

    public void testFindInheritedTypeAndFieldThroughPackageImport() throws Exception {
        String cuText = "import static x.A.*;class X {\tMember m = null;\tint x = intField;}";
        String cuText2 = "package x;public class A extends Base {}";
        String cuText3 = "package x;public class Base {\tpublic static class Member { }\tpublic static final int intField = 123;}";
        List<CompilationUnit> cus = this.runIt(cuText, cuText2, cuText3);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
    }

    public void testInheritedTypeByOuterClass() throws Exception {
        String cuText = "package a; public class A { protected interface I {}; }";
        String cuText2 = "public class B extends a.A {\tI i = null;\tclass Inner {\t\tI i = null;\t}}";
        List<CompilationUnit> cus = this.runIt(cuText, cuText2);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
    }

    public void testResolveTypeParameterReference() throws Exception {
        String cuText = "abstract class X<T extends Number> {private static abstract class Member<T extends Number> extends X<T> {\tprotected F<T> filter() {\t\treturn new F<T>() {\t\t\tprotected boolean matches(T d) {\t\t\t\treturn match(d);\t\t\t}\t\t};\t}\tprotected abstract boolean match(T d);}}abstract class F<T> {\tprotected abstract boolean matches(T t);}";
        List<CompilationUnit> cus = this.runIt(cuText);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
    }

    public void testGetRawMemberType() throws Exception {
        String cuText = "class X {\tprivate class Inner extends a.Other {\t\tprivate class X extends Member { }\t}}";
        String cuText2 = "package a;public abstract class Other<M> {\tprotected abstract static class Member { }}";
        List<CompilationUnit> cus = this.runIt(cuText, cuText2);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
    }

    public void testPrintEmptyMethodComments() throws Exception {
        String cuText = "class X {\n\tX() { /* empty */ }\n\tX(int i) {\n // empty \n}\n\tfoo() {\n\t\t// empty as well\n\t}\n\tbar() {\n\t\t/* empty 4*/\n\t}\n}\ninterface A { /* interfaceComment*/ }";
        List<CompilationUnit> cus = this.runIt(cuText);
        for (CompilationUnit cu : cus) {
            cu.validate();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
        String s = cus.get(0).toSource().replaceAll("( |\n)", "");
        FixedBugs.assertEquals((String)"classX{X(){/*empty*/}X(inti){//empty}foo(){//emptyaswell}bar(){/*empty4*/}}interfaceA{/*interfaceComment*/}", (String)s);
    }

    public void testImportBug() throws Exception {
        String cuText1 = "package p;\nclass A {\n\tpublic static class X {\n\t\tpublic static final int q = 3;\n\t}\n\tpublic class Y { public static final int q = 5;\n }}\n";
        String cuText2 = "package p;\nclass A2 extends A { }\n";
        String cuText3 = "package q;\nimport p.A2.*;class I {\n\tvoid foo() {\n\t\tint i = X.q;\t}\n}\n";
        String cuText4 = "package q;\nimport static p.A2.*;class J {\n\tvoid foo() {\n\t\tint i = X.q;\t}\n}\n";
        String cuText5 = "package q;\nimport static p.A2.*;class K {\n\tvoid foo() {\n\t\tint i = Y.q;\t}\n}\n";
        this.runIt(new RecoderTestCase.SilentErrorHandler(6), cuText1, cuText2, cuText3, cuText4, cuText5);
    }

    public void testAmbiguousMethodBecauseOfErasure() throws Exception {
        String cuText1 = "abstract class A<T> {void foo(T t) { C<T> c = new C<T>(); c.foo(t); } }class B extends A<String> {void foo(String s) { }}class C<T> extends A<T> {void foo(Object s) { }void foo(T t) { }}";
        List<CompilationUnit> cus = this.runIt(cuText1);
    }

    public void testBug2838441() throws Exception {
        String cuText1 = "import java.util.*;\nclass X extends HashMap {\n\tvoid foo(Entry e) { }\n\tvoid bar(Map.Entry e) { }\n}\n";
        this.runIt(new RecoderTestCase.SilentErrorHandler(1), cuText1);
    }

    public void testGenericConstructors() throws Exception {
        String cuText1 = "class NN {\n<T> NN (T t1, T t2) { }\nNN() {\n\t<String>this(null, null);\n}\n}\nclass MM extends NN {\nMM() {\n\t<String>super(null, null);\n\tnew <String>NN(null, null);\n}\n}\n";
        CompilationUnit cu = this.runIt(cuText1).get(0);
        String res = cu.toSource();
        FixedBugs.assertEquals((String)cuText1.replaceAll("( |\n|\t)", ""), (String)res.replaceAll("( |\n|\t)", ""));
    }

    public void testBug2838979() throws Exception {
        String cuText1 = "class B<T> { }\nclass A {\n  public void foobar( B<B<B<A>>> a, B<B<A>> b) {}\n}\n";
        this.runIt(cuText1);
    }

    public void testLocalTypesReadFromBytecode() throws Exception {
        this.sc = new CrossReferenceServiceConfiguration();
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        ClassType coll = this.sc.getNameInfo().getClassType("java.util.Collections");
        for (Method m : coll.getMethods()) {
            if (!m.getName().equals("enumeration")) continue;
            MethodInfo mi = (MethodInfo)m;
            ClassType classType = mi.getTypes().get(0);
        }
    }

    public void testBug2843524() throws Exception {
        String cuText = "public abstract class SomeClass {\n    public abstract <T extends Comparable<T>> boolean check(T x);\n    public boolean match(String s) {\n        return check(s);\n    }\n}\n";
        this.runIt(cuText);
    }

    public void testGenericsIssue() throws Exception {
        String cuText1 = "package p;import java.util.*;class D {\n\tvoid foo() { \t\tString x[] = new String[1];\t\tArrays.asList(x).get(0).toLowerCase(); \t}}\n";
        this.runIt(cuText1);
    }

    public void testOverwriteWithMethodTypeParams() throws Exception {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        SourceInfo si = this.sc.getSourceInfo();
        NameInfo ni = this.sc.getNameInfo();
        ClassType ct = ni.getClassType("java.util.AbstractList");
        List<Method> ms = si.getMethods(ct, "remove", Collections.singletonList(ni.getIntType()));
        ClassType ct2 = ni.getClassType("java.util.AbstractCollection");
        List<Method> ms2 = si.getMethods(ct2, "remove", ms.get(0).getSignature(), false, false);
        FixedBugs.assertEquals((int)0, (int)ms2.size());
    }

    public void testBug2849358() throws Exception {
        String cuText = "class A {A(java.awt.Window s) { }A(java.awt.Frame n) { }void foo() {  new A(null);}}";
        CompilationUnit cu = this.runIt(cuText).get(0);
        ConstructorReference cr = (ConstructorReference)((MethodDeclaration)cu.getTypeDeclarationAt(0).getMembers().get(2)).getBody().getBody().get(0);
        FixedBugs.assertEquals(cu.getTypeDeclarationAt(0).getMembers().get(1), (Object)this.sc.getSourceInfo().getConstructor(cr));
    }

    public void testBug2860511() throws Exception {
        String cuText1 = "class A {\n\tvoid foo() {\n \t\tString s = new String[] {\"aa\"} [0];\n\t}\n}\n";
        List<CompilationUnit> cus = this.runIt(cuText1);
        FixedBugs.assertEquals((String)"classA{voidfoo(){Strings=newString[]{\"aa\"}[0];}}", (String)cus.get(0).toSource().replaceAll("( |\n)", ""));
    }

    public void testInnerClass() throws Exception {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        FixedBugs.assertTrue((boolean)this.sc.getNameInfo().getClassType("java.util.HashMap.Values").isInner());
        FixedBugs.assertFalse((boolean)this.sc.getNameInfo().getClassType("java.util.HashMap.Entry").isInner());
    }

    public void testBug2910715() throws Exception {
        this.sc.getProjectSettings().setProperty("input.path", "test/fixedBugs/Bug2910715/gin-1.0-20090622.jar");
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "import com.google.gwt.inject.client.binder.GinLinkedBindingBuilder;\npublic class TestCase { }\n";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
    }

    public void testBug2912087() throws Exception {
        String cuText1 = "@interface A {\n\tpublic int A_CONST = 0; }\n";
        this.runIt(cuText1);
    }

    public void testBug2927536_WorksWithSourceCodeOnly() throws Exception {
        String cuText = "public class A<X, Y>{\tprotected void parentMethod1(A<?, ?> p) { }\tprotected void parentMethod2(Y input) { }}class A2<X> extends A<java.util.List<X>, X>{\tpublic void childMethod() {}}";
        String cuText2 = "public class Test{public void test(A2<String> child){child.childMethod();child.parentMethod1(child);}}";
        this.runIt(cuText, cuText2);
    }

    public void testBug2927536() throws Exception {
        this.sc.getProjectSettings().setProperty("input.path", "test/fixedBugs/Bug2927536");
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "public class Test{public void test(A2<String> child){child.childMethod();}}";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
    }

    public void testBug2927536_2() throws Exception {
        this.sc.getProjectSettings().setProperty("input.path", "test/fixedBugs/Bug2927536_2");
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        String cuText = "public class Test{public void test(A2<String> child){child.parentMethod1(child);}}";
        CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
        this.sc.getChangeHistory().attached(cu);
        this.sc.getChangeHistory().updateModel();
        cu.validateAll();
    }

    public void testBug2980457() throws Exception {
        String cuText = "import p.q.C;\nimport static p.q.C.CONST;\npublic class Test {\n\tprivate C f = CONST;\n}\n";
        this.runIt(new RecoderTestCase.SilentErrorHandler(5), cuText);
    }

    public void testBug2983137() throws Exception {
        String cuText = "class A {\nint f;\n}\nclass B extends A implements java.io.Serializable {}\nclass C extends A implements java.io.Serializable {}\npublic class IT2 {\n\tpublic static void main(String[] args) {\n\t\tnew IT2().foo(new B(), new C()).f = 3;\n\t}\n\t<T> T foo(T t1, T t2) {\t\treturn null;\t}}";
        this.runIt(cuText);
    }

    public void testXXX() throws Exception {
        String cuText = "package p1;\nclass A {\n  protected int f;\n}\n";
        String cuText2 = "package p2;\nclass B extends p1.A{\n  void foo() { new p1.A().f = 3; }\n}\n";
        this.runIt(cuText, cuText2);
        FixedBugs.fail((String)"This code should not be accepted!");
    }

    public void testGetClass1() throws Exception {
        String cuText = "class A {\tint f;}class B extends A implements I {\tpublic void bar() { }}class C extends A implements I {\tpublic void bar() { }}interface I {\tvoid bar();}public class IT2 extends A {\tpublic static void main(String[] args) {\t\tnew IT2().foo(new B(), new C()).getClass().newInstance().bar();\t}\t<T> T foo(T t1, T t2) {\t\treturn null;\t}}";
        try {
            this.runIt(cuText);
            FixedBugs.fail((String)"This code should not be accepted!");
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testGetClass2() throws Exception {
        String cuText = "class A {\tint f;}class B implements I {\tpublic void bar() { }}class C implements I {\tpublic void bar() { }}interface I {\tvoid bar();}public class IT2 extends A {\tpublic static void main(String[] args) {\t\tnew IT2().foo(new B(), new C()).getClass().newInstance().bar();\t}\t<T> T foo(T t1, T t2) {\t\treturn null;\t}}";
        this.runIt(cuText);
    }

    public void testGetClass3() throws Exception {
        String cuText = "class A {\tint f;}class B implements I,I2 {\tpublic void bar() { }}class C implements I,I2 {\tpublic void bar() { }}interface I2 { }\n interface I {\tvoid bar();}public class IT2 extends A {\tpublic static void main(String[] args) {\t\tnew IT2().foo(new B(), new C()).getClass().newInstance().bar();\t}\t<T> T foo(T t1, T t2) {\t\treturn null;\t}}";
        this.runIt(cuText);
    }

    public void testBug3000357() throws Exception {
        String cuText = "public class Test\n{\npublic void test()\n{\njava.util.List l = null;\nString[] s = null;l.add(l.toArray(s));\n}\n}\n";
        this.runIt(cuText);
    }

    public void testBug3000357_2() throws Exception {
        String cuText = "import java.util.List;public class Test<E>\n{\n  Test(E e) { }\n  Test(E[] e) { int i = 0;/*to indicate correct resolved */ }\npublic void test()\n{\nnew Test(new Object[1]);}\n}\n";
        CompilationUnit cu = this.runIt(cuText).get(0);
        FixedBugs.assertEquals((int)((ConstructorDeclaration)((ErasedConstructor)this.sc.getSourceInfo().getConstructor((ConstructorReference)((MethodDeclaration)cu.getTypeDeclarationAt(0).getMembers().get(2)).getBody().getBody().get(0))).getGenericMethod()).getBody().getBody().size(), (int)1);
    }

    public void testBug3073325() throws Exception {
        String cuText = "public class X { }";
        CompilationUnit cu = this.runIt(cuText).get(0);
        Method m = cu.getTypeDeclarationAt(0).getAllMethods().get(0);
        FixedBugs.assertEquals((String)"getClass", (String)m.getName());
        m.getProgramModelInfo().getReturnType(m);
    }
}

