/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.exhaustive;

import java.io.File;
import java.util.List;
import recoder.ParserException;
import recoder.convenience.Format;
import recoder.java.CompilationUnit;
import recoder.java.ProgramElement;
import recoder.java.reference.MethodReference;
import recoder.service.DefaultErrorHandler;
import recoder.service.SemanticsChecker;
import recoder.service.UnresolvedReferenceException;
import recoder.testsuite.RecoderTestCase;
import recoder.util.ProgressEvent;
import recoder.util.ProgressListener;

public class ReadJDKSources
extends RecoderTestCase {
    public void testReadJDKSrc() throws ParserException {
        String path = System.getProperty("java.home");
        path = path.substring(0, path.length() - 3);
        if (!new File(path = String.valueOf(path) + "src.zip").exists()) {
            ReadJDKSources.fail((String)"src.zip not found. Test case needs to be run on a jre delivered with JDK. Also so far tested under Windows only.");
        }
        this.sc.getProjectSettings().setProperty("input.path", path);
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        this.sc.getProjectSettings().ensureExtensionClassesAreInPath();
        ProgressListener pl = new ProgressListener(){
            int x = 0;

            @Override
            public void workProgressed(ProgressEvent pe) {
                if (this.x % 50 == 0) {
                    System.out.print(".");
                }
                if (++this.x == 3000) {
                    System.out.println();
                    this.x = 0;
                }
            }
        };
        this.sc.getProjectSettings().setErrorHandler(new DefaultErrorHandler(){

            @Override
            public void reportError(Exception e) {
                UnresolvedReferenceException ue;
                ProgramElement pe;
                if (e instanceof UnresolvedReferenceException && (pe = (ue = (UnresolvedReferenceException)e).getUnresolvedReference()) instanceof MethodReference && Format.toString(pe).startsWith("\"constr.getAnnotation(propertyNamesClass).value()")) {
                    return;
                }
                super.reportError(e);
            }
        });
        this.sc.getSourceFileRepository().addProgressListener(pl);
        this.sc.getSourceInfo().addProgressListener(pl);
        System.out.println("Start parsing...");
        long start = System.currentTimeMillis();
        List<CompilationUnit> cus = this.sc.getSourceFileRepository().getAllCompilationUnitsFromPath();
        System.out.println("\nparsed " + cus.size() + " CUs in " + (System.currentTimeMillis() - start) / 1000L + " seconds");
        start = System.currentTimeMillis();
        System.out.println("Updating model...");
        start = System.currentTimeMillis();
        this.sc.getChangeHistory().updateModel();
        System.out.println("\nbuilt model in " + (System.currentTimeMillis() - start) / 1000L + " seconds");
        start = System.currentTimeMillis();
        for (CompilationUnit cu : cus) {
            cu.validateAll();
        }
        System.out.println("\nvalidated in " + (System.currentTimeMillis() - start) / 1000L + " seconds");
        start = System.currentTimeMillis();
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
        System.out.println("\nsemantic checks performed in " + (System.currentTimeMillis() - start) / 1000L + " seconds");
    }
}

