/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.exhaustive;

import java.util.ArrayList;
import junit.framework.TestResult;
import recoder.testsuite.CompleteTestSuite;
import recoder.testsuite.RecoderTestCase;

public class ParallelTest
extends RecoderTestCase {
    private final int nThreads = Runtime.getRuntime().availableProcessors();
    private ArrayList<TestResult> results = new ArrayList();

    public void testCompleteTestsuiteInParallel() {
        System.out.println("Starting parallel testing with " + this.nThreads + " threads...");
        Thread[] threads = new Thread[this.nThreads];
        int i = 0;
        while (i < this.nThreads) {
            threads[i] = new Thread(new RunOnce());
            ++i;
        }
        threads[0].setPriority(1);
        threads[this.nThreads - 1].setPriority(10);
        i = 0;
        while (i < this.nThreads) {
            threads[i].start();
            ++i;
        }
        i = 0;
        while (i < this.nThreads) {
            try {
                threads[i].join();
                System.out.println(String.valueOf(i) + " died");
            }
            catch (InterruptedException e) {
                ParallelTest.fail();
            }
            ++i;
        }
        i = 0;
        while (i < this.nThreads) {
            if (this.results.get(i) == null) {
                ParallelTest.fail((String)("Thread run " + i + " didn't complete"));
            }
            ++i;
        }
        i = 1;
        while (i < this.nThreads) {
            ParallelTest.assertEquals((int)this.results.get(i - 1).errorCount(), (int)this.results.get(i).errorCount());
            ParallelTest.assertEquals((int)this.results.get(i - 1).failureCount(), (int)this.results.get(i).failureCount());
            ++i;
        }
    }

    private class RunOnce
    implements Runnable {
        private RunOnce() {
        }

        @Override
        public void run() {
            TestResult tr = new TestResult();
            try {
                new CompleteTestSuite().run(tr);
            }
            catch (Exception e) {
                e.printStackTrace();
                ParallelTest.this.results.add(null);
                return;
            }
            ParallelTest.this.results.add(tr);
        }
    }
}

