/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.basic.syntax;

import java.util.Iterator;
import junit.framework.Assert;
import recoder.convenience.Format;
import recoder.convenience.TreeWalker;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.testsuite.basic.analysis.TestBase;

public class WalkPositionTest
extends TestBase {
    public void testWalkPosition() {
        SourceFileRepository sfr = this.config.getSourceFileRepository();
        Iterator<CompilationUnit> iterator = sfr.getCompilationUnits().iterator();
        while (iterator.hasNext()) {
            CompilationUnit u;
            ProgramElement oldPe = u = iterator.next();
            SourceElement.Position oldPos = u.getFirstElement().getStartPosition();
            TreeWalker tw = new TreeWalker(u);
            while (tw.next()) {
                ProgramElement pe = tw.getProgramElement();
                SourceElement.Position newPos = pe.getFirstElement().getStartPosition();
                if (newPos.equals(SourceElement.Position.UNDEFINED)) {
                    WalkPositionTest.fail((String)("Position undefined: " + Format.toString("%c @%p in %u", pe)));
                }
                if (newPos.getLine() < oldPos.getLine() || newPos.getLine() == oldPos.getLine() && newPos.getColumn() < newPos.getColumn()) {
                    Assert.fail((String)("Position mismatch: " + Format.toString("%c @%p in %u", oldPe) + "/" + Format.toString("%c @%p", pe)));
                }
                oldPos = newPos;
                oldPe = pe;
            }
        }
    }
}

