/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.basic.analysis;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ParserException;
import recoder.io.DefaultProjectFileIO;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.service.DefaultErrorHandler;
import recoder.service.SemanticsChecker;

public class TestBase
extends TestCase {
    protected CrossReferenceServiceConfiguration config = new CrossReferenceServiceConfiguration();
    private File projectFile;

    public TestBase() {
        this.config.getProjectSettings().setErrorHandler(new DefaultErrorHandler(0));
        this.projectFile = new File("test/basic/collections.prj");
    }

    protected File getProjectFile() {
        return this.projectFile;
    }

    public void setUp() throws IOException, ParserException {
        SourceFileRepository sfr = this.config.getSourceFileRepository();
        sfr.getCompilationUnitsFromFiles(new DefaultProjectFileIO(this.config, this.getProjectFile()).load());
        if (!this.config.getProjectSettings().ensureSystemClassesAreInPath()) {
            throw new RuntimeException("Problem with system setup: Cannot locate system classes");
        }
        this.config.getChangeHistory().updateModel();
        for (CompilationUnit cu : this.config.getSourceFileRepository().getCompilationUnits()) {
            cu.validateAll();
        }
        new SemanticsChecker(this.config).checkAllCompilationUnits();
    }

    public void tearDown() {
        this.config = null;
        this.projectFile = null;
    }
}

