/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.basic.analysis;

import java.util.List;
import junit.framework.Assert;
import recoder.abstraction.Constructor;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.Type;
import recoder.abstraction.Variable;
import recoder.convenience.Format;
import recoder.convenience.TreeWalker;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.java.reference.VariableReference;
import recoder.service.CrossReferenceSourceInfo;
import recoder.testsuite.basic.analysis.TestBase;

public class ReferenceCompletenessTest
extends TestBase {
    private static String makeReferenceError(Reference r, ProgramModelElement x) {
        return String.valueOf(Format.toString("%c %N @%p in %f", r)) + " was not found in reference list of " + Format.toString("%c %N", x);
    }

    public void testReferenceCompleteness() {
        CrossReferenceSourceInfo xrsi = this.config.getCrossReferenceSourceInfo();
        SourceFileRepository sfr = this.config.getSourceFileRepository();
        List<CompilationUnit> units = sfr.getCompilationUnits();
        int i = 0;
        while (i < units.size()) {
            CompilationUnit u = units.get(i);
            TreeWalker tw = new TreeWalker(u);
            while (tw.next()) {
                List<Reference> list;
                ProgramModelElement x;
                Reference r;
                ProgramElement pe = tw.getProgramElement();
                if (!(pe instanceof Reference)) continue;
                Assert.assertTrue((String)"Uncollated reference detected", (!(pe instanceof UncollatedReferenceQualifier) ? 1 : 0) != 0);
                if (pe instanceof VariableReference) {
                    r = (VariableReference)pe;
                    x = xrsi.getVariable((VariableReference)r);
                    list = xrsi.getReferences((Variable)x);
                    if (list.indexOf(r) >= 0) continue;
                    Assert.fail((String)ReferenceCompletenessTest.makeReferenceError(r, x));
                    continue;
                }
                if (pe instanceof TypeReference) {
                    r = (TypeReference)pe;
                    x = xrsi.getType((TypeReference)r);
                    if (x == null || (list = xrsi.getReferences((Type)x)).indexOf(r) >= 0) continue;
                    Assert.fail((String)ReferenceCompletenessTest.makeReferenceError(r, x));
                    continue;
                }
                if (pe instanceof MethodReference) {
                    r = (MethodReference)pe;
                    x = xrsi.getMethod((MethodReference)r);
                    list = xrsi.getReferences((Method)x);
                    if (list.indexOf(r) >= 0) continue;
                    Assert.fail((String)ReferenceCompletenessTest.makeReferenceError(r, x));
                    continue;
                }
                if (pe instanceof ConstructorReference) {
                    r = (ConstructorReference)pe;
                    x = xrsi.getConstructor((ConstructorReference)r);
                    list = xrsi.getReferences((Constructor)x);
                    if (list.indexOf(r) >= 0) continue;
                    Assert.fail((String)ReferenceCompletenessTest.makeReferenceError(r, x));
                    continue;
                }
                if (!(pe instanceof PackageReference) || (list = xrsi.getReferences((Package)(x = xrsi.getPackage((PackageReference)(r = (PackageReference)pe))))).indexOf(r) >= 0) continue;
                Assert.fail((String)ReferenceCompletenessTest.makeReferenceError(r, x));
            }
            ++i;
        }
    }
}

