/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.basic.analysis;

import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import recoder.abstraction.ClassType;
import recoder.java.CompilationUnit;
import recoder.java.declaration.TypeDeclaration;
import recoder.kit.ProblemReport;
import recoder.kit.Transformation;
import recoder.service.ChangeHistory;
import recoder.testsuite.basic.analysis.AnalysisReportTest;

public class ModelRebuildTest
extends AnalysisReportTest {
    public void runTest() throws IOException {
        Transformation clearAll = new Transformation(this.config){

            @Override
            public ProblemReport execute() {
                this.getChangeHistory().begin(this);
                List<CompilationUnit> units = this.getSourceFileRepository().getCompilationUnits();
                int i = 0;
                while (i < units.size()) {
                    this.detach(units.get(i));
                    ++i;
                }
                return NO_PROBLEM;
            }
        };
        clearAll.execute();
        ChangeHistory ch = this.config.getChangeHistory();
        ch.updateModel();
        Assert.assertEquals((int)this.config.getSourceFileRepository().getKnownCompilationUnits().size(), (int)0);
        List<ClassType> ctl = this.config.getNameInfo().getClassTypes();
        int i = ctl.size() - 1;
        while (i >= 0) {
            Assert.assertTrue((String)"Syntax tree left in an emptied model", (!(ctl.get(i) instanceof TypeDeclaration) ? 1 : 0) != 0);
            --i;
        }
        ch.rollback(clearAll);
        ch.updateModel();
        super.testAnalysisReport();
    }
}

