/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.basic.analysis;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import recoder.abstraction.ClassType;
import recoder.abstraction.Method;
import recoder.abstraction.Type;
import recoder.kit.MethodKit;
import recoder.service.CrossReferenceSourceInfo;
import recoder.service.NameInfo;
import recoder.testsuite.basic.analysis.TestBase;

public class GetAllRelatedMethodsTest
extends TestBase {
    CrossReferenceSourceInfo xrsi;
    NameInfo ni;
    static final String PACKAGE = "testdata.";

    private ClassType loadClass(String localname) {
        String name = PACKAGE + localname;
        ClassType ct = this.ni.getClassType(name);
        if (ct == null) {
            Assert.fail((String)("Could not load test data " + name));
        }
        return ct;
    }

    public void testGetAllRelatedMethodsTest() throws Exception {
        this.xrsi = this.config.getCrossReferenceSourceInfo();
        this.ni = this.config.getNameInfo();
        this.loadClass("MethodTestData");
        ClassType ct = this.loadClass("Child");
        this.checkRelatedMethodsCount(ct, "childMethod", 1);
        this.checkRelatedMethodsCount(ct, "baseAndChildMethod", 2);
        this.checkRelatedMethodsCount(ct, "baseAndChildAndIFirstMethod", 3);
        this.checkRelatedMethodsCount(ct, "baseAndIFirstMethod", 2);
        this.checkRelatedMethodsCount(ct, "baseAndIFirstISecondMethod", 3);
        ct = this.loadClass("IFirst");
        this.checkRelatedMethodsCount(ct, "childAndIFirstMethod", 2);
        this.checkRelatedMethodsCount(ct, "baseAndChildAndIFirstMethod", 3);
        this.checkRelatedMethodsCount(ct, "baseAndIFirstMethod", 2);
        ct = this.loadClass("Base");
        this.checkRelatedMethodsCount(ct, "childMethod", 0);
        this.checkRelatedMethodsCount(ct, "baseAndChildMethod", 2);
        this.checkRelatedMethodsCount(ct, "baseAndChildAndIFirstMethod", 3);
        this.checkRelatedMethodsCount(ct, "baseAndIFirstMethod", 2);
    }

    private void checkRelatedMethodsCount(ClassType ct, String methodName, int expectedNumber) {
        List<Method> ml = MethodKit.getAllRelatedMethods(this.ni, this.xrsi, ct, methodName, new ArrayList<Type>(0));
        Assert.assertEquals((String)methodName, (int)expectedNumber, (int)ml.size());
        this.checkSignatures(ml, methodName, new ArrayList<Type>(0));
    }

    private void checkSignatures(List<Method> ml, String methodName, List<Type> signature) {
        int i = 0;
        while (i < ml.size()) {
            Method method = ml.get(i);
            Assert.assertEquals((String)method.getName(), (String)methodName);
            Assert.assertEquals(method.getSignature(), signature);
            ++i;
        }
    }
}

