/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite.basic.analysis;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import junit.framework.Assert;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.Type;
import recoder.convenience.Format;
import recoder.convenience.Naming;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Declaration;
import recoder.java.Expression;
import recoder.java.ProgramElement;
import recoder.java.SourceElement;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.VariableReference;
import recoder.service.ConstantEvaluator;
import recoder.service.SourceInfo;
import recoder.testsuite.basic.analysis.TestBase;
import recoder.util.HashCode;
import recoder.util.Index;
import recoder.util.Order;
import recoder.util.Sorting;

public class AnalysisReportTest
extends TestBase {
    static final Order UNIT_NAME_ORDER = new Order.CustomLexicalOrder(){

        @Override
        protected String toString(Object x) {
            return Naming.toCanonicalName((CompilationUnit)x);
        }
    };

    public void testAnalysisReport() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
        GZIPOutputStream gzip = new GZIPOutputStream(baos);
        OutputStreamWriter osw = new OutputStreamWriter(gzip);
        this.createReport(osw);
        osw.close();
        byte[] buffer = baos.toByteArray();
        File referenceLogFile = this.getLogFile();
        if (!referenceLogFile.exists()) {
            FileOutputStream fos = new FileOutputStream(referenceLogFile);
            baos.writeTo(fos);
            fos.close();
            Assert.fail((String)("No reference log - created " + referenceLogFile.getPath()));
        }
        FileInputStream is = new FileInputStream(referenceLogFile);
        byte[] referenceBuffer = new byte[buffer.length];
        int bsize = ((InputStream)is).read(referenceBuffer);
        ((InputStream)is).close();
        AnalysisReportTest.assertEquals((int)bsize, (int)buffer.length);
        int i = buffer.length - 1;
        while (i >= 0) {
            if (buffer[i] != referenceBuffer[i]) {
                File failureFile = this.createFailureFile(referenceLogFile);
                FileOutputStream fos = new FileOutputStream(failureFile);
                baos.writeTo(fos);
                fos.close();
                Assert.fail((String)("Reference report did not match - created protocol " + failureFile.getPath()));
                break;
            }
            --i;
        }
    }

    protected File getLogFile() {
        File prj = this.getProjectFile();
        String name = prj.getPath();
        if (name.endsWith(".prj") || name.endsWith(".PRJ")) {
            name = name.substring(0, name.length() - 4);
        }
        name = String.valueOf(name) + ".log.gz";
        return new File(name);
    }

    protected File createFailureFile(File logFile) {
        File failureFile = null;
        String path = logFile.getPath();
        String dir = path.substring(0, path.lastIndexOf(File.separatorChar));
        String name = path.substring(path.lastIndexOf(File.separator) + 1);
        int n = 0;
        do {
            String newName = String.valueOf(dir) + File.separator + "fail" + n + "-" + name;
            failureFile = new File(newName);
            ++n;
        } while (failureFile.exists());
        int npidx = Math.max(0, path.lastIndexOf(File.separator));
        File newPath = new File("fail" + (n - 1) + "-" + path.substring(0, npidx));
        newPath.mkdir();
        try {
            failureFile.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected (nearly impossible) IO Error - try again");
        }
        return failureFile;
    }

    protected void createReport(Writer out) throws IOException {
        List<CompilationUnit> units = this.config.getSourceFileRepository().getCompilationUnits();
        Object[] uarray = new CompilationUnit[units.size()];
        int i = 0;
        while (i < uarray.length) {
            uarray[i] = units.get(i);
            ++i;
        }
        Sorting.heapSort(uarray, UNIT_NAME_ORDER);
        SourceInfo si = this.config.getSourceInfo();
        Index decl2num = new Index(HashCode.IDENTITY);
        ConstantEvaluator.EvaluationResult res = new ConstantEvaluator.EvaluationResult();
        int i2 = 0;
        int n = 0;
        while (i2 < uarray.length) {
            TreeWalker tw = new TreeWalker((ProgramElement)uarray[i2]);
            while (tw.next()) {
                ProgramElement pe = tw.getProgramElement();
                if (pe instanceof Declaration) {
                    decl2num.put(pe, n);
                }
                ++n;
            }
            ++i2;
        }
        StringBuffer line = new StringBuffer(1024);
        int number = 1;
        int i3 = 0;
        while (i3 < uarray.length) {
            Object unit = uarray[i3];
            TreeWalker tw = new TreeWalker((ProgramElement)unit);
            SourceElement.Position oldPos = SourceElement.Position.UNDEFINED;
            while (tw.next()) {
                Type t;
                ProgramElement pe = tw.getProgramElement();
                SourceElement.Position pos = pe.getFirstElement().getStartPosition();
                if (!pos.equals(oldPos)) {
                    line.append(pos);
                    oldPos = pos;
                }
                line.append(' ');
                String name = pe.getClass().getName();
                name = name.substring(name.lastIndexOf(46) + 1);
                int k = 0;
                int s = name.length();
                while (k < s) {
                    char c = name.charAt(k);
                    if (Character.isUpperCase(c)) {
                        line.append(c);
                    }
                    ++k;
                }
                if (pe instanceof CompilationUnit) {
                    line.append(Format.toString(" \"%u\"", pe));
                }
                if (pe instanceof Expression && (t = si.getType(pe)) != null) {
                    line.append(" :");
                    if (t instanceof ProgramElement) {
                        line.append(decl2num.get(t));
                    } else {
                        line.append(Format.toString("%N", t));
                    }
                    if (this.config.getConstantEvaluator().isCompileTimeConstant((Expression)pe, res)) {
                        line.append(" ==" + res.toString());
                    }
                }
                ProgramModelElement dest = null;
                if (pe instanceof ConstructorReference) {
                    dest = si.getConstructor((ConstructorReference)pe);
                } else if (pe instanceof MethodReference) {
                    dest = si.getMethod((MethodReference)pe);
                } else if (pe instanceof VariableReference) {
                    dest = si.getVariable((VariableReference)pe);
                } else if (pe instanceof TypeReference) {
                    dest = si.getType((TypeReference)pe);
                } else if (pe instanceof PackageReference) {
                    dest = si.getPackage((PackageReference)pe);
                }
                if (dest != null) {
                    line.append(" ->");
                    if (dest instanceof ProgramElement) {
                        line.append(decl2num.get(dest));
                    } else {
                        line.append(Format.toString("%N", dest));
                    }
                }
                line.append("\n");
                out.write(line.toString());
                line.setLength(0);
                ++number;
            }
            ++i3;
        }
        out.flush();
    }
}

