/*
 * Decompiled with CFR 0.152.
 */
package recoder.testsuite;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ParserException;
import recoder.java.CompilationUnit;
import recoder.service.DefaultErrorHandler;
import recoder.service.ErrorHandler;
import recoder.service.SemanticsChecker;

public class RecoderTestCase
extends TestCase {
    protected CrossReferenceServiceConfiguration sc;
    private boolean writeBackAllowed;

    static {
        RecoderTestCase.class.getClassLoader().setDefaultAssertionStatus(true);
    }

    public RecoderTestCase() {
    }

    public RecoderTestCase(String name) {
        super(name);
    }

    protected List<CompilationUnit> runIt(String ... cuTexts) throws ParserException {
        return this.runIt((ErrorHandler)null, cuTexts);
    }

    public void setUp() throws Exception {
        this.sc = new CrossReferenceServiceConfiguration();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.sc = null;
    }

    protected List<CompilationUnit> runIt(ErrorHandler eh, String ... cuTexts) throws ParserException {
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        ArrayList<CompilationUnit> cus = new ArrayList<CompilationUnit>();
        String[] stringArray = cuTexts;
        int n = cuTexts.length;
        int n2 = 0;
        while (n2 < n) {
            String cuText = stringArray[n2];
            CompilationUnit cu = this.sc.getProgramFactory().parseCompilationUnit(cuText);
            this.sc.getChangeHistory().attached(cu);
            cus.add(cu);
            ++n2;
        }
        if (eh != null) {
            this.sc.getProjectSettings().setErrorHandler(eh);
        }
        this.sc.getChangeHistory().updateModel();
        for (CompilationUnit cu : cus) {
            cu.validateAll();
        }
        new SemanticsChecker(this.sc).checkAllCompilationUnits();
        return cus;
    }

    protected void setPath(String input) {
        this.setPath(input, null);
    }

    protected void setPath(String input, String output) {
        StringTokenizer st = new StringTokenizer(input, ";:");
        while (st.hasMoreElements()) {
            String s = st.nextToken();
            if (new File(s).exists()) continue;
            throw new RuntimeException(String.valueOf(s) + " not found");
        }
        this.writeBackAllowed = false;
        this.sc.getProjectSettings().setProperty("input.path", new File(input).getAbsolutePath());
        if (output != null) {
            if (input.equals(output)) {
                RecoderTestCase.fail((String)"Must not overwrite source files for test cases (input path is output path!");
            }
            this.writeBackAllowed = true;
            this.sc.getProjectSettings().setProperty("output.path", new File(output).getAbsolutePath());
        }
        this.sc.getProjectSettings().ensureSystemClassesAreInPath();
        this.sc.getProjectSettings().ensureExtensionClassesAreInPath();
    }

    protected void runIt() {
        try {
            this.sc.getSourceFileRepository().getAllCompilationUnitsFromPath();
            this.sc.getChangeHistory().updateModel();
            for (CompilationUnit cu : this.sc.getSourceFileRepository().getCompilationUnits()) {
                cu.validateAll();
            }
            new SemanticsChecker(this.sc).checkAllCompilationUnits();
        }
        catch (ParserException pe) {
            System.err.println(pe.getMessage());
            RecoderTestCase.fail((String)"unexpected ParserException");
        }
    }

    protected void writeBack() {
        if (!this.writeBackAllowed) {
            RecoderTestCase.fail((String)"Cannot write back to original data location for test cases!");
        }
        try {
            this.sc.getSourceFileRepository().printAll(true);
        }
        catch (IOException e) {
            RecoderTestCase.fail();
        }
    }

    public static class SilentErrorHandler
    extends DefaultErrorHandler {
        private final int exp;
        private int errCnt = 0;

        public SilentErrorHandler(int cnt) {
            this.exp = cnt;
        }

        @Override
        public void reportError(Exception e) {
            ++this.errCnt;
        }

        @Override
        public void modelUpdated(EventObject event) {
            this.isUpdating = false;
            RecoderTestCase.assertEquals((int)this.exp, (int)this.errCnt);
        }
    }
}

