/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ModelException;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.convenience.Format;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.Import;
import recoder.java.NonTerminalProgramElement;
import recoder.java.PackageSpecification;
import recoder.java.SourceVisitor;
import recoder.java.declaration.AnnotationDeclaration;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ClassInitializer;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.LocalVariableDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.Modifier;
import recoder.java.declaration.VariableSpecification;
import recoder.java.declaration.modifier.Abstract;
import recoder.java.declaration.modifier.Final;
import recoder.java.declaration.modifier.Private;
import recoder.java.declaration.modifier.Protected;
import recoder.java.declaration.modifier.Public;
import recoder.java.declaration.modifier.Static;
import recoder.java.declaration.modifier.Volatile;
import recoder.java.expression.operator.CopyAssignment;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.SuperReference;
import recoder.java.reference.ThisReference;
import recoder.java.reference.TypeReference;
import recoder.java.statement.EnhancedFor;
import recoder.java.statement.If;
import recoder.kit.UnitKit;
import recoder.list.generic.ASTList;
import recoder.service.DefaultSourceInfo;
import recoder.service.ErrorHandler;
import recoder.service.IllegalModifierException;
import recoder.service.IllegalNonStaticAccessException;
import recoder.service.NameInfo;
import recoder.service.ProgramModelInfo;
import recoder.service.SourceInfo;
import recoder.service.TypingException;
import recoder.service.UnresolvedReferenceException;

public class SemanticsChecker {
    private final CrossReferenceServiceConfiguration crsc;
    private final SourceInfo si;
    private final NameInfo ni;
    private boolean java5allowed;
    private ErrorHandler errorHandler;
    private final SemanticsCheckerVisitor checker = new SemanticsCheckerVisitor();

    public SemanticsChecker(CrossReferenceServiceConfiguration crsc) {
        this.crsc = crsc;
        this.si = crsc.getSourceInfo();
        this.ni = crsc.getNameInfo();
    }

    public void checkAllCompilationUnits() throws ModelException {
        for (CompilationUnit cu : this.crsc.getSourceFileRepository().getCompilationUnits()) {
            this.check(cu);
        }
    }

    public void check(CompilationUnit cu) throws ModelException {
        this.java5allowed = this.crsc.getProjectSettings().java5Allowed();
        this.errorHandler = this.crsc.getProjectSettings().getErrorHandler();
        TreeWalker tw = new TreeWalker(cu);
        while (tw.next()) {
            tw.getProgramElement().accept(this.checker);
        }
    }

    private class SemanticsCheckerVisitor
    extends SourceVisitor {
        private SemanticsCheckerVisitor() {
        }

        @Override
        public void visitIf(If x) {
            Type exprType = SemanticsChecker.this.si.getType(x.getExpression());
            if (!(exprType == SemanticsChecker.this.ni.getBooleanType() || SemanticsChecker.this.java5allowed && exprType == SemanticsChecker.this.ni.getJavaLangBoolean())) {
                SemanticsChecker.this.errorHandler.reportError(new TypingException(x.getExpression()));
            }
        }

        @Override
        public void visitEnhancedFor(EnhancedFor ef) {
            Type lhsType = SemanticsChecker.this.si.getType(((LocalVariableDeclaration)ef.getInitializers().get(0)).getTypeReference());
            Type rhsType = SemanticsChecker.this.si.getType(ef.getGuard());
            if (rhsType instanceof ArrayType) {
                if (SemanticsChecker.this.si.isWidening(((ArrayType)rhsType).getBaseType(), lhsType)) {
                    return;
                }
            } else {
                List<ClassType> allSupers = SemanticsChecker.this.si.getAllSupertypes((ClassType)rhsType);
                ClassType iterableType = null;
                for (ClassType ct : allSupers) {
                    if (!ct.getFullName().equals("java.lang.Iterable")) continue;
                    iterableType = ct;
                    break;
                }
                if (iterableType != null) {
                    if (lhsType == SemanticsChecker.this.ni.getJavaLangObject()) {
                        return;
                    }
                    if (iterableType instanceof ParameterizedType) {
                        ClassType rhsTypeArg = ((DefaultSourceInfo)SemanticsChecker.this.si).getBaseType(((ParameterizedType)iterableType).getTypeArgs().get(0));
                        if (SemanticsChecker.this.si.isWidening(lhsType, (Type)rhsTypeArg)) {
                            return;
                        }
                    }
                }
            }
            SemanticsChecker.this.errorHandler.reportError(new TypingException("lhs does not match rhs - " + lhsType.getFullSignature() + " : " + rhsType.getFullSignature(), ef.getGuard()));
        }

        @Override
        public void visitCopyAssignment(CopyAssignment ca) {
            Type lhs = SemanticsChecker.this.si.getType(ca.getChildAt(0));
            Type rhs = SemanticsChecker.this.si.getType(ca.getChildAt(1));
            if (lhs instanceof PrimitiveType && !(rhs instanceof PrimitiveType)) {
                rhs = SemanticsChecker.this.si.getUnboxedType((ClassType)rhs);
            } else if (rhs instanceof PrimitiveType && !(lhs instanceof PrimitiveType)) {
                rhs = SemanticsChecker.this.si.getBoxedType((PrimitiveType)rhs);
            } else if (rhs instanceof TypeArgument.CapturedTypeArgument) {
                rhs = ((DefaultSourceInfo)SemanticsChecker.this.si).getBaseType(((TypeArgument.CapturedTypeArgument)rhs).getTypeArgument());
            }
            if (!SemanticsChecker.this.si.isWidening(rhs, lhs)) {
                if (rhs instanceof PrimitiveType && SemanticsChecker.this.si.getServiceConfiguration().getConstantEvaluator().isCompileTimeConstant((Expression)ca.getChildAt(1))) {
                    return;
                }
                SemanticsChecker.this.errorHandler.reportError(new ModelException("Invalid assignment"));
            }
        }

        @Override
        public void visitClassDeclaration(ClassDeclaration cd) {
            if (cd.isAbstract() && cd.isFinal()) {
                SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException("Illegal class declaration " + cd.getFullName()));
            }
        }

        @Override
        public void visitFieldReference(FieldReference fr) {
            Field f = SemanticsChecker.this.si.getField(fr);
            if (fr.getReferencePrefix() == null) {
                if (this.occursStaticContext(fr) && !f.isStatic()) {
                    SemanticsChecker.this.errorHandler.reportError(new IllegalNonStaticAccessException("Non-static field used in static context"));
                }
            } else if (fr.getReferencePrefix() instanceof TypeReference && this.occursStaticContext(fr) && !f.isStatic()) {
                SemanticsChecker.this.errorHandler.reportError(new IllegalNonStaticAccessException("Non-static field used in static context"));
            }
        }

        private final boolean occursStaticContext(FieldReference fr) {
            NonTerminalProgramElement pe = fr;
            while (pe != null) {
                if (pe instanceof CompilationUnit) {
                    TreeWalker tw = new TreeWalker(pe);
                    while (tw.next()) {
                        if (tw.getProgramElement().getClass().getName() == "recoder.java.Import") {
                            Import imp = (Import)tw.getProgramElement();
                            return imp.isStaticImport();
                        }
                        if (tw.getProgramElement() instanceof ClassInitializer) {
                            return ((ClassInitializer)tw.getProgramElement()).isStatic();
                        }
                        if (tw.getProgramElement() instanceof MethodDeclaration) {
                            return ((MethodDeclaration)tw.getProgramElement()).isStatic();
                        }
                        if (tw.getProgramElement() instanceof FieldDeclaration) {
                            return ((FieldDeclaration)tw.getProgramElement()).isStatic();
                        }
                        if (!(tw.getProgramElement() instanceof AnnotationDeclaration)) continue;
                        return false;
                    }
                }
                if (pe instanceof ClassInitializer) {
                    return ((ClassInitializer)pe).isStatic();
                }
                if (pe instanceof MethodDeclaration) {
                    return ((MethodDeclaration)pe).isStatic();
                }
                if (pe instanceof FieldDeclaration) {
                    return ((FieldDeclaration)pe).isStatic();
                }
                if (pe instanceof PackageSpecification) {
                    return true;
                }
                pe = pe.getASTParent();
            }
            System.out.println(UnitKit.getCompilationUnit(fr) + " " + fr.getStartPosition());
            throw new RuntimeException("cannot determine if FieldReference " + Format.toString(pe) + " occurs in static context; check parent links!");
        }

        @Override
        public void visitFieldDeclaration(FieldDeclaration fd) {
            ASTList<DeclarationSpecifier> fieldDSlist;
            int count = 0;
            int both = 0;
            if (fd.getDeclarationSpecifiers() != null && (fieldDSlist = fd.getDeclarationSpecifiers()).size() > 1) {
                for (DeclarationSpecifier ds : fieldDSlist) {
                    if (ds instanceof Public) {
                        ++count;
                    }
                    if (ds instanceof Protected) {
                        ++count;
                    }
                    if (ds instanceof Private) {
                        ++count;
                    }
                    if (ds instanceof Final) {
                        ++both;
                    }
                    if (!(ds instanceof Volatile)) continue;
                    ++both;
                }
                if (count > 1) {
                    SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException("Illegal field declaration"));
                }
                if (both > 1) {
                    SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException("Illegal field declaration"));
                }
            }
        }

        @Override
        public void visitMethodDeclaration(MethodDeclaration md) {
            List<Modifier> mlist;
            if (md.getASTParent() instanceof InterfaceDeclaration) {
                int isAbstract = 0;
                int isPublic = 0;
                if (md.getModifiers() != null) {
                    mlist = md.getModifiers();
                    for (Modifier modifier : mlist) {
                        if (modifier instanceof Abstract) {
                            ++isAbstract;
                        }
                        if (!(modifier instanceof Public)) continue;
                        ++isPublic;
                    }
                    if (mlist.size() != 0) {
                        if (isAbstract == 0) {
                            if (isPublic == 0) {
                                SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException(" method can only define  abstract && public in interface method : " + Format.toString(md) + Format.toString(md.getASTParent()) + " method define wrong!"));
                            }
                            if (isPublic > 1) {
                                SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException(" method can only define  abstract && public in interface method : " + Format.toString(md) + Format.toString(md.getASTParent()) + " method define wrong!"));
                            }
                        }
                        if (isAbstract == 1) {
                            if (isPublic == 0 && mlist.size() > 1) {
                                SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException(" method can only define  abstract && public in interface method : " + Format.toString(md) + Format.toString(md.getASTParent()) + " method define wrong!"));
                            }
                            if (isPublic > 1) {
                                SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException(" method can only define  abstract && public in interface method : " + Format.toString(md) + Format.toString(md.getASTParent()) + " method define wrong!"));
                            }
                        }
                        if (isAbstract > 1) {
                            SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException(" method can only define  abstract && public in interface method : " + Format.toString(md) + Format.toString(md.getASTParent()) + " method define wrong!"));
                        }
                    }
                }
            }
            if (md.getASTParent() instanceof ClassDeclaration) {
                if (md.isAbstract()) {
                    ClassDeclaration cd = (ClassDeclaration)md.getASTParent();
                    if (!cd.isAbstract()) {
                        SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException("abstract method can only define in an abstract class method : " + Format.toString(md) + "class : " + Format.toString(cd) + " abstract method define wrong!"));
                    } else if (md.getModifiers() != null) {
                        int isProtected = 0;
                        int isPublic = 0;
                        List<Modifier> mlist2 = md.getModifiers();
                        for (Modifier modifier : mlist2) {
                            if (modifier instanceof Protected) {
                                ++isProtected;
                            }
                            if (!(modifier instanceof Public)) continue;
                            ++isPublic;
                        }
                        if (isProtected > 1 || isPublic > 1) {
                            SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException("abstract method can only define protected or public in an abstract class method : " + Format.toString(md) + "class : " + Format.toString(cd) + " abstract method define wrong!"));
                        }
                        if (isProtected == 0 && isPublic == 0 && mlist2.size() > 1) {
                            SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException("abstract method can only define protected or public in an abstract class method : " + Format.toString(md) + "class : " + Format.toString(cd) + " abstract method define wrong!"));
                        }
                        if (isProtected == 1 && isPublic == 1) {
                            SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException("abstract method can only define protected or public in an abstract class method : " + Format.toString(md) + "class : " + Format.toString(cd) + " abstract method define wrong!"));
                        }
                    }
                } else if (md.getModifiers() != null) {
                    ClassDeclaration cd = (ClassDeclaration)md.getASTParent();
                    int one = 0;
                    mlist = md.getModifiers();
                    for (Modifier modifier : mlist) {
                        if (modifier instanceof Protected) {
                            ++one;
                        }
                        if (modifier instanceof Private) {
                            ++one;
                        }
                        if (!(modifier instanceof Public)) continue;
                        ++one;
                    }
                    if (one > 1 && mlist.size() > 1) {
                        SemanticsChecker.this.errorHandler.reportError(new IllegalModifierException("can only define one access modifer method : " + Format.toString(md) + "class : " + Format.toString(cd) + " method access modifier define wrong!"));
                    }
                }
            }
        }

        @Override
        public void visitMethodReference(MethodReference mr) {
            Method m = SemanticsChecker.this.si.getMethod(mr);
            String msg = this.isAppropriate(m, mr);
            if (msg != null) {
                SemanticsChecker.this.errorHandler.reportError(new UnresolvedReferenceException(Format.toString("Inappropriate method access: " + msg + " at " + "%c \"%s\" @%p in %f", mr), mr));
            }
        }

        private final String isAppropriate(Method m, MethodReference mr) {
            if (mr.getReferencePrefix() == null) {
                if (!m.isStatic()) {
                    if (this.occursInStaticContext(mr)) {
                        return "method invocation to non-static method occurs in static context (a)";
                    }
                    if (mr.getExpressionContainer() != null && mr.getExpressionContainer().getASTParent() instanceof LocalVariableDeclaration) {
                        ProgramModelElement pme = SemanticsChecker.this.ni.getUnknownElement();
                        ProgramModelInfo pmi = pme.getProgramModelInfo();
                        LocalVariableDeclaration ld = (LocalVariableDeclaration)mr.getExpressionContainer().getASTParent();
                        ASTList<VariableSpecification> varlist = ld.getVariableSpecifications();
                        for (VariableSpecification var : varlist) {
                            if (pmi.isWidening(m.getReturnType(), var.getType())) continue;
                            return "return type is wrong!check the reference method";
                        }
                    }
                } else if (mr.getExpressionContainer() != null && mr.getExpressionContainer().getASTParent() instanceof LocalVariableDeclaration) {
                    ProgramModelElement pme = SemanticsChecker.this.ni.getUnknownElement();
                    ProgramModelInfo pmi = pme.getProgramModelInfo();
                    LocalVariableDeclaration ld = (LocalVariableDeclaration)mr.getExpressionContainer().getASTParent();
                    ASTList<VariableSpecification> varlist = ld.getVariableSpecifications();
                    for (VariableSpecification var : varlist) {
                        if (pmi.isWidening(m.getReturnType(), var.getType())) continue;
                        return "return type is wrong!check the reference method";
                    }
                }
                return null;
            }
            if (mr.getReferencePrefix() instanceof TypeReference && !m.isStatic()) {
                return "Static access to a non-static member";
            }
            if (mr.getTypeReferenceCount() == 1) {
                MethodDeclaration md;
                if (m.isStatic() && SemanticsChecker.this.si.getMethodDeclaration(m) != null && (md = SemanticsChecker.this.si.getMethodDeclaration(m)).getDeclarationSpecifiers() != null && md.getDeclarationSpecifiers().size() != 0) {
                    ASTList<DeclarationSpecifier> dslist = md.getDeclarationSpecifiers();
                    int size = dslist.size();
                    for (DeclarationSpecifier ds : dslist) {
                        if (!(ds instanceof Static)) continue;
                        --size;
                    }
                    if (size == dslist.size()) {
                        return "cannot access super method because it is static";
                    }
                }
                return null;
            }
            if (mr.getReferencePrefix() instanceof SuperReference) {
                SuperReference sr = (SuperReference)mr.getReferencePrefix();
                if (m.isAbstract()) {
                    List<Method> methodlist = SemanticsChecker.this.si.getMethods(mr);
                    for (Method method : methodlist) {
                        MethodDeclaration md = SemanticsChecker.this.si.getMethodDeclaration(method);
                        ASTList<DeclarationSpecifier> dslist = md.getDeclarationSpecifiers();
                        for (DeclarationSpecifier ds : dslist) {
                            if (!(ds instanceof Abstract)) continue;
                            return "cannot access super method because it is abstract";
                        }
                    }
                }
                if (this.occursInStaticContext(mr)) {
                    return "method invocation to non-static method occurs in static context (c)";
                }
                if (sr.getReferencePrefix() != null) {
                    boolean cfr_ignored_0 = sr.getReferencePrefix() instanceof TypeReference;
                }
                return null;
            }
            if (mr.getReferencePrefix() instanceof ThisReference && this.occursInStaticContext(mr)) {
                return "method invocation to non-static method occurs in static context (d)";
            }
            if (mr.getReferenceSuffix() != null && m.getReturnType() == null) {
                return "void method must not have a reference suffix";
            }
            return null;
        }

        private final boolean occursInStaticContext(MethodReference mr) {
            NonTerminalProgramElement pe = mr;
            while (pe != null) {
                if (pe instanceof ClassInitializer) {
                    return ((ClassInitializer)pe).isStatic();
                }
                if (pe instanceof MethodDeclaration) {
                    return ((MethodDeclaration)pe).isStatic();
                }
                if (pe instanceof FieldDeclaration) {
                    return ((FieldDeclaration)pe).isStatic();
                }
                pe = pe.getASTParent();
            }
            throw new RuntimeException("cannot determine if MethodReference " + Format.toString(pe) + " occurs in static context; check parent links!");
        }

        @Override
        public void visitTypeReference(TypeReference tr) {
            this.checkRawTypeOk(tr);
        }

        private void checkRawTypeOk(TypeReference tr) {
            if (tr.getReferencePrefix() != null && tr.getReferencePrefix() instanceof TypeReference) {
                ClassType trType = (ClassType)SemanticsChecker.this.si.getType(tr);
                if (!(trType instanceof ParameterizedType || trType.getTypeParameters() != null && trType.getTypeParameters().size() != 0)) {
                    return;
                }
                TypeReference rp = (TypeReference)tr.getReferencePrefix();
                ClassType rpType = (ClassType)SemanticsChecker.this.si.getType(rp);
                if (tr.getTypeArguments() != null && tr.getTypeArguments().size() != 0) {
                    if (!trType.isStatic() && rpType instanceof ErasedType) {
                        SemanticsChecker.this.errorHandler.reportError(new TypingException("inner type has type arguments, but the outer does not.", null));
                    }
                } else {
                    List<? extends TypeParameter> tps = ((ParameterizedType)trType).getGenericType().getTypeParameters();
                    if (rpType instanceof ParameterizedType && tps != null && tps.size() > 0) {
                        SemanticsChecker.this.errorHandler.reportError(new TypingException(String.valueOf(tr.getName().toString()) + " occurs in outer type declaration!", null));
                    }
                }
            }
        }
    }
}

