/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import recoder.IllegalTransformationException;
import recoder.ModelException;
import recoder.ProgramFactory;
import recoder.ServiceConfiguration;
import recoder.abstraction.AnnotationProperty;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.EnumConstant;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Field;
import recoder.abstraction.ImplicitEnumMethod;
import recoder.abstraction.IntersectionType;
import recoder.abstraction.Member;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.ResolvedGenericMethod;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.abstraction.Variable;
import recoder.convenience.Format;
import recoder.convenience.Formats;
import recoder.convenience.Naming;
import recoder.convenience.TreeWalker;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.Import;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.PackageSpecification;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.ScopeDefiningElement;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.TerminalProgramElement;
import recoder.java.TypeScope;
import recoder.java.VariableScope;
import recoder.java.declaration.AnnotationDeclaration;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.EnumConstantDeclaration;
import recoder.java.declaration.EnumConstantSpecification;
import recoder.java.declaration.EnumDeclaration;
import recoder.java.declaration.Extends;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.Implements;
import recoder.java.declaration.InheritanceSpecification;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.declaration.Throws;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeDeclarationContainer;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.java.declaration.VariableDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.expression.ArrayInitializer;
import recoder.java.expression.Assignment;
import recoder.java.expression.ElementValueArrayInitializer;
import recoder.java.expression.Literal;
import recoder.java.expression.Operator;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.expression.literal.BooleanLiteral;
import recoder.java.expression.literal.CharLiteral;
import recoder.java.expression.literal.DoubleLiteral;
import recoder.java.expression.literal.FloatLiteral;
import recoder.java.expression.literal.IntLiteral;
import recoder.java.expression.literal.LongLiteral;
import recoder.java.expression.literal.NullLiteral;
import recoder.java.expression.literal.StringLiteral;
import recoder.java.expression.operator.BinaryAnd;
import recoder.java.expression.operator.BinaryNot;
import recoder.java.expression.operator.BinaryOr;
import recoder.java.expression.operator.BinaryXOr;
import recoder.java.expression.operator.ComparativeOperator;
import recoder.java.expression.operator.Conditional;
import recoder.java.expression.operator.CopyAssignment;
import recoder.java.expression.operator.Divide;
import recoder.java.expression.operator.Instanceof;
import recoder.java.expression.operator.LogicalAnd;
import recoder.java.expression.operator.LogicalNot;
import recoder.java.expression.operator.LogicalOr;
import recoder.java.expression.operator.Minus;
import recoder.java.expression.operator.Modulo;
import recoder.java.expression.operator.Negative;
import recoder.java.expression.operator.New;
import recoder.java.expression.operator.NewArray;
import recoder.java.expression.operator.Plus;
import recoder.java.expression.operator.Positive;
import recoder.java.expression.operator.PostDecrement;
import recoder.java.expression.operator.PostIncrement;
import recoder.java.expression.operator.PreDecrement;
import recoder.java.expression.operator.PreIncrement;
import recoder.java.expression.operator.ShiftLeft;
import recoder.java.expression.operator.ShiftRight;
import recoder.java.expression.operator.Times;
import recoder.java.expression.operator.TypeCast;
import recoder.java.expression.operator.TypeOperator;
import recoder.java.expression.operator.UnsignedShiftRight;
import recoder.java.reference.AnnotationPropertyReference;
import recoder.java.reference.ArrayReference;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.EnumConstructorReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MetaClassReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.SuperConstructorReference;
import recoder.java.reference.SuperReference;
import recoder.java.reference.ThisConstructorReference;
import recoder.java.reference.ThisReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceInfix;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.java.reference.VariableReference;
import recoder.java.statement.Branch;
import recoder.java.statement.Break;
import recoder.java.statement.Case;
import recoder.java.statement.Catch;
import recoder.java.statement.Continue;
import recoder.java.statement.Default;
import recoder.java.statement.ExpressionJumpStatement;
import recoder.java.statement.Finally;
import recoder.java.statement.If;
import recoder.java.statement.LabeledStatement;
import recoder.java.statement.LoopStatement;
import recoder.java.statement.Switch;
import recoder.java.statement.SynchronizedBlock;
import recoder.java.statement.Try;
import recoder.kit.MiscKit;
import recoder.kit.StatementKit;
import recoder.kit.UnitKit;
import recoder.list.generic.ASTList;
import recoder.service.AmbiguousDeclarationException;
import recoder.service.AmbiguousImportException;
import recoder.service.AmbiguousReferenceException;
import recoder.service.AmbiguousStaticFieldImportException;
import recoder.service.AttachChange;
import recoder.service.ChangeHistoryEvent;
import recoder.service.ChangeHistoryListener;
import recoder.service.ConstantEvaluator;
import recoder.service.DefaultImplicitElementInfo;
import recoder.service.DefaultNameInfo;
import recoder.service.DefaultProgramModelInfo;
import recoder.service.DetachChange;
import recoder.service.NameInfo;
import recoder.service.SourceInfo;
import recoder.service.TreeChange;
import recoder.service.TypingException;
import recoder.service.UnresolvedReferenceException;
import recoder.util.Debug;
import recoder.util.ProgressListener;
import recoder.util.ProgressListenerManager;

public class DefaultSourceInfo
extends DefaultProgramModelInfo
implements SourceInfo,
ChangeHistoryListener,
Formats {
    private static final boolean DEBUG = false;
    Map<Reference, ProgramModelElement> reference2element = new HashMap<Reference, ProgramModelElement>(1024);
    private final Map<MethodDeclaration, List<Type>> sigCache = new HashMap<MethodDeclaration, List<Type>>();
    ProgressListenerManager listeners = new ProgressListenerManager(this);
    private final Map<String, Type> name2primitiveType = new HashMap<String, Type>(64);
    private HashSet<ClassType> hack = new HashSet();
    private static final int CONSTANT_FALSE = 0;
    private static final int CONSTANT_TRUE = 1;
    private static final int NOT_CONSTANT = -1;
    private FastWorkList worklist = new FastWorkList();

    public DefaultSourceInfo(ServiceConfiguration config) {
        super(config);
    }

    @Override
    public void initialize(ServiceConfiguration cfg) {
        super.initialize(cfg);
        cfg.getChangeHistory().addChangeHistoryListener(this);
        NameInfo ni = this.getNameInfo();
        this.name2primitiveType.put("boolean", ni.getBooleanType());
        this.name2primitiveType.put("char", ni.getCharType());
        this.name2primitiveType.put("int", ni.getIntType());
        this.name2primitiveType.put("float", ni.getFloatType());
        this.name2primitiveType.put("double", ni.getDoubleType());
        this.name2primitiveType.put("byte", ni.getByteType());
        this.name2primitiveType.put("short", ni.getShortType());
        this.name2primitiveType.put("long", ni.getLongType());
    }

    @Override
    public void addProgressListener(ProgressListener l) {
        this.listeners.addProgressListener(l);
    }

    @Override
    public void removeProgressListener(ProgressListener l) {
        this.listeners.removeProgressListener(l);
    }

    @Override
    public void modelChanged(ChangeHistoryEvent changes) {
        TreeChange tc;
        List<TreeChange> changed = changes.getChanges();
        int s = changed.size();
        this.listeners.fireProgressEvent(0, s);
        int c = 0;
        int i = 0;
        while (i < s) {
            tc = changed.get(i);
            if (!tc.isMinor() && tc instanceof DetachChange) {
                this.processChange(tc);
                this.listeners.fireProgressEvent(++c);
            }
            ++i;
        }
        i = 0;
        while (i < s) {
            tc = changed.get(i);
            if (!tc.isMinor() && tc instanceof AttachChange) {
                this.processChange(tc);
                this.listeners.fireProgressEvent(++c);
            }
            ++i;
        }
    }

    void processChange(TreeChange change) {
        ProgramElement changed = change.getChangeRoot();
        if (DefaultSourceInfo.isPartOf(changed, PackageSpecification.class) || DefaultSourceInfo.isPartOf(changed, Import.class) || this.determinesGlobalEntityName(changed) || this.determinesGlobalEntityType(changed) || DefaultSourceInfo.isPartOf(changed, TypeArgumentDeclaration.class)) {
            super.reset();
            this.reference2element.clear();
        }
        if (changed instanceof PackageSpecification) {
            PackageSpecification pkgSpec = (PackageSpecification)changed;
            boolean isAttach = change instanceof AttachChange;
            this.handleCUPackageChange(pkgSpec.getParent(), Naming.toPathName(pkgSpec.getPackageReference()), isAttach);
        }
        if (changed instanceof PackageReference && DefaultSourceInfo.isPartOf(changed, PackageSpecification.class)) {
            System.err.println("WARNING: name info may now contain invalid mappings name2type... (TO BE FIXED)");
        }
        if (changed instanceof Identifier) {
            NonTerminalProgramElement par = changed.getASTParent();
            if (change instanceof AttachChange) {
                this.register(par);
            } else {
                String oldname = ((Identifier)changed).getText();
                if (par instanceof VariableSpecification) {
                    this.unregister((VariableSpecification)par, oldname);
                } else if (par instanceof TypeDeclaration) {
                    this.unregister((TypeDeclaration)par, oldname);
                }
            }
            this.processIdentifierChanged(change);
        } else if (change instanceof AttachChange) {
            this.register(changed);
        } else {
            this.unregister(changed);
        }
    }

    private void handleCUPackageChange(CompilationUnit cu, String originalPkgName, boolean isAttach) {
        DefaultNameInfo dni = (DefaultNameInfo)this.getNameInfo();
        int j = 0;
        int l = cu.getTypeDeclarationCount();
        while (j < l) {
            TypeDeclaration ct = cu.getTypeDeclarationAt(j);
            String fullPath = String.valueOf(originalPkgName) + ("".equals(originalPkgName) ? "" : ".") + ct.getName();
            String defaultPkgPath = ct.getName();
            if (isAttach) {
                dni.handleTypeRename(ct, defaultPkgPath, fullPath);
            } else {
                dni.handleTypeRename(ct, fullPath, defaultPkgPath);
            }
            ++j;
        }
    }

    private void processIdentifierChanged(TreeChange tc) {
        if (!(this.getNameInfo() instanceof DefaultNameInfo)) {
            return;
        }
        DefaultNameInfo dni = (DefaultNameInfo)this.getNameInfo();
        Identifier id = (Identifier)tc.getChangeRoot();
        NonTerminalProgramElement npe = id.getParent();
        if (npe instanceof TypeDeclaration) {
            TypeDeclaration td = (TypeDeclaration)npe;
            if (tc instanceof AttachChange) {
                Type old = dni.getType(td.getFullName());
                if (old == null || old == dni.getUnknownType()) {
                    dni.register(td);
                }
            } else {
                Type old = dni.getType(td.getFullName());
                if (old == td) {
                    dni.unregisterClassType(td.getFullName());
                }
            }
        } else if (npe instanceof FieldSpecification) {
            FieldSpecification fs = (FieldSpecification)npe;
            if (tc instanceof AttachChange) {
                dni.register(fs);
            } else {
                dni.unregisterField(fs.getFullName());
            }
        } else if (npe instanceof PackageReference && DefaultSourceInfo.isPartOf(npe, PackageSpecification.class)) {
            throw new IllegalTransformationException("Changing an Identifier contained in a PackageSpecification is not valid. Change either the containing PackageReference or PackageSpecification instead.");
        }
    }

    static boolean isPartOf(ProgramElement pe, Class<? extends ProgramElement> c) {
        while (pe != null && !c.isInstance(pe)) {
            pe = pe.getASTParent();
        }
        return pe != null;
    }

    private boolean determinesGlobalEntityName(ProgramElement pe) {
        if (pe instanceof Identifier) {
            NonTerminalProgramElement parent = pe.getASTParent();
            return parent instanceof MemberDeclaration;
        }
        return false;
    }

    private boolean determinesGlobalEntityType(ProgramElement pe) {
        return DefaultSourceInfo.isPartOf(pe, TypeReference.class) && (DefaultSourceInfo.isPartOf(pe, FieldDeclaration.class) || DefaultSourceInfo.isPartOf(pe, InheritanceSpecification.class));
    }

    private ProgramElement getDeclaration(ProgramModelElement pme) {
        return pme instanceof ProgramElement ? (ProgramElement)((Object)pme) : null;
    }

    @Override
    public final TypeDeclaration getTypeDeclaration(ClassType ct) {
        return ct instanceof TypeDeclaration ? (TypeDeclaration)ct : null;
    }

    @Override
    public final MethodDeclaration getMethodDeclaration(Method m) {
        return m instanceof MethodDeclaration ? (MethodDeclaration)m : null;
    }

    @Override
    public final VariableSpecification getVariableSpecification(Variable v) {
        return v instanceof VariableSpecification ? (VariableSpecification)v : null;
    }

    @Override
    public final ConstructorDeclaration getConstructorDeclaration(Constructor c) {
        return c instanceof ConstructorDeclaration ? (ConstructorDeclaration)c : null;
    }

    private ClassType getFromUnitPackage(String name, CompilationUnit cu) {
        String xname = Naming.getPackageName(cu);
        if (xname.length() > 0) {
            xname = Naming.dot(xname, name);
        }
        return this.getNameInfo().getClassType(xname);
    }

    public ClassType getFromTypeImports(String name, List<Import> il) {
        Member result = null;
        NameInfo ni = this.getNameInfo();
        int i = il.size() - 1;
        while (i >= 0) {
            Import imp = il.get(i);
            if (!imp.isMultiImport()) {
                String trname;
                TypeReference tr = imp.getTypeReference();
                Member newResult = null;
                String string = trname = imp.isStaticImport() ? imp.getStaticIdentifier().getText() : tr.getName();
                if (name.startsWith(trname)) {
                    int nlen;
                    int tlen = trname.length();
                    if (tlen == (nlen = name.length()) || name.charAt(tlen) == '.') {
                        ReferencePrefix rp = imp.isStaticImport() ? tr : tr.getReferencePrefix();
                        trname = rp == null ? name : Naming.toPathName(rp, name);
                        newResult = ni.getClassType(trname);
                    }
                } else if (name.endsWith(trname) && name.equals(trname = Naming.toPathName(tr))) {
                    newResult = ni.getClassType(trname);
                }
                if (newResult != null && (newResult.isStatic() || !imp.isStaticImport())) {
                    if (result != null && result != newResult) {
                        this.getErrorHandler().reportError(new AmbiguousImportException("Ambiguous import " + Format.toString("%c \"%s\" @%p in %f", imp) + " - could be " + Format.toString("%N", result) + " or " + Format.toString("%N", newResult), imp, (ClassType)result, (ClassType)newResult));
                    }
                    result = newResult;
                }
            }
            --i;
        }
        return result;
    }

    public ClassType getFromPackageImports(String name, List<Import> il, ClassType searchingFrom) {
        ClassType result = null;
        NameInfo ni = this.getNameInfo();
        int i = il.size() - 1;
        while (i >= 0) {
            Import imp = il.get(i);
            if (imp.isMultiImport()) {
                ClassType t;
                TypeReferenceInfix ref = imp.getReference();
                String xname = Naming.toPathName(ref, name);
                ClassType newResult = ni.getClassType(xname);
                if (newResult == null && (ref instanceof TypeReference || ref instanceof UncollatedReferenceQualifier) && (t = this.getNameInfo().getClassType(Naming.toPathName(ref))) != null) {
                    if (this.hack.add(t)) {
                        if (imp.isStaticImport()) {
                            newResult = this.getMemberType(name, t);
                        } else {
                            List<? extends ClassType> innerTypes = t.getTypes();
                            for (ClassType classType : innerTypes) {
                                if (!name.equals(classType.getName())) continue;
                                newResult = classType;
                                break;
                            }
                        }
                    }
                    this.hack.remove(t);
                }
                if (newResult != null && !this.isVisibleFor(newResult, searchingFrom)) {
                    newResult = null;
                }
                if (newResult != null && (newResult.isStatic() || !imp.isStaticImport())) {
                    if (result != null && result != newResult) {
                        this.getErrorHandler().reportError(new AmbiguousImportException("Ambiguous import of type " + name + ": could be " + Format.toString("%N", result) + " or " + Format.toString("%N", newResult), imp, result, newResult));
                    }
                    result = newResult;
                }
            }
            --i;
        }
        return result;
    }

    private ClassType getMemberType(String shortName, ClassType ct) {
        List<? extends ClassType> innerTypes = ct.getTypes();
        int i = innerTypes.size() - 1;
        while (i >= 0) {
            ClassType candid = innerTypes.get(i);
            if (shortName.equals(candid.getName())) {
                return candid;
            }
            --i;
        }
        List<ClassType> superTypes = ct.getSupertypes();
        int i2 = 0;
        while (i2 < superTypes.size()) {
            ClassType possibleSuperclass = superTypes.get(i2);
            ClassType result = this.getMemberType(shortName, possibleSuperclass);
            if (result != null) {
                return result;
            }
            ++i2;
        }
        return null;
    }

    private ClassType getLocalType(String name, TypeScope scope) {
        ClassType result = null;
        int dotPos = name.indexOf(46);
        String shortName = dotPos == -1 ? name : name.substring(0, dotPos);
        result = scope.getTypeInScope(shortName);
        while (result != null && dotPos != -1) {
            int nextDotPos;
            shortName = (nextDotPos = name.indexOf(46, ++dotPos)) == -1 ? name.substring(dotPos) : name.substring(dotPos, nextDotPos);
            dotPos = nextDotPos;
            result = this.getMemberType(shortName, result);
        }
        return result;
    }

    private ClassType getInheritedType(String name, ClassType ct) {
        int dotPos = name.indexOf(46);
        String shortName = dotPos == -1 ? name : name.substring(0, dotPos);
        List<ClassType> ctl = this.getAllTypes(ct);
        ClassType result = null;
        int nc = ctl.size();
        int i = 0;
        while (i < nc) {
            ClassType c = ctl.get(i);
            if (!(c instanceof TypeParameter) && shortName.equals(c.getName())) {
                result = c;
                break;
            }
            ++i;
        }
        while (result != null && dotPos != -1) {
            int nextDotPos;
            shortName = (nextDotPos = name.indexOf(46, ++dotPos)) == -1 ? name.substring(dotPos) : name.substring(dotPos, nextDotPos);
            dotPos = nextDotPos;
            result = this.getMemberType(shortName, result);
        }
        return result;
    }

    @Override
    public Type getType(String name, ProgramElement context) {
        String defaultName;
        Debug.assertNonnull((Object)name, context);
        NameInfo ni = this.getNameInfo();
        Type t = this.name2primitiveType.get(name);
        if (t != null) {
            return t;
        }
        if (name.equals("void")) {
            return null;
        }
        if (name.endsWith("]")) {
            int px = name.indexOf(91);
            t = this.getType(name.substring(0, px), context);
            if (t == null) {
                return null;
            }
            int dim = (name.length() - px) / 2;
            while (dim > 0) {
                t = t.createArrayType();
                --dim;
            }
            return t;
        }
        this.updateModel();
        if (DefaultSourceInfo.isPartOf(context, InheritanceSpecification.class)) {
            while (!(context instanceof InheritanceSpecification)) {
                context = context.getASTParent();
            }
            if ((context = context.getASTParent()) instanceof TypeDeclaration) {
                TypeDeclaration td = (TypeDeclaration)context;
                List tpds = td.getTypeParameters();
                int i = 0;
                int s = tpds == null ? 0 : tpds.size();
                while (i < s) {
                    if (name.equals(((TypeParameterDeclaration)tpds.get(i)).getName())) {
                        return (Type)tpds.get(i);
                    }
                    ++i;
                }
            }
            context = context.getASTParent();
        }
        if (DefaultSourceInfo.isPartOf(context, TypeParameterDeclaration.class)) {
            while (!(context instanceof TypeParameterDeclaration)) {
                context = context.getASTParent();
            }
            context = context.getASTParent();
        }
        ProgramElement pe = context;
        while (pe != null && !(pe instanceof TypeScope)) {
            context = pe;
            pe = pe.getASTParent();
        }
        TypeScope scope = (TypeScope)pe;
        if (scope == null) {
            Debug.log("Null scope during type query " + name + "(" + context.getID() + ") in context " + Format.toString("%c \"%s\" @%p in %f", context));
            Debug.log(Debug.makeStackTrace());
        }
        ClassType result = null;
        TypeScope s = scope;
        while (s != null) {
            TypeDeclaration td;
            ClassType newResult;
            result = this.getLocalType(name, s);
            if (result != null) {
                if (s instanceof StatementBlock) {
                    Statement stmt;
                    StatementBlock cont = (StatementBlock)s;
                    int i = 0;
                    while ((stmt = cont.getStatementAt(i)) != result) {
                        if (stmt == context) {
                            result = null;
                            break;
                        }
                        ++i;
                    }
                }
                if (result != null) break;
            }
            if (s instanceof TypeDeclaration && (newResult = this.getInheritedType(name, td = (TypeDeclaration)s)) != null) {
                if (result == null) {
                    result = newResult;
                    break;
                }
                if (result != newResult) {
                    this.getErrorHandler().reportError(new AmbiguousReferenceException("Type " + Format.toString("%N", newResult) + " is an inherited member type that is also defined as outer member type " + Format.toString("%N", result), null, result, newResult));
                    break;
                }
            }
            scope = s;
            pe = s.getASTParent();
            while (pe != null && !(pe instanceof TypeScope)) {
                context = pe;
                pe = pe.getASTParent();
            }
            s = (TypeScope)pe;
        }
        if (result != null) {
            return result;
        }
        CompilationUnit cu = (CompilationUnit)scope;
        ASTList<Import> il = cu.getImports();
        if (il != null) {
            result = this.getFromTypeImports(name, il);
        }
        if (result == null && (result = this.getFromUnitPackage(name, cu)) == null && il != null) {
            result = this.getFromPackageImports(name, il, cu.getTypeDeclarationCount() == 0 ? null : cu.getTypeDeclarationAt(0));
        }
        if (result == null && (result = ni.getClassType(defaultName = Naming.dot("java.lang", name))) == null) {
            result = ni.getClassType(name);
        }
        if (result != null) {
            scope.addTypeToScope(result, name);
        }
        return result;
    }

    @Override
    public Type getType(TypeReference tr) {
        Type res = (Type)this.reference2element.get(tr);
        if (res != null) {
            return res;
        }
        ReferencePrefix rp = tr.getReferencePrefix();
        if (rp instanceof PackageReference) {
            String name = Naming.toPathName(rp, tr.getName());
            res = this.getNameInfo().getClassType(name);
            if (res != null) {
                int d = tr.getDimensions();
                while (d > 0) {
                    res = this.getNameInfo().createArrayType(res);
                    --d;
                }
            }
        } else if (rp == null && tr.getASTParent() instanceof New) {
            New neww = (New)tr.getASTParent();
            ReferencePrefix nrp = neww.getReferencePrefix();
            if (nrp != null) {
                if (tr.getReferencePrefix() != null) {
                    this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Cannot use qualified class names in inner class creation %c \"%s\" @%p in %f(15)", tr), tr));
                    res = this.getNameInfo().getUnknownType();
                } else {
                    ClassType context = (ClassType)this.getType(nrp);
                    String innerName = tr.getName();
                    for (Type type : context.getTypes()) {
                        if (type.getName() != innerName) continue;
                        res = type;
                        break;
                    }
                }
            } else {
                res = this.getType(Naming.toPathName(tr), tr);
            }
        } else {
            res = this.getType(Naming.toPathName(tr), tr);
            if (res == null && rp instanceof TypeReference) {
                res = this.getMemberType(tr.getName(), (ClassType)this.getType(rp));
            }
        }
        if (res == null && !"void".equals(tr.getName())) {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f(14)", tr), tr));
            res = this.getNameInfo().getUnknownType();
        }
        if (res != null) {
            ClassType rpType;
            ClassType classType = rpType = rp instanceof TypeReference ? (ClassType)this.getType(rp) : null;
            res = rpType instanceof ParameterizedType || tr.getTypeArguments() != null && tr.getTypeArguments().size() != 0 ? (res instanceof ArrayType ? this.makeParameterizedArrayType((ArrayType)res, tr.getTypeArguments()) : this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType((ClassType)res, tr.getTypeArguments(), rpType instanceof ParameterizedType ? (ParameterizedType)rpType : null)) : this.checkEraseRequired(tr, res);
            this.reference2element.put(tr, res);
        }
        return res;
    }

    private Type checkEraseRequired(TypeReference tr, Type t) {
        if (this.java5Allowed() && t instanceof ClassType && !(t instanceof ArrayType) && (tr.getTypeArguments() == null || tr.getTypeArguments().size() == 0)) {
            ClassType ct = (ClassType)t;
            if (ct.getTypeParameters() != null && ct.getTypeParameters().size() > 0) {
                t = ((ClassType)t).getErasedType();
            } else if (tr.getReferencePrefix() instanceof TypeReference && this.getType(tr.getReferencePrefix()) instanceof ErasedType) {
                t = ((ClassType)t).getErasedType();
            }
        }
        return t;
    }

    @Override
    public final ClassType getType(TypeDeclaration td) {
        return td;
    }

    @Override
    public Type getType(VariableSpecification vs) {
        if (vs instanceof EnumConstantSpecification) {
            return this.getType((EnumConstantSpecification)vs);
        }
        this.updateModel();
        TypeReference tr = vs.getParent().getTypeReference();
        Type result = this.getType(tr);
        if (result != null) {
            ParameterDeclaration pd;
            int d = vs.getDimensions();
            if (vs.getASTParent() instanceof ParameterDeclaration && (pd = (ParameterDeclaration)vs.getASTParent()).isVarArg()) {
                ++d;
            }
            while (d > 0) {
                result = this.getNameInfo().createArrayType(result);
                --d;
            }
        }
        return result;
    }

    private Type getType(EnumConstantSpecification ecs) {
        ClassDeclaration cd = ecs.getConstructorReference().getClassDeclaration();
        if (cd != null) {
            return cd;
        }
        return ecs.getParent().getParent();
    }

    @Override
    public Type getType(ProgramElement pe) {
        this.updateModel();
        Type result = null;
        if (pe instanceof Expression) {
            result = this.getType((Expression)pe);
        } else if (pe instanceof UncollatedReferenceQualifier) {
            result = this.getType((UncollatedReferenceQualifier)pe);
        } else if (pe instanceof TypeReference) {
            result = this.getType((TypeReference)pe);
        } else if (pe instanceof VariableSpecification) {
            result = this.getType((VariableSpecification)pe);
        } else if (pe instanceof EnumConstantSpecification) {
            result = this.getType((EnumConstantSpecification)pe);
        } else if (pe instanceof MethodDeclaration) {
            if (!(pe instanceof ConstructorDeclaration)) {
                result = this.getReturnType((MethodDeclaration)pe);
            }
        } else if (pe instanceof TypeDeclaration) {
            result = this.getType((TypeDeclaration)pe);
        }
        return result;
    }

    private Type getType(UncollatedReferenceQualifier urq) {
        Reference r = this.resolveURQ(urq);
        if (r instanceof UncollatedReferenceQualifier) {
            return this.getNameInfo().getUnknownClassType();
        }
        return this.getType(r);
    }

    @Override
    public Type getType(Expression expr) {
        Type result = null;
        if (expr instanceof Operator) {
            Operator op = (Operator)expr;
            ASTList<Expression> args = op.getArguments();
            if (op instanceof Assignment) {
                result = this.getType((Expression)args.get(0));
            } else if (op instanceof TypeCast) {
                result = this.getType(((TypeOperator)op).getTypeReference());
            } else if (op instanceof New) {
                result = ((New)op).getClassDeclaration();
                if (result == null) {
                    result = this.getType(((New)op).getTypeReference());
                }
            } else if (op instanceof NewArray) {
                NewArray n = (NewArray)op;
                TypeReference tr = n.getTypeReference();
                result = this.getType(tr);
                int d = n.getDimensions();
                while (d > 0) {
                    Type oldResult = result;
                    result = this.getNameInfo().getArrayType(result);
                    if (result == null) {
                        result = this.getNameInfo().createArrayType(oldResult);
                    }
                    --d;
                }
            } else if (op instanceof PreIncrement || op instanceof PostIncrement || op instanceof PreDecrement || op instanceof PostDecrement || op instanceof ParenthesizedExpression || op instanceof BinaryNot) {
                result = this.getType((Expression)args.get(0));
            } else if (op instanceof Positive || op instanceof Negative) {
                result = this.getType((Expression)args.get(0));
                if (this.java5Allowed() && result instanceof ClassType) {
                    result = this.getUnboxedType((ClassType)result);
                }
            } else if (op instanceof Plus || op instanceof Minus || op instanceof Times || op instanceof Divide || op instanceof Modulo) {
                Type t2 = this.getType((Expression)args.get(1));
                if (op instanceof Plus && (t2 == this.getNameInfo().getJavaLangString() || t2 == null)) {
                    result = this.getNameInfo().getJavaLangString();
                } else {
                    Type t1 = this.getType((Expression)args.get(0));
                    if (op instanceof Plus && (t1 == this.getNameInfo().getJavaLangString() || t2 == this.getNameInfo().getJavaLangString() || t1 == null || t2 == null)) {
                        result = this.getNameInfo().getJavaLangString();
                    } else {
                        if (this.java5Allowed()) {
                            if (t1 instanceof ClassType) {
                                t1 = this.getUnboxedType((ClassType)t1);
                            }
                            if (t2 instanceof ClassType) {
                                t2 = this.getUnboxedType((ClassType)t2);
                            }
                        }
                        if (t1 instanceof PrimitiveType && t2 instanceof PrimitiveType) {
                            result = this.getPromotedType((PrimitiveType)t1, (PrimitiveType)t2);
                            if (result == null) {
                                this.getErrorHandler().reportError(new TypingException("Boolean types cannot be promoted in " + op, op));
                                result = this.getNameInfo().getUnknownType();
                            }
                        } else if (t1 != null && t2 != null) {
                            this.getErrorHandler().reportError(new TypingException("Illegal operand types for plus " + t1 + " + " + t2 + " in expression " + op, op));
                            result = this.getNameInfo().getUnknownType();
                        }
                    }
                }
            } else if (op instanceof ShiftRight || op instanceof UnsignedShiftRight || op instanceof ShiftLeft || op instanceof BinaryAnd || op instanceof BinaryOr || op instanceof BinaryXOr) {
                Type t1 = this.getType((Expression)args.get(0));
                if (this.java5Allowed()) {
                    Type t2 = this.getType((Expression)args.get(1));
                    if (t1 instanceof ClassType && t2 instanceof PrimitiveType) {
                        t1 = this.getUnboxedType((ClassType)t1);
                    }
                }
                result = t1;
            } else if (op instanceof ComparativeOperator || op instanceof LogicalAnd || op instanceof LogicalOr || op instanceof LogicalNot || op instanceof Instanceof) {
                result = this.getNameInfo().getBooleanType();
            } else if (op instanceof Conditional) {
                Expression e1 = (Expression)args.get(1);
                Expression e2 = (Expression)args.get(2);
                Type t1 = this.getType(e1);
                Type t2 = this.getType(e2);
                if (this.java5Allowed()) {
                    PrimitiveType tmp;
                    if (t1 instanceof PrimitiveType && t2 instanceof ClassType) {
                        tmp = this.getUnboxedType((ClassType)t2);
                        if (tmp != null) {
                            t2 = tmp;
                        } else {
                            t1 = this.getBoxedType((PrimitiveType)t1);
                        }
                    } else if (t1 instanceof ClassType && t2 instanceof PrimitiveType) {
                        tmp = this.getUnboxedType((ClassType)t1);
                        if (tmp != null) {
                            t1 = tmp;
                        } else {
                            t2 = this.getBoxedType((PrimitiveType)t2);
                        }
                    }
                }
                if (t1 == t2) {
                    result = t1;
                } else if (t1 instanceof PrimitiveType && t2 instanceof PrimitiveType) {
                    NameInfo ni = this.getNameInfo();
                    if (t1 == ni.getShortType() && t2 == ni.getByteType() || t2 == ni.getShortType() && t1 == ni.getByteType()) {
                        result = ni.getShortType();
                    } else {
                        result = this.serviceConfiguration.getConstantEvaluator().getCompileTimeConstantType(op);
                        if (result == null) {
                            if (this.isNarrowingTo(e1, (PrimitiveType)t2)) {
                                return t2;
                            }
                            if (this.isNarrowingTo(e2, (PrimitiveType)t1)) {
                                return t1;
                            }
                            result = this.getPromotedType((PrimitiveType)t1, (PrimitiveType)t2);
                        }
                    }
                } else if (t1 instanceof PrimitiveType || t2 instanceof PrimitiveType) {
                    this.getErrorHandler().reportError(new TypingException("Incompatible types in conditional", op));
                    result = this.getNameInfo().getUnknownType();
                } else if (t1 == this.getNameInfo().getNullType()) {
                    result = t2;
                } else if (t2 == this.getNameInfo().getNullType()) {
                    result = t1;
                } else if (this.isWidening(t1, t2)) {
                    result = t2;
                } else if (this.isWidening(t2, t1)) {
                    result = t1;
                } else if (this.java5Allowed() && t1 instanceof ClassType && t2 instanceof ClassType) {
                    result = this.getCommonSupertype((ClassType)t1, (ClassType)t2);
                    if (result instanceof IntersectionType) {
                        ((IntersectionType)result).setAccesibility(MiscKit.getParentTypeDeclaration(expr));
                    }
                } else {
                    this.getErrorHandler().reportError(new TypingException("Incompatible types in conditional", op));
                    result = this.getNameInfo().getUnknownType();
                }
            } else {
                Debug.error("Type resolution not implemented for operation " + op.getClass().getName());
            }
        } else if (expr instanceof Literal) {
            if (expr instanceof NullLiteral) {
                result = this.getNameInfo().getNullType();
            } else if (expr instanceof BooleanLiteral) {
                result = this.getNameInfo().getBooleanType();
            } else if (expr instanceof LongLiteral) {
                result = this.getNameInfo().getLongType();
            } else if (expr instanceof IntLiteral) {
                result = this.getNameInfo().getIntType();
            } else if (expr instanceof FloatLiteral) {
                result = this.getNameInfo().getFloatType();
            } else if (expr instanceof DoubleLiteral) {
                result = this.getNameInfo().getDoubleType();
            } else if (expr instanceof CharLiteral) {
                result = this.getNameInfo().getCharType();
            } else if (expr instanceof StringLiteral) {
                result = this.getNameInfo().getJavaLangString();
            }
        } else if (expr instanceof Reference) {
            ReferencePrefix rp;
            ClassType thisType;
            List<ClassType> supers;
            if (expr instanceof UncollatedReferenceQualifier) {
                result = this.getType((UncollatedReferenceQualifier)expr);
            } else if (expr instanceof MetaClassReference) {
                if (this.java5Allowed()) {
                    Type pref_type = this.getType(((MetaClassReference)expr).getReferencePrefix());
                    if (pref_type instanceof PrimitiveType) {
                        pref_type = this.getBoxedType((PrimitiveType)pref_type);
                    }
                    if (pref_type == null) {
                        pref_type = this.getNameInfo().getType("java.lang.Void");
                    }
                    DefaultProgramModelInfo.ResolvedTypeArgument ta = new DefaultProgramModelInfo.ResolvedTypeArgument(TypeArgument.WildcardMode.None, (ClassType)pref_type, null);
                    ArrayList<DefaultProgramModelInfo.ResolvedTypeArgument> tas = new ArrayList<DefaultProgramModelInfo.ResolvedTypeArgument>(1);
                    tas.add(ta);
                    result = this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType(this.getNameInfo().getJavaLangClass(), tas);
                } else {
                    result = this.getNameInfo().getJavaLangClass();
                }
            } else if (expr instanceof VariableReference) {
                Variable v = this.getVariable((VariableReference)expr);
                if (v != null) {
                    result = v.getType();
                } else {
                    this.getErrorHandler().reportError(new UnresolvedReferenceException(String.valueOf(Format.toString("Could not resolve %c \"%s\" @%p in %f", expr)) + " (01)", expr));
                    v = this.getNameInfo().getUnknownField();
                }
            } else if (expr instanceof MethodReference) {
                ClassType pref;
                MethodReference mr = (MethodReference)expr;
                Method m = this.getMethod(mr);
                if (m != null && (result = m.getReturnType()) instanceof ClassType && result.isInner() && mr.getReferencePrefix() != null && (pref = (ClassType)this.getType(mr.getReferencePrefix())) instanceof ParameterizedType) {
                    result = this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType((ClassType)result, null, (ParameterizedType)pref);
                }
            } else if (expr instanceof AnnotationPropertyReference) {
                AnnotationProperty ap = this.getAnnotationProperty((AnnotationPropertyReference)((Object)expr));
                if (ap != null) {
                    result = ap.getReturnType();
                }
            } else if (expr instanceof ArrayReference) {
                ArrayReference aref = (ArrayReference)expr;
                Type ht = this.getType(aref.getReferencePrefix());
                if (ht != null && !(ht instanceof DefaultNameInfo.UnknownClassType)) {
                    ASTList<Expression> dimExprs = aref.getDimensionExpressions();
                    int dims = dimExprs.size();
                    int i = 0;
                    while (i < dims) {
                        ht = ((ArrayType)ht).getBaseType();
                        ++i;
                    }
                    if (ht != null) {
                        result = ht;
                    } else {
                        this.getErrorHandler().reportError(new TypingException("Not an array type: " + ht + " in expression " + expr, expr));
                        result = this.getNameInfo().getUnknownType();
                    }
                }
            } else if (expr instanceof ThisReference) {
                ReferencePrefix rp2 = ((ThisReference)expr).getReferencePrefix();
                result = rp2 == null ? this.getContainingClassType(expr) : this.getType(rp2);
            } else if (expr instanceof SuperReference && (supers = (thisType = (rp = ((SuperReference)expr).getReferencePrefix()) == null ? this.getContainingClassType(expr) : (ClassType)this.getType(rp)).getSupertypes()) != null && !supers.isEmpty()) {
                result = supers.get(0);
            }
        } else if (expr instanceof ArrayInitializer) {
            ProgramElement pe = expr;
            while (pe != null && !(pe instanceof VariableSpecification) && !(pe instanceof NewArray)) {
                pe = pe.getASTParent();
            }
            result = this.getType(pe);
        } else if (expr instanceof ElementValueArrayInitializer) {
            ProgramElement pe = expr;
            while (pe != null && !(pe instanceof VariableSpecification)) {
                pe = pe.getASTParent();
            }
            result = this.getType(pe);
        } else if (expr instanceof AnnotationUseSpecification) {
            result = this.getType(((AnnotationUseSpecification)expr).getTypeReference());
        } else {
            Debug.error("Type analysis for general expressions is currently not implemented: " + expr + " <" + expr.getClass().getName() + ">");
        }
        return result;
    }

    private boolean containsTypeParameterInSig(Method m, TypeParameter typeParam) {
        List<Type> sig = m.getSignature();
        int j = 0;
        while (j < sig.size()) {
            if (this.containsTypeParameter(sig.get(j), typeParam)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private ClassType inferType(Method m, MethodReference mr, TypeParameter typeParam) {
        String typeParamName = typeParam.getName();
        ArrayList<ClassType> result = new ArrayList<ClassType>();
        List<Type> sig = m.getSignature();
        int j = 0;
        while (j < sig.size()) {
            Expression e;
            Type t = sig.get(j);
            if (m.isVarArgMethod() && j == sig.size() - 1) {
                if (mr.getArguments().size() == sig.size()) {
                    e = (Expression)mr.getArguments().get(sig.size() - 1);
                    Type actualTypeArg = this.getType(e);
                    if (actualTypeArg instanceof ArrayType) {
                        this.inferType1(typeParamName, result, t, actualTypeArg);
                    } else {
                        this.inferType1(typeParamName, result, t, actualTypeArg.createArrayType());
                    }
                } else {
                    int k = sig.size() - 1;
                    while (k < mr.getArguments().size()) {
                        Expression e2 = (Expression)mr.getArguments().get(k);
                        Type actualArgType = this.getType(e2);
                        this.inferType1(typeParamName, result, t, actualArgType.createArrayType());
                        ++k;
                    }
                }
            } else {
                e = (Expression)mr.getArguments().get(j);
                Type actualArgType = this.getType(e);
                this.inferType1(typeParamName, result, t, actualArgType);
            }
            ++j;
        }
        if (result.size() == 0) {
            Type exp;
            if (this.containsTypeParameterInSig(m, typeParam)) {
                return null;
            }
            NonTerminalProgramElement parent = mr.getASTParent();
            if (parent instanceof CopyAssignment) {
                CopyAssignment ca = (CopyAssignment)parent;
                exp = this.getType((Expression)ca.getArguments().get(0));
                this.inferType1(typeParamName, result, m.getReturnType(), exp);
            } else if (parent instanceof VariableSpecification) {
                VariableSpecification vs = (VariableSpecification)parent;
                exp = this.getType(vs.getType());
                this.inferType1(typeParamName, result, m.getReturnType(), exp);
            } else {
                result.addAll(typeParam.getSupertypes());
            }
        }
        this.removeSupertypesFromList(result);
        if (result.size() == 1) {
            return (ClassType)result.get(0);
        }
        IntersectionType res = new IntersectionType(result, this.getServiceConfiguration().getImplicitElementInfo());
        res.setAccesibility(MiscKit.getParentTypeDeclaration(mr));
        return res;
    }

    private void inferType1(String typeParamName, List<ClassType> result, Type t, Type actualArgType) {
        this.inferType2(typeParamName, result, t, actualArgType);
        if (t instanceof ParameterizedType && actualArgType instanceof ClassType) {
            ParameterizedType tp = (ParameterizedType)t;
            List<ClassType> supers = this.removeErasedTypesFromList(((ClassType)actualArgType).getAllSupertypes());
            ParameterizedType inferFrom = null;
            for (ClassType temp : supers) {
                if (!(temp instanceof ParameterizedType) || ((ParameterizedType)temp).getGenericType() != tp.getGenericType()) continue;
                inferFrom = (ParameterizedType)temp;
                break;
            }
            if (inferFrom == null) {
                return;
            }
            int i = 0;
            while (i < tp.getAllTypeArgs().size()) {
                this.inferType1(typeParamName, result, this.getBaseType(tp.getAllTypeArgs().get(i)), this.getBaseType(inferFrom.getAllTypeArgs().get(i)));
                ++i;
            }
        }
    }

    private void inferType2(String typeParamName, List<ClassType> result, Type t, Type actualArgType) {
        Type toAdd = actualArgType;
        int reduceDim = 0;
        while (t instanceof ArrayType) {
            t = ((ArrayType)t).getBaseType();
            ++reduceDim;
        }
        if (t instanceof TypeParameter && t.getName().equals(typeParamName)) {
            while (reduceDim > 0) {
                toAdd = ((ArrayType)toAdd).getBaseType();
                --reduceDim;
            }
            List<Object> ctl = new ArrayList();
            if (toAdd instanceof PrimitiveType) {
                toAdd = this.getBoxedType((PrimitiveType)toAdd);
            }
            ctl = this.removeErasedTypesFromList(this.getAllSupertypes((ClassType)toAdd));
            if (result.isEmpty()) {
                result.addAll(ctl);
            } else {
                int i = result.size() - 1;
                while (i >= 0) {
                    if (ctl.indexOf(result.get(i)) == -1) {
                        result.remove(i);
                    }
                    --i;
                }
            }
        }
    }

    @Override
    public boolean isNarrowingTo(Expression expr, PrimitiveType to) {
        int maxValue;
        int minValue;
        NameInfo ni = this.getNameInfo();
        if (to == ni.getByteType()) {
            minValue = -128;
            maxValue = 127;
        } else if (to == ni.getCharType()) {
            minValue = 0;
            maxValue = 65535;
        } else if (to == ni.getShortType()) {
            minValue = Short.MIN_VALUE;
            maxValue = Short.MAX_VALUE;
        } else {
            return false;
        }
        ConstantEvaluator ce = this.serviceConfiguration.getConstantEvaluator();
        ConstantEvaluator.EvaluationResult res = new ConstantEvaluator.EvaluationResult();
        if (!ce.isCompileTimeConstant(expr, res) || res.getTypeCode() != 4) {
            return false;
        }
        int value = res.getInt();
        return minValue <= value && value <= maxValue;
    }

    @Override
    public Type getType(ProgramModelElement pme) {
        Debug.assertNonnull(pme);
        Type result = null;
        if (pme instanceof Type) {
            result = (Type)pme;
        } else if (pme instanceof ProgramElement) {
            result = this.getType((ProgramElement)((Object)pme));
            if (result == null && pme instanceof VariableSpecification) {
                if (pme instanceof EnumConstantSpecification) {
                    throw new IllegalStateException("Enum constant outside an enum, this shouldn't even be possible");
                }
                this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Unknown type of %c \"%s\" @%p in %f", pme), ((VariableSpecification)pme).getParent().getTypeReference()));
                result = this.getNameInfo().getUnknownType();
            }
            if (result == null && pme instanceof EnumConstantDeclaration) {
                throw new Error("fatal error: EnumConstantDeclaration occured outside enum declaration");
            }
        } else {
            result = pme.getProgramModelInfo().getType(pme);
        }
        return result;
    }

    @Override
    public ClassType getContainingClassType(ProgramElement context) {
        Debug.assertNonnull(context);
        if (context instanceof TypeDeclaration) {
            context = context.getASTParent();
        }
        do {
            if (!(context instanceof ClassType)) continue;
            return (ClassType)((Object)context);
        } while ((context = context.getASTParent()) != null);
        return null;
    }

    @Override
    public ClassType getContainingClassType(Member m) {
        Debug.assertNonnull(m);
        ClassType result = null;
        ProgramElement pe = this.getDeclaration(m);
        result = pe == null ? m.getProgramModelInfo().getContainingClassType(m) : this.getContainingClassType(pe);
        return result;
    }

    private Field getInheritedField(String name, ClassType ct) {
        List<Field> fl = ct.getAllFields();
        int nf = fl.size();
        int i = 0;
        while (i < nf) {
            Field f = fl.get(i);
            if (name.equals(f.getName())) {
                return f;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Variable getVariable(String name, ProgramElement context) {
        ClassType ct;
        ASTList<Import> imports;
        Variable result;
        VariableScope variableScope;
        ProgramElement originalContext = context;
        Debug.assertNonnull((Object)name, context);
        this.updateModel();
        if (this.java5Allowed() && (context instanceof VariableReference || context instanceof UncollatedReferenceQualifier) && context.getASTParent() instanceof Case && this.getType(((Case)context.getASTParent()).getParent().getExpression()) instanceof ClassType && ((ClassType)this.getType(((Case)context.getASTParent()).getParent().getExpression())).isEnumType()) {
            ClassType container = (ClassType)this.getType(((Case)context.getASTParent()).getParent().getExpression());
            for (Field field : container.getFields()) {
                if (!(field instanceof EnumConstant) || !field.getName().equals(name)) continue;
                return field;
            }
            return null;
        }
        ProgramElement pe = context;
        while (pe != null && !(pe instanceof VariableScope)) {
            context = pe;
            pe = pe.getASTParent();
        }
        if (pe == null) {
            if (this.java5Allowed() && DefaultSourceInfo.isPartOf(originalContext, PackageSpecification.class)) {
                ASTList<Import> aSTList = UnitKit.getCompilationUnit(originalContext).getImports();
                return this.getVariableFromStaticSingleImport(name, aSTList, null);
            }
            return null;
        }
        VariableScope variableScope2 = (VariableScope)pe;
        do {
            void var5_11;
            if ((result = var5_11.getVariableInScope(name)) != null) {
                if (var5_11 instanceof StatementBlock) {
                    Statement s;
                    StatementBlock cont = (StatementBlock)var5_11;
                    VariableDeclaration def = result.getParent();
                    int i = 0;
                    while ((s = cont.getStatementAt(i)) != def) {
                        if (s == context) {
                            result = null;
                            break;
                        }
                        ++i;
                    }
                }
                if (result != null) break;
            }
            if (var5_11 instanceof TypeDeclaration && (result = this.getInheritedField(name, (TypeDeclaration)var5_11)) != null) break;
            pe = var5_11.getASTParent();
            while (pe != null && !(pe instanceof VariableScope)) {
                context = pe;
                pe = pe.getASTParent();
            }
        } while ((variableScope = (VariableScope)pe) != null);
        if (result == null && this.java5Allowed() && (result = this.getVariableFromStaticSingleImport(name, imports = UnitKit.getCompilationUnit(context).getImports(), ct = originalContext instanceof ClassType ? (ClassType)((Object)originalContext) : MiscKit.getParentTypeDeclaration(originalContext))) == null) {
            result = this.getVariableFromStaticOnDemandImport(name, imports, ct);
        }
        return result;
    }

    public Variable getVariableFromStaticSingleImport(String name, List<Import> imports, ClassType context) {
        Field result = null;
        Field oldResult = null;
        Import firstImport = null;
        int i = 0;
        int max = imports.size();
        while (i < max) {
            Import imp = imports.get(i);
            if (imp.isStaticImport() && !imp.isMultiImport() && name.equals(imp.getStaticIdentifier().getText())) {
                List<? extends Field> fields = this.getFields((ClassType)this.getType(imp.getTypeReference()));
                int f = 0;
                int maxF = fields.size();
                while (f < maxF) {
                    Field field = fields.get(f);
                    if (field.isStatic() && field.getName().equals(name) && (context == null || this.isVisibleFor(field, context))) {
                        result = field;
                        if (oldResult != null && oldResult != result) {
                            this.getErrorHandler().reportError(new AmbiguousStaticFieldImportException(firstImport, imp, oldResult, result));
                        }
                        firstImport = imp;
                        oldResult = field;
                        break;
                    }
                    ++f;
                }
            }
            ++i;
        }
        return result;
    }

    public Variable getVariableFromStaticOnDemandImport(String name, List<Import> imports, ClassType context) {
        Debug.assertNonnull(name);
        Debug.assertNonnull(imports);
        Debug.assertNonnull(context);
        Field result = null;
        Field oldResult = null;
        Import firstImport = null;
        int i = 0;
        int max = imports.size();
        while (i < max) {
            Import imp = imports.get(i);
            if (imp.isStaticImport() && imp.isMultiImport()) {
                List<Field> fields = this.getAllFields((ClassType)this.getType(imp.getTypeReference()));
                int f = 0;
                int maxF = fields.size();
                while (f < maxF) {
                    Field field = fields.get(f);
                    if (field.isStatic() && field.getName().equals(name) && this.isVisibleFor(field, context)) {
                        result = field;
                        if (oldResult != null && oldResult != result) {
                            this.getErrorHandler().reportError(new AmbiguousStaticFieldImportException(firstImport, imp, oldResult, result));
                        }
                        firstImport = imp;
                        oldResult = field;
                        break;
                    }
                    ++f;
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public final Variable getVariable(VariableSpecification vs) {
        return vs;
    }

    @Override
    public Field getField(FieldReference fr) {
        Field res = (Field)this.reference2element.get(fr);
        if (res != null) {
            return res;
        }
        this.updateModel();
        String name = fr.getName();
        ReferencePrefix rp = fr.getReferencePrefix();
        if (rp == null) {
            res = (Field)this.getVariable(name, fr);
            if (res != null) {
                this.reference2element.put(fr, res);
            }
            return res;
        }
        ClassType ct = (ClassType)this.getType(rp);
        if (ct == null || ct instanceof DefaultNameInfo.UnknownClassType) {
            return null;
        }
        List<Field> fl = ct.getAllFields();
        if (fl == null) {
            return null;
        }
        int i = fl.size() - 1;
        while (i >= 0) {
            res = fl.get(i);
            if (res.getName() == name) {
                this.reference2element.put(fr, res);
                return res;
            }
            --i;
        }
        return null;
    }

    @Override
    public Variable getVariable(VariableReference vr) {
        if (vr instanceof FieldReference) {
            return this.getField((FieldReference)vr);
        }
        Variable res = (Variable)this.reference2element.get(vr);
        if (res != null) {
            return res;
        }
        res = this.getVariable(vr.getName(), vr);
        if (res != null) {
            this.reference2element.put(vr, res);
        }
        return res;
    }

    @Override
    public List<Type> makeSignature(List<Expression> args) {
        if (args == null || args.isEmpty()) {
            return Collections.emptyList();
        }
        int arity = args.size();
        ArrayList<Type> result = new ArrayList<Type>(arity);
        int i = 0;
        while (i < arity) {
            Expression e = args.get(i);
            Type et = this.getType(e);
            if (et == null) {
                this.getErrorHandler().reportError(new TypingException("Unknown type for argument #" + i + " in call " + Format.toString("%c \"%s\" @%p in %f", e.getExpressionContainer()), e));
                et = this.getNameInfo().getUnknownType();
            }
            result.add(et);
            ++i;
        }
        return result;
    }

    @Override
    public final Method getMethod(MethodDeclaration md) {
        return md;
    }

    @Override
    public final Constructor getConstructor(ConstructorDeclaration cd) {
        return cd;
    }

    @Override
    public AnnotationProperty getAnnotationProperty(AnnotationPropertyReference apr) {
        AnnotationProperty res = (AnnotationProperty)this.reference2element.get(apr);
        if (res != null) {
            return res;
        }
        Type at = this.getType(apr.getParent().getParent().getTypeReference());
        if (at instanceof ClassType && ((ClassType)at).isAnnotationType()) {
            ClassType ct = (ClassType)at;
            List<Method> ml = ct.getMethods();
            int i = 0;
            while (i < ml.size()) {
                if (ml.get(i).getName() == apr.getIdentifier().getText()) {
                    res = (AnnotationProperty)ml.get(i);
                    break;
                }
                ++i;
            }
            if (res == null) {
                this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (12)", apr), apr));
                res = this.getNameInfo().getUnknownAnnotationProperty();
            }
        } else if (at == null) {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (13)", apr), apr));
        } else {
            this.getErrorHandler().reportError(new ModelException(Format.toString("%c \"%s\" @%p in %f does not reference an annotation type!", apr)));
            res = this.getNameInfo().getUnknownAnnotationProperty();
        }
        this.reference2element.put(apr, res);
        return res;
    }

    @Override
    public Method getMethod(MethodReference mr) {
        Method res = (Method)this.reference2element.get(mr);
        if (res != null) {
            return res;
        }
        List<Method> mlist = this.getMethods(mr);
        if (mlist == null || mlist.isEmpty()) {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (02)", mr), mr));
            return this.getNameInfo().getUnknownMethod();
        }
        if (mlist.size() > 1) {
            this.getErrorHandler().reportError(new AmbiguousReferenceException(String.valueOf(Format.toString("%c \"%s\" @%p in %f is ambiguous - it could be one of ", mr)) + Format.toString("%N", mlist), mr, mlist));
        }
        if ((res = mlist.get(0)).getTypeParameters() != null && res.getTypeParameters().size() > 0) {
            if (mr.getTypeArguments() != null && mr.getTypeArguments().size() > 0) {
                if (mr.getTypeArguments().size() != res.getTypeParameters().size()) {
                    this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Wrong number of type arguments %c \"%s\" @%p in %f", mr), mr));
                    return this.getNameInfo().getUnknownMethod();
                }
                res = new ResolvedGenericMethod(res, false, this.getTypeListFromTypeArgs(mr.getTypeArguments()), this.getServiceConfiguration().getImplicitElementInfo());
            } else {
                ArrayList<ClassType> inferredTypes = new ArrayList<ClassType>(res.getTypeParameters().size());
                for (TypeParameter typeParameter : res.getTypeParameters()) {
                    ClassType inferred = this.inferType(res, mr, typeParameter);
                    inferredTypes.add(inferred);
                }
                res = new ResolvedGenericMethod(res, true, inferredTypes, this.getServiceConfiguration().getImplicitElementInfo());
            }
        }
        this.reference2element.put(mr, res);
        return res;
    }

    @Override
    public List<Method> getMethods(MethodReference mr) {
        Debug.assertNonnull(mr);
        this.updateModel();
        List<Method> result = null;
        List<Type> signature = this.makeSignature(mr.getArguments());
        ReferencePrefix rp = mr.getReferencePrefix();
        if (rp == null) {
            ClassType targetClass = this.getContainingClassType(mr);
            result = this.getMethods(targetClass, mr.getName(), signature, mr.getTypeArguments());
            if (result != null && result.size() > 0) {
                return result;
            }
            ClassTypeContainer ctc = targetClass.getContainer();
            while (ctc != null) {
                if (ctc instanceof ClassType && (result = this.getMethods((ClassType)ctc, mr.getName(), signature, mr.getTypeArguments())) != null && result.size() > 0) {
                    return result;
                }
                ctc = ctc.getContainer();
            }
            if (this.java5Allowed()) {
                ASTList<Import> imports = UnitKit.getCompilationUnit(mr).getImports();
                result = this.getMethodsFromStaticSingleImports(mr, imports);
                if (result != null && result.size() > 0) {
                    return result;
                }
                result = this.getMethodsFromStaticOnDemandImports(mr, imports);
                if (result != null && result.size() > 0) {
                    return result;
                }
            }
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (03)", mr), mr));
            ArrayList<Method> list = new ArrayList<Method>(1);
            list.add(this.getNameInfo().getUnknownMethod());
            result = list;
        } else {
            Type rpt = this.getType(rp);
            if (rpt == null) {
                this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (04)", rp), rp));
                ArrayList<Method> list = new ArrayList<Method>(1);
                list.add(this.getNameInfo().getUnknownMethod());
                return list;
            }
            result = this.getMethods((ClassType)rpt, mr.getName(), signature, mr.getTypeArguments());
        }
        return result;
    }

    public List<Method> getMethodsFromStaticOnDemandImports(MethodReference mr, List<Import> imports) {
        NameInfo ni = this.getNameInfo();
        ArrayList<Method> result = new ArrayList<Method>();
        int i = 0;
        int max = imports.size();
        while (i < max) {
            Import imp = imports.get(i);
            if (imp.isStaticImport() && imp.isMultiImport()) {
                List<Method> ml = ni.getClassType(Naming.toPathName(imp.getTypeReference())).getMethods();
                int j = 0;
                while (j < ml.size()) {
                    Method m = ml.get(j);
                    if (m.isStatic() && m.getName() == mr.getName()) {
                        result.add(m);
                    }
                    ++j;
                }
            }
            ++i;
        }
        List<Type> sig = this.makeSignature(mr.getArguments());
        return this.doThreePhaseFilter(result, sig, mr.getName(), MiscKit.getParentTypeDeclaration(mr));
    }

    public List<Method> getMethodsFromStaticSingleImports(MethodReference mr, List<Import> imports) {
        NameInfo ni = this.getNameInfo();
        ArrayList<Method> result = new ArrayList<Method>();
        int i = 0;
        int max = imports.size();
        while (i < max) {
            Import imp = imports.get(i);
            if (imp.isStaticImport() && !imp.isMultiImport() && imp.getStaticIdentifier().getText() == mr.getName()) {
                List<Method> ml = ni.getClassType(Naming.toPathName(imp.getTypeReference())).getMethods();
                int j = 0;
                while (j < ml.size()) {
                    Method m = ml.get(j);
                    if (m.isStatic() && m.getName() == mr.getName()) {
                        result.add(m);
                    }
                    ++j;
                }
            }
            ++i;
        }
        List<Type> sig = this.makeSignature(mr.getArguments());
        return this.doThreePhaseFilter(result, sig, mr.getName(), MiscKit.getParentTypeDeclaration(mr));
    }

    @Override
    public Constructor getConstructor(ConstructorReference cr) {
        Constructor res = (Constructor)this.reference2element.get(cr);
        if (res != null) {
            return res;
        }
        List<? extends Constructor> clist = this.getConstructors(cr);
        if (clist == null || clist.isEmpty()) {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (05)", cr), cr));
            return this.getNameInfo().getUnknownConstructor();
        }
        if (clist.size() > 1) {
            this.getErrorHandler().reportError(new AmbiguousReferenceException(String.valueOf(Format.toString("%c \"%s\" @%p in %f is ambiguous - it could be one of ", cr)) + Format.toString("%N", clist), cr, clist));
        }
        res = clist.get(0);
        this.reference2element.put(cr, res);
        return res;
    }

    @Override
    public List<? extends Constructor> getConstructors(ConstructorReference cr) {
        this.updateModel();
        ClassType type = null;
        if (cr instanceof New) {
            New n = (New)cr;
            ReferencePrefix rp = n.getReferencePrefix();
            type = (ClassType)this.getType(n.getTypeReference());
        } else if (cr instanceof ThisConstructorReference) {
            type = this.getContainingClassType(cr);
        } else if (cr instanceof SuperConstructorReference) {
            type = this.getContainingClassType(cr);
            List<ClassType> superTypes = this.getSupertypes(type);
            int i = 0;
            while (i < superTypes.size()) {
                type = superTypes.get(i);
                if (type.isInterface()) {
                    ++i;
                    continue;
                }
                break;
            }
        } else if (cr instanceof EnumConstructorReference) {
            type = this.getContainingClassType(cr);
        } else {
            Debug.error("Unknown Constructor Reference " + cr);
        }
        if (type == null) {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (06)", cr), cr));
            ArrayList<Constructor> list = new ArrayList<Constructor>(1);
            list.add(this.getNameInfo().getUnknownConstructor());
            return list;
        }
        return this.getConstructors(type, this.makeSignature(cr.getArguments()));
    }

    @Override
    public List<TypeDeclaration> getTypes(TypeDeclaration td) {
        Debug.assertNonnull(td);
        this.updateModel();
        ASTList<MemberDeclaration> members = td.getMembers();
        if (members == null) {
            return Collections.emptyList();
        }
        int s = members.size();
        ArrayList<TypeDeclaration> result = new ArrayList<TypeDeclaration>();
        int i = 0;
        while (i < s) {
            MemberDeclaration m = (MemberDeclaration)members.get(i);
            if (m instanceof TypeDeclaration) {
                result.add((TypeDeclaration)m);
            }
            ++i;
        }
        result.trimToSize();
        return result;
    }

    @Override
    public List<FieldSpecification> getFields(TypeDeclaration td) {
        Debug.assertNonnull(td);
        this.updateModel();
        ASTList<MemberDeclaration> members = td.getMembers();
        if (members == null) {
            return Collections.emptyList();
        }
        int s = members.size();
        ArrayList<FieldSpecification> result = new ArrayList<FieldSpecification>();
        int i = 0;
        while (i < s) {
            MemberDeclaration m = (MemberDeclaration)members.get(i);
            if (m instanceof FieldDeclaration) {
                result.addAll(((FieldDeclaration)m).getFieldSpecifications());
            } else if (m instanceof EnumConstantDeclaration) {
                result.add(((EnumConstantDeclaration)m).getEnumConstantSpecification());
            }
            ++i;
        }
        result.trimToSize();
        return result;
    }

    @Override
    public List<Method> getMethods(TypeDeclaration td) {
        Debug.assertNonnull(td);
        this.updateModel();
        ASTList<MemberDeclaration> members = td.getMembers();
        if (members == null && !(td instanceof EnumDeclaration)) {
            return Collections.emptyList();
        }
        int s = members == null ? 0 : members.size();
        ArrayList<Method> result = new ArrayList<Method>();
        int i = 0;
        while (i < s) {
            MemberDeclaration m = (MemberDeclaration)members.get(i);
            if (m instanceof MethodDeclaration && !(m instanceof ConstructorDeclaration)) {
                result.add((MethodDeclaration)m);
            }
            ++i;
        }
        if (td instanceof EnumDeclaration) {
            List<ImplicitEnumMethod> rl = this.serviceConfiguration.getImplicitElementInfo().getImplicitEnumMethods((EnumDeclaration)td);
            result.add(rl.get(0));
            result.add(rl.get(1));
        }
        result.trimToSize();
        return result;
    }

    @Override
    public List<Constructor> getConstructors(TypeDeclaration td) {
        Debug.assertNonnull(td);
        this.updateModel();
        ArrayList<Constructor> result = new ArrayList<Constructor>();
        ASTList<MemberDeclaration> members = td.getMembers();
        int s = members == null ? 0 : members.size();
        int i = 0;
        while (i < s) {
            MemberDeclaration m = (MemberDeclaration)members.get(i);
            if (m instanceof ConstructorDeclaration) {
                result.add((ConstructorDeclaration)m);
            }
            ++i;
        }
        if (result.isEmpty() && !td.isInterface() && td.getName() != null) {
            result.add(this.serviceConfiguration.getImplicitElementInfo().getDefaultConstructor(td));
        }
        result.trimToSize();
        return result;
    }

    @Override
    public Package getPackage(PackageReference pr) {
        Package res = (Package)this.reference2element.get(pr);
        if (res != null) {
            return res;
        }
        res = this.getNameInfo().createPackage(Naming.toPathName(pr));
        if (res != null) {
            this.reference2element.put(pr, res);
        }
        return res;
    }

    @Override
    public Package getPackage(ProgramModelElement pme) {
        Debug.assertNonnull(pme);
        this.updateModel();
        Package result = null;
        ProgramElement pe = this.getDeclaration(pme);
        result = pe == null ? pme.getProgramModelInfo().getPackage(pme) : this.getNameInfo().createPackage(Naming.getPackageName(UnitKit.getCompilationUnit(pe)));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<? extends ClassType> getTypes(ClassTypeContainer ctc) {
        Debug.assertNonnull(ctc);
        this.updateModel();
        decl = this.getDeclaration(ctc);
        if (decl != null) ** GOTO lbl7
        return ctc.getProgramModelInfo().getTypes(ctc);
lbl-1000:
        // 1 sources

        {
            decl = decl.getASTParent();
lbl7:
            // 2 sources

            ** while (decl != null && !(decl instanceof TypeScope))
        }
lbl8:
        // 1 sources

        Debug.assertNonnull((Object)decl, "Internal error - scope inconsistency");
        return ((TypeScope)decl).getTypesInScope();
    }

    @Override
    public ClassTypeContainer getClassTypeContainer(ClassType ct) {
        Debug.assertNonnull(ct);
        TypeDeclaration td = this.getTypeDeclaration(ct);
        if (td == null) {
            return ct.getProgramModelInfo().getClassTypeContainer(ct);
        }
        NonTerminalProgramElement cur = td;
        NonTerminalProgramElement par = cur.getASTParent();
        while (par != null) {
            cur = par;
            if (cur instanceof ClassTypeContainer) {
                return (ClassTypeContainer)((Object)cur);
            }
            par = cur.getASTParent();
        }
        return this.getNameInfo().createPackage(Naming.getPackageName((CompilationUnit)cur));
    }

    List<ClassType> getTypeList(List<TypeReference> trl) {
        this.updateModel();
        int s = trl != null ? trl.size() : 0;
        ArrayList<ClassType> result = new ArrayList<ClassType>(s);
        int i = 0;
        while (i < s) {
            result.add((ClassType)this.getType(trl.get(i)));
            ++i;
        }
        return result;
    }

    List<ClassType> getTypeListFromTypeArgs(List<TypeArgumentDeclaration> targs) {
        this.updateModel();
        ArrayList<ClassType> res = new ArrayList<ClassType>(targs.size());
        for (TypeArgumentDeclaration tad : targs) {
            if (tad.getWildcardMode() != TypeArgument.WildcardMode.None) {
                throw new RuntimeException();
            }
            res.add((ClassType)this.getType(tad.getTypeReference()));
        }
        return res;
    }

    void addToTypeList(ArrayList<ClassType> result, List<TypeReference> trl) {
        int s = trl != null ? trl.size() : 0;
        result.ensureCapacity(result.size() + s);
        int i = 0;
        while (i < s) {
            TypeReference tr = trl.get(i);
            if (tr != null) {
                ClassType ct = (ClassType)this.getType(tr);
                if (ct == null) {
                    this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Unable to resolve %c \"%s\" @%p in %f", tr), tr));
                    ct = this.getNameInfo().getUnknownClassType();
                }
                result.add(ct);
            }
            ++i;
        }
    }

    @Override
    public List<ClassType> getSupertypes(ClassType ct) {
        Debug.assertNonnull(ct);
        this.updateModel();
        TypeDeclaration td = this.getTypeDeclaration(ct);
        if (td == null) {
            return ct.getProgramModelInfo().getSupertypes(ct);
        }
        DefaultProgramModelInfo.ClassTypeCacheEntry ctce = (DefaultProgramModelInfo.ClassTypeCacheEntry)this.classTypeCache.get(ct);
        if (ctce == null) {
            ctce = new DefaultProgramModelInfo.ClassTypeCacheEntry();
            this.classTypeCache.put(ct, ctce);
        } else if (ctce.supertypes != null) {
            return new ArrayList<ClassType>(ctce.supertypes);
        }
        ArrayList<ClassType> res = new ArrayList<ClassType>();
        if (td instanceof EnumDeclaration) {
            res.add(this.getNameInfo().getJavaLangEnum());
            Implements imp = ((EnumDeclaration)td).getImplementedTypes();
            if (imp != null) {
                this.addToTypeList(res, imp.getSupertypes());
            }
        } else if (td instanceof AnnotationDeclaration) {
            res.add(this.getNameInfo().getJavaLangAnnotationAnnotation());
            res.add(this.getNameInfo().getJavaLangObject());
        } else if (td instanceof InterfaceDeclaration) {
            InterfaceDeclaration id = (InterfaceDeclaration)td;
            Extends ext = id.getExtendedTypes();
            if (ext != null) {
                this.addToTypeList(res, ext.getSupertypes());
            }
            res.add(this.getNameInfo().getJavaLangObject());
        } else if (td instanceof TypeParameterDeclaration) {
            TypeParameterDeclaration tp = (TypeParameterDeclaration)td;
            if (tp.getBounds() == null || tp.getBounds().size() == 0) {
                res.add(this.getNameInfo().getJavaLangObject());
            } else {
                for (TypeReference tr : tp.getBounds()) {
                    res.add((ClassType)this.getType(tr));
                }
            }
        } else {
            ClassDeclaration cd = (ClassDeclaration)td;
            assert (cd.getClass() == ClassDeclaration.class);
            ClassType jlo = this.getNameInfo().getJavaLangObject();
            TypeDeclarationContainer con = cd.getParent();
            if (con instanceof New) {
                TypeReference tr = ((New)con).getTypeReference();
                ClassType newType = (ClassType)this.getType(tr);
                if (newType.isInterface()) {
                    res.add(jlo);
                }
                res.add(newType);
            } else if (con instanceof EnumConstructorReference) {
                EnumDeclaration ed = (EnumDeclaration)con.getASTParent().getASTParent().getASTParent();
                res.add(ed);
            } else {
                Implements imp;
                Extends ext = cd.getExtendedTypes();
                if (ext == null || ext.getSupertypes().size() == 0) {
                    if (cd != jlo) {
                        res.add(this.getNameInfo().getJavaLangObject());
                    }
                } else {
                    this.addToTypeList(res, ext.getSupertypes());
                }
                if ((imp = cd.getImplementedTypes()) != null) {
                    this.addToTypeList(res, imp.getSupertypes());
                }
            }
        }
        ctce.supertypes = res;
        return new ArrayList<ClassType>(res);
    }

    @Override
    public List<? extends Field> getFields(ClassType ct) {
        Debug.assertNonnull(ct);
        this.updateModel();
        List<Field> result = null;
        TypeDeclaration td = this.getTypeDeclaration(ct);
        result = td == null ? ct.getProgramModelInfo().getFields(ct) : this.getFields(td);
        return result;
    }

    @Override
    public List<Method> getMethods(ClassType ct) {
        Debug.assertNonnull(ct);
        this.updateModel();
        List<Method> result = null;
        TypeDeclaration td = this.getTypeDeclaration(ct);
        result = td == null ? ct.getProgramModelInfo().getMethods(ct) : this.getMethods(td);
        return result;
    }

    @Override
    public List<? extends Constructor> getConstructors(ClassType ct) {
        Debug.assertNonnull(ct);
        this.updateModel();
        List<Constructor> result = null;
        TypeDeclaration td = this.getTypeDeclaration(ct);
        result = td == null ? ct.getProgramModelInfo().getConstructors(ct) : this.getConstructors(td);
        return result;
    }

    @Override
    public List<Type> getSignature(Method m) {
        Debug.assertNonnull(m);
        this.updateModel();
        MethodDeclaration md = this.getMethodDeclaration(m);
        if (md == null) {
            return m.getProgramModelInfo().getSignature(m);
        }
        List<Type> res = this.sigCache.get(md);
        if (res != null) {
            return new ArrayList<Type>(res);
        }
        ASTList<ParameterDeclaration> pdl = md.getParameters();
        int params = pdl == null ? 0 : pdl.size();
        res = new ArrayList<Type>(params);
        int i = 0;
        while (i < params) {
            Type ptype = this.getType(((ParameterDeclaration)pdl.get(i)).getVariables().get(0));
            res.add(ptype);
            ++i;
        }
        this.sigCache.put(md, res);
        return new ArrayList<Type>(res);
    }

    @Override
    public List<ClassType> getExceptions(Method m) {
        Debug.assertNonnull(m);
        this.updateModel();
        List<ClassType> result = Collections.emptyList();
        MethodDeclaration md = this.getMethodDeclaration(m);
        if (md == null) {
            result = m.getProgramModelInfo().getExceptions(m);
        } else {
            Throws t = md.getThrown();
            if (t != null) {
                result = this.getTypeList(t.getExceptions());
            }
        }
        return result;
    }

    @Override
    public Type getReturnType(Method m) {
        Debug.assertNonnull(m);
        this.updateModel();
        Type result = null;
        MethodDeclaration md = this.getMethodDeclaration(m);
        if (md == null) {
            result = m.getProgramModelInfo().getReturnType(m);
        } else {
            TypeReference tr = md.getTypeReference();
            if (tr != null && !"void".equals(tr.getName())) {
                result = this.getType(tr);
            }
        }
        return result;
    }

    @Override
    public Type getAnnotationType(AnnotationUseSpecification au) {
        Debug.assertNonnull(au);
        this.updateModel();
        Type result = null;
        TypeReference tr = au.getTypeReference();
        if (tr != null) {
            result = this.getType(tr);
        }
        return result;
    }

    @Override
    public Reference resolveURQ(UncollatedReferenceQualifier urq) {
        NonTerminalProgramElement parent = urq.getASTParent();
        return this.resolveURQ(urq, !(parent instanceof TypeReference) && !(parent instanceof PackageReference));
    }

    protected Reference resolveURQ(UncollatedReferenceQualifier urq, boolean allowVariables) {
        String fullname;
        Debug.assertNonnull(urq);
        ReferencePrefix rp = urq.getReferencePrefix();
        if (rp instanceof UncollatedReferenceQualifier) {
            rp = (ReferencePrefix)((Object)this.resolveURQ((UncollatedReferenceQualifier)rp, allowVariables));
        }
        this.updateModel();
        JavaNonTerminalProgramElement result = null;
        NameInfo ni = this.getNameInfo();
        NonTerminalProgramElement parent = urq.getASTParent();
        String urqName = urq.getName();
        if (rp == null) {
            Variable v;
            if (allowVariables && (v = this.getVariable(urqName, urq)) != null) {
                result = v instanceof Field ? urq.toFieldReference() : urq.toVariableReference();
                this.reference2element.put((Reference)((Object)result), v);
            }
            if (result == null) {
                Package pkg = ni.getPackage(urqName);
                if (pkg != null) {
                    result = urq.toPackageReference();
                    this.reference2element.put((Reference)((Object)result), pkg);
                } else {
                    Type t = this.getType(urqName, urq);
                    if (t != null) {
                        result = urq.toTypeReference();
                        t = urq.getTypeArguments() != null && urq.getTypeArguments().size() > 0 ? this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType((ClassType)t, urq.getTypeArguments()) : this.checkEraseRequired((TypeReference)result, t);
                        this.reference2element.put((Reference)((Object)result), t);
                    } else {
                        if (this.resolveURQaggressively(urq)) {
                            return this.resolveURQ(urq, allowVariables);
                        }
                        if (urqName.charAt(0) >= 'A' && urqName.charAt(0) <= 'Z') {
                            result = urq.toTypeReference();
                            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (07b)", urq), urq));
                        } else {
                            try {
                                result = urq.toPackageReference();
                            }
                            catch (ClassCastException cce) {
                                this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (07)", urq), urq));
                                result = urq.toTypeReference();
                            }
                        }
                    }
                }
            }
        } else if (rp instanceof ThisReference) {
            TypeScope thisScope;
            ReferencePrefix rpp = ((ThisReference)rp).getReferencePrefix();
            if (rpp == null) {
                thisScope = (TypeScope)((Object)this.getContainingClassType(urq));
            } else {
                TypeReference tr = rpp instanceof TypeReference ? (TypeReference)rpp : (TypeReference)this.resolveURQ((UncollatedReferenceQualifier)rpp, false);
                Type type = this.getType(tr);
                if (type instanceof ErasedType) {
                    type = ((ErasedType)type).getGenericType();
                }
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getGenericType();
                }
                thisScope = (TypeDeclaration)type;
            }
            Variable v = this.getVariable(urqName, thisScope);
            if (v != null) {
                result = urq.toFieldReference();
                this.reference2element.put((Reference)((Object)result), v);
            } else {
                Type refT = thisScope.getTypeInScope(urqName);
                if (refT != null) {
                    result = urq.toTypeReference();
                    refT = this.checkEraseRequired((TypeReference)result, refT);
                    this.reference2element.put((Reference)((Object)result), refT);
                }
            }
        } else if (rp instanceof SuperReference) {
            ClassType superType = (ClassType)this.getType(rp);
            Field f = this.getInheritedField(urq.getName(), superType);
            if (f != null) {
                result = urq.toFieldReference();
                this.reference2element.put((Reference)((Object)result), f);
            } else {
                fullname = Naming.getFullName(superType, urq.getName());
                ClassType ct = ni.getClassType(fullname);
                if (ct != null) {
                    result = urq.toTypeReference();
                    ct = (ClassType)this.checkEraseRequired((TypeReference)result, ct);
                    this.reference2element.put((Reference)((Object)result), ct);
                }
            }
        } else if (rp instanceof PackageReference) {
            String fullRefName = Naming.toPathName(urq);
            Package pkg = ni.getPackage(fullRefName);
            if (pkg != null) {
                result = urq.toPackageReference();
                this.reference2element.put((Reference)((Object)result), pkg);
            } else {
                Type t = ni.getClassType(fullRefName);
                if (t != null) {
                    result = urq.toTypeReference();
                    t = this.checkEraseRequired((TypeReference)result, t);
                    this.reference2element.put((Reference)((Object)result), t);
                } else {
                    result = urq.getReferenceSuffix() instanceof MethodReference || allowVariables && urq.getReferenceSuffix() instanceof FieldReference ? urq.toTypeReference() : urq.toPackageReference();
                }
            }
        } else if (rp instanceof TypeReference || rp instanceof Expression) {
            Type refT = this.getType(rp);
            if (refT instanceof ClassType) {
                Field f;
                ClassType ct = (ClassType)refT;
                if (allowVariables && (f = this.getInheritedField(urq.getName(), ct)) != null) {
                    result = urq.toFieldReference();
                    this.reference2element.put((Reference)((Object)result), f);
                }
                if (result == null) {
                    fullname = Naming.getFullName((ClassType)refT, urq.getName());
                    ClassType innerType = ni.getClassType(fullname);
                    if (this.getInheritedType(urq.getName(), (ClassType)refT) != null) {
                        result = urq.toTypeReference();
                        innerType = (ClassType)this.checkEraseRequired((TypeReference)result, innerType);
                        this.reference2element.put((Reference)((Object)result), innerType);
                    }
                }
            } else {
                this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (09)", rp), rp));
                result = urq;
            }
        } else {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (10)", rp), rp));
            result = urq;
        }
        if (result == null) {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (11)", urq), urq));
            result = urq;
        } else if (result != urq) {
            block49: {
                try {
                    parent.replaceChild(urq, result);
                }
                catch (ClassCastException cce) {
                    boolean throwAgain = true;
                    if (!(result instanceof Expression) && result instanceof PackageReference) {
                        PackageReference pr = (PackageReference)result;
                        ProgramFactory pf = result.getFactory();
                        Package pack = pf.getServiceConfiguration().getNameInfo().getPackage(pr.toSource());
                        if (pack == null) {
                            PackageReference pkgToBeReplacedByType = pr.getPackageReference();
                            PackageReference newPr = null;
                            TypeReference typeRef = null;
                            if (pkgToBeReplacedByType != null) {
                                newPr = pr.getPackageReference().getPackageReference();
                                typeRef = pf.createTypeReference(newPr, pkgToBeReplacedByType.getIdentifier());
                            }
                            result = pf.createFieldReference(typeRef, pr.getIdentifier());
                            result.setStartPosition(pr.getStartPosition());
                            result.setEndPosition(pr.getEndPosition());
                            result.setRelativePosition(pr.getRelativePosition());
                            result.setComments(pr.getComments());
                            throwAgain = false;
                            parent.replaceChild(urq, result);
                        }
                    }
                    if (!throwAgain) break block49;
                    throw cce;
                }
            }
            Debug.assertBoolean(parent == result.getASTParent());
        }
        return result;
    }

    private boolean resolveURQaggressively(UncollatedReferenceQualifier urq) {
        ReferenceSuffix suf = urq.getReferenceSuffix();
        NameInfo ni = this.getNameInfo();
        while (suf instanceof TypeReferenceInfix) {
            ClassType ct = ni.getClassType(Naming.toPathName((TypeReferenceInfix)suf));
            if (ct != null) {
                while (ct instanceof ArrayType) {
                    ct = (ClassType)((ArrayType)ct).getBaseType();
                }
                String pkg = ct.getPackage().getFullName();
                while (true) {
                    this.getNameInfo().createPackage(pkg);
                    int idx = pkg.lastIndexOf(46);
                    if (idx == -1) break;
                    pkg = pkg.substring(0, idx);
                }
                return true;
            }
            suf = ((TypeReferenceInfix)suf).getReferenceSuffix();
        }
        return false;
    }

    private static VariableScope findOuterVariableScope(VariableScope ts) {
        NonTerminalProgramElement pe = ts.getASTParent();
        while (pe != null && !(pe instanceof VariableScope)) {
            pe = pe.getASTParent();
        }
        return (VariableScope)pe;
    }

    @Override
    public List<Statement> getSucceedingStatements(Statement s) {
        ArrayList<Statement> list;
        block56: {
            block55: {
                list = new ArrayList<Statement>();
                if (!(s instanceof LoopStatement)) break block55;
                LoopStatement loop = (LoopStatement)s;
                switch (this.getBooleanStatus(loop.getGuard())) {
                    case 1: {
                        if (loop.getBody() != null) {
                            list.add(loop.getBody());
                            break;
                        }
                        break block56;
                    }
                    case 0: {
                        if (loop.isCheckedBeforeIteration()) {
                            DefaultSourceInfo.addSequentialFollower(s, list);
                            break;
                        }
                        if (loop.getBody() != null) {
                            list.add(loop.getBody());
                        }
                        DefaultSourceInfo.addSequentialFollower(s, list);
                        break;
                    }
                    case -1: {
                        if (loop.getBody() != null) {
                            list.add(loop.getBody());
                        }
                        DefaultSourceInfo.addSequentialFollower(s, list);
                    }
                }
                break block56;
            }
            if (s instanceof LabeledStatement) {
                list.add(((LabeledStatement)s).getBody());
            } else if (s instanceof StatementBlock) {
                ASTList<Statement> slist = ((StatementBlock)s).getBody();
                if (slist == null || slist.isEmpty()) {
                    DefaultSourceInfo.addSequentialFollower(s, list);
                } else {
                    list.add((Statement)slist.get(0));
                }
            } else if (s instanceof SynchronizedBlock) {
                ASTList<Statement> slist = ((SynchronizedBlock)s).getBody().getBody();
                if (slist == null || slist.isEmpty()) {
                    DefaultSourceInfo.addSequentialFollower(s, list);
                } else {
                    list.add((Statement)slist.get(0));
                }
            } else if (s instanceof If) {
                If ifstmt = (If)s;
                if (ifstmt.getElse() != null) {
                    list.add(ifstmt.getThen().getBody());
                    list.add(ifstmt.getElse().getBody());
                } else {
                    list.add(ifstmt.getThen().getBody());
                    DefaultSourceInfo.addSequentialFollower(s, list);
                }
            } else if (s instanceof Switch) {
                ASTList<Branch> branches = ((Switch)s).getBranchList();
                if (branches == null || branches.isEmpty()) {
                    DefaultSourceInfo.addSequentialFollower(s, list);
                } else {
                    boolean hasDefault = false;
                    int i = 0;
                    int c = branches.size();
                    while (i < c) {
                        Branch b = (Branch)branches.get(i);
                        ASTList<Statement> stats = null;
                        if (b instanceof Default) {
                            stats = ((Default)b).getBody();
                            if (i < c - 1 || stats != null && !stats.isEmpty()) {
                                hasDefault = true;
                            }
                        } else if (b instanceof Case) {
                            stats = ((Case)b).getBody();
                        }
                        if (stats != null && !stats.isEmpty()) {
                            list.add((Statement)stats.get(0));
                        }
                        ++i;
                    }
                    if (!hasDefault) {
                        DefaultSourceInfo.addSequentialFollower(s, list);
                    }
                }
            } else if (s instanceof Try) {
                list.add(((Try)s).getBody());
                ASTList<Branch> branches = ((Try)s).getBranchList();
                if (branches == null || branches.isEmpty()) {
                    DefaultSourceInfo.addSequentialFollower(s, list);
                    return list;
                }
                int i = 0;
                while (i < branches.size()) {
                    Branch b = (Branch)branches.get(i);
                    if (b instanceof Catch) {
                        Catch ca = (Catch)b;
                        boolean newException = true;
                        if (i > 0) {
                            ClassType ex = (ClassType)this.getType(ca.getParameterDeclaration().getTypeReference());
                            int j = i - 1;
                            while (j >= 0) {
                                ClassType dx;
                                if (branches.get(j) instanceof Catch && this.isSubtype(ex, dx = (ClassType)this.getType(((Catch)branches.get(j)).getParameterDeclaration().getTypeReference()))) {
                                    newException = false;
                                    break;
                                }
                                --j;
                            }
                        }
                        if (newException) {
                            list.add(ca.getBody());
                        }
                    } else if (b instanceof Finally) {
                        list.add(((Finally)b).getBody());
                    }
                    ++i;
                }
                DefaultSourceInfo.addSequentialFollower(s, list);
            } else if (s instanceof ExpressionJumpStatement) {
                list.add(METHOD_EXIT);
            } else if (s instanceof Break) {
                if (((Break)s).getIdentifier() == null) {
                    DefaultSourceInfo.addSequentialFollower(DefaultSourceInfo.findInnermostBreakBlock(s), list);
                } else {
                    DefaultSourceInfo.addSequentialFollower(StatementKit.getCorrespondingLabel((Break)s), list);
                }
            } else if (s instanceof Continue) {
                if (((Continue)s).getIdentifier() == null) {
                    list.add(DefaultSourceInfo.findInnermostLoop(s));
                } else {
                    list.add(StatementKit.getCorrespondingLabel((Continue)s).getBody());
                }
            } else {
                DefaultSourceInfo.addSequentialFollower(s, list);
            }
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    private static void addSequentialFollower(Statement s, List<Statement> list) {
        Debug.assertNonnull(s);
        parent = s.getStatementContainer();
        while (true) {
            c = parent.getStatementCount();
            p = 0;
            while (parent.getStatementAt(p) != s) {
                ++p;
            }
            if (p < c - 1) {
                list.add(parent.getStatementAt(p + 1));
                break;
            }
            if (parent instanceof MemberDeclaration) {
                list.add(DefaultSourceInfo.METHOD_EXIT);
                break;
            }
            if (!(parent instanceof Statement)) ** GOTO lbl28
            if (parent instanceof LoopStatement) {
                loop = (LoopStatement)parent;
                list.add(loop);
                return;
            }
            s = (Statement)parent;
            parent = ((Statement)parent).getStatementContainer();
            continue;
lbl-1000:
            // 1 sources

            {
                s = ((Branch)parent).getParent();
                parent = s.getStatementContainer();
lbl28:
                // 2 sources

                ** while (parent instanceof Branch)
            }
lbl29:
            // 1 sources

        }
    }

    private int getBooleanStatus(Expression expr) {
        if (expr == null) {
            return 1;
        }
        ConstantEvaluator.EvaluationResult evr = new ConstantEvaluator.EvaluationResult();
        if (this.serviceConfiguration.getConstantEvaluator().isCompileTimeConstant(expr, evr)) {
            return evr.getBoolean() ? 1 : 0;
        }
        return -1;
    }

    private static Statement findInnermostBreakBlock(Statement s) {
        NonTerminalProgramElement parent = s.getStatementContainer();
        while (parent != null && !(parent instanceof MemberDeclaration)) {
            if (parent instanceof LoopStatement || parent instanceof Switch) {
                return (Statement)((Object)parent);
            }
            parent = parent.getASTParent();
        }
        return null;
    }

    private static LoopStatement findInnermostLoop(Statement s) {
        NonTerminalProgramElement parent = s.getStatementContainer();
        while (parent != null && !(parent instanceof MemberDeclaration)) {
            if (parent instanceof LoopStatement) {
                return (LoopStatement)parent;
            }
            parent = parent.getASTParent();
        }
        return null;
    }

    @Override
    public void register(ProgramElement pe) {
        Debug.assertNonnull(pe);
        if (pe instanceof CompilationUnit) {
            if (!((CompilationUnit)pe).isDefinedScope()) {
                this.analyzeProgramElement(pe);
            }
        } else {
            Debug.assertNonnull(pe.getASTParent());
            this.analyzeProgramElement(pe);
        }
    }

    private void analyzeProgramElement(ProgramElement pe) {
        Debug.assertNonnull(pe);
        if (pe instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)pe;
            String packageName = Naming.getPackageName(cu);
            this.getNameInfo().createPackage(packageName);
        }
        this.analyzeProgramElement0(pe);
    }

    private void analyzeProgramElement0(ProgramElement pe) {
        this.worklist.add(pe);
        while (!this.worklist.isEmpty()) {
            ProgramModelElement dup;
            pe = this.worklist.removeLast();
            if (pe instanceof TerminalProgramElement) continue;
            if (pe instanceof ScopeDefiningElement) {
                ((ScopeDefiningElement)pe).setDefinedScope(true);
                if (pe instanceof MethodDeclaration) {
                    ((MethodDeclaration)pe).setProgramModelInfo(this);
                } else if (pe instanceof TypeDeclaration) {
                    TypeDeclaration td = (TypeDeclaration)pe;
                    td.setProgramModelInfo(this);
                    String typename = td.getName();
                    if (typename != null) {
                        NonTerminalProgramElement parent = pe.getASTParent();
                        while (!(parent instanceof TypeScope)) {
                            parent = parent.getASTParent();
                        }
                        TypeScope scope = (TypeScope)parent;
                        dup = scope.getTypeInScope(typename);
                        if (dup != null && dup != td) {
                            this.getErrorHandler().reportError(new AmbiguousDeclarationException("Duplicate declaration of " + Format.toString("%c \"%N\" @%p in %f", td) + " - was " + Format.toString("%c \"%N\" @%p in %f", dup), td, dup));
                        }
                        scope.addTypeToScope(td, typename);
                        this.getNameInfo().register(td);
                    }
                }
            } else if (pe instanceof VariableSpecification) {
                VariableSpecification vs = (VariableSpecification)pe;
                vs.setProgramModelInfo(this);
                NonTerminalProgramElement parent = vs.getASTParent().getASTParent();
                while (!(parent instanceof VariableScope)) {
                    parent = parent.getASTParent();
                }
                VariableScope scope = (VariableScope)parent;
                String vname = vs.getName();
                dup = scope.getVariableInScope(vname);
                if (dup != null && dup != vs) {
                    this.getErrorHandler().reportError(new AmbiguousDeclarationException("Duplicate declaration of " + Format.toString("%c \"%N\" @%p in %f", vs) + " - was " + Format.toString("%c \"%N\" @%p in %f", dup), vs, dup));
                }
                if (!(scope instanceof TypeDeclaration)) {
                    VariableScope outer = DefaultSourceInfo.findOuterVariableScope(scope);
                    while (!(outer instanceof TypeDeclaration)) {
                        dup = outer.getVariableInScope(vname);
                        if (dup != null && this.isDefinedBefore((VariableSpecification)dup, vs)) {
                            this.getErrorHandler().reportError(new AmbiguousDeclarationException("Hidden local declaration: " + Format.toString("%c \"%N\" @%p in %f", vs) + " - hides " + Format.toString("%c \"%N\" @%p in %f", dup), vs, dup));
                        }
                        outer = DefaultSourceInfo.findOuterVariableScope(outer);
                    }
                }
                scope.addVariableToScope(vs);
                if (vs instanceof FieldSpecification) {
                    this.getNameInfo().register((Field)((Object)vs));
                }
            }
            NonTerminalProgramElement cont = (NonTerminalProgramElement)pe;
            int childCount = cont.getChildCount();
            int i = childCount - 1;
            while (i >= 0) {
                this.worklist.add(cont.getChildAt(i));
                --i;
            }
        }
    }

    private boolean isDefinedBefore(VariableSpecification before, VariableSpecification after) {
        int idxAfter;
        NonTerminalProgramElement hackk = before;
        NonTerminalProgramElement parent = before.getASTParent();
        while (!(parent instanceof VariableScope)) {
            hackk = parent;
            parent = parent.getASTParent();
        }
        NonTerminalProgramElement afterP = after.getASTParent();
        while (afterP != null && afterP.getASTParent() != parent) {
            afterP = afterP.getASTParent();
        }
        if (afterP == null) {
            return true;
        }
        int idxBefore = parent.getIndexOfChild(hackk);
        return idxBefore < (idxAfter = parent.getIndexOfChild(afterP));
    }

    void unregister(TypeDeclaration td) {
        this.unregister(td, td.getName());
    }

    void unregister(TypeDeclaration td, String shortname) {
        List<ClassType> superTypes;
        if (shortname != null) {
            ((TypeScope)td.getASTParent()).removeTypeFromScope(shortname);
        }
        this.getNameInfo().unregisterClassType(td.getFullName());
        DefaultProgramModelInfo.ClassTypeCacheEntry ctce = (DefaultProgramModelInfo.ClassTypeCacheEntry)this.classTypeCache.get(td);
        if (ctce != null && (superTypes = ctce.supertypes) != null) {
            int i = superTypes.size() - 1;
            while (i >= 0) {
                this.removeSubtype(td, superTypes.get(i));
                --i;
            }
        }
    }

    void unregister(VariableSpecification vs) {
        this.unregister(vs, vs.getName());
    }

    void unregister(VariableSpecification vs, String shortname) {
        NonTerminalProgramElement pe = vs.getASTParent().getASTParent();
        while (!(pe instanceof VariableScope)) {
            pe = pe.getASTParent();
        }
        ((VariableScope)pe).removeVariableFromScope(shortname);
        if (vs instanceof FieldSpecification) {
            ClassType ct = ((Field)((Object)vs)).getContainingClassType();
            this.getNameInfo().unregisterField(Naming.getFullName(ct, shortname));
        }
    }

    void unregister(ProgramElement pe) {
        Debug.assertNonnull(pe);
        if (pe instanceof TypeDeclaration) {
            this.unregister((TypeDeclaration)pe);
        } else if (pe instanceof VariableSpecification) {
            this.unregister((VariableSpecification)pe);
        } else if (pe instanceof VariableDeclaration) {
            List<? extends VariableSpecification> vspecs = ((VariableDeclaration)pe).getVariables();
            int i = vspecs.size() - 1;
            while (i >= 0) {
                this.unregister(vspecs.get(i));
                --i;
            }
        }
        TreeWalker tw = new TreeWalker(pe);
        while (tw.next()) {
            pe = tw.getProgramElement();
            if (!(pe instanceof ScopeDefiningElement)) continue;
            this.flushScopes((ScopeDefiningElement)pe);
        }
    }

    void flushScopes(ScopeDefiningElement sde) {
        int j;
        DefaultNameInfo dni = (DefaultNameInfo)this.getNameInfo();
        if (sde instanceof TypeScope) {
            List<? extends ClassType> ctl = ((TypeScope)sde).getTypesInScope();
            if (sde instanceof CompilationUnit) {
                j = ctl.size() - 1;
                while (j >= 0) {
                    ClassType ct = ctl.get(j);
                    if (ct instanceof TypeDeclaration && ((TypeDeclaration)ct).getASTParent() == sde) {
                        dni.unregisterClassType(ct.getFullName());
                    }
                    --j;
                }
            } else {
                j = ctl.size() - 1;
                while (j >= 0) {
                    dni.unregisterClassType(ctl.get(j).getFullName());
                    --j;
                }
            }
        }
        if (sde instanceof TypeDeclaration) {
            List<FieldSpecification> fl = ((TypeDeclaration)sde).getFieldsInScope();
            j = fl.size() - 1;
            while (j >= 0) {
                dni.unregisterField(fl.get(j).getFullName());
                --j;
            }
        }
        sde.setDefinedScope(false);
    }

    @Override
    public void reset() {
        super.reset();
        this.reference2element.clear();
        this.sigCache.clear();
        SourceFileRepository sfr = this.serviceConfiguration.getSourceFileRepository();
        List<CompilationUnit> cul = sfr.getCompilationUnits();
        DefaultNameInfo dni = (DefaultNameInfo)this.getNameInfo();
        dni.paramTypesCache.clear();
        ((DefaultImplicitElementInfo)this.serviceConfiguration.getImplicitElementInfo()).reset();
        dni.reregisterPackages();
        for (CompilationUnit cu : cul) {
            this.unregister(cu);
            this.analyzeProgramElement(cu);
        }
    }

    static final class FastWorkList {
        private int size = 0;
        private ProgramElement[] pes = new ProgramElement[1024];

        FastWorkList() {
        }

        void add(ProgramElement pe) {
            int l = this.pes.length;
            if (this.size == l) {
                ProgramElement[] npes = new ProgramElement[l * 2];
                System.arraycopy(this.pes, 0, npes, 0, l);
                this.pes = npes;
            }
            this.pes[this.size++] = pe;
        }

        ProgramElement removeLast() {
            ProgramElement res = this.pes[--this.size];
            this.pes[this.size] = null;
            return res;
        }

        ProgramElement peekLast() {
            return this.pes[this.size - 1];
        }

        boolean isEmpty() {
            return this.size == 0;
        }
    }
}

