/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import recoder.AbstractService;
import recoder.ServiceConfiguration;
import recoder.TuningParameters;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.DummyGetClassMethod;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Field;
import recoder.abstraction.IntersectionType;
import recoder.abstraction.Member;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.bytecode.TypeArgumentInfo;
import recoder.bytecode.TypeParameterInfo;
import recoder.convenience.Naming;
import recoder.java.NonTerminalProgramElement;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.java.expression.operator.New;
import recoder.service.ChangeHistory;
import recoder.service.ClassTypeTopSort;
import recoder.service.CyclicInheritanceException;
import recoder.service.DefaultImplicitElementInfo;
import recoder.service.ErrorHandler;
import recoder.service.NameInfo;
import recoder.service.ProgramModelInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public abstract class DefaultProgramModelInfo
extends AbstractService
implements ProgramModelInfo,
TuningParameters {
    final Map<ClassType, ClassTypeCacheEntry> classTypeCache = new HashMap<ClassType, ClassTypeCacheEntry>(256);
    static final String GETCLASS_NAME = "getClass".intern();

    protected DefaultProgramModelInfo(ServiceConfiguration config) {
        super(config);
    }

    final ChangeHistory getChangeHistory() {
        return this.serviceConfiguration.getChangeHistory();
    }

    ErrorHandler getErrorHandler() {
        return this.serviceConfiguration.getProjectSettings().getErrorHandler();
    }

    final NameInfo getNameInfo() {
        return this.serviceConfiguration.getNameInfo();
    }

    final void updateModel() {
        this.getChangeHistory().updateModel();
    }

    void registerSubtype(ClassType subtype, ClassType supertype) {
        ClassTypeCacheEntry ctce;
        ProgramModelInfo pmi = supertype.getProgramModelInfo();
        if (pmi != this) {
            ((DefaultProgramModelInfo)pmi).registerSubtype(subtype, supertype);
        }
        if ((ctce = this.classTypeCache.get(supertype)) == null) {
            ctce = new ClassTypeCacheEntry();
            this.classTypeCache.put(supertype, ctce);
        }
        if (ctce.subtypes == null) {
            ctce.subtypes = new HashSet<ClassType>();
        }
        ctce.subtypes.add(subtype);
    }

    void removeSubtype(ClassType subtype, ClassType supertype) {
        ClassTypeCacheEntry ctce;
        ProgramModelInfo pmi = supertype.getProgramModelInfo();
        if (pmi != this) {
            ((DefaultProgramModelInfo)pmi).registerSubtype(subtype, supertype);
        }
        if ((ctce = this.classTypeCache.get(supertype)) != null && ctce.subtypes != null) {
            ctce.subtypes.remove(subtype);
        }
    }

    @Override
    public List<ClassType> getSubtypes(ClassType ct) {
        if (ct == null) {
            throw new NullPointerException();
        }
        Debug.assertNonnull(ct);
        this.updateModel();
        ProgramModelInfo pmi = ct.getProgramModelInfo();
        if (pmi != this) {
            Debug.assertNonnull(pmi);
            return pmi.getSubtypes(ct);
        }
        ClassTypeCacheEntry ctce = this.classTypeCache.get(ct);
        if (ctce == null) {
            ctce = new ClassTypeCacheEntry();
            this.classTypeCache.put(ct, ctce);
        }
        if (ctce.subtypes == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ClassType>(ctce.subtypes);
    }

    @Override
    public List<ClassType> getAllSubtypes(ClassType ct) {
        if (ct == null) {
            throw new NullPointerException();
        }
        this.updateModel();
        List<ClassType> ctl = new SubTypeTopSort().getAllTypes(ct);
        ctl.remove(0);
        return ctl;
    }

    @Override
    public List<ClassType> getAllSupertypes(ClassType ct) {
        if (ct == null) {
            throw new NullPointerException();
        }
        this.updateModel();
        ProgramModelInfo pmi = ct.getProgramModelInfo();
        if (pmi != this) {
            Debug.assertNonnull(pmi);
            return pmi.getAllSupertypes(ct);
        }
        ClassTypeCacheEntry ctce = this.classTypeCache.get(ct);
        if (ctce == null) {
            ctce = new ClassTypeCacheEntry();
            this.classTypeCache.put(ct, ctce);
        }
        if (ctce.allSupertypes == null) {
            this.computeAllSupertypes(ct, ctce);
        }
        return new ArrayList<ClassType>(ctce.allSupertypes);
    }

    private void computeAllSupertypes(ClassType ct, ClassTypeCacheEntry ctce) {
        ctce.allSupertypes = new SuperTypeTopSort().getAllTypes(ct);
    }

    @Override
    public List<Field> getAllFields(ClassType ct) {
        this.updateModel();
        ProgramModelInfo pmi = ct.getProgramModelInfo();
        if (pmi != this) {
            Debug.assertNonnull(pmi);
            return pmi.getAllFields(ct);
        }
        ClassTypeCacheEntry ctce = this.classTypeCache.get(ct);
        if (ctce == null) {
            ctce = new ClassTypeCacheEntry();
            this.classTypeCache.put(ct, ctce);
        }
        if (ctce.allFields == null) {
            this.computeAllFields(ct, ctce);
        }
        return new ArrayList<Field>(ctce.allFields);
    }

    private void computeAllFields(ClassType ct, ClassTypeCacheEntry ctce) {
        if (ctce.allSupertypes == null) {
            this.computeAllSupertypes(ct, ctce);
        }
        List<ClassType> classes = ctce.allSupertypes;
        classes = this.removeErasedTypesFromList(classes);
        int s = classes.size();
        ArrayList<Field> result = new ArrayList<Field>(s * 4);
        int result_size = 0;
        int i = 0;
        while (i < s) {
            ClassType c = classes.get(i);
            List<? extends Field> fl = c.getFields();
            if (fl != null) {
                int fs = fl.size();
                int j = 0;
                while (j < fs) {
                    block7: {
                        Field f = fl.get(j);
                        if (this.isVisibleFor(f, ct)) {
                            String fname = f.getName();
                            int k = 0;
                            while (k < result_size) {
                                Field rf = result.get(k);
                                if (rf.getName() != fname) {
                                    ++k;
                                    continue;
                                }
                                break block7;
                            }
                            result.add(f);
                            ++result_size;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        result.trimToSize();
        ctce.allFields = result;
    }

    @Override
    public List<Method> getAllMethods(ClassType ct) {
        this.updateModel();
        ProgramModelInfo pmi = ct.getProgramModelInfo();
        if (pmi != this) {
            Debug.assertNonnull(pmi);
            return pmi.getAllMethods(ct);
        }
        ClassTypeCacheEntry ctce = this.classTypeCache.get(ct);
        if (ctce == null) {
            ctce = new ClassTypeCacheEntry();
            this.classTypeCache.put(ct, ctce);
        }
        if (ctce.allMethods == null) {
            this.computeAllMethods(ct, ctce);
        }
        return new ArrayList<Method>(ctce.allMethods);
    }

    private void computeAllMethods(ClassType ct, ClassTypeCacheEntry ctce) {
        if (ctce.allSupertypes == null) {
            this.computeAllSupertypes(ct, ctce);
        }
        List<ClassType> classes = ctce.allSupertypes;
        classes = this.removeErasedTypesFromList(classes);
        int s = classes.size();
        ArrayList<Method> result = new ArrayList<Method>(s * 8);
        ClassType jlo = this.getNameInfo().getJavaLangObject();
        int result_size = 0;
        int i = 0;
        while (i < s) {
            ClassType c = classes.get(i);
            List<Method> ml = c.getMethods();
            if (ml != null) {
                int ms = ml.size();
                int j = 0;
                while (j < ms) {
                    block9: {
                        Method m = ml.get(j);
                        if (this.isVisibleFor(m, ct)) {
                            String mname;
                            List<Type> msig = m.getSignature();
                            if (c == jlo & (mname = m.getName()) == GETCLASS_NAME && this.java5Allowed()) {
                                result.add(new DummyGetClassMethod(ct, this.getServiceConfiguration().getImplicitElementInfo()));
                                ++result_size;
                            } else {
                                int k = 0;
                                while (k < result_size) {
                                    List<Type> rsig;
                                    Method rm = result.get(k);
                                    if (rm.getName() != mname || !this.signaturesEquals(rsig = rm.getSignature(), msig)) {
                                        ++k;
                                        continue;
                                    }
                                    break block9;
                                }
                                result.add(m);
                                ++result_size;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        result.trimToSize();
        ctce.allMethods = result;
    }

    private boolean signaturesEquals(List<? extends Type> rsig, List<? extends Type> msig) {
        if (rsig.size() != msig.size()) {
            return false;
        }
        int i = 0;
        int s = rsig.size();
        while (i < s) {
            Type t1 = rsig.get(i);
            Type t2 = msig.get(i);
            while (t1 instanceof ArrayType && t2 instanceof ArrayType) {
                t1 = ((ArrayType)t1).getBaseType();
                t2 = ((ArrayType)t2).getBaseType();
            }
            if (t1 instanceof TypeParameter && t2 instanceof TypeParameter ? !TypeParameter.EqualsImplementor.matchButNotEqual((TypeParameter)t1, (TypeParameter)t2) : !t1.equals(t2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public List<ClassType> removeErasedTypesFromList(List<? extends ClassType> classes) {
        ArrayList<ClassType> res = new ArrayList<ClassType>(classes.size());
        int i = 0;
        while (i < classes.size()) {
            block5: {
                ClassType cur = classes.get(i);
                if (!(cur instanceof ErasedType)) {
                    res.add(cur);
                } else {
                    ErasedType et = (ErasedType)cur;
                    ClassType generic = et.getGenericType();
                    int j = 0;
                    while (j < classes.size()) {
                        ClassType xyz;
                        if (i == j || (xyz = classes.get(j)) != generic && (!(xyz instanceof ParameterizedType) || ((ParameterizedType)xyz).getGenericType() != generic)) {
                            ++j;
                            continue;
                        }
                        break block5;
                    }
                    res.add(cur);
                }
            }
            ++i;
        }
        res.trimToSize();
        return res;
    }

    @Override
    public List<ClassType> getAllTypes(ClassType ct) {
        this.updateModel();
        ProgramModelInfo pmi = ct.getProgramModelInfo();
        if (pmi != this) {
            Debug.assertNonnull(pmi);
            return pmi.getAllTypes(ct);
        }
        ClassTypeCacheEntry ctce = this.classTypeCache.get(ct);
        if (ctce == null) {
            ctce = new ClassTypeCacheEntry();
            this.classTypeCache.put(ct, ctce);
        }
        if (ctce.allMemberTypes == null) {
            this.computeAllMemberTypes(ct, ctce);
        }
        return new ArrayList<ClassType>(ctce.allMemberTypes);
    }

    private void computeAllMemberTypes(ClassType ct, ClassTypeCacheEntry ctce) {
        if (ctce.allSupertypes == null) {
            this.computeAllSupertypes(ct, ctce);
        }
        List<ClassType> classes = ctce.allSupertypes;
        HashSet<String> invisibleAndIgnore = new HashSet<String>();
        classes = this.removeErasedTypesFromList(classes);
        int s = classes.size();
        ArrayList<ClassType> result = new ArrayList<ClassType>(s);
        int result_size = 0;
        for (ClassType c : classes) {
            List<? extends ClassType> cl = c.getTypes();
            if (cl == null) continue;
            int cs = cl.size();
            int j = 0;
            while (j < cs) {
                block9: {
                    ClassType hc = cl.get(j);
                    if (hc != ct && this.isVisibleFor(hc, ct)) {
                        String cname = hc.getName();
                        if (!invisibleAndIgnore.contains(cname)) {
                            int k = 0;
                            while (k < result_size) {
                                ClassType rc = result.get(k);
                                if (rc.getName() != cname) {
                                    ++k;
                                    continue;
                                }
                                break block9;
                            }
                            result.add(hc);
                            ++result_size;
                        }
                    } else if (hc != ct) {
                        invisibleAndIgnore.add(hc.getName());
                    }
                }
                ++j;
            }
        }
        result.trimToSize();
        ctce.allMemberTypes = result;
    }

    @Override
    public PrimitiveType getPromotedType(PrimitiveType a, PrimitiveType b) {
        if (a == b) {
            return a;
        }
        NameInfo ni = this.getNameInfo();
        if (a == ni.getBooleanType() || b == ni.getBooleanType()) {
            return null;
        }
        if (a == ni.getDoubleType() || b == ni.getDoubleType()) {
            return ni.getDoubleType();
        }
        if (a == ni.getFloatType() || b == ni.getFloatType()) {
            return ni.getFloatType();
        }
        if (a == ni.getLongType() || b == ni.getLongType()) {
            return ni.getLongType();
        }
        return ni.getIntType();
    }

    @Override
    public boolean isWidening(PrimitiveType from, PrimitiveType to) {
        if (from == null || to == null) {
            return false;
        }
        if (from == to) {
            return true;
        }
        NameInfo ni = this.getNameInfo();
        if (from == ni.getBooleanType() || to == ni.getBooleanType()) {
            return false;
        }
        if (to == ni.getDoubleType()) {
            return true;
        }
        if (from == ni.getDoubleType()) {
            return false;
        }
        if (to == ni.getFloatType()) {
            return true;
        }
        if (from == ni.getFloatType()) {
            return false;
        }
        if (to == ni.getLongType()) {
            return true;
        }
        if (from == ni.getLongType()) {
            return false;
        }
        if (to == ni.getIntType()) {
            return true;
        }
        if (from == ni.getIntType()) {
            return false;
        }
        return from == ni.getByteType() && to == ni.getShortType();
    }

    @Override
    public boolean isWidening(ClassType from, ClassType to) {
        return this.isSubtype(from, to);
    }

    @Override
    public boolean isWidening(ArrayType from, ArrayType to) {
        Type toBase = to.getBaseType();
        if (toBase == this.getNameInfo().getJavaLangObject()) {
            return true;
        }
        Type fromBase = from.getBaseType();
        if (toBase instanceof PrimitiveType) {
            return toBase == fromBase;
        }
        return this.isWidening(fromBase, toBase);
    }

    @Override
    public boolean isWidening(Type from, Type to) {
        if (from instanceof ArrayType && to instanceof ArrayType) {
            return this.isWidening((ArrayType)from, (ArrayType)to);
        }
        if (from instanceof ClassType) {
            if (to instanceof ClassType) {
                return this.isWidening((ClassType)from, (ClassType)to);
            }
        } else if (from instanceof PrimitiveType && to instanceof PrimitiveType) {
            return this.isWidening((PrimitiveType)from, (PrimitiveType)to);
        }
        return false;
    }

    @Override
    public boolean isSubtype(ClassType a, ClassType b) {
        boolean result = false;
        if (b instanceof ErasedType && ((ErasedType)b).getGenericType() == this.getNameInfo().getJavaLangObject()) {
            b = this.getNameInfo().getJavaLangObject();
        }
        if (a instanceof ErasedType && ((ErasedType)a).getGenericType() == b) {
            return true;
        }
        if (b instanceof ErasedType && ((ErasedType)b).getGenericType() == a) {
            return true;
        }
        if (a instanceof ParameterizedType && b instanceof ErasedType && ((ParameterizedType)a).getGenericType() == ((ErasedType)b).getGenericType()) {
            return true;
        }
        if (b instanceof ParameterizedType && a instanceof ErasedType && ((ParameterizedType)b).getGenericType() == ((ErasedType)a).getGenericType()) {
            return true;
        }
        if (a instanceof ParameterizedType && !(b instanceof ParameterizedType) && ((ParameterizedType)a).getGenericType() == b) {
            return true;
        }
        if (b instanceof ParameterizedType && !(a instanceof ParameterizedType) && ((ParameterizedType)b).getGenericType() == a) {
            return true;
        }
        if (a instanceof ParameterizedType && b instanceof ParameterizedType && ((ParameterizedType)a).getGenericType() == ((ParameterizedType)b).getGenericType()) {
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            if (pa.getAllTypeArgs().size() != pb.getAllTypeArgs().size()) {
                System.out.println("??? look into this!");
            } else {
                int i = 0;
                int s = pa.getAllTypeArgs().size();
                while (i < s) {
                    if (!this.paramMatches(this.getCapture(pa.getAllTypeArgs().get(i)), this.getCapture(pb.getAllTypeArgs().get(i)), false)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        if (a instanceof TypeParameter && b instanceof TypeParameter) {
            result = true;
        } else if (a != null && b != null) {
            if (a == b || a == this.getNameInfo().getNullType() || b == this.getNameInfo().getJavaLangObject()) {
                result = true;
            } else {
                List<ClassType> superA = a.getSupertypes();
                if (superA != null) {
                    int s = superA.size();
                    int i = a instanceof ParameterizedType ? 1 : 0;
                    while (i < s && !result) {
                        ClassType sa = superA.get(i);
                        if (sa == a) {
                            this.getErrorHandler().reportError(new CyclicInheritanceException(a));
                        }
                        if (this.isSubtype(sa, b)) {
                            result = true;
                        }
                        ++i;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean isSupertype(ClassType a, ClassType b) {
        return this.isSubtype(b, a);
    }

    private final boolean paramMatches(Type ta, Type tb, boolean allowAutoboxing) {
        TypeParameter tp;
        if (ta == tb) {
            return true;
        }
        if (allowAutoboxing && ta instanceof ErasedType && tb instanceof PrimitiveType) {
            ta = ((ErasedType)ta).getGenericType();
        }
        if (allowAutoboxing && tb instanceof ErasedType && ta instanceof PrimitiveType) {
            tb = ((ErasedType)tb).getGenericType();
        }
        if (ta instanceof TypeArgument.CapturedTypeArgument) {
            ta = this.getBaseType(((TypeArgument.CapturedTypeArgument)ta).getTypeArgument());
        }
        if (tb instanceof TypeArgument.CapturedTypeArgument) {
            tb = this.getBaseType(((TypeArgument.CapturedTypeArgument)tb).getTypeArgument());
        }
        while (ta instanceof ArrayType && tb instanceof ArrayType) {
            ta = ((ArrayType)ta).getBaseType();
            tb = ((ArrayType)tb).getBaseType();
        }
        if (ta instanceof TypeParameter && tb instanceof TypeParameter) {
            TypeParameter tp1 = (TypeParameter)ta;
            TypeParameter tp2 = (TypeParameter)tb;
            if (tp1.getContainer() instanceof Method && tp2.getContainer() instanceof Method) {
                return this.checkBoundsMatch(tp1, tp2);
            }
            if (TypeParameter.EqualsImplementor.matchButNotEqual((TypeParameter)ta, (TypeParameter)tb)) {
                return true;
            }
        }
        if (tb instanceof TypeParameter && ta instanceof ArrayType) {
            tp = (TypeParameter)tb;
            if (tp.getBoundCount() > 1) {
                return false;
            }
            return tp.getBoundName(0).equals("java.lang.Object");
        }
        if (allowAutoboxing && tb instanceof TypeParameter && ta instanceof PrimitiveType) {
            ta = this.getBoxedType((PrimitiveType)ta);
        }
        if (tb instanceof TypeParameter && ta instanceof ClassType) {
            tp = (TypeParameter)tb;
            int i = 0;
            while (i < tp.getBoundCount()) {
                ClassType t = this.getClassTypeFromTypeParameter(tp, i);
                if (t == null) {
                    System.err.println(tp.getBoundName(i));
                    System.err.println("cannot resolve type reference in paramMatches/raw type check... TODO");
                }
                if (!this.isWidening(ta, (Type)t)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (ta != null && !this.isWidening(ta, tb)) {
            if (allowAutoboxing) {
                if (ta instanceof PrimitiveType && this.isWidening((Type)this.getBoxedType((PrimitiveType)ta), tb)) {
                    return true;
                }
                if (!(ta instanceof ClassType)) {
                    return false;
                }
                PrimitiveType unboxedType = this.getUnboxedType((ClassType)ta);
                if (this.isWidening((Type)unboxedType, tb)) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkBoundsMatch(TypeParameter tp1, TypeParameter tp2) {
        ArrayList<ClassType> bounds1 = new ArrayList<ClassType>();
        int i = 0;
        while (i < tp1.getBoundCount()) {
            bounds1.addAll(this.getAllSupertypes(this.getNameInfo().getClassType(tp1.getBoundName(i))));
            ++i;
        }
        i = 0;
        while (i < tp2.getBoundCount()) {
            ClassType ct = this.getNameInfo().getClassType(tp2.getBoundName(i));
            if (!bounds1.contains(ct)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ClassType getClassTypeFromTypeParameter(TypeParameter tp, int i) {
        ClassType t = this.getNameInfo().getClassType(tp.getBoundName(i));
        return t;
    }

    private final boolean internalIsCompatibleSignature(List<Type> a, List<Type> b, boolean allowAutoboxing, boolean isVarArgMethod) {
        int s = b.size();
        int n = a.size();
        if (isVarArgMethod) {
            if (s > n + 1) {
                return false;
            }
            if (s == n) {
                Type tb;
                Type ta = a.get(s - 1);
                if (this.paramMatches(ta, tb = ((ArrayType)b.get(s - 1)).getBaseType(), allowAutoboxing)) {
                    --s;
                }
            } else {
                Type tb = ((ArrayType)b.get(s - 1)).getBaseType();
                int i = s - 1;
                while (i < n) {
                    Type ta = a.get(i);
                    if (!this.paramMatches(ta, tb, allowAutoboxing)) {
                        return false;
                    }
                    ++i;
                }
                --s;
            }
        } else if (s != n) {
            return false;
        }
        int i = 0;
        while (i < s) {
            Type tb;
            Type ta = a.get(i);
            if (!this.paramMatches(ta, tb = b.get(i), allowAutoboxing)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final boolean isCompatibleSignature(List<Type> a, List<Type> b) {
        return this.internalIsCompatibleSignature(a, b, false, false);
    }

    @Override
    public final boolean isCompatibleSignature(List<Type> a, List<Type> b, boolean allowAutoboxing, boolean bIsVariableArityMethod) {
        return this.internalIsCompatibleSignature(a, b, allowAutoboxing, bIsVariableArityMethod);
    }

    @Override
    public ClassType getBoxedType(PrimitiveType unboxedType) {
        NameInfo ni = this.getNameInfo();
        if (unboxedType == ni.getBooleanType()) {
            return ni.getJavaLangBoolean();
        }
        if (unboxedType == ni.getByteType()) {
            return ni.getJavaLangByte();
        }
        if (unboxedType == ni.getCharType()) {
            return ni.getJavaLangCharacter();
        }
        if (unboxedType == ni.getShortType()) {
            return ni.getJavaLangShort();
        }
        if (unboxedType == ni.getIntType()) {
            return ni.getJavaLangInteger();
        }
        if (unboxedType == ni.getLongType()) {
            return ni.getJavaLangLong();
        }
        if (unboxedType == ni.getFloatType()) {
            return ni.getJavaLangFloat();
        }
        if (unboxedType == ni.getDoubleType()) {
            return ni.getJavaLangDouble();
        }
        throw new Error("Unknown primitive type " + unboxedType.getFullName());
    }

    @Override
    public PrimitiveType getUnboxedType(ClassType boxedType) {
        NameInfo ni;
        if (boxedType instanceof ErasedType) {
            boxedType = ((ErasedType)boxedType).getGenericType();
        }
        if (boxedType == (ni = this.getNameInfo()).getJavaLangBoolean()) {
            return ni.getBooleanType();
        }
        if (boxedType == ni.getJavaLangByte()) {
            return ni.getByteType();
        }
        if (boxedType == ni.getJavaLangCharacter()) {
            return ni.getCharType();
        }
        if (boxedType == ni.getJavaLangShort()) {
            return ni.getShortType();
        }
        if (boxedType == ni.getJavaLangInteger()) {
            return ni.getIntType();
        }
        if (boxedType == ni.getJavaLangLong()) {
            return ni.getLongType();
        }
        if (boxedType == ni.getJavaLangFloat()) {
            return ni.getFloatType();
        }
        if (boxedType == ni.getJavaLangDouble()) {
            return ni.getDoubleType();
        }
        return null;
    }

    protected ClassType getOutermostType(ClassType t) {
        ClassTypeContainer c = t;
        ClassTypeContainer cc = t.getContainer();
        while (cc != null && !(cc instanceof Package)) {
            c = cc;
            cc = cc.getContainer();
        }
        return c;
    }

    @Override
    public boolean isVisibleFor(Member m, ClassType t) {
        ClassType mt;
        if (m instanceof ErasedType) {
            m = ((ErasedType)m).getGenericType();
        } else if (m instanceof ParameterizedType) {
            m = ((ParameterizedType)m).getGenericType();
        }
        if (t instanceof ParameterizedType) {
            t = ((ParameterizedType)t).getGenericType();
        } else if (t instanceof ErasedType) {
            t = ((ErasedType)t).getGenericType();
        }
        if (m.isPublic()) {
            return true;
        }
        if (t instanceof IntersectionType) {
            t = ((IntersectionType)t).getAccessibility();
        }
        if ((mt = m.getContainingClassType()) == null) {
            return false;
        }
        if (mt instanceof ParameterizedType) {
            mt = ((ParameterizedType)mt).getGenericType();
        }
        if (mt instanceof ErasedType) {
            mt = ((ErasedType)mt).getGenericType();
        }
        if (mt == t) {
            return true;
        }
        if (m.isPrivate()) {
            return this.getOutermostType(t) == this.getOutermostType(mt);
        }
        if (mt.getPackage() == t.getPackage()) {
            return true;
        }
        return m.isProtected() && this.isSubtype(t, mt);
    }

    @Override
    public void filterApplicableMethods(List<Method> list, String name, List<Type> signature, ClassType context) {
        boolean allowJava5 = this.getServiceConfiguration().getProjectSettings().java5Allowed();
        this.internalFilterApplicableMethods(list, name, signature, context, allowJava5);
    }

    public ClassType getBaseType(TypeArgument ta) {
        if (ta.getWildcardMode() == TypeArgument.WildcardMode.Any) {
            return this.getNameInfo().getJavaLangObject();
        }
        if (ta.getWildcardMode() == TypeArgument.WildcardMode.Super) {
            return this.getNameInfo().getJavaLangObject();
        }
        List<? extends TypeArgument> targs = ta.getTypeArguments();
        if (ta instanceof TypeArgumentInfo) {
            TypeArgumentInfo tai = (TypeArgumentInfo)ta;
            if (tai.isTypeVariable()) {
                String taiName = tai.getTypeName();
                int dim = 0;
                int idx = taiName.indexOf(91);
                int n = dim = idx == -1 ? 0 : (taiName.length() - idx) / 2;
                if (dim > 0) {
                    taiName = taiName.substring(0, idx);
                }
                if (tai.getContainingMethodInfo() != null && tai.getContainingMethodInfo().getTypeParameters() != null) {
                    for (TypeParameterInfo tpi : tai.getContainingMethodInfo().getTypeParameters()) {
                        if (tpi.getName() != taiName) continue;
                        ClassType res = tpi;
                        while (dim-- > 0) {
                            res = res.createArrayType();
                        }
                        return tpi;
                    }
                }
                ClassType container = tai.getContainingClassFile();
                while (true) {
                    for (TypeParameter typeParameter : container.getTypeParameters()) {
                        if (typeParameter.getName() != taiName) continue;
                        ClassType res = typeParameter;
                        while (dim-- > 0) {
                            res = res.createArrayType();
                        }
                        return typeParameter;
                    }
                    if (!container.isInner()) break;
                    container = container.getContainingClassType();
                }
                return this.getNameInfo().getJavaLangObject();
            }
            ClassType ct = this.getNameInfo().getClassType(ta.getTypeName());
            return targs == null || targs.size() == 0 ? ct : this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType(ct, targs);
        }
        if (ta instanceof TypeArgumentDeclaration) {
            ClassType ct;
            TypeDeclaration td;
            List list;
            SourceInfo si = this.getServiceConfiguration().getSourceInfo();
            TypeArgumentDeclaration tad = (TypeArgumentDeclaration)ta;
            NonTerminalProgramElement context = tad;
            context = context.getASTParent();
            while (context.getASTParent() instanceof TypeArgumentDeclaration) {
                context = context.getASTParent();
                context = context.getASTParent();
            }
            String typename = Naming.toPathName(tad.getTypeReferenceAt(0));
            if (context.getASTParent().getASTParent() instanceof TypeDeclaration && typename.indexOf(46) == -1 && !(context.getASTParent() instanceof MethodDeclaration) && (list = (td = (TypeDeclaration)context.getASTParent().getASTParent()).getTypeParameters()) != null) {
                int dim = 0;
                String tp_name = typename;
                while (tp_name.endsWith("[]")) {
                    tp_name = tp_name.substring(0, tp_name.length() - 2);
                    ++dim;
                }
                for (TypeParameterDeclaration tp : list) {
                    if (!tp.getName().equals(tp_name)) continue;
                    ClassType res = tp;
                    while (dim-- > 0) {
                        res = res.createArrayType();
                    }
                    return res;
                }
            }
            if ((ct = (ClassType)si.getType(typename, context)) == null) {
                ct = this.getNameInfo().getUnknownClassType();
            }
            return targs == null || targs.size() == 0 ? ct : this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType(ct, targs);
        }
        if (ta instanceof ResolvedTypeArgument) {
            ResolvedTypeArgument ra = (ResolvedTypeArgument)ta;
            if (ra.typeArgs != null && ra.typeArgs.size() > 0) {
                return this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType(ra.type, ra.typeArgs);
            }
            return ra.type;
        }
        if (ta instanceof WrappedTypeArgument) {
            return ((WrappedTypeArgument)ta).type;
        }
        throw new RuntimeException();
    }

    private void internalFilterApplicableMethods(List<Method> list, String name, List<Type> signature, ClassType context, boolean allowJava5) {
        Debug.assertNonnull(name, signature, context);
        name = name.intern();
        int s = list.size();
        int i = 0;
        while (i < s) {
            List<Type> methodSig;
            Method m = list.get(i);
            if (name != m.getName() || !this.isVisibleFor(m, context) || !this.internalIsCompatibleSignature(signature, methodSig = m.getSignature(), allowJava5, m.isVarArgMethod() & allowJava5)) break;
            ++i;
        }
        if (i < s) {
            int j = i++;
            while (i < s) {
                List<Type> methodSig;
                Method m = list.get(i);
                if (name == m.getName() && this.isVisibleFor(m, context) && this.internalIsCompatibleSignature(signature, methodSig = m.getSignature(), allowJava5, m.isVarArgMethod() & allowJava5)) {
                    list.set(j, m);
                    ++j;
                }
                ++i;
            }
            DefaultProgramModelInfo.removeRange(list, j);
        }
    }

    private static void removeRange(List<?> list, int from) {
        int i = list.size() - 1;
        while (i >= from) {
            list.remove(i);
            --i;
        }
    }

    private static void removeRange(List<?> list, int from, int to) {
        if (from > to) {
            int n = to;
            to ^= from;
            from ^= to;
            to = n ^ from;
        }
        int cnt = to - from;
        while (cnt-- > 0) {
            list.remove(from);
        }
    }

    @Override
    public void filterMostSpecificMethods(List<Method> list) {
        this.internalFilterMostSpecificMethods(list, false, false);
    }

    @Override
    public void filterMostSpecificMethodsPhase2(List<Method> list) {
        this.internalFilterMostSpecificMethods(list, true, false);
    }

    @Override
    public void filterMostSpecificMethodsPhase3(List<Method> list) {
        this.internalFilterMostSpecificMethods(list, true, true);
    }

    private void internalFilterMostSpecificMethods(List<Method> list, boolean allowAutoboxing, boolean allowVarArgs) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        List[] signatures = new List[size];
        signatures[0] = list.get(0).getSignature();
        int i = 1;
        while (i < size) {
            signatures[i] = list.get(i).getSignature();
            List<Type> sig = signatures[i];
            if (sig != null) {
                int j = i - 1;
                while (j >= 0) {
                    List sig2 = signatures[j];
                    if (sig2 != null) {
                        if (this.internalIsCompatibleSignature(sig2, sig, allowAutoboxing, allowVarArgs & list.get(i).isVarArgMethod())) {
                            if (!allowAutoboxing || !this.internalIsCompatibleSignature(sig, sig2, allowAutoboxing, false)) {
                                signatures[i] = null;
                            }
                        } else if (this.internalIsCompatibleSignature(sig, sig2, allowAutoboxing, allowVarArgs & list.get(j).isVarArgMethod())) {
                            signatures[j] = null;
                        }
                    }
                    --j;
                }
            }
            ++i;
        }
        int k = 0;
        int i2 = size - 1;
        while (i2 >= 0) {
            if (signatures[i2] == null) {
                ++k;
            } else if (k > 0) {
                DefaultProgramModelInfo.removeRange(list, i2 + 1, i2 + k + 1);
                k = 0;
            }
            --i2;
        }
        if (k > 0) {
            DefaultProgramModelInfo.removeRange(list, 0, k);
        }
    }

    public List<? extends Constructor> getConstructors(ClassType ct, List<Type> signature, List<TypeArgumentDeclaration> typeArgs) {
        Debug.assertNonnull((Object)ct, signature);
        if (ct.isInterface()) {
            if (signature.isEmpty()) {
                return this.getNameInfo().getJavaLangObject().getConstructors();
            }
            return Collections.emptyList();
        }
        String name = ct.getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        List<Method> meths = this.internalGetMostSpecificMethods(ct, name, signature, ct.getConstructors(), typeArgs);
        ArrayList<Constructor> result = new ArrayList<Constructor>(meths.size());
        int i = 0;
        int s = meths.size();
        while (i < s) {
            result.add((Constructor)meths.get(i));
            ++i;
        }
        return result;
    }

    @Override
    public List<Method> getMethods(ClassType ct, String name, List<Type> signature, List<? extends TypeArgument> typeArgs) {
        return this.internalGetMostSpecificMethods(ct, name, signature, ct.getAllMethods(), typeArgs);
    }

    private List<Method> internalGetMostSpecificMethods(ClassType ct, String name, List<Type> signature, List<? extends Method> meths, List<? extends TypeArgument> typeArgs) {
        ArrayList<Method> result;
        Debug.assertNonnull(ct, name, signature);
        boolean allowJava5 = this.getServiceConfiguration().getProjectSettings().java5Allowed();
        if (allowJava5) {
            result = this.doThreePhaseFilter(meths, signature, name, ct);
        } else {
            result = new ArrayList<Method>(meths);
            this.internalFilterApplicableMethods(result, name, signature, ct, false);
            this.filterMostSpecificMethods(result);
        }
        return result;
    }

    public List<Method> doThreePhaseFilter(List<? extends Method> methods, List<Type> signature, String name, ClassType context) {
        ArrayList<Method> applicableMethods = new ArrayList<Method>(methods.size() + 1);
        applicableMethods.addAll(methods);
        this.internalFilterApplicableMethods(applicableMethods, name, signature, context, true);
        if (applicableMethods.size() < 2) {
            return applicableMethods;
        }
        ArrayList<Method> result = new ArrayList<Method>(applicableMethods.size() + 1);
        result.addAll(applicableMethods);
        this.internalFilterApplicableMethods(result, name, signature, context, false);
        this.filterMostSpecificMethods(result);
        if (result.size() > 0) {
            return result;
        }
        result.addAll(applicableMethods);
        this.filterMostSpecificMethodsPhase2(result);
        if (result.size() == 1) {
            return result;
        }
        result.clear();
        result.addAll(applicableMethods);
        this.filterMostSpecificMethodsPhase3(result);
        return result;
    }

    public void reset() {
        this.classTypeCache.clear();
    }

    protected ClassType makeParameterizedArrayType(ClassType t, List<? extends TypeArgument> typeArgs) {
        ClassType result = t;
        int dim = 0;
        while (result instanceof ArrayType) {
            result = (ClassType)((ArrayType)result).getBaseType();
            ++dim;
        }
        result = this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType(result, typeArgs);
        int i = 0;
        while (i < dim) {
            result = this.getNameInfo().createArrayType(result);
            ++i;
        }
        return result;
    }

    @Override
    public List<Method> getMethods(ClassType ct, String name, List<Type> signature) {
        return this.getMethods(ct, name, signature, null);
    }

    @Override
    public List<Method> getMethods(ClassType ct, String name, List<Type> signature, boolean allowBoxing, boolean allowVarArgs) {
        List<Method> result = this.getMethods(ct, name, signature);
        if (allowBoxing & allowVarArgs) {
            return result;
        }
        Iterator<Method> it = result.iterator();
        while (it.hasNext()) {
            Method m = it.next();
            if (this.internalIsCompatibleSignature(signature, m.getSignature(), allowBoxing, m.isVarArgMethod() & allowVarArgs)) continue;
            it.remove();
        }
        return result;
    }

    @Override
    public List<? extends Constructor> getConstructors(ClassType ct, List<Type> signature) {
        return this.getConstructors(ct, signature, null);
    }

    @Override
    public ClassType getCommonSupertype(ClassType ... types) {
        if (types == null || types.length == 0) {
            throw new IllegalArgumentException();
        }
        if (types.length == 1) {
            return types[0];
        }
        int i = 0;
        while (i < types.length) {
            if (types[i] instanceof ErasedType) {
                int j = 0;
                while (j < types.length) {
                    types[j] = types[j].getErasedType();
                    ++j;
                }
                break;
            }
            ++i;
        }
        ArrayList<ClassType> tml = new ArrayList<ClassType>();
        tml.addAll(this.getAllSupertypes(types[0]));
        int i2 = 1;
        while (i2 < types.length) {
            List<ClassType> comp = this.getAllSupertypes(types[i2]);
            int j = tml.size() - 1;
            while (j >= 0) {
                if (comp.indexOf(tml.get(j)) == -1) {
                    tml.remove(j);
                }
                --j;
            }
            ++i2;
        }
        this.removeSupertypesFromList(tml);
        if (tml.size() == 0) {
            throw new Error("Cannot compute common supertype for " + Arrays.toString(types));
        }
        ClassType result = tml.size() == 1 ? tml.get(0) : new IntersectionType(tml, this.getServiceConfiguration().getImplicitElementInfo());
        tml.trimToSize();
        return result;
    }

    /*
     * Unable to fully structure code
     */
    void removeSupertypesFromList(List<ClassType> result) {
        j = result.size() - 1;
        while (j >= 0) {
            k = 0;
            while (k < result.size() - 1) {
                block4: {
                    block5: {
                        if (j == k) break block4;
                        a = result.get(j);
                        b = result.get(k);
                        if (!(a instanceof ArrayType)) break block5;
                        if (DefaultProgramModelInfo.$assertionsDisabled || b instanceof ArrayType) ** GOTO lbl13
                        throw new AssertionError();
lbl-1000:
                        // 1 sources

                        {
                            a = (ClassType)((ArrayType)a).getBaseType();
                            b = (ClassType)((ArrayType)b).getBaseType();
lbl13:
                            // 2 sources

                            ** while (a instanceof ArrayType)
                        }
                    }
                    if (this.isSupertype(a, b)) {
                        result.remove(j);
                        break;
                    }
                }
                ++k;
            }
            --j;
        }
    }

    @Override
    public boolean containsTypeParameter(Type t) {
        while (t instanceof ArrayType) {
            t = ((ArrayType)t).getBaseType();
        }
        if (!(t instanceof ClassType)) {
            return false;
        }
        if (t instanceof TypeParameter) {
            return true;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (pt.getGenericType() instanceof TypeParameter) {
                return true;
            }
            for (TypeArgument ta : pt.getAllTypeArgs()) {
                if (!this.containsTypeParameter(ta)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsTypeParameter(TypeArgument ta) {
        if (this.getBaseType(ta) instanceof TypeParameter) {
            return true;
        }
        if (ta.getTypeArguments() != null) {
            for (TypeArgument typeArgument : ta.getTypeArguments()) {
                if (!this.containsTypeParameter(typeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    boolean containsTypeParameter(Type t, TypeParameter tp) {
        while (t instanceof ArrayType) {
            t = ((ArrayType)t).getBaseType();
        }
        if (!(t instanceof ClassType)) {
            return false;
        }
        if (t == tp) {
            return true;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (pt.getGenericType() == tp) {
                return true;
            }
            for (TypeArgument ta : pt.getAllTypeArgs()) {
                if (!this.containsTypeParameter(ta, tp)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsTypeParameter(TypeArgument ta, TypeParameter tp) {
        if (this.getBaseType(ta) == tp) {
            return true;
        }
        if (ta.getTypeArguments() != null) {
            for (TypeArgument typeArgument : ta.getTypeArguments()) {
                if (!this.containsTypeParameter(typeArgument, tp)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsTypeParameter(Method m) {
        if (m.getReturnType() != null && this.containsTypeParameter(m.getReturnType())) {
            return true;
        }
        for (Type type : m.getSignature()) {
            if (!this.containsTypeParameter(type)) continue;
            return true;
        }
        for (Type type : m.getExceptions()) {
            if (!this.containsTypeParameter(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsTypeParameter(Field f) {
        Type t = f.getType();
        return this.containsTypeParameter(t);
    }

    @Override
    public List<? extends Type> getAllSubtypes(Type t) {
        if (t == null) {
            throw new NullPointerException();
        }
        if (t instanceof PrimitiveType) {
            return this.getAllSubtypes((PrimitiveType)t);
        }
        if (t instanceof ClassType) {
            return this.getAllSubtypes((ClassType)t);
        }
        throw new Error("This shouldn't happen: All cases covered!");
    }

    @Override
    public List<PrimitiveType> getAllSubtypes(PrimitiveType pt) {
        NameInfo ni = this.getNameInfo();
        if (pt == ni.getBooleanType()) {
            return Collections.emptyList();
        }
        if (pt == ni.getByteType()) {
            return Collections.emptyList();
        }
        if (pt == ni.getShortType()) {
            return this.makeList(ni.getByteType());
        }
        if (pt == ni.getLongType()) {
            return this.makeList(ni.getIntType(), ni.getShortType(), ni.getCharType(), ni.getByteType());
        }
        if (pt == ni.getIntType()) {
            return this.makeList(ni.getShortType(), ni.getCharType(), ni.getByteType());
        }
        if (pt == ni.getFloatType()) {
            return this.makeList(ni.getLongType(), ni.getIntType(), ni.getShortType(), ni.getCharType(), ni.getByteType());
        }
        if (pt == ni.getDoubleType()) {
            return this.makeList(ni.getFloatType(), ni.getLongType(), ni.getIntType(), ni.getShortType(), ni.getCharType(), ni.getByteType());
        }
        if (pt == ni.getCharType()) {
            return Collections.emptyList();
        }
        throw new Error();
    }

    @Override
    public List<PrimitiveType> getAllSupertypes(PrimitiveType pt) {
        NameInfo ni = this.getNameInfo();
        if (pt == ni.getBooleanType()) {
            return this.makeList(ni.getBooleanType());
        }
        if (pt == ni.getByteType()) {
            return this.makeList(ni.getByteType(), ni.getShortType(), ni.getIntType(), ni.getLongType(), ni.getFloatType(), ni.getDoubleType());
        }
        if (pt == ni.getShortType()) {
            return this.makeList(ni.getShortType(), ni.getIntType(), ni.getLongType(), ni.getFloatType(), ni.getDoubleType());
        }
        if (pt == ni.getLongType()) {
            return this.makeList(ni.getLongType(), ni.getFloatType(), ni.getDoubleType());
        }
        if (pt == ni.getIntType()) {
            return this.makeList(ni.getIntType(), ni.getLongType(), ni.getFloatType(), ni.getDoubleType());
        }
        if (pt == ni.getFloatType()) {
            return this.makeList(ni.getFloatType(), ni.getDoubleType());
        }
        if (pt == ni.getDoubleType()) {
            return this.makeList(ni.getDoubleType());
        }
        if (pt == ni.getCharType()) {
            return this.makeList(ni.getCharType(), ni.getIntType(), ni.getLongType(), ni.getFloatType(), ni.getDoubleType());
        }
        throw new Error();
    }

    @Override
    public List<PrimitiveType> getSubtypes(PrimitiveType pt) {
        NameInfo ni = this.getNameInfo();
        if (pt == ni.getBooleanType()) {
            return Collections.emptyList();
        }
        if (pt == ni.getByteType()) {
            return Collections.emptyList();
        }
        if (pt == ni.getShortType()) {
            return this.makeList(ni.getByteType());
        }
        if (pt == ni.getLongType()) {
            return this.makeList(ni.getIntType());
        }
        if (pt == ni.getIntType()) {
            return this.makeList(ni.getShortType(), ni.getCharType());
        }
        if (pt == ni.getFloatType()) {
            return this.makeList(ni.getLongType());
        }
        if (pt == ni.getDoubleType()) {
            return this.makeList(ni.getFloatType());
        }
        if (pt == ni.getCharType()) {
            return Collections.emptyList();
        }
        throw new Error();
    }

    @Override
    public List<PrimitiveType> getSupertypes(PrimitiveType pt) {
        NameInfo ni = this.getNameInfo();
        if (pt == ni.getBooleanType()) {
            return Collections.emptyList();
        }
        if (pt == ni.getByteType()) {
            return this.makeList(ni.getShortType());
        }
        if (pt == ni.getShortType()) {
            return this.makeList(ni.getIntType());
        }
        if (pt == ni.getLongType()) {
            return this.makeList(ni.getFloatType());
        }
        if (pt == ni.getIntType()) {
            return this.makeList(ni.getLongType());
        }
        if (pt == ni.getFloatType()) {
            return this.makeList(ni.getDoubleType());
        }
        if (pt == ni.getDoubleType()) {
            return Collections.emptyList();
        }
        if (pt == ni.getCharType()) {
            return this.makeList(ni.getIntType());
        }
        throw new Error();
    }

    private ArrayList<PrimitiveType> makeList(PrimitiveType ... types) {
        ArrayList<PrimitiveType> res = new ArrayList<PrimitiveType>(types.length);
        PrimitiveType[] primitiveTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            PrimitiveType pt = primitiveTypeArray[n2];
            res.add(pt);
            ++n2;
        }
        return res;
    }

    @Override
    public Type eraseType(Type t) {
        if (t instanceof ParameterizedType) {
            t = ((ParameterizedType)t).getGenericType();
        }
        int dim = 0;
        while (t instanceof ArrayType) {
            t = ((ArrayType)t).getBaseType();
            ++dim;
        }
        if (dim > 0) {
            t = this.eraseType(t);
            int i = 0;
            while (i < dim) {
                t = t.createArrayType();
                ++i;
            }
        }
        if (t instanceof PrimitiveType) {
            return t;
        }
        if (t instanceof TypeParameter) {
            t = this.getClassTypeFromTypeParameter((TypeParameter)t, 0);
        }
        if (t instanceof IntersectionType) {
            IntersectionType it = (IntersectionType)t;
            for (ClassType ct : it.getSupertypes()) {
                if (ct.isInterface()) continue;
                return ct;
            }
            System.err.println("WARNING: cannot determine type erasure of intersection type " + it.getFullName() + " - guessing!");
            return it.getSupertypes().get(0);
        }
        if (t == null) {
            return null;
        }
        ClassType ct = (ClassType)t;
        if (!(ct instanceof ErasedType) && !(ct instanceof ArrayType)) {
            t = ct.getErasedType();
        }
        return t;
    }

    @Override
    public <T extends Type> List<T> eraseTypes(List<T> types) {
        ArrayList<Type> res = new ArrayList<Type>(types.size());
        for (Type t : types) {
            res.add(this.eraseType(t));
        }
        return res;
    }

    List<Type> replaceAllTypeParameters(List<? extends Type> replaceIn, List<? extends TypeParameter> typeParams, List<? extends ClassType> replaceWith, boolean goByName) {
        ArrayList<Type> res = new ArrayList<Type>(replaceIn.size());
        for (Type type : replaceIn) {
            res.add(this.replaceAllTypeParameters(type, typeParams, replaceWith, goByName));
        }
        return res;
    }

    Type replaceAllTypeParameters(Type replaceIn, List<? extends TypeParameter> typeParams, List<? extends ClassType> replaceWith, boolean goByName) {
        goByName = false;
        Type repl = replaceIn;
        int dim = 0;
        while (repl instanceof ArrayType) {
            repl = ((ArrayType)repl).getBaseType();
            ++dim;
        }
        if (repl instanceof PrimitiveType) {
            return replaceIn;
        }
        List<TypeArgument> targs = null;
        if (repl instanceof ParameterizedType) {
            targs = ((ParameterizedType)repl).getAllTypeArgs();
            repl = ((ParameterizedType)repl).getGenericType();
        }
        if (replaceWith.contains(null)) {
            targs = null;
        }
        int i = -1;
        for (TypeParameter typeParameter : typeParams) {
            ++i;
            if (repl instanceof TypeParameter) {
                if (typeParameter != repl) continue;
                if (replaceWith.get(i) == null) {
                    repl = this.getNameInfo().getClassType(typeParameter.getBoundName(0)).getErasedType();
                    targs = null;
                    break;
                }
                repl = replaceWith.get(i);
                continue;
            }
            if (targs == null) continue;
            ArrayList<TypeParameter> single_tp = new ArrayList<TypeParameter>(1);
            single_tp.add(typeParameter);
            ArrayList<WrappedTypeArgument> single_cp = new ArrayList<WrappedTypeArgument>(1);
            single_cp.add(new WrappedTypeArgument(replaceWith.get(i)));
            targs = this.replaceAllTypeParametersWithArgsInArgs(targs, single_tp, single_cp);
        }
        if (targs != null) {
            repl = this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType((ClassType)repl, targs);
        }
        while (dim-- > 0) {
            repl = repl.createArrayType();
        }
        return repl;
    }

    public <X extends Type> List<X> replaceAllTypeParametersWithArgs(List<X> replaceIn, List<? extends TypeParameter> typeParams, List<? extends TypeArgument> replaceWith) {
        ArrayList<Type> res = new ArrayList<Type>(replaceIn.size());
        for (Type t : replaceIn) {
            res.add(this.replaceAllTypeParametersWithArgs(t, typeParams, replaceWith));
        }
        return res;
    }

    public <X extends Type> X replaceAllTypeParametersWithArgs(X replaceIn, List<? extends TypeParameter> typeParams, List<? extends TypeArgument> replaceWith) {
        return this.replaceAllTypeParametersWithArgs(replaceIn, typeParams, replaceWith, Collections.emptyList());
    }

    <X extends Type> X replaceAllTypeParametersWithArgs(X replaceIn, List<? extends TypeParameter> typeParams, List<? extends TypeArgument> replaceWith, List<? extends TypeParameter> skip) {
        if (skip == null) {
            skip = Collections.emptyList();
        }
        Object replaced = replaceIn;
        int dim = 0;
        while (replaced instanceof ArrayType) {
            replaced = ((ArrayType)replaced).getBaseType();
            ++dim;
        }
        if (replaced instanceof PrimitiveType) {
            return replaceIn;
        }
        List<TypeArgument> targs = null;
        if (replaced instanceof ParameterizedType) {
            targs = ((ParameterizedType)replaced).getAllTypeArgs();
            replaced = ((ParameterizedType)replaced).getGenericType();
        }
        int i = -1;
        block1: for (TypeParameter typeParameter : typeParams) {
            ++i;
            if (!typeParameter.equals(replaced)) continue;
            for (TypeParameter sk : skip) {
                if (sk.getName() == replaced.getName()) continue block1;
            }
            replaced = this.getCapture(replaceWith.get(i));
            while (dim-- > 0) {
                replaced = replaced.createArrayType();
            }
            return (X)replaced;
        }
        if (targs != null) {
            targs = this.replaceAllTypeParametersWithArgsInArgs(targs, typeParams, replaceWith);
            replaced = this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType((ClassType)replaced, targs);
        }
        while (dim-- > 0) {
            replaced = replaced.createArrayType();
        }
        return (X)replaced;
    }

    private List<TypeArgument> replaceAllTypeParametersWithArgsInArgs(List<? extends TypeArgument> replaceIn, List<? extends TypeParameter> typeParams, List<? extends TypeArgument> replaceWith) {
        ArrayList<TypeArgument> res = new ArrayList<TypeArgument>(replaceIn.size());
        for (TypeArgument typeArgument : replaceIn) {
            res.add(this.replaceAllTypeParametersWithArgs(typeArgument, typeParams, replaceWith));
        }
        return res;
    }

    private TypeArgument replaceAllTypeParametersWithArgs(TypeArgument replaceIn, List<? extends TypeParameter> typeParams, List<? extends TypeArgument> replaceWith) {
        ClassType bt = this.getBaseType(replaceIn);
        if (bt instanceof TypeParameter) {
            int i = 0;
            while (i < typeParams.size()) {
                if (bt == typeParams.get(i)) {
                    return replaceWith.get(i);
                }
                ++i;
            }
            return replaceIn;
        }
        List<? extends TypeArgument> targs = replaceIn.getTypeArguments();
        if (targs != null && targs.size() > 0) {
            List<TypeArgument> new_targs = this.replaceAllTypeParametersWithArgsInArgs(targs, typeParams, replaceWith);
            return new ResolvedTypeArgument(TypeArgument.WildcardMode.None, this.getBaseType(replaceIn), new_targs);
        }
        return replaceIn;
    }

    public ClassType getCapture(TypeArgument ta) {
        switch (ta.getWildcardMode()) {
            case None: {
                return this.getBaseType(ta);
            }
            case Any: 
            case Extends: 
            case Super: {
                return new TypeArgument.CapturedTypeArgument(ta, this.getServiceConfiguration().getImplicitElementInfo());
            }
        }
        throw new RuntimeException();
    }

    boolean java5Allowed() {
        return this.serviceConfiguration.getProjectSettings().java5Allowed();
    }

    static class ClassTypeCacheEntry {
        List<ClassType> supertypes;
        Set<ClassType> subtypes;
        List<ClassType> allSupertypes;
        List<ClassType> allMemberTypes;
        List<Field> allFields;
        List<Method> allMethods;

        ClassTypeCacheEntry() {
        }
    }

    public class ResolvedTypeArgument
    implements TypeArgument {
        final TypeArgument.WildcardMode wm;
        final ClassType type;
        final List<? extends TypeArgument> typeArgs;

        public ResolvedTypeArgument(TypeArgument.WildcardMode wm, ClassType type, List<? extends TypeArgument> typeArgs) {
            this.wm = wm;
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getGenericType();
            }
            this.type = type;
            List<Object> list = this.typeArgs = typeArgs == null ? Collections.emptyList() : typeArgs;
            assert (wm == TypeArgument.WildcardMode.Any ^ this.getTypeName() != null);
        }

        @Override
        public TypeArgument.WildcardMode getWildcardMode() {
            return this.wm;
        }

        @Override
        public String getTypeName() {
            if (this.type instanceof ClassDeclaration && ((ClassDeclaration)this.type).getASTParent() instanceof New) {
                return Naming.toPathName(((New)((ClassDeclaration)this.type).getASTParent()).getTypeReference());
            }
            return this.type.getFullName();
        }

        @Override
        public List<? extends TypeArgument> getTypeArguments() {
            return this.typeArgs;
        }

        @Override
        public boolean semanticalEquality(TypeArgument o) {
            return TypeArgument.EqualsImpl.equals(this, o, (DefaultImplicitElementInfo)DefaultProgramModelInfo.this.getServiceConfiguration().getImplicitElementInfo());
        }

        @Override
        public int semanticalHashCode() {
            return TypeArgument.EqualsImpl.semanticalHashCode(this);
        }

        @Override
        public String getFullSignature() {
            if (this.wm == null) {
                return this.getTypeName();
            }
            return TypeArgument.DescriptionImpl.getFullDescription(this);
        }

        @Override
        public TypeParameter getTargetedTypeParameter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTypeVariable() {
            return false;
        }
    }

    class SubTypeTopSort
    extends ClassTypeTopSort {
        SubTypeTopSort() {
        }

        @Override
        protected final List<ClassType> getAdjacent(ClassType c) {
            return DefaultProgramModelInfo.this.getSubtypes(c);
        }
    }

    static class SuperTypeTopSort
    extends ClassTypeTopSort {
        SuperTypeTopSort() {
        }

        @Override
        protected final List<ClassType> getAdjacent(ClassType c) {
            return c.getSupertypes();
        }
    }

    private static class WrappedTypeArgument
    implements TypeArgument {
        final ClassType type;

        WrappedTypeArgument(ClassType ct) {
            this.type = ct;
        }

        @Override
        public String getFullSignature() {
            return null;
        }

        @Override
        public TypeParameter getTargetedTypeParameter() {
            return null;
        }

        @Override
        public List<? extends TypeArgument> getTypeArguments() {
            return null;
        }

        @Override
        public String getTypeName() {
            return this.type.getFullName();
        }

        @Override
        public TypeArgument.WildcardMode getWildcardMode() {
            return TypeArgument.WildcardMode.None;
        }

        @Override
        public boolean semanticalEquality(TypeArgument ta) {
            return TypeArgument.EqualsImpl.equals(this, ta, (DefaultImplicitElementInfo)this.type.getProgramModelInfo().getServiceConfiguration().getImplicitElementInfo());
        }

        @Override
        public int semanticalHashCode() {
            return TypeArgument.EqualsImpl.semanticalHashCode(this);
        }

        @Override
        public boolean isTypeVariable() {
            return false;
        }
    }
}

