/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import recoder.AbstractService;
import recoder.ParserException;
import recoder.ServiceConfiguration;
import recoder.abstraction.AnnotationProperty;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.EnumConstant;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Field;
import recoder.abstraction.Member;
import recoder.abstraction.Method;
import recoder.abstraction.NullType;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.abstraction.Variable;
import recoder.bytecode.ClassFile;
import recoder.bytecode.FieldInfo;
import recoder.bytecode.ReflectionImport;
import recoder.convenience.Format;
import recoder.io.ClassFileRepository;
import recoder.io.DefaultClassFileRepository;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.java.JavaProgramFactory;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.list.generic.ASTList;
import recoder.parser.JavaCCParser;
import recoder.service.ByteCodeInfo;
import recoder.service.DefaultByteCodeInfo;
import recoder.service.DefaultProgramModelInfo;
import recoder.service.ImplicitElementInfo;
import recoder.service.NameInfo;
import recoder.service.ProgramModelInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public class DefaultNameInfo
extends AbstractService
implements NameInfo,
PropertyChangeListener {
    private static final boolean DEBUG = false;
    private final Map<String, Type> name2type = new HashMap<String, Type>(128);
    final Map<String, ParameterizedType> paramTypesCache = new HashMap<String, ParameterizedType>(128);
    private final Map<String, Field> name2field = new HashMap<String, Field>(128);
    private Map<String, Package> name2package = new HashMap<String, Package>(64);
    private ClassType nullType;
    private ClassType javaLangObject;
    private ClassType javaLangString;
    private ClassType javaLangClass;
    private ClassType javaLangCloneable;
    private ClassType javaIoSerializable;
    private ClassType javaLangRunnable;
    private ClassType javaLangBoolean;
    private ClassType javaLangByte;
    private ClassType javaLangCharacter;
    private ClassType javaLangShort;
    private ClassType javaLangInteger;
    private ClassType javaLangLong;
    private ClassType javaLangFloat;
    private ClassType javaLangDouble;
    private ClassType javaLangAnnotationAnnotation;
    private ClassType javaLangEnum;
    private ClassType javaLangIterable;
    private final PrimitiveType intType = new PrimitiveType("int");
    private final PrimitiveType booleanType = new PrimitiveType("boolean");
    private final PrimitiveType longType = new PrimitiveType("long");
    private final PrimitiveType doubleType = new PrimitiveType("double");
    private final PrimitiveType charType = new PrimitiveType("char");
    private final PrimitiveType floatType = new PrimitiveType("float");
    private final PrimitiveType byteType = new PrimitiveType("byte");
    private final PrimitiveType shortType = new PrimitiveType("short");
    private static final int NO_SEARCH = 0;
    private static final int SEARCH_SOURCE = 1;
    private static final int SEARCH_CLASS = 2;
    private static final int SEARCH_REFLECT = 3;
    private int[] searchMode;
    private UnknownProgramModelElementInfo unknownProgramModelInfo = new UnknownProgramModelElementInfo();
    private final ProgramModelElement unknownElement = new UnknownProgramModelElement();
    private final ClassType unknownClassType = new UnknownClassType();
    private final Type unknownType = this.unknownClassType;
    private final Package unknownPackage = new Package("<unknownPackage>", null);
    private final Method unknownMethod = new UnknownMethod();
    private final Constructor unknownConstructor = new UnknownConstructor();
    private final Variable unknownVariable = new UnknownVariable();
    private final Field unknownField = new UnknownField();
    private final AnnotationProperty unknownAnnotationProperty = new UnknownAnnotationProperty();

    public DefaultNameInfo(ServiceConfiguration config) {
        super(config);
        PrimitiveType[] pts;
        PrimitiveType[] primitiveTypeArray = pts = new PrimitiveType[]{this.intType, this.booleanType, this.longType, this.doubleType, this.charType, this.floatType, this.byteType, this.shortType};
        int n = pts.length;
        int n2 = 0;
        while (n2 < n) {
            PrimitiveType pt = primitiveTypeArray[n2];
            this.name2type.put(pt.getName(), pt);
            pt.setProgramModelInfo(this.getImplicitElementInfo());
            ++n2;
        }
    }

    @Override
    public void initialize(ServiceConfiguration cfg) {
        super.initialize(cfg);
        this.nullType = new NullType(cfg.getImplicitElementInfo());
        this.createPackage("java.lang");
        cfg.getProjectSettings().addPropertyChangeListener(this);
        this.updateSearchMode();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String changedProp = evt.getPropertyName();
        if (changedProp.equals("class.search.mode")) {
            this.updateSearchMode();
        }
    }

    private void updateSearchMode() {
        String prop = this.serviceConfiguration.getProjectSettings().getProperty("class.search.mode");
        if (prop == null) {
            prop = "";
        }
        this.searchMode = new int[prop.length()];
        int i = 0;
        while (i < this.searchMode.length) {
            switch (prop.charAt(i)) {
                case 'S': 
                case 's': {
                    this.searchMode[i] = 1;
                    break;
                }
                case 'C': 
                case 'c': {
                    this.searchMode[i] = 2;
                    break;
                }
                case 'R': 
                case 'r': {
                    this.searchMode[i] = 3;
                    break;
                }
                default: {
                    this.searchMode[i] = 0;
                }
            }
            ++i;
        }
    }

    final void updateModel() {
        this.serviceConfiguration.getChangeHistory().updateModel();
    }

    ClassFileRepository getClassFileRepository() {
        return this.serviceConfiguration.getClassFileRepository();
    }

    SourceFileRepository getSourceFileRepository() {
        return this.serviceConfiguration.getSourceFileRepository();
    }

    ByteCodeInfo getByteCodeInfo() {
        return this.serviceConfiguration.getByteCodeInfo();
    }

    SourceInfo getSourceInfo() {
        return this.serviceConfiguration.getSourceInfo();
    }

    ImplicitElementInfo getImplicitElementInfo() {
        return this.serviceConfiguration.getImplicitElementInfo();
    }

    @Override
    public void register(ClassType ct) {
        Debug.assertNonnull(ct);
        String name = ct.getFullName();
        Type ob = this.name2type.put(name, ct);
        if (ob != null && ob != ct && !(ob instanceof UnknownClassType)) {
            Debug.log("Internal Warning - Multiple registration of " + Format.toString("%N [%i]", ct) + Format.toString(" --- was: %N [%i]", ob));
        }
    }

    @Override
    public void register(Field f) {
        Debug.assertNonnull(f);
        this.name2field.put(f.getFullName(), f);
    }

    @Override
    public ClassType getJavaLangObject() {
        if (this.javaLangObject == null) {
            this.javaLangObject = this.getClassType("java.lang.Object");
        }
        return this.javaLangObject;
    }

    @Override
    public ClassType getJavaLangString() {
        if (this.javaLangString == null) {
            this.javaLangString = this.getClassType("java.lang.String");
        }
        return this.javaLangString;
    }

    @Override
    public ClassType getJavaLangBoolean() {
        if (this.javaLangBoolean == null) {
            this.javaLangBoolean = this.getClassType("java.lang.Boolean");
        }
        return this.javaLangBoolean;
    }

    @Override
    public ClassType getJavaLangByte() {
        if (this.javaLangByte == null) {
            this.javaLangByte = this.getClassType("java.lang.Byte");
        }
        return this.javaLangByte;
    }

    @Override
    public ClassType getJavaLangCharacter() {
        if (this.javaLangCharacter == null) {
            this.javaLangCharacter = this.getClassType("java.lang.Character");
        }
        return this.javaLangCharacter;
    }

    @Override
    public ClassType getJavaLangShort() {
        if (this.javaLangShort == null) {
            this.javaLangShort = this.getClassType("java.lang.Short");
        }
        return this.javaLangShort;
    }

    @Override
    public ClassType getJavaLangInteger() {
        if (this.javaLangInteger == null) {
            this.javaLangInteger = this.getClassType("java.lang.Integer");
        }
        return this.javaLangInteger;
    }

    @Override
    public ClassType getJavaLangLong() {
        if (this.javaLangLong == null) {
            this.javaLangLong = this.getClassType("java.lang.Long");
        }
        return this.javaLangLong;
    }

    @Override
    public ClassType getJavaLangFloat() {
        if (this.javaLangFloat == null) {
            this.javaLangFloat = this.getClassType("java.lang.Float");
        }
        return this.javaLangFloat;
    }

    @Override
    public ClassType getJavaLangDouble() {
        if (this.javaLangDouble == null) {
            this.javaLangDouble = this.getClassType("java.lang.Double");
        }
        return this.javaLangDouble;
    }

    @Override
    public ClassType getJavaLangClass() {
        if (this.javaLangClass == null) {
            this.javaLangClass = this.getClassType("java.lang.Class");
        }
        return this.javaLangClass;
    }

    @Override
    public ClassType getJavaLangCloneable() {
        if (this.javaLangCloneable == null) {
            this.javaLangCloneable = this.getClassType("java.lang.Cloneable");
        }
        return this.javaLangCloneable;
    }

    public ClassType getJavaLangRunnable() {
        if (this.javaLangRunnable == null) {
            this.javaLangRunnable = this.getClassType("java.lang.Runnable");
        }
        return this.javaLangRunnable;
    }

    @Override
    public ClassType getJavaIoSerializable() {
        if (this.javaIoSerializable == null) {
            this.javaIoSerializable = this.getClassType("java.io.Serializable");
        }
        return this.javaIoSerializable;
    }

    @Override
    public ClassType getJavaLangAnnotationAnnotation() {
        if (this.javaLangAnnotationAnnotation == null) {
            this.javaLangAnnotationAnnotation = this.getClassType("java.lang.annotation.Annotation");
        }
        return this.javaLangAnnotationAnnotation;
    }

    @Override
    public ClassType getJavaLangEnum() {
        if (this.javaLangEnum == null) {
            this.javaLangEnum = this.getClassType("java.lang.Enum");
        }
        return this.javaLangEnum;
    }

    @Override
    public ClassType getJavaLangIterable() {
        if (this.javaLangIterable == null) {
            this.javaLangIterable = this.getClassType("java.lang.Iterable");
        }
        return this.javaLangIterable;
    }

    @Override
    public ClassType getNullType() {
        return this.nullType;
    }

    @Override
    public PrimitiveType getShortType() {
        return this.shortType;
    }

    @Override
    public PrimitiveType getByteType() {
        return this.byteType;
    }

    @Override
    public PrimitiveType getBooleanType() {
        return this.booleanType;
    }

    @Override
    public PrimitiveType getIntType() {
        return this.intType;
    }

    @Override
    public PrimitiveType getLongType() {
        return this.longType;
    }

    @Override
    public PrimitiveType getFloatType() {
        return this.floatType;
    }

    @Override
    public PrimitiveType getDoubleType() {
        return this.doubleType;
    }

    @Override
    public PrimitiveType getCharType() {
        return this.charType;
    }

    public boolean isPackage(String name) {
        this.updateModel();
        return this.name2package.get(name) != null;
    }

    @Override
    public Package createPackage(String name) {
        Package result = this.name2package.get(name);
        if (result == null) {
            result = new Package(name, this.serviceConfiguration.getImplicitElementInfo());
            this.name2package.put(result.getName(), result);
            int ldp = name.lastIndexOf(46);
            if (ldp > 0) {
                this.createPackage(name.substring(0, ldp));
            }
        }
        return result;
    }

    @Override
    public Package getPackage(String name) {
        Debug.assertNonnull(name);
        this.updateModel();
        return this.name2package.get(name);
    }

    @Override
    public List<Package> getPackages() {
        this.updateModel();
        int size = this.name2package.size();
        ArrayList<Package> result = new ArrayList<Package>(size);
        for (Package p : this.name2package.values()) {
            result.add(p);
        }
        return result;
    }

    @Override
    public ClassType getClassType(String name) {
        Type result = this.getType(name);
        if (result instanceof ClassType) {
            return (ClassType)result;
        }
        return null;
    }

    @Override
    @Deprecated
    public ArrayType createArrayType(Type basetype) {
        return basetype.createArrayType();
    }

    @Override
    @Deprecated
    public ArrayType createArrayType(Type basetype, int dimensions) {
        if (dimensions < 1) {
            throw new IllegalArgumentException("dimensions must be >= 1");
        }
        Type result = basetype;
        while (dimensions-- > 0) {
            result = result.createArrayType();
        }
        return (ArrayType)result;
    }

    @Override
    @Deprecated
    public ArrayType getArrayType(Type basetype) {
        Debug.assertNonnull(basetype);
        return basetype.getArrayType();
    }

    @Override
    public Type getType(String name) {
        String sname = name.trim();
        Debug.assertNonnull(name);
        this.updateModel();
        int dim = 0;
        while (sname.endsWith("[]")) {
            ++dim;
            sname = sname.substring(0, sname.length() - 2);
        }
        Type result = null;
        String name_with_args = sname;
        String typeArgs = null;
        int idx = sname.indexOf(60);
        if (idx > -1 && (result = (Type)this.paramTypesCache.get(sname)) == null) {
            typeArgs = sname.substring(idx, sname.length());
            sname = sname.substring(0, idx);
        }
        if (result == null) {
            result = this.name2type.get(sname);
        }
        if (result == null && (result = this.name2type.get("java.lang." + sname)) == this.unknownType) {
            result = null;
        }
        if (result == this.unknownType) {
            return null;
        }
        if (result == null) {
            if (this.loadClass(sname)) {
                result = this.name2type.get(sname);
            }
            if ((result == null || result == this.unknownType) && this.loadClass("java.lang." + sname) && (result = this.name2type.get("java.lang." + sname)) == this.unknownType) {
                return null;
            }
            this.name2type.put(sname, result != null ? result : this.unknownType);
        }
        if (typeArgs != null && result != null) {
            StringReader sr = new StringReader(typeArgs);
            JavaCCParser parser = new JavaCCParser(sr);
            parser.initialize(sr, (JavaProgramFactory)this.getServiceConfiguration().getProgramFactory());
            ASTList<TypeArgumentDeclaration> tads = null;
            try {
                tads = parser.TypeArguments();
                if (!parser.getNextToken().image.equals("")) {
                    throw new IllegalArgumentException(name);
                }
            }
            catch (ParserException e) {
                throw new IllegalArgumentException(name);
            }
            ArrayList<DefaultProgramModelInfo.ResolvedTypeArgument> tis = new ArrayList<DefaultProgramModelInfo.ResolvedTypeArgument>(tads.size());
            for (TypeArgumentDeclaration tad : tads) {
                TypeArgument.WildcardMode wm = tad.getWildcardMode();
                tad.setWildcardMode(TypeArgument.WildcardMode.None);
                String sig = TypeArgument.DescriptionImpl.getFullDescription(tad, true);
                ClassType argType = this.getClassType(sig);
                if (argType == null) {
                    return null;
                }
                DefaultProgramModelInfo pmi = (DefaultProgramModelInfo)((Object)this.getServiceConfiguration().getSourceInfo());
                if (argType instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)argType;
                    DefaultProgramModelInfo defaultProgramModelInfo = pmi;
                    defaultProgramModelInfo.getClass();
                    tis.add(new DefaultProgramModelInfo.ResolvedTypeArgument(defaultProgramModelInfo, wm, pt.getGenericType(), pt.getTypeArgs()));
                    continue;
                }
                DefaultProgramModelInfo defaultProgramModelInfo = pmi;
                defaultProgramModelInfo.getClass();
                tis.add(new DefaultProgramModelInfo.ResolvedTypeArgument(defaultProgramModelInfo, wm, argType, null));
            }
            result = this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType((ClassType)result, tis);
            this.paramTypesCache.put(name_with_args, (ParameterizedType)result);
        }
        if (result != null) {
            int i = 0;
            while (i < dim) {
                result = result.createArrayType();
                ++i;
            }
        }
        return result;
    }

    @Override
    public List<Type> getTypes() {
        this.updateModel();
        int size = this.name2type.size();
        ArrayList<Type> result = new ArrayList<Type>(size);
        for (Type t : this.name2type.values()) {
            if (t == this.unknownType) continue;
            result.add(t);
        }
        result.trimToSize();
        return result;
    }

    @Override
    public List<ClassType> getTypes(Package pkg) {
        Debug.assertNonnull(pkg);
        this.updateModel();
        ArrayList<ClassType> result = new ArrayList<ClassType>();
        List<Type> tl = this.getTypes();
        int s = tl.size();
        int i = 0;
        while (i < s) {
            ClassType ct;
            Type t = tl.get(i);
            if (t instanceof ClassType && (ct = (ClassType)t).getContainer() == pkg) {
                result.add(ct);
            }
            ++i;
        }
        result.trimToSize();
        return result;
    }

    @Override
    public List<ClassType> getClassTypes() {
        this.updateModel();
        ArrayList<ClassType> result = new ArrayList<ClassType>(this.name2type.size() - 8);
        List<Type> tl = this.getTypes();
        int s = tl.size();
        int i = 0;
        while (i < s) {
            Type t = tl.get(i);
            if (t instanceof ClassType) {
                result.add((ClassType)t);
            }
            ++i;
        }
        result.trimToSize();
        return result;
    }

    @Override
    public Field getField(String name) {
        Debug.assertNonnull(name);
        this.updateModel();
        Field result = this.name2field.get(name);
        if (result != null) {
            return result;
        }
        int ldp = name.lastIndexOf(46);
        if (ldp == -1) {
            return null;
        }
        ClassType ct = this.getClassType(name.substring(0, ldp));
        if (ct == null) {
            return null;
        }
        List<? extends Field> fields = ct.getFields();
        if (fields == null) {
            return null;
        }
        String shortname = name.substring(ldp + 1);
        int i = 0;
        while (i < fields.size()) {
            String fname = fields.get(i).getName();
            if (shortname.equals(fname) && (result = fields.get(i)) != null) break;
            ++i;
        }
        return result;
    }

    @Override
    public List<Field> getFields() {
        this.updateModel();
        int size = this.name2field.size();
        ArrayList<Field> result = new ArrayList<Field>(size);
        for (Field f : this.name2field.values()) {
            result.add(f);
        }
        result.trimToSize();
        return result;
    }

    private boolean loadClass(String classname) {
        boolean result = false;
        int i = 0;
        while (!result && i < this.searchMode.length) {
            switch (this.searchMode[i]) {
                case 1: {
                    result = this.loadClassFromSourceCode(classname);
                    break;
                }
                case 2: {
                    result = this.loadClassFromPrecompiledCode(classname);
                    break;
                }
                case 3: {
                    result = this.loadClassByReflection(classname);
                    break;
                }
            }
            ++i;
        }
        return result;
    }

    private boolean loadClassFromPrecompiledCode(String classname) {
        boolean result = false;
        ClassFileRepository cfr = this.getClassFileRepository();
        ClassFile cf = cfr.getClassFile(classname);
        if (cf != null) {
            this.getByteCodeInfo().register(cf);
            result = true;
        }
        return result;
    }

    private boolean loadClassFromSourceCode(String classname) {
        boolean result = false;
        CompilationUnit cu = null;
        try {
            int ldp;
            cu = this.getSourceFileRepository().getCompilationUnit(classname);
            if (cu == null && (ldp = classname.lastIndexOf(46)) >= 0) {
                String shortedname = classname.substring(0, ldp);
                return !this.name2package.containsKey(shortedname) && this.loadClassFromSourceCode(shortedname) && this.name2type.containsKey(classname);
            }
            if (cu != null) {
                this.getSourceInfo().register(cu);
                result = true;
            }
        }
        catch (Exception e) {
            Debug.error("Error trying to retrieve source file for type " + classname + "\n" + "Exception was " + e);
            e.printStackTrace();
        }
        return result && this.name2type.containsKey(classname);
    }

    private boolean loadClassByReflection(String classname) {
        ClassFile cf = ReflectionImport.getClassFile(classname);
        if (cf != null) {
            this.getByteCodeInfo().register(cf);
            return true;
        }
        return false;
    }

    public String information() {
        int unknown = 0;
        for (Type t : this.name2type.values()) {
            if (t != this.unknownType) continue;
            ++unknown;
        }
        return this.name2package.size() + " packages with " + (this.name2type.size() - unknown) + " types (" + unknown + " were pure speculations) and " + this.name2field.size() + " fields";
    }

    @Override
    public void unregisterClassType(String fullname) {
        Debug.assertNonnull(fullname);
        this.name2type.remove(fullname);
    }

    @Override
    public void unregisterField(String fullname) {
        Debug.assertNonnull(fullname);
        this.name2field.remove(fullname);
    }

    void reregisterPackages() {
        HashMap<String, Package> n2p = new HashMap<String, Package>(64);
        List<ClassFile> cf = this.getClassFileRepository().getKnownClassFiles();
        int i = cf.size() - 1;
        while (i >= 0) {
            ClassTypeContainer ctc = cf.get(i).getContainer();
            if (ctc instanceof Package) {
                n2p.put(ctc.getFullName(), (Package)ctc);
            }
            --i;
        }
        this.name2package = n2p;
    }

    @Override
    public ClassType getUnknownClassType() {
        return this.unknownClassType;
    }

    @Override
    public ProgramModelElement getUnknownElement() {
        return this.unknownElement;
    }

    @Override
    public Package getUnknownPackage() {
        return this.unknownPackage;
    }

    @Override
    public Method getUnknownMethod() {
        return this.unknownMethod;
    }

    @Override
    public Constructor getUnknownConstructor() {
        return this.unknownConstructor;
    }

    @Override
    public Variable getUnknownVariable() {
        return this.unknownVariable;
    }

    @Override
    public Field getUnknownField() {
        return this.unknownField;
    }

    @Override
    public Type getUnknownType() {
        return this.unknownType;
    }

    @Override
    public AnnotationProperty getUnknownAnnotationProperty() {
        return this.unknownAnnotationProperty;
    }

    void handleTypeRename(ClassType ct, String unregisterFrom, String registerTo) {
        Type removed;
        boolean register = false;
        boolean unregister = false;
        Type old = this.name2type.get(registerTo);
        if (old == null || old == this.unknownType) {
            register = true;
        }
        if ((old = this.name2type.get(unregisterFrom)) == ct) {
            unregister = true;
        }
        if (unregister) {
            this.name2type.remove(unregisterFrom);
        }
        String newArrayName = String.valueOf(registerTo) + "[]";
        String arrayRemove = String.valueOf(unregisterFrom) + "[]";
        while ((removed = this.name2type.remove(arrayRemove)) != null) {
            this.name2type.put(newArrayName, removed);
            arrayRemove = String.valueOf(arrayRemove) + "[]";
            newArrayName = String.valueOf(newArrayName) + "[]";
        }
        if (register) {
            this.register(ct);
        }
        this.name2type.put(unregisterFrom, this.unknownClassType);
        List<? extends Field> fl = ct.getFields();
        int f = 0;
        int fm = fl.size();
        while (f < fm) {
            Field currentField = fl.get(f);
            String fieldremove = String.valueOf(unregisterFrom) + "." + currentField.getName();
            if (unregister) {
                this.unregisterField(fieldremove);
            }
            if (register) {
                this.register(currentField);
            }
            ++f;
        }
    }

    @Override
    public List<ClassType> getClassTypes(String pattern) {
        pattern = this.adjustPattern(pattern);
        Pattern patt = Pattern.compile(pattern);
        ArrayList<ClassType> result = new ArrayList<ClassType>();
        for (ClassType t : this.getClassTypes()) {
            if (!patt.matcher(t.getFullName()).matches()) continue;
            result.add(t);
        }
        result.trimToSize();
        return result;
    }

    private String adjustPattern(String pattern) {
        pattern = pattern.replace("**", "!");
        pattern = pattern.replace("*", "(\\w)*");
        pattern = pattern.replace("!", "(\\w|\\.)*");
        pattern = pattern.replace("?", ".");
        pattern = pattern.replace("$", "\\$");
        return pattern;
    }

    @Override
    public List<Method> getMethods(String pattern) {
        return this.getMethods(pattern, false);
    }

    @Override
    public List<Method> getMethods(String pattern, boolean includeConstructors) {
        String type = pattern.substring(0, pattern.indexOf(40));
        String type2 = null;
        if (type.lastIndexOf(46) > 0) {
            type2 = type.substring(0, type.lastIndexOf(46));
        }
        String sig = pattern.substring(pattern.indexOf(40) + 1, pattern.length() - 1);
        sig = sig.replace("**", "!");
        sig = sig.replace("*", "(\\w|\\.|\\[|\\])+");
        sig = sig.replace("!", "(\\w|,|\\.|\\[|\\])*");
        sig = sig.replace("?", ".");
        sig = sig.replace("$", "\\$");
        sig = sig.replace("[", "\\[");
        sig = sig.replace("]", "\\]");
        Pattern sigPattern = Pattern.compile(sig);
        List<ClassType> types = this.getClassTypes(type);
        if (type2 != null) {
            List<ClassType> types2 = this.getClassTypes(type2);
            types.removeAll(types2);
            types.addAll(types2);
        }
        ArrayList<Method> result = new ArrayList<Method>();
        type = this.adjustPattern(type);
        Pattern methPattern = Pattern.compile(type);
        for (ClassType t : types) {
            List<Method> methsAndConstrs = t.getMethods();
            if (includeConstructors) {
                methsAndConstrs.addAll(t.getConstructors());
            }
            for (Method m : methsAndConstrs) {
                if (!methPattern.matcher(m.getFullName()).matches()) continue;
                if (sigPattern.matcher(this.makeSigString(m.getSignature(), true)).matches()) {
                    result.add(m);
                    continue;
                }
                if (!sigPattern.matcher(this.makeSigString(m.getSignature(), false)).matches()) continue;
                result.add(m);
            }
        }
        result.trimToSize();
        return result;
    }

    private String makeSigString(List<Type> signature, boolean fullName) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Type t : signature) {
            if (!first) {
                result.append(',');
            } else {
                first = false;
            }
            if (fullName) {
                result.append(t.getFullName());
                continue;
            }
            result.append(t.getName());
        }
        return result.toString();
    }

    public void resetBytecode() {
        this.paramTypesCache.clear();
        Iterator<ProgramModelElement> it = this.name2type.values().iterator();
        while (it.hasNext()) {
            Type t = it.next();
            if (!(t instanceof ClassFile)) continue;
            it.remove();
        }
        it = this.name2field.values().iterator();
        while (it.hasNext()) {
            Field f = (Field)it.next();
            if (!(f instanceof FieldInfo)) continue;
            it.remove();
        }
        if (this.javaIoSerializable instanceof ClassFile) {
            this.javaIoSerializable = null;
        }
        if (this.javaLangAnnotationAnnotation instanceof ClassFile) {
            this.javaLangAnnotationAnnotation = null;
        }
        if (this.javaLangBoolean instanceof ClassFile) {
            this.javaLangBoolean = null;
        }
        if (this.javaLangByte instanceof ClassFile) {
            this.javaLangByte = null;
        }
        if (this.javaLangCharacter instanceof ClassFile) {
            this.javaLangCharacter = null;
        }
        if (this.javaLangClass instanceof ClassFile) {
            this.javaLangClass = null;
        }
        if (this.javaLangCloneable instanceof ClassFile) {
            this.javaLangCloneable = null;
        }
        if (this.javaLangDouble instanceof ClassFile) {
            this.javaLangDouble = null;
        }
        if (this.javaLangEnum instanceof ClassFile) {
            this.javaLangEnum = null;
        }
        if (this.javaLangFloat instanceof ClassFile) {
            this.javaLangFloat = null;
        }
        if (this.javaLangInteger instanceof ClassFile) {
            this.javaLangInteger = null;
        }
        if (this.javaLangLong instanceof ClassFile) {
            this.javaLangLong = null;
        }
        if (this.javaLangObject instanceof ClassFile) {
            this.javaLangObject = null;
        }
        if (this.javaLangRunnable instanceof ClassFile) {
            this.javaLangRunnable = null;
        }
        if (this.javaLangShort instanceof ClassFile) {
            this.javaLangShort = null;
        }
        if (this.javaLangString instanceof ClassFile) {
            this.javaLangString = null;
        }
        ((DefaultByteCodeInfo)this.getByteCodeInfo()).clear();
        ((DefaultClassFileRepository)this.getClassFileRepository()).reset();
    }

    class UnknownAnnotationProperty
    extends UnknownMethod
    implements AnnotationProperty {
        UnknownAnnotationProperty() {
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }

    class UnknownClassType
    extends UnknownMember
    implements ClassType {
        private ArrayType arrayType;
        private final ErasedType erasedType;

        UnknownClassType() {
            this.erasedType = new ErasedType(this, DefaultNameInfo.this.getServiceConfiguration().getImplicitElementInfo());
        }

        @Override
        public String getName() {
            return "<unknownClassType>";
        }

        @Override
        public ClassTypeContainer getContainer() {
            return null;
        }

        public List<ClassType> getTypes() {
            return Collections.emptyList();
        }

        @Override
        public Package getPackage() {
            return DefaultNameInfo.this.unknownPackage;
        }

        @Override
        public boolean isInterface() {
            return false;
        }

        @Override
        public boolean isOrdinaryInterface() {
            return false;
        }

        @Override
        public boolean isAnnotationType() {
            return true;
        }

        @Override
        public boolean isEnumType() {
            return false;
        }

        @Override
        public boolean isOrdinaryClass() {
            return true;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public List<ClassType> getSupertypes() {
            return Collections.singletonList(DefaultNameInfo.this.getJavaLangObject());
        }

        @Override
        public List<ClassType> getAllSupertypes() {
            ArrayList<ClassType> result = new ArrayList<ClassType>();
            result.add(this);
            result.add(DefaultNameInfo.this.getJavaLangObject());
            result.trimToSize();
            return result;
        }

        @Override
        public List<? extends Field> getFields() {
            return DefaultNameInfo.this.getJavaLangObject().getFields();
        }

        @Override
        public List<Field> getAllFields() {
            return DefaultNameInfo.this.getJavaLangObject().getAllFields();
        }

        @Override
        public List<Method> getMethods() {
            return DefaultNameInfo.this.getJavaLangObject().getMethods();
        }

        @Override
        public List<Method> getAllMethods() {
            return DefaultNameInfo.this.getJavaLangObject().getAllMethods();
        }

        public List<Constructor> getConstructors() {
            return Collections.emptyList();
        }

        @Override
        public List<ClassType> getAllTypes() {
            return Collections.emptyList();
        }

        public List<AnnotationUseSpecification> getAnnotations() {
            return null;
        }

        public List<? extends EnumConstant> getEnumConstants() {
            return null;
        }

        public List<TypeParameterDeclaration> getTypeParameters() {
            return null;
        }

        @Override
        public String getFullSignature() {
            return this.getFullName();
        }

        @Override
        public ArrayType createArrayType() {
            if (this.arrayType == null) {
                this.arrayType = new ArrayType(this, DefaultNameInfo.this.getServiceConfiguration().getImplicitElementInfo());
            }
            return this.arrayType;
        }

        @Override
        public ArrayType getArrayType() {
            return this.arrayType;
        }

        @Override
        public ErasedType getErasedType() {
            return this.erasedType;
        }

        @Override
        public boolean isInner() {
            return false;
        }

        @Override
        public ClassType getBaseClassType() {
            return this;
        }
    }

    class UnknownConstructor
    extends UnknownMethod
    implements Constructor {
        UnknownConstructor() {
        }

        @Override
        public String getName() {
            return "<unknownConstructor>";
        }
    }

    class UnknownField
    extends UnknownMember
    implements Field {
        UnknownField() {
        }

        @Override
        public String getName() {
            return "<unknownField>";
        }

        @Override
        public Type getType() {
            return DefaultNameInfo.this.unknownType;
        }

        public List<AnnotationUseSpecification> getAnnotations() {
            return null;
        }

        @Override
        public List<? extends TypeArgument> getTypeArguments() {
            return null;
        }
    }

    abstract class UnknownMember
    extends UnknownProgramModelElement
    implements Member {
        UnknownMember() {
        }

        @Override
        public ClassType getContainingClassType() {
            return DefaultNameInfo.this.unknownClassType;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isPrivate() {
            return false;
        }

        @Override
        public boolean isProtected() {
            return false;
        }

        @Override
        public boolean isPublic() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isStrictFp() {
            return false;
        }
    }

    class UnknownMethod
    extends UnknownMember
    implements Method {
        UnknownMethod() {
        }

        @Override
        public String getName() {
            return "<unknownMethod>";
        }

        @Override
        public Package getPackage() {
            return DefaultNameInfo.this.unknownPackage;
        }

        @Override
        public ClassTypeContainer getContainer() {
            return DefaultNameInfo.this.unknownClassType;
        }

        public List<ClassType> getTypes() {
            return Collections.emptyList();
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isNative() {
            return false;
        }

        @Override
        public boolean isStrictFp() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public List<ClassType> getExceptions() {
            return Collections.emptyList();
        }

        @Override
        public Type getReturnType() {
            return DefaultNameInfo.this.unknownType;
        }

        @Override
        public List<Type> getSignature() {
            return Collections.emptyList();
        }

        @Override
        public boolean isVarArgMethod() {
            return false;
        }

        public List<AnnotationUseSpecification> getAnnotations() {
            return null;
        }

        @Override
        public List<? extends TypeParameter> getTypeParameters() {
            return null;
        }
    }

    class UnknownProgramModelElement
    implements ProgramModelElement {
        UnknownProgramModelElement() {
        }

        @Override
        public String getName() {
            return "<unkownElement>";
        }

        @Override
        public String getFullName() {
            return this.getName();
        }

        @Override
        public String getBinaryName() {
            return this.getFullName();
        }

        @Override
        public ProgramModelInfo getProgramModelInfo() {
            return DefaultNameInfo.this.unknownProgramModelInfo;
        }

        @Override
        public void setProgramModelInfo(ProgramModelInfo pmi) {
        }

        @Override
        public void validate() {
        }

        public UnknownProgramModelElement deepClone() {
            throw new UnsupportedOperationException("Cannot deep-clone implicit information");
        }
    }

    private class UnknownProgramModelElementInfo
    extends DefaultProgramModelInfo {
        UnknownProgramModelElementInfo() {
            super(DefaultNameInfo.this.getServiceConfiguration());
        }

        @Override
        public ClassTypeContainer getClassTypeContainer(ClassType ct) {
            return DefaultNameInfo.this.unknownClassType;
        }

        @Override
        public List<? extends Constructor> getConstructors(ClassType ct) {
            ArrayList<Constructor> res = new ArrayList<Constructor>(1);
            res.add(DefaultNameInfo.this.unknownConstructor);
            return res;
        }

        @Override
        public ClassType getContainingClassType(Member m) {
            return DefaultNameInfo.this.unknownClassType;
        }

        @Override
        public List<ClassType> getExceptions(Method m) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends Field> getFields(ClassType ct) {
            return Collections.emptyList();
        }

        @Override
        public List<Method> getMethods(ClassType ct) {
            return Collections.emptyList();
        }

        @Override
        public Package getPackage(ProgramModelElement pme) {
            return DefaultNameInfo.this.unknownPackage;
        }

        @Override
        public Type getReturnType(Method m) {
            return DefaultNameInfo.this.unknownType;
        }

        @Override
        public List<Type> getSignature(Method m) {
            return null;
        }

        @Override
        public List<ClassType> getSupertypes(ClassType ct) {
            return null;
        }

        @Override
        public Type getType(ProgramModelElement pme) {
            return null;
        }

        @Override
        public List<? extends ClassType> getTypes(ClassTypeContainer ctc) {
            return null;
        }
    }

    class UnknownVariable
    extends UnknownProgramModelElement
    implements Variable {
        UnknownVariable() {
        }

        @Override
        public String getName() {
            return "<unknownVariable>";
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public Type getType() {
            return DefaultNameInfo.this.unknownType;
        }
    }
}

