/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import recoder.ServiceConfiguration;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.DefaultConstructor;
import recoder.abstraction.DummyGetClassMethod;
import recoder.abstraction.ErasedConstructor;
import recoder.abstraction.ErasedField;
import recoder.abstraction.ErasedMethod;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Field;
import recoder.abstraction.ImplicitEnumMethod;
import recoder.abstraction.ImplicitEnumValueOf;
import recoder.abstraction.ImplicitEnumValues;
import recoder.abstraction.IntersectionType;
import recoder.abstraction.Member;
import recoder.abstraction.Method;
import recoder.abstraction.NullType;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedConstructor;
import recoder.abstraction.ParameterizedField;
import recoder.abstraction.ParameterizedMethod;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.ResolvedGenericMethod;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.java.declaration.EnumDeclaration;
import recoder.service.DefaultProgramModelInfo;
import recoder.service.ImplicitElementInfo;
import recoder.service.NameInfo;
import recoder.service.ProgramModelInfo;
import recoder.util.Debug;

public class DefaultImplicitElementInfo
extends DefaultProgramModelInfo
implements ImplicitElementInfo {
    private final Map<ClassType, DefaultConstructor> type2defaultConstructor = new IdentityHashMap<ClassType, DefaultConstructor>();
    private final Map<EnumDeclaration, List<ImplicitEnumMethod>> type2implicitEnumMethods = new IdentityHashMap<EnumDeclaration, List<ImplicitEnumMethod>>();
    private final Map<Method, Type> methodToReturnType = new IdentityHashMap<Method, Type>();
    private final Map<ParameterizedMethod, List<ClassType>> methodToExceptions = new IdentityHashMap<ParameterizedMethod, List<ClassType>>();
    private final Map<Method, List<Type>> methodToSig = new IdentityHashMap<Method, List<Type>>();
    private List<ClassType> enumValueOfExceptions = null;
    private HashMap<ParameterizedType, ParameterizedType> ptypes = new HashMap();

    public DefaultImplicitElementInfo(ServiceConfiguration config) {
        super(config);
    }

    @Override
    public DefaultConstructor getDefaultConstructor(ClassType ct) {
        Debug.assertNonnull(ct);
        this.updateModel();
        DefaultConstructor cons = this.type2defaultConstructor.get(ct);
        if (cons == null) {
            cons = new DefaultConstructor(ct);
            cons.setProgramModelInfo(this);
            this.type2defaultConstructor.put(ct, cons);
        }
        return cons;
    }

    @Override
    public List<ImplicitEnumMethod> getImplicitEnumMethods(EnumDeclaration etd) {
        if (etd == null) {
            throw new NullPointerException();
        }
        this.updateModel();
        List<ImplicitEnumMethod> res = this.type2implicitEnumMethods.get(etd);
        if (res == null) {
            res = new ArrayList<ImplicitEnumMethod>(2);
            ImplicitEnumMethod meth = new ImplicitEnumValueOf(etd);
            meth.setProgramModelInfo(this);
            res.add(meth);
            meth = new ImplicitEnumValues(etd);
            meth.setProgramModelInfo(this);
            res.add(meth);
            this.type2implicitEnumMethods.put(etd, res);
        }
        return res;
    }

    @Override
    public Type getType(ProgramModelElement pme) {
        if (pme instanceof NullType || pme instanceof ArrayType || pme instanceof IntersectionType || pme instanceof ErasedType || pme instanceof TypeArgument.CapturedTypeArgument) {
            return (Type)pme;
        }
        if (pme instanceof Package) {
            return null;
        }
        if (pme instanceof ErasedField) {
            return this.eraseType(((ErasedField)pme).getGenericField().getType());
        }
        if (pme instanceof ParameterizedField) {
            ParameterizedField pf = (ParameterizedField)pme;
            Type genRet = pf.getGenericField().getType();
            return this.replaceAllTypeParametersWithArgs(genRet, pf.getContainingClassType().getDefinedTypeParameters(), pf.getContainingClassType().getAllTypeArgs());
        }
        if (pme instanceof ArrayType.ArrayLengthField) {
            return this.getNameInfo().getIntType();
        }
        return this.getReturnType((Method)pme);
    }

    @Override
    public Package getPackage(ProgramModelElement pme) {
        if (pme instanceof Package) {
            return (Package)pme;
        }
        if (pme instanceof DefaultConstructor || pme instanceof ImplicitEnumMethod) {
            this.updateModel();
            return this.getContainingClassType((Method)pme).getPackage();
        }
        return null;
    }

    @Override
    public List<? extends ClassType> getTypes(ClassTypeContainer ctc) {
        if (ctc instanceof Package) {
            return this.serviceConfiguration.getNameInfo().getTypes((Package)ctc);
        }
        if (ctc instanceof DefaultConstructor) {
            return Collections.emptyList();
        }
        if (ctc instanceof ErasedMethod) {
            return this.eraseTypes(((ErasedMethod)ctc).getGenericMethod().getTypes());
        }
        if (ctc instanceof ErasedType) {
            return this.eraseTypes(((ErasedType)ctc).getGenericType().getTypes());
        }
        if (ctc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)ctc;
            List<? extends ClassType> genericTypes = pt.getGenericType().getTypes();
            ArrayList<ClassType> res = new ArrayList<ClassType>(genericTypes.size());
            for (ClassType classType : genericTypes) {
                if (classType.isInner()) {
                    res.add(this.getParameterizedType(classType, null, (ParameterizedType)ctc));
                    continue;
                }
                res.add(classType);
            }
            return res;
        }
        if (ctc instanceof ResolvedGenericMethod) {
            throw new RuntimeException();
        }
        return null;
    }

    @Override
    public List<ClassType> getAllTypes(ClassType ct) {
        if (ct instanceof ErasedType || ct instanceof ParameterizedType || ct instanceof IntersectionType) {
            return super.getAllTypes(ct);
        }
        assert (ct == this.getNameInfo().getNullType() || ct instanceof ArrayType) : ct.getClass().getName();
        return null;
    }

    @Override
    public ClassTypeContainer getClassTypeContainer(ClassType ct) {
        assert (ct == this.getNameInfo().getNullType());
        return null;
    }

    private ClassType makeParentParameterizedType(ParameterizedType subType, ClassType st) {
        if (!(st instanceof ParameterizedType)) {
            return st;
        }
        ParameterizedType superType = (ParameterizedType)st;
        ClassType res = this.replaceAllTypeParametersWithArgs(superType, subType.getDefinedTypeParameters(), subType.getAllTypeArgs());
        return res;
    }

    @Override
    public List<ClassType> getSupertypes(ClassType ct) {
        if (ct instanceof IntersectionType) {
            return ((IntersectionType)ct).getSupertypes();
        }
        if (ct instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)ct;
            List<TypeArgument> typeArgs = pt.getAllTypeArgs();
            boolean allNonWildcard = true;
            for (TypeArgument ta : typeArgs) {
                if (ta.getWildcardMode() == TypeArgument.WildcardMode.None) continue;
                allNonWildcard = false;
                break;
            }
            ArrayList<ClassType> res = new ArrayList<ClassType>();
            res.add(pt.getGenericType().getErasedType());
            List<ClassType> genericSupers = pt.getGenericType().getSupertypes();
            for (ClassType genSuper : genericSupers) {
                res.add(this.makeParentParameterizedType(pt, genSuper));
            }
            res.trimToSize();
            return res;
        }
        if (ct instanceof ErasedType) {
            ErasedType rt = (ErasedType)ct;
            List<ClassType> genericSupers = rt.getGenericType().getSupertypes();
            ArrayList<ClassType> res = new ArrayList<ClassType>(genericSupers.size());
            for (ClassType sup : genericSupers) {
                res.add(sup.getErasedType());
            }
            return res;
        }
        if (ct instanceof NullType) {
            return null;
        }
        if (ct instanceof ArrayType) {
            ArrayList<ClassType> res = new ArrayList<ClassType>();
            NameInfo ni = this.getNameInfo();
            ArrayType at = (ArrayType)ct;
            Type baseType = at.getBaseType();
            if (baseType instanceof PrimitiveType || baseType == ni.getJavaLangObject()) {
                res.add(ni.getJavaIoSerializable());
                res.add(ni.getJavaLangCloneable());
                res.add(ni.getJavaLangObject());
            } else {
                List<ClassType> baseTypesSupers = ((ClassType)baseType).getSupertypes();
                for (ClassType sup : baseTypesSupers) {
                    res.add(ni.createArrayType(sup));
                }
            }
            res.trimToSize();
            return res;
        }
        if (ct instanceof TypeArgument.CapturedTypeArgument) {
            TypeArgument.CapturedTypeArgument cta = (TypeArgument.CapturedTypeArgument)ct;
            TypeArgument ta = cta.getTypeArgument();
            if (ta.getWildcardMode() == TypeArgument.WildcardMode.Any || ta.getWildcardMode() == TypeArgument.WildcardMode.Super) {
                return ta.getTargetedTypeParameter().getSupertypes();
            }
            return this.getBaseType(ta).getSupertypes();
        }
        return ct.getProgramModelInfo().getSupertypes(ct);
    }

    @Override
    public List<ClassType> getAllSupertypes(ClassType ct) {
        ProgramModelInfo pmi = ct.getProgramModelInfo();
        if (pmi != this) {
            return pmi.getAllSupertypes(ct);
        }
        if (ct instanceof ParameterizedType || ct instanceof ArrayType || ct instanceof IntersectionType || ct instanceof ErasedType || ct instanceof TypeArgument.CapturedTypeArgument) {
            return super.getAllSupertypes(ct);
        }
        if (ct instanceof NullType) {
            ArrayList<ClassType> result = new ArrayList<ClassType>(1);
            result.add(ct);
            return result;
        }
        throw new RuntimeException("DefaultImplicitElementInfo not a valid service for " + ct.getClass().getName());
    }

    @Override
    public List<? extends Field> getFields(ClassType ct) {
        if (ct instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)ct;
            List<? extends Field> temp = pt.getGenericType().getFields();
            ArrayList<Field> res = new ArrayList<Field>(temp.size());
            for (Field field : temp) {
                if (this.getServiceConfiguration().getSourceInfo().containsTypeParameter(field)) {
                    res.add(new ParameterizedField(field, pt, this));
                    continue;
                }
                res.add(field);
            }
            return res;
        }
        if (ct instanceof ArrayType) {
            ArrayType at = (ArrayType)ct;
            ArrayList<ArrayType.ArrayLengthField> res = new ArrayList<ArrayType.ArrayLengthField>(1);
            res.add(at.getArrayLengthField());
            return res;
        }
        if (ct instanceof ErasedType) {
            ErasedType et = (ErasedType)ct;
            List<? extends Field> genericFields = et.getGenericType().getFields();
            ArrayList<Field> res = new ArrayList<Field>(genericFields.size());
            for (Field field : genericFields) {
                if (field.isStatic()) {
                    res.add(field);
                    continue;
                }
                res.add(new ErasedField(field, this));
            }
            return res;
        }
        if (ct instanceof TypeArgument.CapturedTypeArgument) {
            TypeArgument ta = ((TypeArgument.CapturedTypeArgument)ct).getTypeArgument();
            if (ta.getWildcardMode() == TypeArgument.WildcardMode.Any || ta.getWildcardMode() == TypeArgument.WildcardMode.Super) {
                return Collections.emptyList();
            }
            return this.getBaseType(ta).getFields();
        }
        assert (ct == this.getNameInfo().getNullType());
        return null;
    }

    @Override
    public List<Field> getAllFields(ClassType ct) {
        if (ct instanceof IntersectionType || ct instanceof ParameterizedType || ct instanceof ArrayType || ct instanceof ErasedType || ct instanceof TypeArgument.CapturedTypeArgument) {
            return super.getAllFields(ct);
        }
        return null;
    }

    @Override
    public List<Method> getMethods(ClassType ct) {
        if (ct instanceof ArrayType) {
            ArrayList<Method> res = new ArrayList<Method>(2);
            ArrayType at = (ArrayType)ct;
            res.add(at.getArrayCloneMethod());
            return res;
        }
        if (ct instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)ct;
            List<Method> temp = pt.getGenericType().getMethods();
            ArrayList<Method> res = new ArrayList<Method>(temp.size());
            Iterator<Method> iterator = temp.iterator();
            while (iterator.hasNext()) {
                Type ret;
                Method m;
                Method pm = m = iterator.next();
                if (this.getServiceConfiguration().getSourceInfo().containsTypeParameter(m)) {
                    pm = new ParameterizedMethod(m, pt, this);
                }
                if ((ret = m.getReturnType()) instanceof ClassType) {
                    ((ClassType)ret).isInner();
                }
                res.add(pm);
            }
            return res;
        }
        if (ct instanceof ErasedType) {
            ErasedType et = (ErasedType)ct;
            List<Method> methods = et.getGenericType().getMethods();
            ArrayList<Method> res = new ArrayList<Method>(methods.size());
            for (Method m : methods) {
                if (m.isStatic()) {
                    res.add(m);
                    continue;
                }
                res.add(new ErasedMethod(m, this));
            }
            return res;
        }
        if (ct instanceof TypeArgument.CapturedTypeArgument) {
            TypeArgument ta = ((TypeArgument.CapturedTypeArgument)ct).getTypeArgument();
            if (ta.getWildcardMode() == TypeArgument.WildcardMode.Any || ta.getWildcardMode() == TypeArgument.WildcardMode.Super) {
                return Collections.emptyList();
            }
            return this.getBaseType(ta).getMethods();
        }
        if (ct instanceof IntersectionType) {
            return null;
        }
        assert (ct == this.getNameInfo().getNullType()) : ct;
        return null;
    }

    @Override
    public List<Method> getAllMethods(ClassType ct) {
        if (ct instanceof IntersectionType || ct instanceof ParameterizedType || ct instanceof ArrayType || ct instanceof ErasedType || ct instanceof TypeArgument.CapturedTypeArgument) {
            return super.getAllMethods(ct);
        }
        return null;
    }

    public List<Constructor> getConstructors(ClassType ct) {
        if (ct instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)ct;
            List<? extends Constructor> temp = pt.getGenericType().getConstructors();
            ArrayList<Constructor> res = new ArrayList<Constructor>(temp.size());
            for (Constructor constructor : temp) {
                if (this.getServiceConfiguration().getSourceInfo().containsTypeParameter(constructor)) {
                    res.add(new ParameterizedConstructor(constructor, pt, this));
                    continue;
                }
                res.add(constructor);
            }
            return res;
        }
        if (ct instanceof ErasedType) {
            ErasedType et = (ErasedType)ct;
            List<? extends Constructor> cons = et.getGenericType().getConstructors();
            ArrayList<Constructor> res = new ArrayList<Constructor>(cons.size());
            for (Constructor constructor : cons) {
                res.add(new ErasedConstructor(constructor, this));
            }
            return res;
        }
        if (ct instanceof ArrayType) {
            return Collections.emptyList();
        }
        if (ct instanceof TypeArgument.CapturedTypeArgument) {
            return null;
        }
        assert (ct == this.getNameInfo().getNullType());
        return null;
    }

    @Override
    public ClassType getContainingClassType(Member m) {
        if (m instanceof DefaultConstructor || m instanceof ImplicitEnumMethod) {
            return m.getContainingClassType();
        }
        return null;
    }

    @Override
    public List<Type> getSignature(Method m) {
        if (m instanceof ImplicitEnumValueOf) {
            ArrayList<Type> tal = new ArrayList<Type>(1);
            tal.add(this.getServiceConfiguration().getNameInfo().getJavaLangString());
            return tal;
        }
        if (m instanceof DefaultConstructor || m instanceof ArrayType.ArrayCloneMethod || m instanceof ImplicitEnumValues) {
            return Collections.emptyList();
        }
        List<Type> res = this.methodToSig.get(m);
        if (res != null) {
            return res;
        }
        if (m instanceof ParameterizedMethod) {
            ParameterizedMethod pm = (ParameterizedMethod)m;
            res = this.replaceAllTypeParametersWithArgs(pm.getGenericMethod().getSignature(), (List<? extends TypeParameter>)pm.getContainingClassType().getDefinedTypeParameters(), (List<? extends TypeArgument>)pm.getContainingClassType().getAllTypeArgs());
        } else if (m instanceof ErasedMethod) {
            res = this.eraseTypes(((ErasedMethod)m).getGenericMethod().getSignature());
        } else if (m instanceof ResolvedGenericMethod) {
            ResolvedGenericMethod rgm = (ResolvedGenericMethod)m;
            res = this.replaceAllTypeParameters(rgm.getGenericMethod().getSignature(), rgm.getGenericMethod().getTypeParameters(), rgm.getReplacementType(), false);
        }
        this.methodToSig.put(m, res);
        return res;
    }

    @Override
    public List<ClassType> getExceptions(Method m) {
        if (m instanceof ImplicitEnumValueOf) {
            if (this.enumValueOfExceptions == null) {
                this.enumValueOfExceptions = new ArrayList<ClassType>(2);
                this.enumValueOfExceptions.add(this.getNameInfo().getClassType("java.lang.IllegalArgumentException"));
                this.enumValueOfExceptions.add(this.getNameInfo().getClassType("java.lang.NullPointerException"));
                this.enumValueOfExceptions = Collections.unmodifiableList(this.enumValueOfExceptions);
            }
            return this.enumValueOfExceptions;
        }
        if (m instanceof ParameterizedMethod) {
            ParameterizedMethod pm = (ParameterizedMethod)m;
            List<ClassType> res = this.methodToExceptions.get(pm);
            if (res == null) {
                res = this.replaceAllTypeParametersWithArgs(pm.getGenericMethod().getExceptions(), (List<? extends TypeParameter>)pm.getContainingClassType().getDefinedTypeParameters(), (List<? extends TypeArgument>)pm.getContainingClassType().getAllTypeArgs());
                this.methodToExceptions.put(pm, res);
            }
            return res;
        }
        if (m instanceof ErasedMethod) {
            return this.eraseTypes(((ErasedMethod)m).getGenericMethod().getExceptions());
        }
        if (m instanceof ResolvedGenericMethod) {
            ResolvedGenericMethod rgm = (ResolvedGenericMethod)m;
            return this.replaceAllTypeParameters(rgm.getGenericMethod().getExceptions(), rgm.getGenericMethod().getTypeParameters(), rgm.getReplacementType(), false);
        }
        assert (m instanceof DefaultConstructor || m instanceof ImplicitEnumValues);
        return Collections.emptyList();
    }

    @Override
    public Type getReturnType(Method m) {
        if (m instanceof DummyGetClassMethod) {
            Type returnType = this.methodToReturnType.get(m);
            if (returnType == null) {
                ClassType ct = this.getNameInfo().getJavaLangClass();
                DefaultProgramModelInfo.ResolvedTypeArgument ta = new DefaultProgramModelInfo.ResolvedTypeArgument(this, TypeArgument.WildcardMode.Extends, (ClassType)this.eraseType(((DummyGetClassMethod)m).getParentClass()), null);
                ArrayList<DefaultProgramModelInfo.ResolvedTypeArgument> tas = new ArrayList<DefaultProgramModelInfo.ResolvedTypeArgument>(1);
                tas.add(ta);
                returnType = this.getParameterizedType(ct, tas);
                this.methodToReturnType.put(m, returnType);
            }
            return returnType;
        }
        if (m instanceof ImplicitEnumValueOf) {
            return m.getContainingClassType();
        }
        if (m instanceof ImplicitEnumValues) {
            return this.getServiceConfiguration().getNameInfo().createArrayType(m.getContainingClassType());
        }
        if (m instanceof ParameterizedMethod) {
            Type res = this.methodToReturnType.get(m);
            if (res == null) {
                ParameterizedMethod pm = (ParameterizedMethod)m;
                Type genRet = pm.getGenericMethod().getReturnType();
                res = this.replaceAllTypeParametersWithArgs(genRet, pm.getContainingClassType().getDefinedTypeParameters(), pm.getContainingClassType().getAllTypeArgs(), pm.getGenericMethod().getTypeParameters());
                this.methodToReturnType.put(m, res);
            }
            return res;
        }
        if (m instanceof ArrayType.ArrayCloneMethod) {
            if (this.getServiceConfiguration().getProjectSettings().java5Allowed()) {
                ArrayType.ArrayCloneMethod acm = (ArrayType.ArrayCloneMethod)m;
                return acm.getContainingClassType();
            }
            return this.getServiceConfiguration().getNameInfo().getJavaLangObject();
        }
        if (m instanceof ErasedMethod) {
            return this.eraseType(((ErasedMethod)m).getGenericMethod().getReturnType());
        }
        if (m instanceof ResolvedGenericMethod) {
            ResolvedGenericMethod rgm = (ResolvedGenericMethod)m;
            Type res = rgm.getGenericMethod().getReturnType();
            if (res == null) {
                return null;
            }
            res = this.replaceAllTypeParameters(res, rgm.getGenericMethod().getTypeParameters(), rgm.getReplacementType(), true);
            return res;
        }
        assert (m instanceof DefaultConstructor);
        return null;
    }

    @Override
    public ParameterizedType getParameterizedType(ClassType genericType, List<? extends TypeArgument> typeArgs) {
        return this.getParameterizedType(genericType, typeArgs, null);
    }

    @Override
    public ParameterizedType getParameterizedType(ClassType innerGenericType, List<? extends TypeArgument> typeArgs, ParameterizedType enclosingType) {
        ParameterizedType newRes = new ParameterizedType(innerGenericType, typeArgs, enclosingType, this);
        ParameterizedType oldRes = this.ptypes.get(newRes);
        if (oldRes != null) {
            return oldRes;
        }
        this.ptypes.put(newRes, newRes);
        return newRes;
    }

    @Override
    public void reset() {
        super.reset();
        this.methodToReturnType.clear();
        this.methodToExceptions.clear();
        this.methodToSig.clear();
        this.ptypes.clear();
    }
}

