/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import recoder.ServiceConfiguration;
import recoder.abstraction.AnnotationProperty;
import recoder.abstraction.ClassType;
import recoder.abstraction.Constructor;
import recoder.abstraction.DummyGetClassMethod;
import recoder.abstraction.ErasedConstructor;
import recoder.abstraction.ErasedField;
import recoder.abstraction.ErasedMethod;
import recoder.abstraction.ErasedType;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedConstructor;
import recoder.abstraction.ParameterizedField;
import recoder.abstraction.ParameterizedMethod;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.ResolvedGenericMethod;
import recoder.abstraction.Type;
import recoder.abstraction.Variable;
import recoder.convenience.Format;
import recoder.convenience.TreeWalker;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.Import;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.declaration.AnnotationElementValuePair;
import recoder.java.declaration.InheritanceSpecification;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.VariableDeclaration;
import recoder.java.expression.operator.New;
import recoder.java.reference.AnnotationPropertyReference;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.java.reference.VariableReference;
import recoder.service.AttachChange;
import recoder.service.ChangeHistoryEvent;
import recoder.service.ClassTypeTopSort;
import recoder.service.CrossReferenceSourceInfo;
import recoder.service.DefaultNameInfo;
import recoder.service.DefaultProgramModelInfo;
import recoder.service.DefaultSourceInfo;
import recoder.service.DetachChange;
import recoder.service.ProgramModelInfo;
import recoder.service.TreeChange;
import recoder.service.UnresolvedReferenceException;
import recoder.util.Debug;
import recoder.util.ProgressEvent;

public class DefaultCrossReferenceSourceInfo
extends DefaultSourceInfo
implements CrossReferenceSourceInfo {
    private final Map<ProgramModelElement, Set<Reference>> element2references = new HashMap<ProgramModelElement, Set<Reference>>(256);
    private DefaultSourceInfo.FastWorkList worklist = new DefaultSourceInfo.FastWorkList();
    private Stack<NonTerminalProgramElement> NTEs = new Stack();

    public DefaultCrossReferenceSourceInfo(ServiceConfiguration config) {
        super(config);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void modelChanged(ChangeHistoryEvent changes) {
        ProgramElement pe;
        TreeChange tc;
        TreeChange tc2;
        List<TreeChange> changed = changes.getChanges();
        int s = changed.size();
        int c = 0;
        this.listeners.fireProgressEvent(0, 3 * s, "Building Scopes");
        int i = 0;
        while (i < s) {
            tc2 = changed.get(i);
            if (tc2 instanceof DetachChange) {
                if (!tc2.isMinor()) {
                    this.processChange(tc2);
                }
                this.listeners.fireProgressEvent(++c);
            }
            ++i;
        }
        i = 0;
        while (i < s) {
            tc2 = changed.get(i);
            if (tc2 instanceof AttachChange) {
                if (!tc2.isMinor()) {
                    this.processChange(tc2);
                }
                this.listeners.fireProgressEvent(++c);
            }
            ++i;
        }
        this.listeners.fireProgressEvent(c, "Resolving References");
        TreeWalker tw = new TreeWalker(null);
        int i2 = 0;
        while (i2 < s) {
            tc = changed.get(i2);
            if (tc instanceof DetachChange) {
                if (!tc.isMinor()) {
                    pe = tc.getChangeRoot();
                    boolean rippleEffect = this.isPossiblyShowingRippleEffect(tc);
                    if (pe instanceof TypeArgumentDeclaration) {
                        this.reset(true);
                        return;
                    }
                    if (pe instanceof Reference) {
                        if (rippleEffect) {
                            this.reset(true);
                            return;
                        }
                        this.deregisterReference((Reference)pe);
                    } else {
                        if (pe instanceof ProgramModelElement || pe instanceof VariableDeclaration) {
                            this.reset(true);
                            return;
                        }
                        if (pe instanceof InheritanceSpecification) {
                            this.reset(true);
                            return;
                        }
                        if (pe instanceof AnnotationElementValuePair) {
                            this.reset(true);
                            return;
                        }
                        if (pe instanceof Import) {
                            this.reset(true);
                            return;
                        }
                    }
                    tw.reset(pe);
                    tw.next();
                    while (tw.next()) {
                        ProgramElement p = tw.getProgramElement();
                        if (!(p instanceof Reference)) continue;
                        this.deregisterReference((Reference)p);
                    }
                }
                this.listeners.fireProgressEvent(++c);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < s) {
            tc = changed.get(i2);
            if (tc instanceof AttachChange) {
                if (!tc.isMinor()) {
                    pe = tc.getChangeRoot();
                    if (pe instanceof TypeArgumentDeclaration) {
                        this.reset(true);
                        return;
                    }
                    if (pe instanceof Reference) {
                        if (!(pe instanceof Expression) || this.isPossiblyShowingRippleEffect(tc)) {
                            this.reset(true);
                            return;
                        }
                    } else {
                        if (pe instanceof ProgramModelElement || pe instanceof VariableDeclaration) {
                            this.reset(true);
                            return;
                        }
                        if (pe instanceof InheritanceSpecification) {
                            this.reset(true);
                            return;
                        }
                        if (pe instanceof AnnotationElementValuePair) {
                            this.reset(true);
                            return;
                        }
                        if (pe instanceof Import) {
                            this.reset(true);
                            return;
                        }
                    }
                }
                this.listeners.fireProgressEvent(++c);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < s) {
            tc = changed.get(i2);
            if (!tc.isMinor() && tc instanceof AttachChange) {
                AttachChange ac = (AttachChange)tc;
                ProgramElement pe2 = ac.getChangeRoot();
                this.analyzeReferences(pe2);
            }
            this.listeners.fireProgressEvent(++c);
            ++i2;
        }
    }

    private boolean isPossiblyShowingRippleEffect(TreeChange tc) {
        return true;
    }

    @Override
    public List<MemberReference> getReferences(Method m) {
        Debug.assertNonnull(m);
        this.updateModel();
        m = this.getBaseMethod(m);
        Set<Reference> references = this.element2references.get(m);
        if (references == null) {
            return Collections.emptyList();
        }
        int s = references.size();
        if (s == 0) {
            return Collections.emptyList();
        }
        ArrayList<MemberReference> result = new ArrayList<MemberReference>(s);
        for (Reference o : references) {
            result.add((MemberReference)o);
        }
        return result;
    }

    @Override
    public List<ConstructorReference> getReferences(Constructor c) {
        Debug.assertNonnull(c);
        this.updateModel();
        c = this.getBaseConstructor(c);
        Set<Reference> references = this.element2references.get(c);
        if (references == null) {
            return Collections.emptyList();
        }
        int s = references.size();
        if (s == 0) {
            return Collections.emptyList();
        }
        ArrayList<ConstructorReference> result = new ArrayList<ConstructorReference>(s);
        for (Reference o : references) {
            result.add((ConstructorReference)o);
        }
        return result;
    }

    @Override
    public List<VariableReference> getReferences(Variable v) {
        Debug.assertNonnull(v);
        this.updateModel();
        Set<Reference> references = this.element2references.get(v);
        if (references == null) {
            return Collections.emptyList();
        }
        int s = references.size();
        if (s == 0) {
            return Collections.emptyList();
        }
        ArrayList<VariableReference> result = new ArrayList<VariableReference>(s);
        for (Reference o : references) {
            result.add((VariableReference)o);
        }
        return result;
    }

    @Override
    public List<FieldReference> getReferences(Field f) {
        Debug.assertNonnull(f);
        this.updateModel();
        f = (Field)this.getBaseField(f);
        Set<Reference> references = this.element2references.get(f);
        if (references == null) {
            return Collections.emptyList();
        }
        int s = references.size();
        if (s == 0) {
            return Collections.emptyList();
        }
        ArrayList<FieldReference> result = new ArrayList<FieldReference>(s);
        for (Reference r : references) {
            result.add((FieldReference)r);
        }
        return result;
    }

    @Override
    public List<TypeReference> getReferences(Type t) {
        Debug.assertNonnull(t);
        this.updateModel();
        t = this.getBaseType(t);
        Set<Reference> references = this.element2references.get(t);
        if (references == null) {
            return Collections.emptyList();
        }
        int s = references.size();
        if (s == 0) {
            return Collections.emptyList();
        }
        ArrayList<TypeReference> result = new ArrayList<TypeReference>(s);
        for (Reference r : references) {
            result.add((TypeReference)r);
        }
        return result;
    }

    @Override
    public List<TypeReference> getReferences(Type t, boolean includeArrayTypes) {
        if (!includeArrayTypes) {
            return this.getReferences(t);
        }
        if (t == null) {
            throw new NullPointerException();
        }
        this.updateModel();
        ArrayList<TypeReference> result = new ArrayList<TypeReference>();
        t = this.getBaseType(t);
        do {
            Set<Reference> references;
            if ((references = this.element2references.get(t)) == null) continue;
            for (Reference r : references) {
                result.add((TypeReference)r);
            }
        } while ((t = t.getArrayType()) != null);
        result.trimToSize();
        return result;
    }

    @Override
    public List<PackageReference> getReferences(Package p) {
        Debug.assertNonnull(p);
        this.updateModel();
        Set<Reference> references = this.element2references.get(p);
        if (references == null) {
            return Collections.emptyList();
        }
        int s = references.size();
        if (s == 0) {
            return Collections.emptyList();
        }
        ArrayList<PackageReference> result = new ArrayList<PackageReference>(s);
        for (Reference pr : references) {
            result.add((PackageReference)pr);
        }
        return result;
    }

    private void registerVariableReference(VariableReference ref, Variable v) {
        v = this.getBaseField(v);
        this.registerReference(ref, v);
    }

    private Variable getBaseField(Variable v) {
        if (v instanceof ErasedField) {
            v = ((ErasedField)v).getGenericField();
        }
        while (v instanceof ParameterizedField) {
            v = ((ParameterizedField)v).getGenericField();
        }
        return v;
    }

    private void registerMethodReference(MethodReference ref, Method m) {
        m = this.getBaseMethod(m);
        this.registerReference(ref, m);
    }

    private Method getBaseMethod(Method m) {
        if (m instanceof DummyGetClassMethod) {
            m = this.findObjectGetClass();
        }
        if (m instanceof ErasedMethod) {
            m = ((ErasedMethod)m).getGenericMethod();
        }
        while (m instanceof ParameterizedMethod) {
            m = ((ParameterizedMethod)m).getGenericMethod();
        }
        if (m instanceof ResolvedGenericMethod) {
            m = ((ResolvedGenericMethod)m).getGenericMethod();
        }
        while (m instanceof ParameterizedMethod) {
            m = ((ParameterizedMethod)m).getGenericMethod();
        }
        return m;
    }

    private Method findObjectGetClass() {
        ClassType ct = this.getNameInfo().getJavaLangObject();
        for (Method m : ct.getMethods()) {
            if (m.getName() != GETCLASS_NAME) continue;
            return m;
        }
        throw new Error();
    }

    private void registerConstructorReference(ConstructorReference ref, Constructor c) {
        c = this.getBaseConstructor(c);
        this.registerReference(ref, c);
    }

    private Constructor getBaseConstructor(Constructor c) {
        if (c instanceof ErasedConstructor) {
            c = (Constructor)((ErasedConstructor)c).getGenericMethod();
        }
        if (c instanceof ParameterizedConstructor) {
            c = (Constructor)((ParameterizedConstructor)c).getGenericMethod();
        }
        return c;
    }

    private void registerAnnotationPropertyReference(AnnotationPropertyReference ref, AnnotationProperty pme) {
        this.registerReference(ref, pme);
    }

    private void registerTypeReference(TypeReference ref, Type t) {
        t = this.getBaseType(t);
        this.registerReference(ref, t);
    }

    private Type getBaseType(Type t) {
        if (t instanceof ErasedType) {
            t = ((ErasedType)t).getGenericType();
        }
        while (t instanceof ParameterizedType) {
            t = ((ParameterizedType)t).getGenericType();
        }
        return t;
    }

    private void registerPackageReference(PackageReference ref, Package pme) {
        this.registerReference(ref, pme);
    }

    private void registerReference(Reference ref, ProgramModelElement pme) {
        Set<Reference> set = this.element2references.get(pme);
        if (set == null) {
            set = new HashSet<Reference>(4);
            this.element2references.put(pme, set);
        }
        set.add(ref);
    }

    private void deregisterReference(Reference ref) {
        ProgramModelElement pme = (ProgramModelElement)this.reference2element.get(ref);
        if (pme == null) {
            return;
        }
        Set<Reference> set = this.element2references.get(pme);
        if (set == null) {
            return;
        }
        set.remove(ref);
    }

    private void analyzeReferences(ProgramElement pe) {
        this.worklist.add(pe);
        this.NTEs.push(null);
        while (!this.worklist.isEmpty()) {
            pe = this.worklist.peekLast();
            if (pe instanceof NonTerminalProgramElement) {
                NonTerminalProgramElement nt = (NonTerminalProgramElement)pe;
                if (this.NTEs.peek() != nt) {
                    this.NTEs.push(nt);
                    int i = nt.getChildCount() - 1;
                    while (i >= 0) {
                        this.worklist.add(nt.getChildAt(i));
                        --i;
                    }
                    continue;
                }
            } else {
                this.worklist.removeLast();
                continue;
            }
            this.worklist.removeLast();
            this.NTEs.pop();
            if (!(pe instanceof Reference)) continue;
            if (pe instanceof UncollatedReferenceQualifier) {
                try {
                    pe = this.resolveURQ((UncollatedReferenceQualifier)pe);
                }
                catch (ClassCastException cce) {
                    this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f(CR1)", pe), pe));
                }
            }
            if (pe instanceof VariableReference) {
                VariableReference vr = (VariableReference)pe;
                Variable v = this.getVariable(vr);
                if (v == null) {
                    this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f(CR2)", vr), vr));
                    v = this.getNameInfo().getUnknownField();
                }
                this.registerVariableReference(vr, v);
                continue;
            }
            if (pe instanceof TypeReference) {
                TypeReference tr = (TypeReference)pe;
                Type t = this.getType(tr);
                if (t instanceof ParameterizedType) {
                    t = ((ParameterizedType)t).getGenericType();
                }
                if (t == null || t instanceof DefaultNameInfo.UnknownClassType) continue;
                this.registerTypeReference(tr, t);
                if (!(t instanceof ClassType)) continue;
                TypeDeclaration subType = null;
                TypeReferenceContainer parent = tr.getParent();
                if (parent instanceof InheritanceSpecification) {
                    subType = ((InheritanceSpecification)parent).getParent();
                } else if (parent instanceof New) {
                    subType = ((New)parent).getClassDeclaration();
                }
                if (subType == null) continue;
                ClassType superType = (ClassType)t;
                ProgramModelInfo pmi = superType.getProgramModelInfo();
                ((DefaultProgramModelInfo)pmi).registerSubtype(subType, superType);
                continue;
            }
            if (pe instanceof MethodReference) {
                MethodReference mr = (MethodReference)pe;
                Method m = this.getMethod(mr);
                this.registerMethodReference(mr, m);
                continue;
            }
            if (pe instanceof ConstructorReference) {
                ConstructorReference cr = (ConstructorReference)pe;
                Constructor c = this.getConstructor(cr);
                this.registerConstructorReference(cr, c);
                continue;
            }
            if (pe instanceof AnnotationPropertyReference) {
                AnnotationPropertyReference apr = (AnnotationPropertyReference)pe;
                AnnotationProperty ap = this.getAnnotationProperty(apr);
                this.registerAnnotationPropertyReference(apr, ap);
                continue;
            }
            if (!(pe instanceof PackageReference)) continue;
            PackageReference pr = (PackageReference)pe;
            Package p = this.getPackage(pr);
            this.registerPackageReference(pr, p);
        }
    }

    public String information() {
        this.updateModel();
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        int c4 = 0;
        int c5 = 0;
        int r1 = 0;
        int r2 = 0;
        int r3 = 0;
        int r4 = 0;
        int r5 = 0;
        for (ProgramModelElement pme : this.element2references.keySet()) {
            int size;
            Set<Reference> set = this.element2references.get(pme);
            int n = size = set == null ? 0 : set.size();
            if (pme instanceof Variable) {
                ++c1;
                r1 += size;
                continue;
            }
            if (pme instanceof Method) {
                if (pme instanceof Constructor) {
                    ++c3;
                    r3 += size;
                    continue;
                }
                ++c2;
                r2 += size;
                continue;
            }
            if (pme instanceof Type) {
                ++c4;
                r4 += size;
                continue;
            }
            if (!(pme instanceof Package)) continue;
            ++c5;
            r5 += size;
        }
        return c1 + " variables with " + r1 + " references\n" + c2 + " methods with " + r2 + " references\n" + c3 + " constructors with " + r3 + " references\n" + c4 + " types with " + r4 + " references\n" + c5 + " packages with " + r5 + " references";
    }

    private void reset(boolean fire) {
        super.reset();
        this.element2references.clear();
        SourceFileRepository sfr = this.serviceConfiguration.getSourceFileRepository();
        List<CompilationUnit> cul = sfr.getCompilationUnits();
        int c = 0;
        if (fire) {
            ProgressEvent pe = this.listeners.getLastProgressEvent();
            c = pe.getWorkDoneCount();
            this.listeners.fireProgressEvent(c, c + cul.size());
        }
        int i = cul.size() - 1;
        while (i >= 0) {
            CompilationUnit cu = cul.get(i);
            this.analyzeReferences(cu);
            if (fire) {
                this.listeners.fireProgressEvent(++c);
            }
            --i;
        }
    }

    @Override
    public void reset() {
        this.reset(false);
    }

    class SubTypeTopSort
    extends ClassTypeTopSort {
        SubTypeTopSort() {
        }

        @Override
        protected final List<ClassType> getAdjacent(ClassType c) {
            return DefaultCrossReferenceSourceInfo.this.getSubtypes(c);
        }
    }
}

