/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.Stack;
import recoder.AbstractService;
import recoder.ModelException;
import recoder.ServiceConfiguration;
import recoder.abstraction.Field;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.abstraction.Variable;
import recoder.java.Expression;
import recoder.java.JavaProgramFactory;
import recoder.java.Reference;
import recoder.java.expression.Assignment;
import recoder.java.expression.Literal;
import recoder.java.expression.Operator;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.expression.literal.BooleanLiteral;
import recoder.java.expression.literal.CharLiteral;
import recoder.java.expression.literal.DoubleLiteral;
import recoder.java.expression.literal.FloatLiteral;
import recoder.java.expression.literal.IntLiteral;
import recoder.java.expression.literal.LongLiteral;
import recoder.java.expression.literal.NullLiteral;
import recoder.java.expression.literal.StringLiteral;
import recoder.java.expression.operator.BinaryAnd;
import recoder.java.expression.operator.BinaryNot;
import recoder.java.expression.operator.BinaryOr;
import recoder.java.expression.operator.BinaryXOr;
import recoder.java.expression.operator.ComparativeOperator;
import recoder.java.expression.operator.Divide;
import recoder.java.expression.operator.Equals;
import recoder.java.expression.operator.GreaterOrEquals;
import recoder.java.expression.operator.GreaterThan;
import recoder.java.expression.operator.LessOrEquals;
import recoder.java.expression.operator.LessThan;
import recoder.java.expression.operator.LogicalAnd;
import recoder.java.expression.operator.LogicalNot;
import recoder.java.expression.operator.LogicalOr;
import recoder.java.expression.operator.Minus;
import recoder.java.expression.operator.Modulo;
import recoder.java.expression.operator.Negative;
import recoder.java.expression.operator.NotEquals;
import recoder.java.expression.operator.Plus;
import recoder.java.expression.operator.Positive;
import recoder.java.expression.operator.ShiftLeft;
import recoder.java.expression.operator.ShiftRight;
import recoder.java.expression.operator.Times;
import recoder.java.expression.operator.TypeCast;
import recoder.java.expression.operator.TypeOperator;
import recoder.java.expression.operator.UnsignedShiftRight;
import recoder.java.reference.FieldReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.TypeReference;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.java.reference.VariableReference;
import recoder.service.ByteCodeInfo;
import recoder.service.ConstantEvaluator;
import recoder.service.NameInfo;
import recoder.service.ProgramModelInfo;
import recoder.service.SourceInfo;

public class DefaultConstantEvaluator
extends AbstractService
implements ConstantEvaluator {
    private Stack<Expression> visitedVariableReferences = new Stack();
    static final BinaryNumericOperation PLUS = new BinaryNumericOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            this.fail();
            return false;
        }

        @Override
        public int eval(int a, int b) {
            return a + b;
        }

        @Override
        public long eval(long a, long b) {
            return a + b;
        }

        @Override
        public float eval(float a, float b) {
            return a + b;
        }

        @Override
        public double eval(double a, double b) {
            return a + b;
        }

        @Override
        public String eval(String a, String b) {
            if (a == null) {
                this.fail();
                return null;
            }
            return String.valueOf(a) + b;
        }
    };
    static final BinaryNumericOperation MINUS = new BinaryNumericOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            this.fail();
            return false;
        }

        @Override
        public int eval(int a, int b) {
            return a - b;
        }

        @Override
        public long eval(long a, long b) {
            return a - b;
        }

        @Override
        public float eval(float a, float b) {
            return a - b;
        }

        @Override
        public double eval(double a, double b) {
            return a - b;
        }

        @Override
        public String eval(String a, String b) {
            this.fail();
            return null;
        }
    };
    static final BinaryNumericOperation DIVIDE = new BinaryNumericOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            this.fail();
            return false;
        }

        @Override
        public int eval(int a, int b) {
            return a / b;
        }

        @Override
        public long eval(long a, long b) {
            return a / b;
        }

        @Override
        public float eval(float a, float b) {
            return a / b;
        }

        @Override
        public double eval(double a, double b) {
            return a / b;
        }

        @Override
        public String eval(String a, String b) {
            this.fail();
            return null;
        }
    };
    static final BinaryNumericOperation MODULO = new BinaryNumericOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            this.fail();
            return false;
        }

        @Override
        public int eval(int a, int b) {
            return a % b;
        }

        @Override
        public long eval(long a, long b) {
            return a % b;
        }

        @Override
        public float eval(float a, float b) {
            return a % b;
        }

        @Override
        public double eval(double a, double b) {
            return a % b;
        }

        @Override
        public String eval(String a, String b) {
            this.fail();
            return null;
        }
    };
    static final BinaryNumericOperation TIMES = new BinaryNumericOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            this.fail();
            return false;
        }

        @Override
        public int eval(int a, int b) {
            return a * b;
        }

        @Override
        public long eval(long a, long b) {
            return a * b;
        }

        @Override
        public float eval(float a, float b) {
            return a * b;
        }

        @Override
        public double eval(double a, double b) {
            return a * b;
        }

        @Override
        public String eval(String a, String b) {
            this.fail();
            return null;
        }
    };
    static final BinaryNumericOperation SHIFT_LEFT = new BinaryNumericOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            this.fail();
            return false;
        }

        @Override
        public int eval(int a, int b) {
            return a << b;
        }

        @Override
        public long eval(long a, long b) {
            return a << (int)b;
        }

        @Override
        public float eval(float a, float b) {
            this.fail();
            return 0.0f;
        }

        @Override
        public double eval(double a, double b) {
            this.fail();
            return 0.0;
        }

        @Override
        public String eval(String a, String b) {
            this.fail();
            return null;
        }
    };
    static final BinaryNumericOperation SHIFT_RIGHT = new BinaryNumericOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            this.fail();
            return false;
        }

        @Override
        public int eval(int a, int b) {
            return a >> b;
        }

        @Override
        public long eval(long a, long b) {
            return a >> (int)b;
        }

        @Override
        public float eval(float a, float b) {
            this.fail();
            return 0.0f;
        }

        @Override
        public double eval(double a, double b) {
            this.fail();
            return 0.0;
        }

        @Override
        public String eval(String a, String b) {
            this.fail();
            return null;
        }
    };
    static final BinaryNumericOperation UNSIGNED_SHIFT_RIGHT = new BinaryNumericOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            this.fail();
            return false;
        }

        @Override
        public int eval(int a, int b) {
            return a >>> b;
        }

        @Override
        public long eval(long a, long b) {
            return a >>> (int)b;
        }

        @Override
        public float eval(float a, float b) {
            this.fail();
            return 0.0f;
        }

        @Override
        public double eval(double a, double b) {
            this.fail();
            return 0.0;
        }

        @Override
        public String eval(String a, String b) {
            this.fail();
            return null;
        }
    };
    static final BinaryNumericOperation BINARY_AND = new BinaryNumericOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            return a & b;
        }

        @Override
        public int eval(int a, int b) {
            return a & b;
        }

        @Override
        public long eval(long a, long b) {
            return a & b;
        }

        @Override
        public float eval(float a, float b) {
            this.fail();
            return 0.0f;
        }

        @Override
        public double eval(double a, double b) {
            this.fail();
            return 0.0;
        }

        @Override
        public String eval(String a, String b) {
            this.fail();
            return null;
        }
    };
    static final BinaryNumericOperation BINARY_OR = new BinaryNumericOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            return a | b;
        }

        @Override
        public int eval(int a, int b) {
            return a | b;
        }

        @Override
        public long eval(long a, long b) {
            return a | b;
        }

        @Override
        public float eval(float a, float b) {
            this.fail();
            return 0.0f;
        }

        @Override
        public double eval(double a, double b) {
            this.fail();
            return 0.0;
        }

        @Override
        public String eval(String a, String b) {
            this.fail();
            return null;
        }
    };
    static final BinaryNumericOperation BINARY_XOR = new BinaryNumericOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            return a ^ b;
        }

        @Override
        public int eval(int a, int b) {
            return a ^ b;
        }

        @Override
        public long eval(long a, long b) {
            return a ^ b;
        }

        @Override
        public float eval(float a, float b) {
            this.fail();
            return 0.0f;
        }

        @Override
        public double eval(double a, double b) {
            this.fail();
            return 0.0;
        }

        @Override
        public String eval(String a, String b) {
            this.fail();
            return null;
        }
    };
    static final BinaryBooleanOperation EQUALS = new BinaryBooleanOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            return a == b;
        }

        @Override
        public boolean eval(int a, int b) {
            return a == b;
        }

        @Override
        public boolean eval(long a, long b) {
            return a == b;
        }

        @Override
        public boolean eval(float a, float b) {
            return a == b;
        }

        @Override
        public boolean eval(double a, double b) {
            return a == b;
        }

        @Override
        public boolean eval(String a, String b) {
            return a == b;
        }
    };
    static final BinaryBooleanOperation NOT_EQUALS = new BinaryBooleanOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            return a ^ b;
        }

        @Override
        public boolean eval(int a, int b) {
            return a != b;
        }

        @Override
        public boolean eval(long a, long b) {
            return a != b;
        }

        @Override
        public boolean eval(float a, float b) {
            return a != b;
        }

        @Override
        public boolean eval(double a, double b) {
            return a != b;
        }

        @Override
        public boolean eval(String a, String b) {
            return a != b;
        }
    };
    static final BinaryBooleanOperation LESS_THAN = new BinaryBooleanOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(int a, int b) {
            return a < b;
        }

        @Override
        public boolean eval(long a, long b) {
            return a < b;
        }

        @Override
        public boolean eval(float a, float b) {
            return a < b;
        }

        @Override
        public boolean eval(double a, double b) {
            return a < b;
        }

        @Override
        public boolean eval(String a, String b) {
            this.fail();
            return false;
        }
    };
    static final BinaryBooleanOperation GREATER_THAN = new BinaryBooleanOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(int a, int b) {
            return a > b;
        }

        @Override
        public boolean eval(long a, long b) {
            return a > b;
        }

        @Override
        public boolean eval(float a, float b) {
            return a > b;
        }

        @Override
        public boolean eval(double a, double b) {
            return a > b;
        }

        @Override
        public boolean eval(String a, String b) {
            this.fail();
            return false;
        }
    };
    static final BinaryBooleanOperation LESS_OR_EQUALS = new BinaryBooleanOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(int a, int b) {
            return a <= b;
        }

        @Override
        public boolean eval(long a, long b) {
            return a <= b;
        }

        @Override
        public boolean eval(float a, float b) {
            return a <= b;
        }

        @Override
        public boolean eval(double a, double b) {
            return a <= b;
        }

        @Override
        public boolean eval(String a, String b) {
            this.fail();
            return false;
        }
    };
    static final BinaryBooleanOperation GREATER_OR_EQUALS = new BinaryBooleanOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(int a, int b) {
            return a >= b;
        }

        @Override
        public boolean eval(long a, long b) {
            return a >= b;
        }

        @Override
        public boolean eval(float a, float b) {
            return a >= b;
        }

        @Override
        public boolean eval(double a, double b) {
            return a >= b;
        }

        @Override
        public boolean eval(String a, String b) {
            this.fail();
            return false;
        }
    };
    static final BinaryBooleanOperation LOGICAL_AND = new BinaryBooleanOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            return a && b;
        }

        @Override
        public boolean eval(int a, int b) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(long a, long b) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(float a, float b) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(double a, double b) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(String a, String b) {
            this.fail();
            return false;
        }
    };
    static final BinaryBooleanOperation LOGICAL_OR = new BinaryBooleanOperation(){

        @Override
        public boolean eval(boolean a, boolean b) {
            return a || b;
        }

        @Override
        public boolean eval(int a, int b) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(long a, long b) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(float a, float b) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(double a, double b) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(String a, String b) {
            this.fail();
            return false;
        }
    };
    static final UnaryBooleanOperation LOGICAL_NOT = new UnaryBooleanOperation(){

        @Override
        public boolean eval(boolean a) {
            return !a;
        }

        @Override
        public boolean eval(int a) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(long a) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(float a) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(double a) {
            this.fail();
            return false;
        }

        @Override
        public boolean eval(String a) {
            this.fail();
            return false;
        }
    };
    static final UnaryNumericOperation POSITIVE = new UnaryNumericOperation(){

        @Override
        public boolean eval(boolean a) {
            this.fail();
            return false;
        }

        @Override
        public int eval(int a) {
            return a;
        }

        @Override
        public long eval(long a) {
            return a;
        }

        @Override
        public float eval(float a) {
            return a;
        }

        @Override
        public double eval(double a) {
            return a;
        }

        @Override
        public String eval(String a) {
            this.fail();
            return null;
        }
    };
    static final UnaryNumericOperation NEGATIVE = new UnaryNumericOperation(){

        @Override
        public boolean eval(boolean a) {
            this.fail();
            return false;
        }

        @Override
        public int eval(int a) {
            return -a;
        }

        @Override
        public long eval(long a) {
            return -a;
        }

        @Override
        public float eval(float a) {
            return -a;
        }

        @Override
        public double eval(double a) {
            return -a;
        }

        @Override
        public String eval(String a) {
            this.fail();
            return null;
        }
    };
    static final UnaryNumericOperation BINARY_NOT = new UnaryNumericOperation(){

        @Override
        public boolean eval(boolean a) {
            this.fail();
            return false;
        }

        @Override
        public int eval(int a) {
            return ~a;
        }

        @Override
        public long eval(long a) {
            return a ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Override
        public float eval(float a) {
            this.fail();
            return 0.0f;
        }

        @Override
        public double eval(double a) {
            this.fail();
            return 0.0;
        }

        @Override
        public String eval(String a) {
            this.fail();
            return null;
        }
    };

    public DefaultConstantEvaluator(ServiceConfiguration config) {
        super(config);
    }

    NameInfo getNameInfo() {
        return this.serviceConfiguration.getNameInfo();
    }

    SourceInfo getSourceInfo() {
        return this.serviceConfiguration.getSourceInfo();
    }

    static int translateType(PrimitiveType t, NameInfo ni) {
        if (t == ni.getIntType()) {
            return 4;
        }
        if (t == ni.getBooleanType()) {
            return 0;
        }
        if (t == ni.getLongType()) {
            return 5;
        }
        if (t == ni.getFloatType()) {
            return 6;
        }
        if (t == ni.getDoubleType()) {
            return 7;
        }
        if (t == ni.getByteType()) {
            return 1;
        }
        if (t == ni.getCharType()) {
            return 3;
        }
        if (t == ni.getShortType()) {
            return 2;
        }
        return -1;
    }

    static PrimitiveType translateType(int t, NameInfo ni) {
        switch (t) {
            case 4: {
                return ni.getIntType();
            }
            case 0: {
                return ni.getBooleanType();
            }
            case 5: {
                return ni.getLongType();
            }
            case 6: {
                return ni.getFloatType();
            }
            case 7: {
                return ni.getDoubleType();
            }
            case 1: {
                return ni.getByteType();
            }
            case 3: {
                return ni.getCharType();
            }
            case 2: {
                return ni.getShortType();
            }
        }
        return null;
    }

    static void promoteNumericTypeToInt(ConstantEvaluator.EvaluationResult res) {
        switch (res.getTypeCode()) {
            case 1: {
                res.setInt(res.getByte());
                break;
            }
            case 3: {
                res.setInt(res.getChar());
                break;
            }
            case 2: {
                res.setInt(res.getShort());
            }
        }
    }

    static void matchTypes(ConstantEvaluator.EvaluationResult lhs, ConstantEvaluator.EvaluationResult rhs) {
        block0 : switch (lhs.getTypeCode()) {
            case 4: {
                switch (rhs.getTypeCode()) {
                    case 5: {
                        lhs.setLong(lhs.getInt());
                        break;
                    }
                    case 6: {
                        lhs.setFloat(lhs.getInt());
                        break;
                    }
                    case 7: {
                        lhs.setDouble(lhs.getInt());
                    }
                }
                break;
            }
            case 5: {
                switch (rhs.getTypeCode()) {
                    case 4: {
                        rhs.setLong(rhs.getInt());
                        break;
                    }
                    case 6: {
                        lhs.setFloat(lhs.getLong());
                        break;
                    }
                    case 7: {
                        lhs.setDouble(lhs.getLong());
                    }
                }
                break;
            }
            case 6: {
                switch (rhs.getTypeCode()) {
                    case 4: {
                        rhs.setFloat(rhs.getInt());
                        break;
                    }
                    case 5: {
                        rhs.setFloat(rhs.getLong());
                        break;
                    }
                    case 7: {
                        lhs.setDouble(lhs.getFloat());
                    }
                }
                break;
            }
            case 7: {
                switch (rhs.getTypeCode()) {
                    case 4: {
                        rhs.setDouble(rhs.getInt());
                        break;
                    }
                    case 5: {
                        rhs.setDouble(rhs.getLong());
                        break;
                    }
                    case 6: {
                        rhs.setDouble(rhs.getFloat());
                    }
                }
                break;
            }
            case 8: {
                switch (rhs.getTypeCode()) {
                    case 4: {
                        rhs.setString(String.valueOf(rhs.getInt()));
                        break block0;
                    }
                    case 5: {
                        rhs.setString(String.valueOf(rhs.getLong()));
                        break block0;
                    }
                    case 6: {
                        rhs.setString(String.valueOf(rhs.getFloat()));
                        break block0;
                    }
                    case 7: {
                        rhs.setString(String.valueOf(rhs.getDouble()));
                    }
                }
            }
        }
        if (lhs.getTypeCode() != rhs.getTypeCode()) {
            throw new RuntimeException("Operand types are illegal: " + lhs.getTypeCode() + " / " + rhs.getTypeCode());
        }
    }

    static void matchAssignmentTypes(ConstantEvaluator.EvaluationResult lhs, ConstantEvaluator.EvaluationResult rhs) {
        switch (lhs.getTypeCode()) {
            case 4: {
                switch (rhs.getTypeCode()) {
                    case 1: {
                        int value = lhs.getInt();
                        if (-128 <= value && value <= 127) {
                            lhs.setByte((byte)value);
                        } else {
                            rhs.setInt(rhs.getByte());
                        }
                        return;
                    }
                    case 3: {
                        int value = lhs.getInt();
                        if (value >= 0 && value <= 65535) {
                            lhs.setChar((char)value);
                        } else {
                            rhs.setInt(rhs.getChar());
                        }
                        return;
                    }
                    case 2: {
                        int value = lhs.getInt();
                        if (Short.MIN_VALUE <= value && value <= Short.MAX_VALUE) {
                            lhs.setShort((short)value);
                        } else {
                            rhs.setInt(rhs.getShort());
                        }
                        return;
                    }
                }
                break;
            }
            case 1: {
                if (rhs.getTypeCode() != 4) break;
                int value = rhs.getInt();
                if (-128 <= value && value <= 127) {
                    rhs.setByte((byte)value);
                } else {
                    lhs.setInt(lhs.getByte());
                }
                return;
            }
            case 2: {
                if (rhs.getTypeCode() != 4) break;
                int value = rhs.getInt();
                if (Short.MIN_VALUE <= value && value <= Short.MAX_VALUE) {
                    rhs.setShort((short)value);
                } else {
                    lhs.setInt(lhs.getShort());
                }
                return;
            }
            case 3: {
                if (rhs.getTypeCode() != 4) break;
                int value = rhs.getInt();
                if (value >= 0 && value <= 65535) {
                    rhs.setChar((char)value);
                } else {
                    lhs.setInt(lhs.getChar());
                }
                return;
            }
        }
        DefaultConstantEvaluator.matchTypes(lhs, rhs);
    }

    static void matchConditionalTypes(ConstantEvaluator.EvaluationResult lhs, ConstantEvaluator.EvaluationResult rhs) {
        switch (lhs.getTypeCode()) {
            case 1: {
                switch (rhs.getTypeCode()) {
                    case 2: {
                        lhs.setShort(lhs.getByte());
                        return;
                    }
                    case 3: {
                        DefaultConstantEvaluator.promoteNumericTypeToInt(lhs);
                        DefaultConstantEvaluator.promoteNumericTypeToInt(rhs);
                        return;
                    }
                }
                break;
            }
            case 3: {
                switch (rhs.getTypeCode()) {
                    case 1: 
                    case 2: {
                        DefaultConstantEvaluator.promoteNumericTypeToInt(lhs);
                        DefaultConstantEvaluator.promoteNumericTypeToInt(rhs);
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (rhs.getTypeCode()) {
                    case 1: {
                        rhs.setShort(rhs.getByte());
                        return;
                    }
                    case 3: {
                        DefaultConstantEvaluator.promoteNumericTypeToInt(lhs);
                        DefaultConstantEvaluator.promoteNumericTypeToInt(rhs);
                        return;
                    }
                }
            }
        }
        DefaultConstantEvaluator.matchAssignmentTypes(lhs, rhs);
    }

    static String parseJavaString(String text) {
        int len = text.length();
        StringBuilder buf = new StringBuilder(len);
        int i = 1;
        while (i < len - 1) {
            char c = text.charAt(i);
            if (c != '\\') {
                buf.append(c);
            } else {
                switch (text.charAt(++i)) {
                    case 'b': {
                        buf.append('\b');
                        break;
                    }
                    case 't': {
                        buf.append('\t');
                        break;
                    }
                    case 'n': {
                        buf.append('\n');
                        break;
                    }
                    case 'f': {
                        buf.append('\f');
                        break;
                    }
                    case 'r': {
                        buf.append('\r');
                        break;
                    }
                    case '\"': {
                        buf.append('\"');
                        break;
                    }
                    case '\'': {
                        buf.append('\'');
                        break;
                    }
                    case '\\': {
                        buf.append('\\');
                        break;
                    }
                    case 'u': {
                        ++i;
                        while (text.charAt(i) == 'u') {
                            ++i;
                        }
                        buf.append((char)Integer.parseInt(text.substring(i, i + 4), 16));
                        i += 4;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        int j = i + 1;
                        while (j < len && text.charAt(j) >= '0' && text.charAt(j) <= '7') {
                            ++j;
                        }
                        buf.append((char)Integer.parseInt(text.substring(i, j), 8));
                        i = j;
                        break;
                    }
                    default: {
                        throw new ModelException("Bad character representation: " + text);
                    }
                }
            }
            ++i;
        }
        return buf.toString();
    }

    static void doPrimitiveTypeCast(int newType, ConstantEvaluator.EvaluationResult res) {
        int oldType = res.getTypeCode();
        if (oldType == newType) {
            return;
        }
        if (oldType == 0 || newType == 0) {
            throw new ModelException("Cast not allowed");
        }
        switch (oldType) {
            case 1: {
                switch (newType) {
                    case 2: {
                        res.setShort(res.getByte());
                        return;
                    }
                    case 3: {
                        res.setChar((char)res.getByte());
                        return;
                    }
                    case 4: {
                        res.setInt(res.getByte());
                        return;
                    }
                    case 5: {
                        res.setLong(res.getByte());
                        return;
                    }
                    case 6: {
                        res.setFloat(res.getByte());
                        return;
                    }
                    case 7: {
                        res.setDouble(res.getByte());
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (newType) {
                    case 1: {
                        res.setByte((byte)res.getShort());
                        return;
                    }
                    case 3: {
                        res.setChar((char)res.getShort());
                        return;
                    }
                    case 4: {
                        res.setInt(res.getShort());
                        return;
                    }
                    case 5: {
                        res.setLong(res.getShort());
                        return;
                    }
                    case 6: {
                        res.setFloat(res.getShort());
                        return;
                    }
                    case 7: {
                        res.setDouble(res.getShort());
                        return;
                    }
                }
                break;
            }
            case 3: {
                switch (newType) {
                    case 1: {
                        res.setByte((byte)res.getChar());
                        return;
                    }
                    case 2: {
                        res.setShort((short)res.getChar());
                        return;
                    }
                    case 4: {
                        res.setInt(res.getChar());
                        return;
                    }
                    case 5: {
                        res.setLong(res.getChar());
                        return;
                    }
                    case 6: {
                        res.setFloat(res.getChar());
                        return;
                    }
                    case 7: {
                        res.setDouble(res.getChar());
                        return;
                    }
                }
                break;
            }
            case 4: {
                switch (newType) {
                    case 1: {
                        res.setByte((byte)res.getInt());
                        return;
                    }
                    case 2: {
                        res.setShort((short)res.getInt());
                        return;
                    }
                    case 3: {
                        res.setChar((char)res.getInt());
                        return;
                    }
                    case 5: {
                        res.setLong(res.getInt());
                        return;
                    }
                    case 6: {
                        res.setFloat(res.getInt());
                        return;
                    }
                    case 7: {
                        res.setDouble(res.getInt());
                        return;
                    }
                }
                break;
            }
            case 5: {
                switch (newType) {
                    case 1: {
                        res.setByte((byte)res.getLong());
                        return;
                    }
                    case 2: {
                        res.setShort((short)res.getLong());
                        return;
                    }
                    case 3: {
                        res.setChar((char)res.getLong());
                        return;
                    }
                    case 4: {
                        res.setInt((int)res.getLong());
                        return;
                    }
                    case 6: {
                        res.setFloat(res.getLong());
                        return;
                    }
                    case 7: {
                        res.setDouble(res.getLong());
                        return;
                    }
                }
                break;
            }
            case 6: {
                switch (newType) {
                    case 1: {
                        res.setByte((byte)res.getFloat());
                        return;
                    }
                    case 2: {
                        res.setShort((short)res.getFloat());
                        return;
                    }
                    case 3: {
                        res.setChar((char)res.getFloat());
                        return;
                    }
                    case 4: {
                        res.setInt((int)res.getFloat());
                        return;
                    }
                    case 5: {
                        res.setLong((long)res.getFloat());
                        return;
                    }
                    case 7: {
                        res.setDouble(res.getFloat());
                        return;
                    }
                }
                break;
            }
            case 7: {
                switch (newType) {
                    case 1: {
                        res.setByte((byte)res.getDouble());
                        return;
                    }
                    case 2: {
                        res.setShort((short)res.getDouble());
                        return;
                    }
                    case 3: {
                        res.setChar((char)res.getDouble());
                        return;
                    }
                    case 4: {
                        res.setInt((int)res.getDouble());
                        return;
                    }
                    case 5: {
                        res.setLong((long)res.getDouble());
                        return;
                    }
                    case 6: {
                        res.setFloat((float)res.getDouble());
                        return;
                    }
                }
            }
        }
    }

    @Override
    public Type getCompileTimeConstantType(Expression expr) {
        ConstantEvaluator.EvaluationResult res = new ConstantEvaluator.EvaluationResult();
        if (!this.isCompileTimeConstant(expr, res)) {
            return null;
        }
        return res.getPrimitiveType(this.getNameInfo());
    }

    @Override
    public boolean isCompileTimeConstant(Expression expr) {
        return this.isCompileTimeConstant(expr, new ConstantEvaluator.EvaluationResult());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isCompileTimeConstant(Expression expr, ConstantEvaluator.EvaluationResult res) {
        Variable v;
        if (expr instanceof Literal) {
            if (expr instanceof IntLiteral) {
                String v2 = ((IntLiteral)expr).getValue();
                res.setInt(JavaProgramFactory.parseInt(v2));
                return true;
            }
            if (expr instanceof StringLiteral) {
                res.setString(DefaultConstantEvaluator.parseJavaString(((StringLiteral)expr).getValue()));
                return true;
            }
            if (expr instanceof BooleanLiteral) {
                res.setBoolean(((BooleanLiteral)expr).getValue());
                return true;
            }
            if (expr instanceof NullLiteral) {
                res.setString(null);
                return true;
            }
            if (expr instanceof CharLiteral) {
                res.setChar(DefaultConstantEvaluator.parseJavaString(((CharLiteral)expr).getValue()).charAt(0));
                return true;
            }
            if (expr instanceof LongLiteral) {
                String v3 = ((LongLiteral)expr).getValue();
                res.setLong(JavaProgramFactory.parseLong(v3));
                return true;
            }
            if (expr instanceof FloatLiteral) {
                String v4 = ((FloatLiteral)expr).getValue();
                res.setFloat(Float.valueOf(v4).floatValue());
                return true;
            }
            if (!(expr instanceof DoubleLiteral)) throw new ModelException("Unknown literal type");
            String v5 = ((DoubleLiteral)expr).getValue();
            res.setDouble(Double.valueOf(v5));
            return true;
        }
        if (expr instanceof Operator) {
            if (expr instanceof Assignment) {
                return false;
            }
            Operator op = (Operator)expr;
            if (op instanceof TypeOperator) {
                if (!(op instanceof TypeCast)) return false;
                if (!this.isCompileTimeConstant(((TypeCast)expr).getExpressionAt(0), res)) {
                    return false;
                }
                int newType = -1;
                Type to = this.getSourceInfo().getType(((TypeCast)expr).getTypeReference());
                if (to instanceof PrimitiveType) {
                    newType = DefaultConstantEvaluator.translateType((PrimitiveType)to, this.getNameInfo());
                    DefaultConstantEvaluator.doPrimitiveTypeCast(newType, res);
                    return true;
                }
                if (to != this.getNameInfo().getJavaLangString()) return false;
                newType = 8;
                if (res.getTypeCode() == 8) return true;
                return false;
            }
            if (op instanceof ParenthesizedExpression) {
                return this.isCompileTimeConstant(op.getExpressionAt(0), res);
            }
            DefaultConstantEvaluator.promoteNumericTypeToInt(res);
            ConstantEvaluator.EvaluationResult lhs = null;
            ConstantEvaluator.EvaluationResult rhs = null;
            UnaryNumericOperation uno = null;
            UnaryBooleanOperation ubo = null;
            BinaryNumericOperation bno = null;
            BinaryBooleanOperation bbo = null;
            switch (op.getArity()) {
                case 1: {
                    if (!this.isCompileTimeConstant(op.getExpressionAt(0), res)) {
                        return false;
                    }
                    if (op instanceof Positive) {
                        uno = POSITIVE;
                        break;
                    }
                    if (op instanceof Negative) {
                        uno = NEGATIVE;
                        break;
                    }
                    if (op instanceof BinaryNot) {
                        uno = BINARY_NOT;
                        break;
                    }
                    if (!(op instanceof LogicalNot)) break;
                    ubo = LOGICAL_NOT;
                    break;
                }
                case 2: {
                    if (!this.isCompileTimeConstant(op.getExpressionAt(0), res)) {
                        return false;
                    }
                    lhs = res;
                    DefaultConstantEvaluator.promoteNumericTypeToInt(lhs);
                    rhs = new ConstantEvaluator.EvaluationResult();
                    if (!this.isCompileTimeConstant(op.getExpressionAt(1), rhs)) {
                        return false;
                    }
                    DefaultConstantEvaluator.promoteNumericTypeToInt(rhs);
                    DefaultConstantEvaluator.matchTypes(lhs, rhs);
                    if (op instanceof ComparativeOperator) {
                        if (op instanceof Equals) {
                            bbo = EQUALS;
                            break;
                        }
                        if (op instanceof NotEquals) {
                            bbo = NOT_EQUALS;
                            break;
                        }
                        if (op instanceof GreaterThan) {
                            bbo = GREATER_THAN;
                            break;
                        }
                        if (op instanceof LessThan) {
                            bbo = LESS_THAN;
                            break;
                        }
                        if (op instanceof GreaterOrEquals) {
                            bbo = GREATER_OR_EQUALS;
                            break;
                        }
                        if (op instanceof LessOrEquals) {
                            bbo = LESS_OR_EQUALS;
                            break;
                        }
                        if (op instanceof LogicalAnd) {
                            bbo = LOGICAL_AND;
                            break;
                        }
                        if (!(op instanceof LogicalOr)) break;
                        bbo = LOGICAL_OR;
                        break;
                    }
                    if (op instanceof Plus) {
                        bno = PLUS;
                        break;
                    }
                    if (op instanceof Minus) {
                        bno = MINUS;
                        break;
                    }
                    if (op instanceof Times) {
                        bno = TIMES;
                        break;
                    }
                    if (op instanceof Divide) {
                        bno = DIVIDE;
                        break;
                    }
                    if (op instanceof Modulo) {
                        bno = MODULO;
                        break;
                    }
                    if (op instanceof ShiftLeft) {
                        bno = SHIFT_LEFT;
                        break;
                    }
                    if (op instanceof ShiftRight) {
                        bno = SHIFT_RIGHT;
                        break;
                    }
                    if (op instanceof UnsignedShiftRight) {
                        bno = UNSIGNED_SHIFT_RIGHT;
                        break;
                    }
                    if (op instanceof BinaryAnd) {
                        bno = BINARY_AND;
                        break;
                    }
                    if (op instanceof BinaryOr) {
                        bno = BINARY_OR;
                        break;
                    }
                    if (op instanceof BinaryXOr) {
                        bno = BINARY_XOR;
                        break;
                    }
                    if (op instanceof LogicalAnd) {
                        bbo = LOGICAL_AND;
                        break;
                    }
                    if (!(op instanceof LogicalOr)) break;
                    bbo = LOGICAL_OR;
                    break;
                }
                case 3: {
                    if (!this.isCompileTimeConstant(op.getExpressionAt(0), res)) {
                        return false;
                    }
                    if (res.getTypeCode() != 0) {
                        throw new ModelException("No boolean expression in ?:");
                    }
                    boolean cond = res.getBoolean();
                    lhs = res;
                    if (!this.isCompileTimeConstant(op.getExpressionAt(1), lhs)) {
                        return false;
                    }
                    rhs = new ConstantEvaluator.EvaluationResult();
                    if (!this.isCompileTimeConstant(op.getExpressionAt(2), rhs)) {
                        return false;
                    }
                    DefaultConstantEvaluator.matchConditionalTypes(lhs, rhs);
                    switch (lhs.getTypeCode()) {
                        case 0: {
                            res.setBoolean(cond ? lhs.getBoolean() : rhs.getBoolean());
                            return true;
                        }
                        case 1: {
                            res.setByte(cond ? lhs.getByte() : rhs.getByte());
                            return true;
                        }
                        case 2: {
                            res.setShort(cond ? lhs.getShort() : rhs.getShort());
                            return true;
                        }
                        case 3: {
                            res.setChar(cond ? lhs.getChar() : rhs.getChar());
                            return true;
                        }
                        case 4: {
                            res.setInt(cond ? lhs.getInt() : rhs.getInt());
                            return true;
                        }
                        case 5: {
                            res.setLong(cond ? lhs.getLong() : rhs.getLong());
                            return true;
                        }
                        case 6: {
                            res.setFloat(cond ? lhs.getFloat() : rhs.getFloat());
                            return true;
                        }
                        case 7: {
                            res.setDouble(cond ? lhs.getDouble() : rhs.getDouble());
                            return true;
                        }
                        case 8: {
                            res.setString(cond ? lhs.getString() : rhs.getString());
                            return true;
                        }
                    }
                    return true;
                }
            }
            if (bno != null) {
                switch (lhs.getTypeCode()) {
                    case 0: {
                        lhs.setBoolean(bno.eval(lhs.getBoolean(), rhs.getBoolean()));
                        return true;
                    }
                    case 4: {
                        lhs.setInt(bno.eval(lhs.getInt(), rhs.getInt()));
                        return true;
                    }
                    case 5: {
                        lhs.setLong(bno.eval(lhs.getLong(), rhs.getLong()));
                        return true;
                    }
                    case 6: {
                        lhs.setFloat(bno.eval(lhs.getFloat(), rhs.getFloat()));
                        return true;
                    }
                    case 7: {
                        lhs.setDouble(bno.eval(lhs.getDouble(), rhs.getDouble()));
                        return true;
                    }
                    case 8: {
                        lhs.setString(bno.eval(lhs.getString(), rhs.getString()));
                        return true;
                    }
                }
                return true;
            }
            if (bbo != null) {
                switch (lhs.getTypeCode()) {
                    case 0: {
                        lhs.setBoolean(bbo.eval(lhs.getBoolean(), rhs.getBoolean()));
                        return true;
                    }
                    case 4: {
                        lhs.setBoolean(bbo.eval(lhs.getInt(), rhs.getInt()));
                        return true;
                    }
                    case 5: {
                        lhs.setBoolean(bbo.eval(lhs.getLong(), rhs.getLong()));
                        return true;
                    }
                    case 6: {
                        lhs.setBoolean(bbo.eval(lhs.getFloat(), rhs.getFloat()));
                        return true;
                    }
                    case 7: {
                        lhs.setBoolean(bbo.eval(lhs.getDouble(), rhs.getDouble()));
                        return true;
                    }
                    case 8: {
                        lhs.setBoolean(bbo.eval(lhs.getString(), rhs.getString()));
                        return true;
                    }
                }
                return true;
            }
            if (uno != null) {
                switch (res.getTypeCode()) {
                    case 0: {
                        res.setBoolean(uno.eval(res.getBoolean()));
                        return true;
                    }
                    case 4: {
                        res.setInt(uno.eval(res.getInt()));
                        return true;
                    }
                    case 5: {
                        res.setLong(uno.eval(res.getLong()));
                        return true;
                    }
                    case 6: {
                        res.setFloat(uno.eval(res.getFloat()));
                        return true;
                    }
                    case 7: {
                        res.setDouble(uno.eval(res.getDouble()));
                        return true;
                    }
                    case 8: {
                        res.setString(uno.eval(res.getString()));
                        return true;
                    }
                }
                return true;
            }
            if (ubo == null) throw new ModelException("Unknown operator " + op.getClass().getName() + "?!");
            switch (res.getTypeCode()) {
                case 0: {
                    res.setBoolean(ubo.eval(res.getBoolean()));
                    return true;
                }
                case 4: {
                    res.setBoolean(ubo.eval(res.getInt()));
                    return true;
                }
                case 5: {
                    res.setBoolean(ubo.eval(res.getLong()));
                    return true;
                }
                case 6: {
                    res.setBoolean(ubo.eval(res.getFloat()));
                    return true;
                }
                case 7: {
                    res.setBoolean(ubo.eval(res.getDouble()));
                    return true;
                }
                case 8: {
                    res.setBoolean(ubo.eval(res.getString()));
                    return true;
                }
            }
            return true;
        }
        if (expr instanceof UncollatedReferenceQualifier) {
            Reference pe = this.getSourceInfo().resolveURQ((UncollatedReferenceQualifier)expr);
            if (!(pe instanceof VariableReference)) return false;
            expr = (VariableReference)pe;
        }
        if (!(expr instanceof VariableReference)) return false;
        if (expr instanceof FieldReference) {
            ReferencePrefix pre = ((FieldReference)expr).getReferencePrefix();
            while (pre != null) {
                if (!(pre instanceof FieldReference || pre instanceof PackageReference || pre instanceof TypeReference)) {
                    if (!(pre instanceof UncollatedReferenceQualifier)) return false;
                }
                pre = ((ReferenceSuffix)((Object)pre)).getReferencePrefix();
            }
        }
        if ((v = this.getSourceInfo().getVariable((VariableReference)expr)) == null) return false;
        if (!v.isFinal()) return false;
        if (v instanceof Field && !((Field)v).isStatic()) {
            return false;
        }
        int vtype = -1;
        Type vt = v.getType();
        if (vt instanceof PrimitiveType) {
            vtype = DefaultConstantEvaluator.translateType((PrimitiveType)vt, this.getNameInfo());
        } else if (vt == this.getNameInfo().getJavaLangString()) {
            vtype = 8;
        }
        if (vtype == -1) {
            return false;
        }
        if (this.visitedVariableReferences.contains(expr)) {
            return false;
        }
        this.visitedVariableReferences.push(expr);
        try {
            ProgramModelInfo qs = v.getProgramModelInfo();
            if (qs instanceof SourceInfo) {
                SourceInfo ais = (SourceInfo)qs;
                expr = ais.getVariableSpecification(v).getInitializer();
                if (expr == null) {
                    return false;
                }
                if (!this.isCompileTimeConstant(expr, res)) {
                    return false;
                }
                DefaultConstantEvaluator.doPrimitiveTypeCast(vtype, res);
                return true;
            }
            if (!(qs instanceof ByteCodeInfo)) return false;
            ByteCodeInfo bis = (ByteCodeInfo)qs;
            String val = bis.getFieldInfo((Field)v).getConstantValue();
            if (val == null) {
                return false;
            }
            switch (vtype) {
                case 0: {
                    res.setBoolean(Integer.parseInt(val) != 0);
                    return true;
                }
                case 1: {
                    res.setByte((byte)Integer.parseInt(val));
                    return true;
                }
                case 2: {
                    res.setShort((short)Integer.parseInt(val));
                    return true;
                }
                case 3: {
                    res.setChar((char)Integer.parseInt(val));
                    return true;
                }
                case 4: {
                    res.setInt(Integer.parseInt(val));
                    return true;
                }
                case 5: {
                    res.setLong(Long.parseLong(val));
                    return true;
                }
                case 6: {
                    if (val.equals("NaN")) {
                        res.setFloat(Float.NaN);
                        return true;
                    }
                    res.setFloat(Float.valueOf(val).floatValue());
                    return true;
                }
                case 7: {
                    if (val.equals("NaN")) {
                        res.setDouble(Double.NaN);
                        return true;
                    }
                    res.setDouble(Double.valueOf(val));
                    return true;
                }
                case 8: {
                    res.setString(val);
                    return true;
                }
            }
            return true;
        }
        finally {
            this.visitedVariableReferences.pop();
        }
    }

    static abstract class BinaryBooleanOperation
    extends Operation {
        BinaryBooleanOperation() {
        }

        public abstract boolean eval(boolean var1, boolean var2);

        public abstract boolean eval(int var1, int var2);

        public abstract boolean eval(long var1, long var3);

        public abstract boolean eval(float var1, float var2);

        public abstract boolean eval(double var1, double var3);

        public abstract boolean eval(String var1, String var2);
    }

    static abstract class BinaryNumericOperation
    extends Operation {
        BinaryNumericOperation() {
        }

        public abstract boolean eval(boolean var1, boolean var2);

        public abstract int eval(int var1, int var2);

        public abstract long eval(long var1, long var3);

        public abstract float eval(float var1, float var2);

        public abstract double eval(double var1, double var3);

        public abstract String eval(String var1, String var2);
    }

    static abstract class Operation {
        Operation() {
        }

        protected void fail() {
            throw new ModelException("Operand types are illegal");
        }
    }

    static abstract class UnaryBooleanOperation
    extends Operation {
        UnaryBooleanOperation() {
        }

        public abstract boolean eval(boolean var1);

        public abstract boolean eval(int var1);

        public abstract boolean eval(long var1);

        public abstract boolean eval(float var1);

        public abstract boolean eval(double var1);

        public abstract boolean eval(String var1);
    }

    static abstract class UnaryNumericOperation
    extends Operation {
        UnaryNumericOperation() {
        }

        public abstract boolean eval(boolean var1);

        public abstract int eval(int var1);

        public abstract long eval(long var1);

        public abstract float eval(float var1);

        public abstract double eval(double var1);

        public abstract String eval(String var1);
    }
}

