/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import recoder.ServiceConfiguration;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.Field;
import recoder.abstraction.Member;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.Type;
import recoder.abstraction.TypeParameter;
import recoder.bytecode.AnnotationUseInfo;
import recoder.bytecode.ByteCodeElement;
import recoder.bytecode.ClassFile;
import recoder.bytecode.ConstructorInfo;
import recoder.bytecode.FieldInfo;
import recoder.bytecode.MemberInfo;
import recoder.bytecode.MethodInfo;
import recoder.bytecode.TypeArgumentInfo;
import recoder.bytecode.TypeParameterInfo;
import recoder.convenience.Format;
import recoder.service.ByteCodeInfo;
import recoder.service.DefaultProgramModelInfo;
import recoder.service.ImplicitElementInfo;
import recoder.service.MissingClassFileException;
import recoder.service.NameInfo;
import recoder.service.UnresolvedBytecodeReferenceException;
import recoder.util.Debug;

public class DefaultByteCodeInfo
extends DefaultProgramModelInfo
implements ByteCodeInfo {
    private final Map<ProgramModelElement, ClassTypeContainer> element2container = new HashMap<ProgramModelElement, ClassTypeContainer>(256);
    private final Map<ClassTypeContainer, ArrayList<ClassType>> containedTypes = new HashMap<ClassTypeContainer, ArrayList<ClassType>>(32);
    private final Map<Method, List<Type>> method2signature = new HashMap<Method, List<Type>>(128);

    public DefaultByteCodeInfo(ServiceConfiguration config) {
        super(config);
    }

    private ByteCodeElement getByteCodeElement(ProgramModelElement pme) {
        if (pme instanceof ByteCodeElement) {
            return (ByteCodeElement)pme;
        }
        return null;
    }

    @Override
    public final ClassFile getClassFile(ClassType ct) {
        return (ClassFile)this.getByteCodeElement(ct);
    }

    @Override
    public final MethodInfo getMethodInfo(Method m) {
        return (MethodInfo)this.getByteCodeElement(m);
    }

    @Override
    public final ConstructorInfo getConstructorInfo(Constructor c) {
        return (ConstructorInfo)this.getByteCodeElement(c);
    }

    @Override
    public final FieldInfo getFieldInfo(Field f) {
        return (FieldInfo)this.getByteCodeElement(f);
    }

    /*
     * WARNING - void declaration
     */
    private TypeParameterInfo findTypeParameter(MemberInfo mi, String name) {
        void var4_7;
        TypeParameter result = null;
        if (mi instanceof MethodInfo && ((MethodInfo)mi).getTypeParameters() != null) {
            for (TypeParameter typeParameter : ((MethodInfo)mi).getTypeParameters()) {
                if (!name.equals(typeParameter.getName())) continue;
                result = typeParameter;
                break;
            }
        }
        ClassType classType = mi.getContainingClassType();
        block1: while (result == null && var4_7 != null) {
            List<? extends TypeParameter> tpl = var4_7.getTypeParameters();
            if (tpl != null) {
                for (TypeParameter typeParameter : tpl) {
                    if (!name.equals(typeParameter.getName())) continue;
                    result = typeParameter;
                    break block1;
                }
            }
            ClassType classType2 = var4_7.getContainingClassType();
        }
        return (TypeParameterInfo)result;
    }

    public Type getType(ByteCodeElement bce) {
        List<TypeArgumentInfo> typeArgs;
        if (bce instanceof ConstructorInfo) {
            return null;
        }
        Type result = null;
        String typeName = bce.getTypeName();
        if (typeName.equals("void")) {
            return null;
        }
        if (bce instanceof MemberInfo) {
            String baseTypeName;
            MemberInfo mi = (MemberInfo)bce;
            int idx = typeName.indexOf(91);
            int dim = idx == -1 ? 0 : (typeName.length() - idx) / 2;
            String string = baseTypeName = idx == -1 ? typeName : typeName.substring(0, idx);
            if (mi.isTypeVariable() && (result = this.findTypeParameter(mi, baseTypeName)) != null) {
                while (dim-- > 0) {
                    result = result.createArrayType();
                }
            }
        }
        if (result == null) {
            result = this.getNameInfo().getType(typeName);
        }
        if (bce instanceof MemberInfo && (typeArgs = bce instanceof MethodInfo ? ((MethodInfo)bce).getTypeArgumentsForReturnType() : ((FieldInfo)bce).getTypeArguments()) != null && typeArgs.size() != 0) {
            result = result instanceof ArrayType ? this.makeParameterizedArrayType((ArrayType)result, typeArgs) : this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType((ClassType)result, typeArgs);
        }
        if (result == null) {
            this.getErrorHandler().reportError(new UnresolvedBytecodeReferenceException(typeName, bce.getFullName()));
            result = this.getServiceConfiguration().getNameInfo().getUnknownType();
        }
        return result;
    }

    @Override
    public Type getType(ProgramModelElement pme) {
        ByteCodeElement bci;
        Debug.assertNonnull(pme);
        Type result = null;
        result = pme instanceof Type ? (Type)pme : ((bci = this.getByteCodeElement(pme)) == null ? pme.getProgramModelInfo().getType(pme) : this.getType(bci));
        return result;
    }

    @Override
    public Package getPackage(ProgramModelElement pme) {
        Debug.assertNonnull(pme);
        ProgramModelElement x = this.element2container.get(pme);
        while (x != null && !(x instanceof Package)) {
            x = this.element2container.get(x);
        }
        return (Package)x;
    }

    @Override
    public List<? extends ClassType> getTypes(ClassTypeContainer ctc) {
        Debug.assertNonnull(ctc);
        if (ctc instanceof ByteCodeElement) {
            List ctl = this.containedTypes.get(ctc);
            if (ctl == null) {
                return Collections.emptyList();
            }
            return new ArrayList(ctl);
        }
        return ctc.getProgramModelInfo().getTypes(ctc);
    }

    @Override
    public ClassTypeContainer getClassTypeContainer(ClassType ct) {
        return this.element2container.get(ct);
    }

    @Override
    public List<ClassType> getSupertypes(ClassType ct) {
        Debug.assertNonnull(ct);
        if (ct instanceof TypeParameterInfo) {
            TypeParameterInfo tp = (TypeParameterInfo)ct;
            ArrayList<ClassType> res = new ArrayList<ClassType>(tp.getBoundCount());
            int i = 0;
            while (i < tp.getBoundCount()) {
                List<TypeArgumentInfo> boundTAs = tp.getBoundTypeArguments(i);
                ClassType boundCT = this.getNameInfo().getClassType(tp.getBoundName(i));
                if (boundTAs != null && boundTAs.size() > 0) {
                    ParameterizedType finalCT = this.makeParameterizedInnerTypeRec(boundCT, boundTAs);
                    res.add(finalCT);
                } else {
                    res.add(boundCT);
                }
                ++i;
            }
            return res;
        }
        ClassFile cf = this.getClassFile(ct);
        if (cf == null) {
            return ct.getProgramModelInfo().getSupertypes(ct);
        }
        ClassFileCacheEntry cfce = (ClassFileCacheEntry)this.classTypeCache.get(ct);
        Debug.assertNonnull(cfce);
        Debug.assertNonnull(cfce.supertypes);
        return new ArrayList<ClassType>(cfce.supertypes);
    }

    private ParameterizedType makeParameterizedInnerTypeRec(ClassType boundCT, List<TypeArgumentInfo> boundTAs) {
        int myTPCount;
        ImplicitElementInfo iei = this.getServiceConfiguration().getImplicitElementInfo();
        int n = myTPCount = boundCT.getTypeParameters() == null ? 0 : boundCT.getTypeParameters().size();
        if (myTPCount == boundTAs.size()) {
            return iei.getParameterizedType(boundCT, boundTAs);
        }
        List<TypeArgumentInfo> outerTAs = boundTAs.subList(0, boundTAs.size() - myTPCount);
        List<TypeArgumentInfo> myTAs = boundTAs.subList(boundTAs.size() - myTPCount, boundTAs.size());
        ParameterizedType outerCT = this.makeParameterizedInnerTypeRec(boundCT.getContainingClassType(), outerTAs);
        return iei.getParameterizedType(boundCT, myTAs, outerCT);
    }

    @Override
    public List<? extends Field> getFields(ClassType ct) {
        Debug.assertNonnull(ct);
        if (ct instanceof ClassFile) {
            return ((ClassFile)ct).getFieldInfos();
        }
        return ct.getProgramModelInfo().getFields(ct);
    }

    @Override
    public List<Method> getMethods(ClassType ct) {
        Debug.assertNonnull(ct);
        if (ct instanceof ClassFile) {
            return new ArrayList<Method>(((ClassFile)ct).getMethodInfos());
        }
        return ct.getProgramModelInfo().getMethods(ct);
    }

    @Override
    public List<? extends Constructor> getConstructors(ClassType ct) {
        Debug.assertNonnull(ct);
        if (ct instanceof ClassFile) {
            return ((ClassFile)ct).getConstructorInfos();
        }
        return ct.getProgramModelInfo().getConstructors(ct);
    }

    @Override
    public ClassType getContainingClassType(Member m) {
        return (ClassType)this.element2container.get(m);
    }

    @Override
    public List<Type> getSignature(Method m) {
        List<Type> result;
        Debug.assertNonnull(m);
        MethodInfo mi = this.getMethodInfo(m);
        if (mi == null) {
            result = m.getProgramModelInfo().getSignature(m);
        } else {
            String[] ptypes = mi.getParameterTypeNames();
            int pcount = ptypes.length;
            if (pcount == 0) {
                return Collections.emptyList();
            }
            result = this.method2signature.get(m);
            if (result == null) {
                NameInfo ni = this.getNameInfo();
                ArrayList<Type> res = new ArrayList<Type>(pcount);
                int i = 0;
                while (i < pcount) {
                    Type t = null;
                    String basename = ptypes[i];
                    int dim = basename.indexOf(91);
                    if (dim != -1) {
                        basename = basename.substring(0, dim);
                    }
                    boolean checkClassTypeParameters = true;
                    List<TypeParameter> tpl = mi.getTypeParameters();
                    if (tpl != null) {
                        for (TypeParameter tp : tpl) {
                            if (!basename.equals(tp.getName())) continue;
                            t = tp;
                            if (dim != -1) {
                                dim = (ptypes[i].length() - dim) / 2;
                                while (dim != 0) {
                                    t = ni.createArrayType(tp);
                                    --dim;
                                }
                            }
                            checkClassTypeParameters = false;
                            break;
                        }
                    }
                    if (checkClassTypeParameters && (tpl = mi.getContainingClassType().getTypeParameters()) != null) {
                        for (TypeParameter tp : tpl) {
                            if (!basename.equals(tp.getName())) continue;
                            t = tp;
                            if (dim == -1) break;
                            dim = (ptypes[i].length() - dim) / 2;
                            while (dim != 0) {
                                t = ni.createArrayType(tp);
                                --dim;
                            }
                            break block3;
                        }
                    }
                    if (t == null) {
                        t = ni.getType(ptypes[i]);
                    }
                    if (t == null) {
                        this.getErrorHandler().reportError(new UnresolvedBytecodeReferenceException(ptypes[i], m.getFullName()));
                        t = this.getServiceConfiguration().getNameInfo().getUnknownType();
                    }
                    if (mi.getTypeArgumentsForParam(i) != null && mi.getTypeArgumentsForParam(i).size() > 0) {
                        t = t instanceof ArrayType ? this.makeParameterizedArrayType((ArrayType)t, mi.getTypeArgumentsForParam(i)) : this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType((ClassType)t, mi.getTypeArgumentsForParam(i));
                    }
                    res.add(t);
                    ++i;
                }
                result = res;
                this.method2signature.put(m, result);
            }
        }
        return new ArrayList<Type>(result);
    }

    @Override
    public List<ClassType> getExceptions(Method m) {
        Debug.assertNonnull(m);
        MethodInfo mi = this.getMethodInfo(m);
        if (mi == null) {
            return m.getProgramModelInfo().getExceptions(m);
        }
        String[] etypes = mi.getExceptionsInfo();
        if (etypes == null || etypes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ClassType> res = new ArrayList<ClassType>(etypes.length);
        NameInfo ni = this.getNameInfo();
        String[] stringArray = etypes;
        int n = etypes.length;
        int n2 = 0;
        while (n2 < n) {
            String exc = stringArray[n2];
            ClassType excT = this.findTypeParameter(mi, exc);
            if (excT == null) {
                excT = ni.getClassType(exc);
            }
            if (excT == null) {
                this.getErrorHandler().reportError(new UnresolvedBytecodeReferenceException(exc, String.valueOf(mi.getFullName()) + " (a declared exception)"));
                excT = this.getServiceConfiguration().getNameInfo().getUnknownClassType();
            }
            res.add(excT);
            ++n2;
        }
        return res;
    }

    @Override
    public Type getReturnType(Method m) {
        return this.getType(m);
    }

    @Override
    public void register(ClassFile cf) {
        ClassType jlo;
        String[] innerClasses;
        ClassTypeContainer ctc;
        Debug.assertNonnull(cf);
        ClassFileCacheEntry cfce = (ClassFileCacheEntry)this.classTypeCache.get(cf);
        if (cfce != null) {
            return;
        }
        if (cf.getName().equals("package-info")) {
            return;
        }
        cfce = new ClassFileCacheEntry();
        this.classTypeCache.put(cf, cfce);
        String classname = cf.getBinaryName();
        NameInfo ni = this.getNameInfo();
        cf.setProgramModelInfo(this);
        ni.register(cf);
        int ldp = classname.lastIndexOf(36);
        if (cf.getEnclosingMethod() != null) {
            ctc = null;
            String s = cf.getEnclosingMethod();
            ClassFile clazz = (ClassFile)this.getNameInfo().getClassType(s.substring(0, s.lastIndexOf(46)).replace('/', '.').replace('$', '.'));
            String mname = s.substring(s.lastIndexOf(46) + 1, s.lastIndexOf(40));
            block0: for (Method mi : clazz.getMethods()) {
                if (!mi.getName().equals(mname)) continue;
                String msig = s.substring(s.indexOf(40));
                org.objectweb.asm.Type[] sigTypes = org.objectweb.asm.Type.getArgumentTypes((String)msig);
                String[] sig = new String[sigTypes.length + 1];
                int i = 0;
                while (i < sigTypes.length) {
                    sig[i] = sigTypes[i].getClassName();
                    ++i;
                }
                sig[sigTypes.length] = org.objectweb.asm.Type.getReturnType((String)s).getClassName();
                if (sig.length - 1 != mi.getSignature().size()) continue;
                i = 0;
                while (i < sig.length - 1) {
                    if (!sig[i].equals(mi.getSignature().get(i).getFullName())) continue block0;
                    ++i;
                }
                if (mi.getReturnType() != null && !mi.getReturnType().getFullName().equals(sig[sig.length - 1])) continue;
                if (ctc != null) {
                    throw new UnsupportedOperationException("Two methods with same name, one has local/anonymous type - not supported yet!");
                }
                ctc = mi;
            }
        } else if (ldp >= 0) {
            String outerClassName = classname.substring(0, ldp);
            classname = classname.substring(ldp + 1);
            ClassType outerClass = ni.getClassType(outerClassName.replace('$', '.'));
            if (outerClass == null) {
                do {
                    if ((ldp = outerClassName.lastIndexOf(36)) < 0 || (outerClassName = outerClassName.substring(0, ldp)).length() <= 0) continue;
                    outerClass = ni.getClassType(outerClassName.replace('$', '.'));
                } while (ldp >= 0 && outerClass == null);
            }
            if (outerClass instanceof ClassFile) {
                this.register((ClassFile)outerClass);
            } else {
                Debug.log("Found a non-ClassFile outer class of " + classname + ":" + Format.toString("%c %N", outerClass));
            }
            ctc = outerClass;
        } else {
            ldp = classname.lastIndexOf(46);
            String packageName = "";
            if (ldp != -1) {
                packageName = classname.substring(0, ldp);
            }
            ctc = ni.createPackage(packageName);
        }
        this.element2container.put(cf, ctc);
        if (ctc instanceof ByteCodeElement) {
            ArrayList<ClassType> ctl = this.containedTypes.get(ctc);
            if (ctl == null) {
                ctl = new ArrayList();
                this.containedTypes.put(ctc, ctl);
            }
            ctl.add(cf);
            ctl.trimToSize();
        }
        List<FieldInfo> fl = cf.getFieldInfos();
        int i = 0;
        int s = fl.size();
        while (i < s) {
            Field f = fl.get(i);
            f.setProgramModelInfo(this);
            this.element2container.put(f, cf);
            ni.register(f);
            ++i;
        }
        List<MethodInfo> ml = cf.getMethodInfos();
        int i2 = 0;
        int s2 = ml.size();
        while (i2 < s2) {
            Method m = ml.get(i2);
            m.setProgramModelInfo(this);
            this.element2container.put(m, cf);
            ++i2;
        }
        List<ConstructorInfo> cl = cf.getConstructorInfos();
        int i3 = 0;
        int s3 = cl.size();
        while (i3 < s3) {
            Constructor c = cl.get(i3);
            c.setProgramModelInfo(this);
            this.element2container.put(c, cf);
            ++i3;
        }
        if (cl.isEmpty() && !cf.isInterface() && !cf.isEnumType() && Character.isJavaIdentifierStart(cf.getName().charAt(0))) {
            Debug.log("No constructor defined in " + cf.getFullName());
        }
        if ((innerClasses = cf.getInnerClassNames()) != null) {
            String fullName = cf.getFullName();
            int i4 = 0;
            while (i4 < innerClasses.length) {
                String cn = innerClasses[i4];
                if (!cn.equals(fullName)) {
                    ni.getClassType(cn);
                }
                ++i4;
            }
        }
        String sname = cf.getSuperClassName();
        String[] inames = cf.getInterfaceNames();
        ArrayList<ClassType> list = new ArrayList<ClassType>(inames.length + 2);
        if (sname != null) {
            ClassType ct = ni.getClassType(sname);
            if (ct == null) {
                this.getErrorHandler().reportError(new MissingClassFileException("Unknown byte code supertype " + sname + " in class " + cf.getFullName(), sname));
            } else {
                List<TypeArgumentInfo> tais = cf.getSuperClassTypeArguments();
                if (tais != null && tais.size() > 0) {
                    ct = this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType(ct, tais);
                }
                list.add(ct);
            }
        }
        int i5 = 0;
        while (i5 < inames.length) {
            String iname = inames[i5];
            ClassType ct = ni.getClassType(iname);
            if (ct == null) {
                this.getErrorHandler().reportError(new MissingClassFileException("Unknown byte code supertype " + iname + " in class " + cf.getFullName(), iname));
            } else {
                List<TypeArgumentInfo> tais = cf.getSuperInterfaceTypeArguments(i5);
                if (tais != null && tais.size() > 0) {
                    ct = this.getServiceConfiguration().getImplicitElementInfo().getParameterizedType(ct, tais);
                }
                list.add(ct);
            }
            ++i5;
        }
        if (list.isEmpty() && cf != (jlo = ni.getJavaLangObject())) {
            list.add(jlo);
        }
        cfce.supertypes = list;
        i = 0;
        while (i < list.size()) {
            this.registerSubtype(cf, (ClassType)list.get(i));
            ++i;
        }
    }

    @Override
    public Type getAnnotationType(AnnotationUseInfo au) {
        return this.getNameInfo().getType(au.getFullReferencedName());
    }

    void clear() {
        this.containedTypes.clear();
        this.element2container.clear();
        this.method2signature.clear();
    }

    static class ClassFileCacheEntry
    extends DefaultProgramModelInfo.ClassTypeCacheEntry {
        ClassFileCacheEntry() {
        }
    }
}

