/*
 * Decompiled with CFR 0.152.
 */
package recoder.miniexamples;

import java.io.File;
import java.util.EventObject;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.abstraction.ClassType;
import recoder.convenience.ForestWalker;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.java.ProgramElement;
import recoder.java.expression.operator.Equals;
import recoder.kit.UnitKit;
import recoder.service.ErrorHandler;
import recoder.service.SourceInfo;

public class ProblematicStringComparisons {
    public static void main(String[] args) throws Exception {
        CrossReferenceServiceConfiguration crsc = new CrossReferenceServiceConfiguration();
        SourceFileRepository dsfr = crsc.getSourceFileRepository();
        String p = args[0];
        int i = 1;
        while (i < args.length) {
            p = String.valueOf(p) + File.pathSeparator + args[i];
            ++i;
        }
        crsc.getProjectSettings().setProperty("input.path", p);
        crsc.getProjectSettings().ensureSystemClassesAreInPath();
        crsc.getProjectSettings().setErrorHandler(new ErrorHandler(){

            @Override
            public void modelUpdating(EventObject event) {
            }

            @Override
            public void modelUpdated(EventObject event) {
            }

            @Override
            public void setErrorThreshold(int maxCount) {
            }

            @Override
            public void reportError(Exception e) throws RuntimeException {
            }

            @Override
            public int getErrorThreshold() {
                return Integer.MAX_VALUE;
            }
        });
        ClassType string = crsc.getNameInfo().getJavaLangString();
        SourceInfo si = crsc.getSourceInfo();
        List<CompilationUnit> cus = dsfr.getAllCompilationUnitsFromPath();
        ForestWalker fw = new ForestWalker(cus);
        while (fw.next()) {
            Equals eq;
            ProgramElement pe = fw.getProgramElement();
            if (!(pe instanceof Equals) || si.getType((eq = (Equals)pe).getExpressionAt(0)) != string || si.getType(eq.getExpressionAt(1)) != string) continue;
            ProblematicStringComparisons.printLocation(eq);
        }
    }

    private static void printLocation(ProgramElement pe) {
        System.out.println(String.valueOf(UnitKit.getCompilationUnit(pe).getPrimaryTypeDeclaration().getFullName()) + " line " + pe.getStartPosition().getLine() + " col " + pe.getStartPosition().getColumn());
    }
}

