/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4.methodRepl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.abstraction.ClassType;
import recoder.abstraction.Type;
import recoder.java.reference.TypeReference;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;

public class ReplaceOthers
extends TwoPassTransformation {
    private List<TypeReference> toRepl;
    private List<TypeReference> trRepls = new ArrayList<TypeReference>();

    public ReplaceOthers(CrossReferenceServiceConfiguration sc) {
        super(sc);
    }

    @Override
    public ProblemReport analyze() {
        ClassType coll = this.getNameInfo().getClassType("java.lang.StringBuilder");
        if (coll == null) {
            System.out.println("When using ReplaceEmptyCollections, please provide a JDK 1.5 or higher");
            return this.setProblemReport(IDENTITY);
        }
        this.toRepl = Collections.unmodifiableList(this.getServiceConfiguration().getCrossReferenceSourceInfo().getReferences(coll, true));
        for (TypeReference tr : this.toRepl) {
            this.trRepls.add(TypeKit.createTypeReference(this.getProgramFactory(), (Type)this.getNameInfo().getClassType("java.lang.StringBuffer"), tr.getDimensions()));
        }
        if (this.toRepl.size() == 0) {
            return this.setProblemReport(IDENTITY);
        }
        return this.setProblemReport(EQUIVALENCE);
    }

    @Override
    public void transform() {
        super.transform();
        int i = 0;
        for (TypeReference tr : this.toRepl) {
            this.replace(tr, this.trRepls.get(i));
            ++i;
        }
    }
}

