/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4.methodRepl;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ClassType;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;

public class ReplaceEmptyCollections
extends TwoPassTransformation {
    private List<MethodReference> replList = new ArrayList<MethodReference>();
    private List<MethodReference> replMap = new ArrayList<MethodReference>();
    private List<MethodReference> replSet = new ArrayList<MethodReference>();

    public ReplaceEmptyCollections(CrossReferenceServiceConfiguration sc) {
        super(sc);
    }

    @Override
    public ProblemReport analyze() {
        ClassType coll = this.getNameInfo().getClassType("java.util.Collections");
        Field list = null;
        Field map = null;
        Field set = null;
        for (Field field : coll.getFields()) {
            if ("EMPTY_LIST".equals(field.getName())) {
                list = field;
                continue;
            }
            if ("EMPTY_MAP".equals(field.getName())) {
                map = field;
                continue;
            }
            if (!"EMPTY_SET".equals(field.getName())) continue;
            set = field;
        }
        if (list == null) {
            System.out.println("When using ReplaceEmptyCollections, please provide a JDK 1.5 or higher");
            return this.setProblemReport(IDENTITY);
        }
        assert (map != null && set != null);
        for (Method method : coll.getMethods()) {
            List<MemberReference> refs;
            if ("emptyList".equals(method.getName())) {
                refs = this.getCrossReferenceSourceInfo().getReferences(method);
                for (MemberReference mr : refs) {
                    this.replList.add((MethodReference)mr);
                }
                continue;
            }
            if ("emptyMap".equals(method.getName())) {
                refs = this.getCrossReferenceSourceInfo().getReferences(method);
                for (MemberReference mr : refs) {
                    this.replMap.add((MethodReference)mr);
                }
                continue;
            }
            if (!"emptySet".equals(method.getName())) continue;
            refs = this.getCrossReferenceSourceInfo().getReferences(method);
            for (MemberReference mr : refs) {
                this.replSet.add((MethodReference)mr);
            }
        }
        if (this.replList.size() == 0 && this.replMap.size() == 0 && this.replSet.size() == 0) {
            return this.setProblemReport(IDENTITY);
        }
        return this.setProblemReport(EQUIVALENCE);
    }

    @Override
    public void transform() {
        FieldReference fr;
        ReferencePrefix prefix;
        super.transform();
        ProgramFactory f = this.getProgramFactory();
        for (MethodReference mr : this.replList) {
            prefix = mr.getReferencePrefix();
            fr = f.createFieldReference(f.createIdentifier("EMPTY_LIST"));
            fr.setReferencePrefix(prefix);
            if (prefix != null) {
                prefix.setReferenceSuffix(fr);
            }
            this.replace(mr, fr);
        }
        for (MethodReference mr : this.replMap) {
            prefix = mr.getReferencePrefix();
            fr = f.createFieldReference(f.createIdentifier("EMPTY_MAP"));
            fr.setReferencePrefix(prefix);
            if (prefix != null) {
                prefix.setReferenceSuffix(fr);
            }
            this.replace(mr, fr);
        }
        for (MethodReference mr : this.replSet) {
            prefix = mr.getReferencePrefix();
            fr = f.createFieldReference(f.createIdentifier("EMPTY_SET"));
            fr.setReferencePrefix(prefix);
            if (prefix != null) {
                prefix.setReferenceSuffix(fr);
            }
            this.replace(mr, fr);
        }
    }
}

