/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4.methodRepl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import recoder.CrossReferenceServiceConfiguration;
import recoder.abstraction.ClassType;
import recoder.abstraction.Constructor;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Type;
import recoder.bytecode.ByteCodeFormatException;
import recoder.bytecode.ByteCodeParser;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.NonTerminalProgramElement;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.TypeReference;
import recoder.kit.MiscKit;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.kit.UnitKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;

public class ApplyRetrotranslatorLibs
extends TwoPassTransformation {
    private final String pathToLibs;
    private Map<String, ClassType> completeReplacements = new HashMap<String, ClassType>();
    private Map<String, ClassType> partialReplacements = new HashMap<String, ClassType>();
    private final List<NonTerminalProgramElement[]> replacements = new ArrayList<NonTerminalProgramElement[]>();

    public ApplyRetrotranslatorLibs(CrossReferenceServiceConfiguration sc, String pathToLibs) {
        super(sc);
        this.pathToLibs = pathToLibs;
    }

    @Override
    public ProblemReport analyze() {
        ZipFile retroZip;
        ZipFile backportZip;
        try {
            backportZip = new ZipFile(String.valueOf(this.pathToLibs) + "/backport-util-concurrent-3.1.jar");
        }
        catch (IOException e) {
            System.out.println("Cannot find backport-util-concurrent lib! Aborting!");
            System.out.println("Searching In:\n" + new File(String.valueOf(this.pathToLibs) + "/backport-util-concurrent-3.1.jar").getAbsolutePath());
            return this.setProblemReport(new ProblemReport(){});
        }
        Enumeration<? extends ZipEntry> zes = backportZip.entries();
        while (zes.hasMoreElements()) {
            ClassType cf;
            ZipEntry ze = zes.nextElement();
            if (!ze.getName().endsWith(".class") || !ze.getName().startsWith("edu/emory/mathcs/backport/")) continue;
            try {
                cf = new ByteCodeParser().parseClassFile(backportZip.getInputStream(ze));
                cf = this.getNameInfo().getClassType(cf.getFullName());
            }
            catch (ByteCodeFormatException e) {
                System.out.println("Problem parsing class file: " + ze.getName());
                return this.setProblemReport(new ProblemReport(){});
            }
            catch (IOException e) {
                System.out.println("IOException while parsing file: " + ze.getName());
                return this.setProblemReport(new ProblemReport(){});
            }
            String cfName = cf.getFullName().substring("edu.emory.mathcs.backport.".length());
            this.completeReplacements.put(cfName, cf);
        }
        try {
            retroZip = new ZipFile(String.valueOf(this.pathToLibs) + "/retrotranslator-runtime-1.2.7-transformed.jar");
        }
        catch (IOException e) {
            System.out.println("Cannot find retrotranslator runtime! Aborting!");
            return this.setProblemReport(new ProblemReport(){});
        }
        zes = retroZip.entries();
        while (zes.hasMoreElements()) {
            ZipEntry ze = zes.nextElement();
            try {
                if (!ze.getName().endsWith(".class") || !ze.getName().startsWith("net/sf/retrotranslator/runtime/java")) continue;
                ClassType cf = new ByteCodeParser().parseClassFile(retroZip.getInputStream(ze));
                cf = this.getNameInfo().getClassType(cf.getFullName());
                String cfName = cf.getFullName().substring("net.sf.retrotranslator.runtime.".length());
                if (cfName.charAt(cfName.length() - 1) == '_') {
                    this.completeReplacements.put(cfName.substring(0, cfName.length() - 1), cf);
                    continue;
                }
                if (cfName.indexOf("_.") > 0) {
                    this.completeReplacements.put(cfName.replace("_.", "."), cf);
                    continue;
                }
                assert (cfName.indexOf("._") == cfName.lastIndexOf("._") && cfName.indexOf("._") > 0);
                cfName = cfName.replace("._", ".");
                this.partialReplacements.put(cfName, cf);
            }
            catch (ByteCodeFormatException e) {
                System.out.println("Problem parsing class file: " + ze.getName());
                return this.setProblemReport(new ProblemReport(){});
            }
            catch (IOException e) {
                System.out.println("IOException while parsing file: " + ze.getName());
                return this.setProblemReport(new ProblemReport(){});
            }
        }
        for (Map.Entry<String, ClassType> entry : this.partialReplacements.entrySet()) {
            ClassType ct = entry.getValue();
            List<? extends Field> fields = ct.getFields();
            List<Method> meths = ct.getMethods();
            List<? extends Constructor> constr = ct.getConstructors();
            for (Field field : fields) {
                if (!field.isPublic() || !field.isStatic()) continue;
                Field origF = this.getNameInfo().getField(String.valueOf(entry.getKey()) + "." + field.getName());
                if (origF == null) {
                    System.out.println("not found: " + entry.getKey() + "." + field.getName());
                    continue;
                }
                for (FieldReference r : this.getCrossReferenceSourceInfo().getReferences(origF)) {
                    FieldReference fr = this.getProgramFactory().createFieldReference(TypeKit.createTypeReference(this.getProgramFactory(), field.getContainingClassType()), this.getProgramFactory().createIdentifier(field.getName()));
                    this.replacements.add(new NonTerminalProgramElement[]{r, fr});
                }
            }
            for (Method method : meths) {
                if (!method.isPublic() || !method.isStatic() || method.getName().equals("convertConstructorArguments") || method.getFullName().equals("net.sf.retrotranslator.runtime.java.io._PrintStream.createInstanceBuilder") || method.getFullName().equals("net.sf.retrotranslator.runtime.java.lang._SecurityException.createInstanceBuilder") || method.getFullName().equals("net.sf.retrotranslator.runtime.java.io._PrintStream.initialize") || method.getFullName().equals("net.sf.retrotranslator.runtime.java.lang._SecurityException.initialize")) continue;
                List<Type> sig = method.getSignature();
                String sigStr = this.makeSigString(sig, true);
                List<Method> cand = this.getNameInfo().getMethods(String.valueOf(entry.getKey()) + "." + method.getName() + "(" + sigStr + ")");
                if (cand.size() == 0) {
                    if (method.isStatic()) continue;
                    sig.remove(0);
                    sigStr = this.makeSigString(sig, true);
                    cand = this.getNameInfo().getMethods(String.valueOf(entry.getKey()) + "." + method.getName() + "(" + sigStr + ")");
                    cand.size();
                    if (cand.size() == 0) continue;
                    for (Method toRepl : cand) {
                        for (MemberReference r : this.getCrossReferenceSourceInfo().getReferences(toRepl)) {
                            MethodReference mr = (MethodReference)r;
                            ReferencePrefix rp = mr.getReferencePrefix();
                            rp = rp == null ? this.getProgramFactory().createThisReference() : (ReferencePrefix)rp.deepClone();
                            ASTList<Object> newArgs = ((MethodReference)r).getArguments();
                            newArgs = newArgs == null ? new ASTArrayList<boolean>(true) : newArgs.deepClone();
                            newArgs.add(0, (Expression)((Object)rp));
                            MethodReference newRef = this.getProgramFactory().createMethodReference(TypeKit.createTypeReference(this.getProgramFactory(), ct.getFullName()), this.getProgramFactory().createIdentifier(method.getName()), newArgs);
                            this.replacements.add(new NonTerminalProgramElement[]{r, newRef});
                        }
                    }
                    continue;
                }
                if (cand.size() != 1) {
                    throw new RuntimeException();
                }
                Method toRepl2 = cand.get(0);
                for (MemberReference r : this.getCrossReferenceSourceInfo().getReferences(toRepl2)) {
                    MethodReference newRef = this.getProgramFactory().createMethodReference(TypeKit.createTypeReference(this.getProgramFactory(), ct.getFullName()), this.getProgramFactory().createIdentifier(method.getName()), ((MethodReference)r).getArguments().deepClone());
                    this.replacements.add(new NonTerminalProgramElement[]{r, newRef});
                }
            }
        }
        System.out.println("Found " + this.completeReplacements.size() + " classes for complete replacement");
        System.out.println("Found " + this.partialReplacements.size() + " classes for partial replacement");
        for (Map.Entry<String, ClassType> me : this.completeReplacements.entrySet()) {
            ClassType oldType;
            String name = me.getKey();
            int idx = name.lastIndexOf(".");
            if (idx != -1 && !Character.isJavaIdentifierStart(name.charAt(idx + 1)) || (oldType = this.getNameInfo().getClassType(name)) == null) continue;
            for (TypeReference tr : this.getCrossReferenceSourceInfo().getReferences(oldType, true)) {
                if (oldType.getFullName().equals("java.util.Collections") && tr.getReferenceSuffix() instanceof FieldReference) continue;
                this.replacements.add(new TypeReference[]{tr, TypeKit.createTypeReference(this.getProgramFactory(), (Type)me.getValue(), tr.getDimensions())});
            }
        }
        this.sortRepls(this.replacements);
        return this.setProblemReport(EQUIVALENCE);
    }

    private String makeSigString(List<Type> signature, boolean fullName) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Type t : signature) {
            if (!first) {
                result.append(',');
            } else {
                first = false;
            }
            if (fullName) {
                result.append(t.getFullName());
                continue;
            }
            result.append(t.getName());
        }
        return result.toString();
    }

    private void sortReplsLoc(List<NonTerminalProgramElement[]> casts) {
        boolean changed = true;
        NonTerminalProgramElement ntpe = null;
        while (changed) {
            changed = false;
            int i = 0;
            while (i < casts.size() - 1) {
                int j = i + 1;
                while (j < casts.size()) {
                    NonTerminalProgramElement ex2;
                    NonTerminalProgramElement ex1 = casts.get(i)[0];
                    ntpe = ex1;
                    if (this.isChild(ntpe, ex2 = casts.get(j)[0])) {
                        NonTerminalProgramElement[] tmp = casts.get(i);
                        casts.set(i, casts.get(j));
                        casts.set(j, tmp);
                        changed = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private boolean isChild(NonTerminalProgramElement ex1, NonTerminalProgramElement ex2) {
        if (ex1 == ex2) {
            return false;
        }
        return MiscKit.contains(ex1, ex2);
    }

    private void sortRepls(List<NonTerminalProgramElement[]> casts) {
        HashMap<CompilationUnit, ArrayList<NonTerminalProgramElement[]>> temp = new HashMap<CompilationUnit, ArrayList<NonTerminalProgramElement[]>>(casts.size());
        for (NonTerminalProgramElement[] cast : casts) {
            CompilationUnit decl = UnitKit.getCompilationUnit(cast[0]);
            ArrayList<NonTerminalProgramElement[]> al = (ArrayList<NonTerminalProgramElement[]>)temp.get(decl);
            if (al == null) {
                al = new ArrayList<NonTerminalProgramElement[]>(4);
                temp.put(decl, al);
            }
            al.add(cast);
        }
        casts.clear();
        for (ArrayList al : temp.values()) {
            this.sortReplsLoc(al);
            casts.addAll(al);
        }
    }

    @Override
    public void transform() {
        super.transform();
        for (NonTerminalProgramElement[] repl : this.replacements) {
            this.replace(repl[0], repl[1]);
        }
    }
}

