/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ArrayType;
import recoder.abstraction.Method;
import recoder.abstraction.Type;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.ProgramElement;
import recoder.java.Statement;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.expression.ArrayInitializer;
import recoder.java.expression.operator.NewArray;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.TypeReference;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.kit.transformation.java5to4.Util;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.SourceInfo;

public class ResolveVarArgs
extends TwoPassTransformation {
    private List<CompilationUnit> cul;
    private List<MethodDeclaration> varArgMeths;
    private List<Item> items;
    private List<TypeReference> newLastParamRefs;

    public ResolveVarArgs(CrossReferenceServiceConfiguration sc, CompilationUnit cu) {
        super(sc);
        this.cul = new ArrayList<CompilationUnit>();
        this.cul.add(cu);
    }

    public ResolveVarArgs(CrossReferenceServiceConfiguration sc, List<CompilationUnit> cul) {
        super(sc);
        this.cul = cul;
    }

    @Override
    public ProblemReport analyze() {
        SourceInfo si = this.getSourceInfo();
        this.varArgMeths = new ArrayList<MethodDeclaration>();
        this.items = new ArrayList<Item>();
        this.newLastParamRefs = new ArrayList<TypeReference>();
        for (CompilationUnit cu : this.cul) {
            TreeWalker tw = new TreeWalker(cu);
            while (tw.next()) {
                ASTList<Expression> args;
                ProgramElement pe = tw.getProgramElement();
                if (pe instanceof MethodDeclaration) {
                    MethodDeclaration md = (MethodDeclaration)pe;
                    if (!md.isVarArgMethod()) continue;
                    this.varArgMeths.add(md);
                    ArrayType t = si.getType(((ParameterDeclaration)md.getParameters().get(md.getParameters().size() - 1)).getTypeReference()).createArrayType();
                    this.newLastParamRefs.add(TypeKit.createTypeReference(this.getSourceInfo(), (Type)t, md));
                    continue;
                }
                if (!(pe instanceof MethodReference) && !(pe instanceof ConstructorReference)) continue;
                MemberReference mr = (MemberReference)pe;
                Method m = mr instanceof MethodReference ? this.getSourceInfo().getMethod((MethodReference)mr) : this.getSourceInfo().getConstructor((ConstructorReference)mr);
                ASTList<Expression> aSTList = args = mr instanceof MethodReference ? ((MethodReference)mr).getArguments() : ((ConstructorReference)mr).getArguments();
                if (!m.isVarArgMethod()) continue;
                if (args != null && args.size() == m.getSignature().size()) {
                    int idx = args.size() - 1;
                    Type tt = this.getSourceInfo().getType((Expression)args.get(idx));
                    if (tt instanceof ArrayType) continue;
                    List<Type> sig = m.getSignature();
                    TypeReference tr = TypeKit.createTypeReference(this.getSourceInfo(), sig.get(sig.size() - 1), mr);
                    this.items.add(new Item(mr, tr, sig.size() - 1));
                    continue;
                }
                if (args == null) {
                    if (mr instanceof MethodReference) {
                        ((MethodReference)mr).setArguments(new ASTArrayList<boolean>(true));
                    } else {
                        ((ConstructorReference)mr).setArguments(new ASTArrayList<boolean>(true));
                    }
                }
                List<Type> sig = m.getSignature();
                TypeReference tr = TypeKit.createTypeReference(this.getSourceInfo(), sig.get(sig.size() - 1), mr);
                this.items.add(new Item(mr, tr, sig.size() - 1));
            }
        }
        return super.analyze();
    }

    @Override
    public void transform() {
        super.transform();
        ProgramFactory f = this.getProgramFactory();
        Util.sortCasts(this.items);
        System.out.println("refs: " + this.items.size() + " varArgMeths: " + this.varArgMeths.size());
        for (Item item : this.items) {
            Statement repl;
            NewArray na;
            ArrayInitializer ai;
            int from = item.firstVA;
            int cnt = 0;
            ASTArrayList<Expression> eml = new ASTArrayList();
            if (item.memberReference instanceof MethodReference) {
                MethodReference methRef = (MethodReference)item.memberReference;
                cnt = methRef.getArguments() == null ? 0 : methRef.getArguments().size() - from;
                eml = new ASTArrayList<int>(cnt);
                int i = 0;
                while (i < cnt) {
                    eml.add(((Expression)methRef.getArguments().get(from + i)).deepClone());
                    ++i;
                }
                ai = f.createArrayInitializer(eml);
                na = f.createNewArray(item.newTypeRef, 0, ai);
                repl = methRef.deepClone();
                while (cnt-- > 0) {
                    ((MethodReference)repl).getArguments().remove(((MethodReference)repl).getArguments().size() - 1);
                }
                if (((MethodReference)repl).getArguments() == null) {
                    ((MethodReference)repl).setArguments(new ASTArrayList<boolean>(false));
                }
                ((MethodReference)repl).getArguments().add(na);
                ((MethodReference)repl).makeParentRoleValid();
                this.replace(item.memberReference, repl);
                continue;
            }
            if (!(item.memberReference instanceof ConstructorReference)) continue;
            ConstructorReference cRef = (ConstructorReference)item.memberReference;
            cnt = cRef.getArguments() == null ? 0 : cRef.getArguments().size() - from;
            eml = new ASTArrayList<int>(cnt);
            int i = 0;
            while (i < cnt) {
                eml.add(((Expression)cRef.getArguments().get(from + i)).deepClone());
                ++i;
            }
            ai = f.createArrayInitializer(eml);
            na = f.createNewArray(item.newTypeRef, 0, ai);
            repl = (ConstructorReference)cRef.deepClone();
            while (cnt-- > 0) {
                repl.getArguments().remove(repl.getArguments().size() - 1);
            }
            if (repl.getArguments() == null) {
                repl.setArguments(new ASTArrayList<boolean>(false));
            }
            repl.getArguments().add(na);
            repl.makeParentRoleValid();
            this.replace(item.memberReference, repl);
        }
        int idx = 0;
        for (MethodDeclaration md : this.varArgMeths) {
            MethodDeclaration repl = md.deepClone();
            ASTList<ParameterDeclaration> pds = md.getParameters();
            ParameterDeclaration pd = (ParameterDeclaration)pds.get(pds.size() - 1);
            ASTArrayList<DeclarationSpecifier> decls = null;
            if (pd.isFinal()) {
                decls = new ASTArrayList<DeclarationSpecifier>(f.createFinal());
            }
            ParameterDeclaration newpd = f.createParameterDeclaration(decls, this.newLastParamRefs.get(idx++), pd.getVariableSpecification().getIdentifier().deepClone());
            newpd.setVarArg(false);
            this.replace(repl.getParameterDeclarationAt(repl.getParameterDeclarationCount() - 1), newpd);
            repl.makeParentRoleValid();
            this.replace(md, repl);
        }
    }

    private static class Item
    implements Util.DepSortable {
        final MemberReference memberReference;
        final TypeReference newTypeRef;
        final int firstVA;

        @Override
        public ProgramElement getSortItem() {
            return this.memberReference;
        }

        Item(MemberReference mr, TypeReference newTypeRef, int firstVA) {
            this.memberReference = mr;
            this.newTypeRef = newTypeRef;
            this.firstVA = firstVA;
        }
    }
}

