/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ClassType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.expression.Assignment;
import recoder.java.expression.Operator;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.expression.operator.PostDecrement;
import recoder.java.expression.operator.PostIncrement;
import recoder.java.expression.operator.PreDecrement;
import recoder.java.expression.operator.PreIncrement;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.TypeReference;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.transformation.java5to4.Util;
import recoder.list.generic.ASTArrayList;
import recoder.service.NameInfo;
import recoder.service.SourceInfo;

public class ResolveBoxing
extends TwoPassTransformation {
    private NonTerminalProgramElement root;
    private List<CompilationUnit> cul;
    private List<Object[]> list = new ArrayList<Object[]>();

    public ResolveBoxing(CrossReferenceServiceConfiguration sc, NonTerminalProgramElement root) {
        super(sc);
        this.root = root;
    }

    public ResolveBoxing(CrossReferenceServiceConfiguration sc, List<CompilationUnit> cul) {
        super(sc);
        this.cul = cul;
    }

    private void traverse(TreeWalker tw) {
        SourceInfo si = this.getServiceConfiguration().getSourceInfo();
        NameInfo ni = this.getServiceConfiguration().getNameInfo();
        while (tw.next()) {
            ProgramElement pe = tw.getProgramElement();
            if (!(pe instanceof Expression) || pe instanceof ParenthesizedExpression) continue;
            Expression e = (Expression)pe;
            Type act = si.getType(e);
            if (act instanceof ClassType && (e instanceof PreDecrement || e instanceof PreIncrement || e instanceof PostIncrement || e instanceof PostDecrement)) {
                boolean needsParentheses = Util.getRequiredContextType(si, e) != null;
                boolean addAdjust = needsParentheses && (e instanceof PostDecrement || e instanceof PostIncrement);
                this.list.add(new Object[]{e, act, addAdjust, needsParentheses});
                continue;
            }
            Type req = Util.getRequiredContextType(si, e);
            if (act instanceof PrimitiveType && req instanceof ClassType && req != ni.getJavaLangString()) {
                this.list.add(new Object[]{e, act});
                continue;
            }
            if (!(act instanceof ClassType) || !(req instanceof PrimitiveType)) continue;
            this.list.add(new Object[]{e, act});
        }
    }

    @Override
    public ProblemReport analyze() {
        if (this.cul != null) {
            for (CompilationUnit cu : this.cul) {
                TreeWalker tw = new TreeWalker(cu);
                this.traverse(tw);
            }
        } else {
            TreeWalker tw = new TreeWalker(this.root);
            this.traverse(tw);
        }
        return super.analyze();
    }

    @Override
    public void transform() {
        super.transform();
        ProgramFactory f = this.getProgramFactory();
        SourceInfo si = this.getServiceConfiguration().getSourceInfo();
        System.out.println("To (un-)box: " + this.list.size());
        int i = this.list.size() - 1;
        while (i >= 0) {
            MethodReference replacement;
            Identifier id;
            boolean isPlus;
            Object[] op = this.list.get(i);
            Expression e = (Expression)op[0];
            Type t = (Type)op[1];
            boolean bl = isPlus = e instanceof PreIncrement || e instanceof PostIncrement;
            if (op.length == 4) {
                Assignment a = (Assignment)e;
                Operator repl = f.createCopyAssignment(a.getExpressionAt(0).deepClone(), f.createMethodReference(f.createTypeReference(this.makeBoxIdentifierForType(si.getUnboxedType((ClassType)t))), f.createIdentifier("valueOf"), new ASTArrayList<Expression>(isPlus ? f.createPlus(f.createMethodReference((ReferencePrefix)((Object)a.getExpressionAt(0).deepClone()), this.makeUnboxIdentifierForType((ClassType)t), null), f.createIntLiteral(1)) : f.createMinus(f.createMethodReference((ReferencePrefix)((Object)a.getExpressionAt(0).deepClone()), this.makeUnboxIdentifierForType((ClassType)t), null), f.createIntLiteral(1)))));
                if (((Boolean)op[3]).booleanValue()) {
                    repl = f.createParenthesizedExpression(repl);
                }
                if (((Boolean)op[2]).booleanValue()) {
                    repl = isPlus ? f.createMinus(repl, f.createIntLiteral(1)) : f.createPlus(repl, f.createIntLiteral(1));
                    repl = f.createParenthesizedExpression(repl);
                }
                this.replace(e, repl);
            } else if (t instanceof ClassType) {
                id = this.makeUnboxIdentifierForType((ClassType)t);
                ReferencePrefix rp = e instanceof ReferencePrefix ? (ReferencePrefix)((Object)e.deepClone()) : f.createParenthesizedExpression(e.deepClone());
                replacement = f.createMethodReference(rp, id);
                this.replace(e, replacement);
            } else {
                id = this.makeBoxIdentifierForType((PrimitiveType)t);
                TypeReference tr = f.createTypeReference(id);
                replacement = f.createMethodReference(tr, f.createIdentifier("valueOf"), new ASTArrayList<Expression>(e.deepClone()));
                this.replace(e, replacement);
            }
            --i;
        }
    }

    private Identifier makeUnboxIdentifierForType(ClassType t) {
        Identifier id;
        NameInfo ni = this.getNameInfo();
        ProgramFactory f = this.getProgramFactory();
        if (t == ni.getJavaLangBoolean()) {
            id = f.createIdentifier("booleanValue");
        } else if (t == ni.getJavaLangByte()) {
            id = f.createIdentifier("byteValue");
        } else if (t == ni.getJavaLangShort()) {
            id = f.createIdentifier("shortValue");
        } else if (t == ni.getJavaLangCharacter()) {
            id = f.createIdentifier("charValue");
        } else if (t == ni.getJavaLangInteger()) {
            id = f.createIdentifier("intValue");
        } else if (t == ni.getJavaLangLong()) {
            id = f.createIdentifier("longValue");
        } else if (t == ni.getJavaLangFloat()) {
            id = f.createIdentifier("floatValue");
        } else if (t == ni.getJavaLangDouble()) {
            id = f.createIdentifier("doubleValue");
        } else {
            throw new Error("cannot unbox type " + t.getFullName() + " (" + t.getClass() + ")\n");
        }
        return id;
    }

    private Identifier makeBoxIdentifierForType(PrimitiveType t) {
        Identifier id;
        NameInfo ni = this.getNameInfo();
        ProgramFactory f = this.getProgramFactory();
        if (t == ni.getBooleanType()) {
            id = f.createIdentifier("Boolean");
        } else if (t == ni.getByteType()) {
            id = f.createIdentifier("Byte");
        } else if (t == ni.getShortType()) {
            id = f.createIdentifier("Short");
        } else if (t == ni.getCharType()) {
            id = f.createIdentifier("Character");
        } else if (t == ni.getIntType()) {
            id = f.createIdentifier("Integer");
        } else if (t == ni.getLongType()) {
            id = f.createIdentifier("Long");
        } else if (t == ni.getFloatType()) {
            id = f.createIdentifier("Float");
        } else if (t == ni.getDoubleType()) {
            id = f.createIdentifier("Double");
        } else {
            System.out.println("cannot box: " + t + " " + t);
            throw new Error();
        }
        return id;
    }
}

