/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.retrotranslator.transformer.Retrotranslator;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.EnumConstant;
import recoder.abstraction.Field;
import recoder.abstraction.Type;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.LoopInitializer;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ClassInitializer;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.EnumConstantDeclaration;
import recoder.java.declaration.EnumConstantSpecification;
import recoder.java.declaration.EnumDeclaration;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.LocalVariableDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.modifier.Abstract;
import recoder.java.declaration.modifier.Static;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.expression.operator.New;
import recoder.java.expression.operator.NewArray;
import recoder.java.reference.ArrayReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.SpecialConstructorReference;
import recoder.java.reference.SuperConstructorReference;
import recoder.java.reference.TypeReference;
import recoder.java.statement.Case;
import recoder.java.statement.For;
import recoder.java.statement.If;
import recoder.java.statement.Switch;
import recoder.kit.MiscKit;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.DefaultNameInfo;
import recoder.service.NameInfo;
import recoder.service.SourceInfo;
import recoder.util.FileUtils;

public class ReplaceEnumsNew
extends TwoPassTransformation {
    private static final String ENUM_REPLACEMENT_TYPE = "net.sf.retrotranslator.runtime.java.lang.Enum_";
    private static final String ENUMSET_REPLACEMENT_TYPE = "net.sf.retrotranslator.runtime.java.util.EnumSet_";
    private static final String ENUMMAP_REPLACEMENT_TYPE = "net.sf.retrotranslator.runtime.java.util.EnumMap_";
    private static final String ORDINAL_VALUE_CONSTANT_FIELD_PREFIX = "";
    private static final String ORDINAL_VALUE_CONSTANT_FIELD_SUFFIX = "__ORD_VALUE__";
    private List<TransObj> trans;
    private List<EnumDeclaration> enums;
    private List<CompilationUnit> detach;

    public ReplaceEnumsNew(CrossReferenceServiceConfiguration sc) {
        super(sc);
    }

    @Override
    public ProblemReport analyze() {
        this.trans = new ArrayList<TransObj>();
        this.enums = new ArrayList<EnumDeclaration>();
        this.detach = new ArrayList<CompilationUnit>(5);
        SourceInfo si = this.getSourceInfo();
        NameInfo ni = this.getNameInfo();
        ProgramFactory pf = this.getProgramFactory();
        TypeReference enumRefProto = TypeKit.createTypeReference(pf, ENUM_REPLACEMENT_TYPE);
        TypeReference enumSetProto = TypeKit.createTypeReference(pf, ENUMSET_REPLACEMENT_TYPE);
        TypeReference enumMapProto = TypeKit.createTypeReference(pf, ENUMMAP_REPLACEMENT_TYPE);
        Type t = ni.getType("java.lang.Enum");
        if (t instanceof TypeDeclaration) {
            this.detach.add((CompilationUnit)((TypeDeclaration)t).getASTParent());
        }
        if ((t = ni.getType("java.util.RegularEnumSet")) instanceof TypeDeclaration) {
            this.detach.add((CompilationUnit)((TypeDeclaration)t).getASTParent());
        }
        if ((t = ni.getType("java.util.EnumMap")) instanceof TypeDeclaration) {
            this.detach.add((CompilationUnit)((TypeDeclaration)t).getASTParent());
        }
        if ((t = ni.getType("java.util.EnumSet")) instanceof TypeDeclaration) {
            this.detach.add((CompilationUnit)((TypeDeclaration)t).getASTParent());
        }
        if ((t = ni.getType("java.util.JumboEnumSet")) instanceof TypeDeclaration) {
            this.detach.add((CompilationUnit)((TypeDeclaration)t).getASTParent());
        }
        for (CompilationUnit cu : this.getSourceFileRepository().getCompilationUnits()) {
            TreeWalker tw = new TreeWalker(cu);
            while (tw.next()) {
                TypeReference repl;
                ProgramElement pe = tw.getProgramElement();
                if (pe instanceof CompilationUnit && this.detach.contains(pe)) continue;
                if (pe instanceof EnumDeclaration) {
                    this.enums.add((EnumDeclaration)pe);
                    continue;
                }
                if (pe instanceof Expression && pe.getASTParent() instanceof Switch) {
                    Type type = si.getType((Expression)pe);
                    if (!(type instanceof ClassType) || !((ClassType)type).isEnumType()) continue;
                    this.trans.add(new TransObj(pe, pf.createMethodReference((ReferencePrefix)pe.deepClone(), pf.createIdentifier("ordinal"))));
                    continue;
                }
                if (pe instanceof FieldReference) {
                    NonTerminalProgramElement parent;
                    Field f;
                    FieldReference fr = (FieldReference)pe;
                    if (fr.getReferencePrefix() != null || !((f = (Field)si.getVariable((FieldReference)pe)) instanceof EnumConstant) || !((parent = pe.getASTParent()) instanceof Case)) continue;
                    this.trans.add(new TransObj(pe, pf.createFieldReference(TypeKit.createTypeReference(si, (Type)f.getContainingClassType(), MiscKit.getParentTypeDeclaration(parent)), pf.createIdentifier(f.getName() + ORDINAL_VALUE_CONSTANT_FIELD_SUFFIX))));
                    continue;
                }
                if (!(pe instanceof TypeReference)) continue;
                TypeReference tr = (TypeReference)pe;
                t = si.getType(tr);
                while (t instanceof ArrayType) {
                    t = ((ArrayType)t).getBaseType();
                }
                if (t == ni.getJavaLangEnum()) {
                    repl = enumRefProto.deepClone();
                    repl.setDimensions(tr.getDimensions());
                } else if (t == ni.getClassType("java.util.EnumMap")) {
                    repl = enumMapProto.deepClone();
                    repl.setDimensions(tr.getDimensions());
                } else {
                    if (t != ni.getClassType("java.util.EnumSet")) continue;
                    repl = enumSetProto.deepClone();
                    repl.setDimensions(tr.getDimensions());
                }
                this.trans.add(new TransObj(pe, repl));
            }
        }
        if (this.detach.isEmpty() && this.enums.isEmpty() && this.trans.isEmpty()) {
            return this.setProblemReport(IDENTITY);
        }
        return this.setProblemReport(NO_PROBLEM);
    }

    private ClassDeclaration makeReplacement(EnumDeclaration ed) {
        ProgramFactory f = this.getProgramFactory();
        ASTArrayList<MemberDeclaration> members = new ASTArrayList<MemberDeclaration>();
        ClassDeclaration res = f.createClassDeclaration(ed.getDeclarationSpecifiers() == null ? null : ed.getDeclarationSpecifiers().deepClone(), ed.getIdentifier().deepClone(), f.createExtends(TypeKit.createTypeReference(f, ENUM_REPLACEMENT_TYPE)), ed.getImplementedTypes() == null ? null : ed.getImplementedTypes().deepClone(), members);
        boolean hasStatic = false;
        if (res.getDeclarationSpecifiers() != null) {
            for (DeclarationSpecifier ds : res.getDeclarationSpecifiers()) {
                if (!(ds instanceof Static)) continue;
                hasStatic = true;
                break;
            }
        }
        if (!hasStatic && ed.getParent() instanceof TypeDeclaration) {
            Static stat = new Static();
            if (res.getDeclarationSpecifiers() == null) {
                res.setDeclarationSpecifiers(new ASTArrayList<boolean>(true));
            }
            res.getDeclarationSpecifiers().add(stat);
            stat.setParent(res);
        }
        if (ed.getComments() != null) {
            res.setComments(ed.getComments().deepClone());
        }
        boolean hasConstructor = false;
        ArrayList<FieldSpecification> enumConstantRepls = new ArrayList<FieldSpecification>();
        int ord = 0;
        boolean needsAbstract = false;
        for (MemberDeclaration md : ed.getMembers()) {
            if (md instanceof ClassInitializer) {
                members.add(md.deepClone());
                continue;
            }
            if (md instanceof EnumConstantDeclaration) {
                EnumConstantDeclaration ec = (EnumConstantDeclaration)md;
                EnumConstantSpecification ecs = ec.getEnumConstantSpecification();
                ASTArrayList<DeclarationSpecifier> dsml = new ASTArrayList<DeclarationSpecifier>();
                if (ec.getAnnotations() != null) {
                    for (AnnotationUseSpecification a : ec.getAnnotations()) {
                        dsml.add(a.deepClone());
                    }
                }
                dsml.add(f.createFinal());
                dsml.add(f.createPublic());
                dsml.add(f.createStatic());
                FieldDeclaration fd = f.createFieldDeclaration(dsml, f.createTypeReference(ed.getIdentifier().deepClone()), ecs.getIdentifier().deepClone(), null);
                FieldSpecification fs = (FieldSpecification)fd.getFieldSpecifications().get(0);
                enumConstantRepls.add(fs);
                dsml = new ASTArrayList();
                dsml.add(f.createPublic());
                dsml.add(f.createStatic());
                dsml.add(f.createFinal());
                FieldDeclaration constDecl = f.createFieldDeclaration(dsml, f.createTypeReference(f.createIdentifier("int")), f.createIdentifier(ecs.getName() + ORDINAL_VALUE_CONSTANT_FIELD_SUFFIX), f.createIntLiteral(ord));
                members.add(constDecl);
                New e = f.createNew();
                e.setTypeReference(f.createTypeReference(ed.getIdentifier().deepClone()));
                ASTArrayList<int> args = null;
                if (ecs.getConstructorReference().getArguments() != null || ecs.getConstructorReference().getClassDeclaration() != null) {
                    ASTList<Expression> ecsargs = ecs.getConstructorReference().getArguments();
                    int s = ecsargs == null ? 0 : ecsargs.size();
                    args = new ASTArrayList<int>(s + 2);
                    int j = 0;
                    while (j < s) {
                        args.add((int)((Expression)ecsargs.get(j)).deepClone());
                        ++j;
                    }
                    if (ecs.getConstructorReference().getClassDeclaration() != null) {
                        ClassDeclaration cd = ecs.getConstructorReference().getClassDeclaration().deepClone();
                        e.setClassDeclaration(cd);
                    }
                } else {
                    args = new ASTArrayList<int>(2);
                }
                args.add((int)f.createStringLiteral("\"" + ecs.getIdentifier().getText() + "\""));
                args.add((int)f.createIntLiteral(ord));
                e.setArguments(args);
                fs.setInitializer(e);
                e.makeParentRoleValid();
                fs.makeParentRoleValid();
                fd.makeParentRoleValid();
                members.add(fd);
                ++ord;
                continue;
            }
            if (md instanceof FieldDeclaration) {
                members.add(md.deepClone());
                continue;
            }
            if (md instanceof ConstructorDeclaration) {
                ASTList<Object> superRefArgs;
                hasConstructor = true;
                ConstructorDeclaration cd = (ConstructorDeclaration)md.deepClone();
                cd.getParameters().add(f.createParameterDeclaration(f.createTypeReference(f.createIdentifier("String")), f.createIdentifier("__name")));
                cd.getParameters().add(f.createParameterDeclaration(f.createTypeReference(f.createIdentifier("int")), f.createIdentifier("__ord")));
                if (cd.getBody().getBody().size() > 0 && cd.getBody().getBody().get(0) instanceof SpecialConstructorReference) {
                    SpecialConstructorReference scr = (SpecialConstructorReference)cd.getBody().getBody().get(0);
                    superRefArgs = scr.getArguments();
                    superRefArgs.add((int)f.createVariableReference(f.createIdentifier("__name")));
                    superRefArgs.add(f.createVariableReference(f.createIdentifier("__ord")));
                } else {
                    superRefArgs = new ASTArrayList<int>(2);
                    superRefArgs.add((int)f.createVariableReference(f.createIdentifier("__name")));
                    superRefArgs.add((int)f.createVariableReference(f.createIdentifier("__ord")));
                    cd.getBody().getBody().add(0, f.createSuperConstructorReference(superRefArgs));
                }
                cd.makeAllParentRolesValid();
                members.add(cd);
                continue;
            }
            if (md instanceof MethodDeclaration) {
                members.add(md.deepClone());
                if (!((MethodDeclaration)md).isAbstract()) continue;
                needsAbstract = true;
                continue;
            }
            if (md instanceof EnumDeclaration) {
                members.add(this.makeReplacement((EnumDeclaration)md));
                continue;
            }
            if (!(md instanceof TypeDeclaration)) continue;
            members.add(md.deepClone());
        }
        if (needsAbstract) {
            Abstract abstr = f.createAbstract();
            if (res.getDeclarationSpecifiers() == null) {
                res.setDeclarationSpecifiers(new ASTArrayList<boolean>(true));
            }
            res.getDeclarationSpecifiers().add(abstr);
            abstr.setParent(res);
        }
        if (!hasConstructor) {
            ASTArrayList<boolean> block = new ASTArrayList<boolean>(true);
            ASTArrayList<int> scrArgs = new ASTArrayList<int>(2);
            scrArgs.add((int)f.createVariableReference(f.createIdentifier("name")));
            scrArgs.add((int)f.createVariableReference(f.createIdentifier("ord")));
            SuperConstructorReference scr = f.createSuperConstructorReference(scrArgs);
            block.add((boolean)scr);
            StatementBlock body = f.createStatementBlock(block);
            ASTArrayList<int> constrParams = new ASTArrayList<int>(2);
            constrParams.add((int)f.createParameterDeclaration(f.createTypeReference(f.createIdentifier("String")), f.createIdentifier("name")));
            constrParams.add((int)f.createParameterDeclaration(f.createTypeReference(f.createIdentifier("int")), f.createIdentifier("ord")));
            ConstructorDeclaration newConstructor = f.createConstructorDeclaration(f.createPrivate(), ed.getIdentifier().deepClone(), constrParams, null, body);
            members.add(newConstructor);
        }
        MethodDeclaration values = f.createMethodDeclaration();
        MethodDeclaration valueOf = f.createMethodDeclaration();
        MethodDeclaration compareTo = f.createMethodDeclaration();
        values.setIdentifier(f.createIdentifier("values"));
        valueOf.setIdentifier(f.createIdentifier("valueOf"));
        compareTo.setIdentifier(f.createIdentifier("compareTo"));
        ASTList<DeclarationSpecifier> declSpecs = new ASTArrayList<DeclarationSpecifier>();
        declSpecs.add(f.createPublic());
        compareTo.setDeclarationSpecifiers(declSpecs.deepClone());
        declSpecs.add(f.createStatic());
        values.setDeclarationSpecifiers(declSpecs);
        declSpecs = declSpecs.deepClone();
        valueOf.setDeclarationSpecifiers(declSpecs);
        values.setTypeReference(f.createTypeReference(ed.getIdentifier().deepClone(), 1));
        valueOf.setTypeReference(f.createTypeReference(ed.getIdentifier().deepClone()));
        compareTo.setTypeReference(f.createTypeReference(f.createIdentifier("int")));
        valueOf.setParameters(new ASTArrayList<ParameterDeclaration>(f.createParameterDeclaration(TypeKit.createTypeReference(f, "String"), f.createIdentifier("name"))));
        compareTo.setParameters(new ASTArrayList<ParameterDeclaration>(f.createParameterDeclaration(f.createTypeReference(f.createIdentifier("Object")), f.createIdentifier("o"))));
        StatementBlock valuesSt = f.createStatementBlock();
        StatementBlock valueOfSt = f.createStatementBlock();
        StatementBlock compareToSt = f.createStatementBlock();
        values.setBody(valuesSt);
        valueOf.setBody(valueOfSt);
        compareTo.setBody(compareToSt);
        ParenthesizedExpression pExpr = f.createParenthesizedExpression(f.createTypeCast(f.createVariableReference(f.createIdentifier("o")), f.createTypeReference(ed.getIdentifier().deepClone())));
        FieldReference fRef = f.createFieldReference(f.createIdentifier("ordinal"));
        pExpr.setReferenceSuffix(fRef);
        fRef.setReferencePrefix(pExpr);
        pExpr.makeParentRoleValid();
        fRef.makeParentRoleValid();
        compareToSt.setBody(new ASTArrayList<Statement>(f.createReturn(f.createMethodReference(f.createSuperReference(), f.createIdentifier("compareTo"), new ASTArrayList<Expression>(f.createTypeCast(f.createVariableReference(f.createIdentifier("o")), TypeKit.createTypeReference(f, ENUM_REPLACEMENT_TYPE)))))));
        NewArray na = f.createNewArray();
        na.setTypeReference(f.createTypeReference(ed.getIdentifier().deepClone(), 1));
        na.setArrayInitializer(f.createArrayInitializer(new ASTArrayList<int>(enumConstantRepls.size())));
        na.makeParentRoleValid();
        valuesSt.setBody(new ASTArrayList<Statement>(f.createReturn(na)));
        ASTArrayList<Statement> stmtList = new ASTArrayList<Statement>();
        valueOfSt.setBody(stmtList);
        If ite = f.createIf();
        LocalVariableDeclaration lvd = f.createLocalVariableDeclaration(null, TypeKit.createTypeReference(f, "int"), f.createIdentifier("i"), f.createIntLiteral(0));
        FieldReference fieldRef = f.createFieldReference(f.createIdentifier("length"));
        MethodReference methRef = f.createMethodReference(f.createIdentifier("values"));
        fieldRef.setReferencePrefix(methRef.deepClone());
        fieldRef.makeAllParentRolesValid();
        For fst = f.createFor(new ASTArrayList<LoopInitializer>(lvd), f.createLessThan(f.createVariableReference(f.createIdentifier("i")), fieldRef.deepClone()), new ASTArrayList<Expression>(f.createPostIncrement(f.createVariableReference(f.createIdentifier("i")))), ite);
        methRef = f.createMethodReference(f.createIdentifier("values"));
        ArrayReference arrRef = f.createArrayReference(methRef, new ASTArrayList<Expression>(f.createVariableReference(f.createIdentifier("i"))));
        arrRef.setReferencePrefix(methRef.deepClone());
        arrRef.makeParentRoleValid();
        ArrayReference arrRef2 = arrRef.deepClone();
        methRef = f.createMethodReference(f.createIdentifier("name"));
        methRef.setReferencePrefix(arrRef.deepClone());
        methRef.makeParentRoleValid();
        MethodReference methRef2 = f.createMethodReference(f.createIdentifier("equals"), new ASTArrayList<Expression>(f.createVariableReference(f.createIdentifier("name"))));
        methRef2.setReferencePrefix(methRef.deepClone());
        methRef2.makeParentRoleValid();
        ite.setExpression(methRef2.deepClone());
        ite.setThen(f.createThen(f.createReturn(arrRef2)));
        ite.makeParentRoleValid();
        stmtList.add(fst);
        stmtList.add(f.createThrow(f.createNew(null, f.createTypeReference(f.createIdentifier("IllegalArgumentException")), null)));
        fst.makeParentRoleValid();
        int i = 0;
        while (i < enumConstantRepls.size()) {
            FieldSpecification fs = (FieldSpecification)enumConstantRepls.get(i);
            na.getArrayInitializer().getArguments().add(f.createFieldReference(fs.getIdentifier().deepClone()));
            ++i;
        }
        na.getArrayInitializer().makeParentRoleValid();
        valuesSt.makeParentRoleValid();
        valueOfSt.makeParentRoleValid();
        compareToSt.makeParentRoleValid();
        compareTo.makeParentRoleValid();
        values.makeParentRoleValid();
        valueOf.makeParentRoleValid();
        members.add(values);
        members.add(valueOf);
        members.add(compareTo);
        res.makeParentRoleValid();
        return res;
    }

    @Override
    public void transform() {
        super.transform();
        for (CompilationUnit det : this.detach) {
            this.detach(det);
        }
        int i = this.trans.size() - 1;
        while (i >= 0) {
            TransObj to = this.trans.get(i);
            this.replace(to.pe, to.repl);
            --i;
        }
        i = this.enums.size() - 1;
        while (i >= 0) {
            EnumDeclaration ed = this.enums.get(i);
            this.replace(ed, this.makeReplacement(ed));
            --i;
        }
        this.runRetrotranslator();
    }

    private void runRetrotranslator() {
        System.out.println("Running Retrotranslator");
        String inputPath = this.getServiceConfiguration().getProjectSettings().getProperty("input.path");
        String outputPath = this.getServiceConfiguration().getProjectSettings().getProperty("output.path");
        StringTokenizer st = new StringTokenizer(inputPath, File.pathSeparator);
        StringBuffer newInputPath = new StringBuffer(inputPath.length());
        File destDir = new File(String.valueOf(outputPath) + File.separator + "_transformed_bytecode_");
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.replace("/", "\\").startsWith(FileUtils.getPathOfExtensionClassesDir().getAbsolutePath().replace("/", "\\")) || s.replace("/", "\\").startsWith(FileUtils.getPathOfSystemClasses().getAbsolutePath().replace("/", "\\"))) {
                newInputPath.append(s);
                newInputPath.append(File.pathSeparator);
                continue;
            }
            boolean jar = s.endsWith(".jar");
            String dest = String.valueOf(destDir.getAbsolutePath()) + (jar ? s.substring(s.lastIndexOf(File.separator), s.length()) : ORDINAL_VALUE_CONSTANT_FIELD_PREFIX);
            Retrotranslator.main((String[])new String[]{jar ? "-srcjar" : "-srcdir", s, jar ? "-destjar" : "-destdir", dest, "-stripsign"});
            newInputPath.append(dest);
            newInputPath.append(File.pathSeparator);
        }
        this.getServiceConfiguration().getProjectSettings().setProperty("input.path", newInputPath.toString());
        System.out.println("New input_path: " + this.getServiceConfiguration().getProjectSettings().getProperty("input.path"));
        System.out.println("---");
        ((DefaultNameInfo)this.getNameInfo()).resetBytecode();
    }

    static class TransObj {
        final ProgramElement pe;
        final ProgramElement repl;

        TransObj(ProgramElement pe, ProgramElement repl) {
            this.pe = pe;
            this.repl = repl;
        }
    }
}

