/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.Method;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.ResolvedGenericMethod;
import recoder.abstraction.Type;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Import;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.NameReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.ReferenceSuffix;
import recoder.java.reference.TypeReference;
import recoder.java.statement.Case;
import recoder.kit.MiscKit;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.list.generic.ASTList;
import recoder.service.DefaultSourceInfo;

public class RemoveStaticImports
extends TwoPassTransformation {
    private List<CompilationUnit> cul;
    private List<Item> hotSpots;
    private List<Import> allStatics;

    public RemoveStaticImports(CrossReferenceServiceConfiguration sc, CompilationUnit cu) {
        super(sc);
        this.cul = new ArrayList<CompilationUnit>();
        this.cul.add(cu);
    }

    public RemoveStaticImports(CrossReferenceServiceConfiguration sc, List<CompilationUnit> cul) {
        super(sc);
        this.cul = cul;
    }

    @Override
    public ProblemReport analyze() {
        this.hotSpots = new ArrayList<Item>();
        this.allStatics = new ArrayList<Import>();
        for (CompilationUnit cu : this.cul) {
            ArrayList<Import> statics = new ArrayList<Import>();
            ASTList<Import> il = cu.getImports();
            if (il == null || il.isEmpty()) continue;
            int i = 0;
            int s = il.size();
            while (i < s) {
                Import im = (Import)il.get(i);
                if (im.isStaticImport()) {
                    statics.add(im);
                }
                ++i;
            }
            if (statics.isEmpty()) continue;
            TreeWalker tw = new TreeWalker(cu);
            block2: while (tw.next()) {
                ClassType targetCT;
                ProgramElement pe = tw.getProgramElement();
                if (pe instanceof TypeDeclaration) {
                    TypeDeclaration typeDeclaration = (TypeDeclaration)pe;
                }
                if (!(pe instanceof MemberReference) || !(pe instanceof ReferenceSuffix) || !(pe instanceof NameReference)) continue;
                MemberReference r = (MemberReference)pe;
                ReferenceSuffix s2 = (ReferenceSuffix)pe;
                NameReference nr = (NameReference)pe;
                if (s2.getReferencePrefix() != null) continue;
                if (r instanceof MethodReference) {
                    targetCT = this.getSourceInfo().getMethod((MethodReference)r).getContainingClassType();
                } else if (r instanceof FieldReference) {
                    targetCT = this.getSourceInfo().getField((FieldReference)r).getContainingClassType();
                    if (targetCT.isEnumType() && r.getASTParent() instanceof Case) {
                        continue;
                    }
                } else {
                    if (!(r instanceof TypeReference)) continue;
                    Type t = this.getSourceInfo().getType((TypeReference)r);
                    while (t instanceof ArrayType) {
                        t = ((ArrayType)t).getBaseType();
                    }
                    if (!(t instanceof ClassType)) continue;
                    targetCT = (ClassType)t;
                    while (targetCT.getContainingClassType() != null) {
                        targetCT = targetCT.getContainingClassType();
                    }
                }
                if (targetCT instanceof TypeDeclaration && MiscKit.getParentTypeDeclaration((TypeDeclaration)targetCT) == targetCT) continue;
                String n = nr.getName();
                int i2 = 0;
                int si = statics.size();
                while (i2 < si) {
                    block22: {
                        Import im;
                        block21: {
                            TypeReference tr;
                            block25: {
                                List<Method> meths;
                                ProgramModelElement res;
                                DefaultSourceInfo dsi;
                                block24: {
                                    block19: {
                                        block23: {
                                            block20: {
                                                im = (Import)statics.get(i2);
                                                tr = im.getTypeReference();
                                                dsi = (DefaultSourceInfo)this.getSourceInfo();
                                                if (!im.isMultiImport()) break block19;
                                                if (!(pe instanceof FieldReference)) break block20;
                                                if (dsi.getField((FieldReference)pe) == dsi.getVariableFromStaticOnDemandImport(((FieldReference)pe).getName(), Collections.singletonList(im), MiscKit.getParentTypeDeclaration(pe))) break block21;
                                                break block22;
                                            }
                                            if (!(pe instanceof MethodReference)) break block23;
                                            res = dsi.getMethod((MethodReference)pe);
                                            if (res instanceof ResolvedGenericMethod) {
                                                res = ((ResolvedGenericMethod)res).getGenericMethod();
                                            }
                                            if ((meths = dsi.getMethodsFromStaticOnDemandImports((MethodReference)pe, Collections.singletonList(im))).size() == 1 && res == meths.get(0)) break block21;
                                            break block22;
                                        }
                                        res = dsi.getType((TypeReference)pe);
                                        ClassType type = dsi.getFromPackageImports(((TypeReference)pe).getName(), Collections.singletonList(im), cu.getTypeDeclarationCount() == 0 ? null : cu.getTypeDeclarationAt(0));
                                        if (type == res && (!(r instanceof TypeReference) || !n.equals(im.getTypeReference().getName()))) break block21;
                                        break block22;
                                    }
                                    if (!(pe instanceof FieldReference)) break block24;
                                    if (dsi.getField((FieldReference)pe) == dsi.getVariableFromStaticSingleImport(((FieldReference)pe).getName(), Collections.singletonList(im), MiscKit.getParentTypeDeclaration(pe))) break block21;
                                    break block22;
                                }
                                if (!(pe instanceof MethodReference)) break block25;
                                res = dsi.getMethod((MethodReference)pe);
                                if (res instanceof ResolvedGenericMethod) {
                                    res = ((ResolvedGenericMethod)res).getGenericMethod();
                                }
                                if ((meths = dsi.getMethodsFromStaticSingleImports((MethodReference)pe, Collections.singletonList(im))).size() == 1 && res == meths.get(0)) break block21;
                                break block22;
                            }
                            if ((ClassType)this.getSourceInfo().getType(tr) != targetCT || !n.equals(im.getStaticIdentifier().getText())) break block22;
                        }
                        TypeReference prefix = im.getTypeReference();
                        this.hotSpots.add(new Item(nr, prefix));
                        continue block2;
                    }
                    ++i2;
                }
            }
            this.allStatics.addAll(statics);
        }
        return super.analyze();
    }

    private boolean isChild(NonTerminalProgramElement nr1, NameReference nr2) {
        int c = 0;
        while (c < nr1.getChildCount()) {
            if (nr1.getChildAt(c) instanceof NameReference) {
                NameReference tmp = (NameReference)nr1.getChildAt(c);
                if (tmp.equals(nr2)) {
                    return true;
                }
                return this.isChild(tmp, nr2);
            }
            if (nr1.getChildAt(c) instanceof NonTerminalProgramElement) {
                return this.isChild((NonTerminalProgramElement)nr1.getChildAt(c), nr2);
            }
            ++c;
        }
        return false;
    }

    private void sortReferences(List<Item> its) {
        boolean changed = true;
        while (changed) {
            changed = false;
            int i = 0;
            while (i < its.size() - 1) {
                int j = i + 1;
                while (j < its.size()) {
                    Item it1 = its.get(i);
                    Item it2 = its.get(j);
                    if (this.isChild(it1.r, it2.r)) {
                        Item tmp = its.get(i);
                        its.set(i, it2);
                        its.set(j, tmp);
                        changed = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void transform() {
        super.transform();
        this.sortReferences(this.hotSpots);
        System.out.println("static imports: " + this.allStatics.size() + " hotSpots: " + this.hotSpots.size());
        for (Import i : this.allStatics) {
            this.detach(i);
        }
        for (Item hs : this.hotSpots) {
            TypeReference tr;
            MiscKit.unindent(hs.r);
            if (hs.r instanceof MethodReference) {
                MethodReference mr = (MethodReference)hs.r;
                tr = hs.prefix.deepClone();
                mr.setReferencePrefix(tr);
                mr.makeParentRoleValid();
                this.getChangeHistory().attached(tr);
                continue;
            }
            if (hs.r instanceof TypeReference) {
                this.attach((ReferencePrefix)hs.prefix.deepClone(), (TypeReference)hs.r);
                continue;
            }
            FieldReference fr = (FieldReference)hs.r;
            tr = hs.prefix.deepClone();
            fr.setReferencePrefix(tr);
            fr.makeParentRoleValid();
            this.getChangeHistory().attached(tr);
        }
    }

    private static class Item {
        NameReference r;
        TypeReference prefix;

        Item(NameReference r, TypeReference prefix) {
            this.r = r;
            this.prefix = prefix;
        }
    }
}

