/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ErasedMethod;
import recoder.abstraction.Member;
import recoder.abstraction.Method;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.bytecode.MethodInfo;
import recoder.convenience.ForestWalker;
import recoder.java.CompilationUnit;
import recoder.java.ProgramElement;
import recoder.java.StatementContainer;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.expression.operator.TypeCast;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.TypeReference;
import recoder.kit.MethodKit;
import recoder.kit.MiscKit;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.kit.transformation.java5to4.Util;
import recoder.service.CrossReferenceSourceInfo;
import recoder.service.SourceInfo;

public class RemoveCoVariantReturnTypes
extends TwoPassTransformation {
    private Dictionary<Method, Type> visitedMethods;
    private List<CompilationUnit> cul;
    private List<Util.IntroduceCast> casts;
    private List<ReturnTypeRefReplacement> covariantReturnTypes;
    private ArrayList<TypeDeclaration> workList = new ArrayList();
    private HashSet<ClassType> seenClasses = new HashSet();

    public RemoveCoVariantReturnTypes(CrossReferenceServiceConfiguration sc, List<CompilationUnit> cul) {
        super(sc);
        this.cul = cul;
    }

    private void handleTypeDeclaration(TypeDeclaration td) {
        CrossReferenceSourceInfo si = this.getCrossReferenceSourceInfo();
        for (Method m : td.getMethods()) {
            if (m.getReturnType() == null || this.visited(m) != null || m.getReturnType() instanceof PrimitiveType) continue;
            List<Method> meths = MethodKit.getAllRelatedMethods(si, m);
            for (Method toadd : meths) {
                this.visitedMethods.put(toadd, this.getNameInfo().getUnknownType());
            }
            if (meths.size() <= 1) continue;
            ClassType returnType = null;
            for (Method redefined : meths) {
                ClassType rt = (ClassType)redefined.getReturnType();
                rt = rt.getBaseClassType();
                if (returnType == null) {
                    returnType = rt;
                    continue;
                }
                if (returnType == rt) continue;
                if (si.isSubtype(returnType, rt)) {
                    returnType = rt;
                    continue;
                }
                if (si.isSubtype(rt, returnType)) continue;
                returnType = this.getNameInfo().getJavaLangObject();
                break;
            }
            for (Method redefined : meths) {
                if (!(redefined instanceof MethodDeclaration) || returnType == redefined.getReturnType()) continue;
                this.createItem((MethodDeclaration)redefined, returnType);
            }
        }
    }

    @Override
    public ProblemReport analyze() {
        this.visitedMethods = new Hashtable<Method, Type>();
        this.casts = new ArrayList<Util.IntroduceCast>();
        this.covariantReturnTypes = new ArrayList<ReturnTypeRefReplacement>();
        SourceInfo si = this.getSourceInfo();
        ForestWalker fw = new ForestWalker(this.cul);
        while (fw.next()) {
            List<Method> lm;
            Type retType;
            ProgramElement pe = fw.getProgramElement();
            if (pe instanceof TypeDeclaration) {
                this.handleTypeDeclaration((TypeDeclaration)pe);
                continue;
            }
            if (!(pe instanceof MethodReference)) continue;
            MethodReference mr = (MethodReference)pe;
            Method m = si.getMethod(mr);
            if (m instanceof ErasedMethod) {
                m = ((ErasedMethod)m).getGenericMethod();
            }
            if (m instanceof ArrayType.ArrayCloneMethod) {
                Type req = Util.getRequiredContextType(si, mr);
                if (mr.getASTParent() instanceof TypeCast || req == null || req == this.getNameInfo().getJavaLangObject()) continue;
                this.casts.add(new Util.IntroduceCast(mr, TypeKit.createTypeReference(si, m.getReturnType(), mr, false)));
                continue;
            }
            if (!(m instanceof MethodInfo) || (retType = m.getReturnType()) == null || retType instanceof PrimitiveType || (lm = MethodKit.getAllRedefinedMethods(m)).isEmpty()) continue;
            ArrayList<ClassType> types = new ArrayList<ClassType>(lm.size());
            for (Method om : lm) {
                types.add((ClassType)om.getReturnType());
            }
            ClassType newCT = si.getCommonSupertype(types.toArray(new ClassType[lm.size()]));
            ClassType req = (ClassType)Util.getRequiredContextType(si, mr);
            if (req == null || si.isSubtype(newCT, req)) continue;
            this.casts.add(new Util.IntroduceCast(mr, TypeKit.createTypeReference(si, (Type)req, mr, false)));
        }
        if (this.casts.isEmpty() && this.covariantReturnTypes.isEmpty()) {
            return this.setProblemReport(IDENTITY);
        }
        return super.analyze();
    }

    private Type visited(Method md) {
        return this.visitedMethods.get(md);
    }

    private void createItem(MethodDeclaration md, ClassType originalType) {
        this.visitedMethods.put(md, originalType);
        List<MemberReference> references = this.getCrossReferenceSourceInfo().getReferences(md);
        TypeReference newReturnTypeReference = TypeKit.createTypeReference(this.getSourceInfo(), (Type)originalType, md, false);
        this.covariantReturnTypes.add(new ReturnTypeRefReplacement(md.getTypeReference(), newReturnTypeReference));
        for (MemberReference memRef : references) {
            MethodReference mr = (MethodReference)memRef;
            Type reqType = Util.getRequiredContextType(this.getSourceInfo(), mr);
            if (reqType == null || this.getSourceInfo().isSubtype(originalType, (ClassType)reqType)) continue;
            if (!this.getSourceInfo().isVisibleFor((Member)((Object)reqType), MiscKit.getParentTypeDeclaration(mr))) {
                reqType = this.getSourceInfo().getType(mr);
            }
            this.casts.add(new Util.IntroduceCast(mr, TypeKit.createTypeReference(this.getSourceInfo(), reqType, mr, false)));
        }
    }

    @Override
    public void transform() {
        super.transform();
        System.out.println("casts: " + this.casts.size() + " covariantReturnTypes: " + this.covariantReturnTypes.size());
        ProgramFactory f = this.getProgramFactory();
        for (ReturnTypeRefReplacement rtrr : this.covariantReturnTypes) {
            if (rtrr.typeParamRef.getASTParent().getIndexOfChild(rtrr.typeParamRef) == -1) continue;
            this.replace(rtrr.typeParamRef, rtrr.replacement);
        }
        Util.sortCasts(this.casts);
        for (Util.IntroduceCast c : this.casts) {
            MiscKit.unindent(c.toBeCasted);
            if (c.toBeCasted.getASTParent().getIndexOfChild(c.toBeCasted) == -1 || c.toBeCasted.getASTParent() instanceof StatementContainer) continue;
            this.replace(c.toBeCasted, f.createParenthesizedExpression(f.createTypeCast(c.toBeCasted.deepClone(), c.castedType)));
        }
    }

    private static class ReturnTypeRefReplacement {
        TypeReference typeParamRef;
        TypeReference replacement;

        ReturnTypeRefReplacement(TypeReference from, TypeReference to) {
            this.typeParamRef = from;
            this.replacement = to;
        }
    }
}

