/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Import;
import recoder.java.NonTerminalProgramElement;
import recoder.java.PackageSpecification;
import recoder.java.ProgramElement;
import recoder.java.declaration.AnnotationDeclaration;
import recoder.java.declaration.AnnotationPropertyDeclaration;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.reference.PackageReference;
import recoder.java.reference.TypeReference;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;

public class RemoveAnnotations
extends TwoPassTransformation {
    private NonTerminalProgramElement root;
    private List<CompilationUnit> cul;
    private List<AnnotationUseSpecification> toRemove;
    private List<AnnotationDeclaration> unusedAnnotationTypes;
    private List<AnnotationDeclaration> usedAnnotationTypes;
    private List<Import> imports;

    public RemoveAnnotations(CrossReferenceServiceConfiguration sc, NonTerminalProgramElement root) {
        super(sc);
        this.root = root;
    }

    public RemoveAnnotations(CrossReferenceServiceConfiguration sc, List<CompilationUnit> cul) {
        super(sc);
        this.cul = cul;
    }

    private void traverse(TreeWalker tw) {
        while (tw.next()) {
            int i;
            ProgramElement pe = tw.getProgramElement();
            if (pe instanceof AnnotationUseSpecification) {
                this.toRemove.add((AnnotationUseSpecification)pe);
                continue;
            }
            if (pe instanceof AnnotationDeclaration) {
                AnnotationDeclaration ad = (AnnotationDeclaration)pe;
                List<TypeReference> trl = this.getServiceConfiguration().getCrossReferenceSourceInfo().getReferences(ad, true);
                boolean remove = true;
                i = 0;
                while (i < trl.size()) {
                    if (!(trl.get(i).getASTParent() instanceof AnnotationUseSpecification)) {
                        remove = false;
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < ad.getMembers().size()) {
                    MemberDeclaration md = (MemberDeclaration)ad.getMembers().get(i);
                    if (md instanceof TypeDeclaration) {
                        remove = false;
                        break;
                    }
                    ++i;
                }
                if (remove) {
                    this.unusedAnnotationTypes.add(ad);
                    continue;
                }
                this.usedAnnotationTypes.add(ad);
                continue;
            }
            if (!(pe instanceof Import)) continue;
            Import imp = (Import)pe;
            PackageReference pr = imp.getPackageReference();
            block3: while (pr != null) {
                if (pr.getName().equals("annotation") || pr.getName().equals("reflect")) {
                    this.imports.add(imp);
                }
                int numChild = pr.getChildCount();
                i = 0;
                while (i < numChild) {
                    if (pr.getChildAt(i) instanceof PackageReference) {
                        pr = (PackageReference)pr.getChildAt(i);
                        continue block3;
                    }
                    if (i == numChild - 1) {
                        pr = null;
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public ProblemReport analyze() {
        this.toRemove = new ArrayList<AnnotationUseSpecification>(100);
        this.unusedAnnotationTypes = new ArrayList<AnnotationDeclaration>(10);
        this.usedAnnotationTypes = new ArrayList<AnnotationDeclaration>(10);
        this.imports = new ArrayList<Import>(10);
        if (this.cul != null && this.cul.size() > 0) {
            for (CompilationUnit cu : this.cul) {
                TreeWalker tw = new TreeWalker(cu);
                this.traverse(tw);
            }
        } else if (this.root != null) {
            TreeWalker tw = new TreeWalker(this.root);
            this.traverse(tw);
        }
        return super.analyze();
    }

    @Override
    public void transform() {
        super.transform();
        System.out.println("toRemove: " + this.toRemove.size() + " unusedAnnotationTypes: " + this.unusedAnnotationTypes.size() + " usedAnnotationsTypes: " + this.usedAnnotationTypes.size());
        for (AnnotationUseSpecification au : this.toRemove) {
            if (!(au.getASTParent() instanceof PackageSpecification) || au.getASTParent() instanceof PackageSpecification && ((PackageSpecification)au.getASTParent()).getAnnotations() != null) {
                this.detach(au);
            }
            if (!(au.getASTParent() instanceof PackageSpecification)) continue;
            PackageSpecification ps = (PackageSpecification)au.getASTParent();
            ps.setAnnotations(null);
        }
        for (AnnotationDeclaration ad : this.unusedAnnotationTypes) {
            this.detach(ad);
        }
        for (AnnotationDeclaration ad : this.usedAnnotationTypes) {
            this.replace(ad, this.makeInterface(ad));
        }
    }

    private InterfaceDeclaration makeInterface(AnnotationDeclaration ad) {
        ProgramFactory f = this.getProgramFactory();
        InterfaceDeclaration replacement = this.getProgramFactory().createInterfaceDeclaration();
        replacement.setExtendedTypes(f.createExtends(TypeKit.createTypeReference(f, "java.lang.annotation.Annotation")));
        ASTList<MemberDeclaration> oldMems = ad.getMembers();
        ASTArrayList<int> newMems = new ASTArrayList<int>(oldMems.size());
        int i = 0;
        while (i < oldMems.size()) {
            MemberDeclaration newMD;
            MemberDeclaration md = (MemberDeclaration)oldMems.get(i);
            if (md instanceof AnnotationPropertyDeclaration) {
                AnnotationPropertyDeclaration apd = (AnnotationPropertyDeclaration)md;
                MethodDeclaration m = f.createMethodDeclaration();
                if (apd.getComments() != null) {
                    m.setComments(apd.getComments().deepClone());
                }
                m.setIdentifier(apd.getIdentifier().deepClone());
                m.setTypeReference(apd.getTypeReference().deepClone());
                newMD = m;
            } else {
                newMD = md instanceof AnnotationDeclaration ? this.makeInterface((AnnotationDeclaration)md) : md.deepClone();
            }
            newMD.makeParentRoleValid();
            newMems.add((int)newMD);
            ++i;
        }
        replacement.setIdentifier(ad.getIdentifier().deepClone());
        replacement.setMembers(newMems);
        if (ad.getComments() != null) {
            replacement.setComments(ad.getComments().deepClone());
        }
        replacement.setDeclarationSpecifiers(ad.getDeclarationSpecifiers().deepClone());
        replacement.makeParentRoleValid();
        return replacement;
    }
}

