/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ClassType;
import recoder.abstraction.IntersectionType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.abstraction.TypeParameter;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.expression.operator.Conditional;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.TypeReference;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.kit.transformation.java5to4.Util;

public class MakeConditionalCompatible
extends TwoPassTransformation {
    private NonTerminalProgramElement root;
    private List<CompilationUnit> cul;
    private List<Item> list;
    private List<Conditional> visited;

    public MakeConditionalCompatible(CrossReferenceServiceConfiguration sc, NonTerminalProgramElement root) {
        super(sc);
        this.root = root;
    }

    public MakeConditionalCompatible(CrossReferenceServiceConfiguration sc, List<CompilationUnit> cul) {
        super(sc);
        this.cul = cul;
    }

    private Type nestedConditionals(Conditional c, int deepth) {
        int i;
        ParenthesizedExpression pe;
        boolean inner = true;
        Type p = null;
        Type t = this.getSourceInfo().getType(c);
        Expression e1 = c.getExpressionAt(1);
        Expression e2 = c.getExpressionAt(2);
        Type t1 = this.getSourceInfo().getType(c.getExpressionAt(1));
        Type t2 = this.getSourceInfo().getType(c.getExpressionAt(2));
        if (e1 instanceof Conditional) {
            p = this.nestedConditionals((Conditional)e1, deepth + 1);
            inner = false;
        }
        if (e1 instanceof ParenthesizedExpression) {
            pe = (ParenthesizedExpression)e1;
            i = 0;
            while (i < pe.getChildCount()) {
                if (pe.getChildAt(i) instanceof Conditional) {
                    p = this.nestedConditionals((Conditional)pe.getChildAt(i), deepth + 1);
                    inner = false;
                }
                ++i;
            }
        }
        if (e2 instanceof Conditional) {
            p = this.nestedConditionals((Conditional)e2, deepth + 1);
            inner = false;
        }
        if (e2 instanceof ParenthesizedExpression) {
            pe = (ParenthesizedExpression)e2;
            i = 0;
            while (i < pe.getChildCount()) {
                if (pe.getChildAt(i) instanceof Conditional) {
                    p = this.nestedConditionals((Conditional)pe.getChildAt(i), deepth + 1);
                    inner = false;
                }
                ++i;
            }
        }
        if (inner) {
            p = t1;
        }
        if (!(!(t instanceof IntersectionType) && (t1 == t2 || t1 instanceof PrimitiveType && t2 instanceof PrimitiveType || t1 == this.getNameInfo().getNullType() || t2 == this.getNameInfo().getNullType() || this.getSourceInfo().isWidening(t1, t2) || this.getSourceInfo().isWidening(t2, t1)))) {
            NonTerminalProgramElement parent = c.getASTParent();
            Type target = Util.getRequiredContextType(this.getSourceInfo(), c);
            if (target == null) {
                target = this.getNameInfo().getJavaLangString();
            }
            if (t1 instanceof TypeParameter) {
                if ((((TypeParameter)t1).getBoundCount() != 0 || target != this.getNameInfo().getJavaLangObject()) && this.getClassTypeFromTypeParameter((TypeParameter)t1, 0) != target) {
                    TypeReference tr = TypeKit.createTypeReference(this.getSourceInfo(), target, c);
                    this.list.add(new Item(c, target, tr, p, this.getSourceInfo().getType(c.getExpressionAt(1)), this.getSourceInfo().getType(c.getExpressionAt(2))));
                }
            } else if (t2 instanceof TypeParameter) {
                if ((((TypeParameter)t2).getBoundCount() != 0 || target != this.getNameInfo().getJavaLangObject()) && this.getClassTypeFromTypeParameter((TypeParameter)t2, 0) != target) {
                    TypeReference tr = TypeKit.createTypeReference(this.getSourceInfo(), target, c);
                    this.list.add(new Item(c, target, tr, p, this.getSourceInfo().getType(c.getExpressionAt(1)), this.getSourceInfo().getType(c.getExpressionAt(2))));
                }
            } else {
                TypeReference tr = TypeKit.createTypeReference(this.getSourceInfo(), target, c);
                this.list.add(new Item(c, target, tr, p, this.getSourceInfo().getType(c.getExpressionAt(1)), this.getSourceInfo().getType(c.getExpressionAt(2))));
            }
        }
        this.visited.add(c);
        return p;
    }

    private ClassType getClassTypeFromTypeParameter(TypeParameter tp, int i) {
        ClassType t = this.getNameInfo().getClassType(tp.getBoundName(i));
        return t;
    }

    @Override
    public ProblemReport analyze() {
        this.list = new ArrayList<Item>();
        this.visited = new ArrayList<Conditional>();
        this.setProblemReport(NO_PROBLEM);
        if (this.cul != null) {
            for (CompilationUnit cu : this.cul) {
                this.root = cu;
                TreeWalker tw = new TreeWalker(this.root);
                while (tw.next()) {
                    Conditional c;
                    ProgramElement pe = tw.getProgramElement();
                    if (!(pe instanceof Conditional) || this.visited.contains(c = (Conditional)pe)) continue;
                    this.nestedConditionals(c, 0);
                }
            }
        } else {
            TreeWalker tw = new TreeWalker(this.root);
            while (tw.next()) {
                Conditional c;
                ProgramElement pe = tw.getProgramElement();
                if (!(pe instanceof Conditional) || this.visited.contains(c = (Conditional)pe)) continue;
                this.nestedConditionals(c, 0);
            }
        }
        if (this.list.isEmpty()) {
            return IDENTITY;
        }
        return NO_PROBLEM;
    }

    @Override
    public void transform() {
        super.transform();
        ProgramFactory f = this.getProgramFactory();
        System.out.println("Conditionals to be transformed: " + this.list.size());
        for (Item i : this.list) {
            boolean toString;
            Expression e1 = i.c.getExpressionAt(1);
            Expression e2 = i.c.getExpressionAt(2);
            Type t1 = i.st1;
            Type t2 = i.st2;
            boolean bl = toString = i.t == this.getNameInfo().getJavaLangString();
            if (toString) {
                if (t1 != this.getNameInfo().getJavaLangString()) {
                    this.replace(e1, f.createMethodReference((ReferencePrefix)((Object)e1.deepClone()), f.createIdentifier("toString")));
                }
                if (t2 == this.getNameInfo().getJavaLangString()) continue;
                this.replace(e2, f.createMethodReference((ReferencePrefix)((Object)e2.deepClone()), f.createIdentifier("toString")));
                continue;
            }
            if (t1 != i.t) {
                this.replace(e1, f.createTypeCast(e1.deepClone(), i.tr.deepClone()));
            }
            if (t2 == i.t) continue;
            this.replace(e2, f.createTypeCast(e2.deepClone(), i.tr));
        }
    }

    private static class Item {
        Conditional c;
        Type t;
        Type st1;
        Type st2;
        Type p;
        TypeReference tr;

        Item(Conditional c, Type t, TypeReference tr, Type p, Type st1, Type st2) {
            if (t == null) {
                throw new NullPointerException();
            }
            this.c = c;
            this.t = t;
            this.tr = tr;
            this.p = p;
            this.st1 = st1;
            this.st2 = st2;
        }
    }
}

