/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.convenience.ForestWalker;
import recoder.java.CompilationUnit;
import recoder.java.ProgramElement;
import recoder.java.expression.literal.DoubleLiteral;
import recoder.java.expression.literal.FloatLiteral;
import recoder.kit.ProblemReport;
import recoder.kit.Transformation;

public class FloatingPoints
extends Transformation {
    private final List<CompilationUnit> cus;

    public FloatingPoints(CrossReferenceServiceConfiguration sc, List<CompilationUnit> cus) {
        super(sc);
        this.cus = cus;
    }

    @Override
    public ProblemReport execute() {
        ForestWalker fw = new ForestWalker(this.cus);
        while (fw.next()) {
            DoubleLiteral dl;
            ProgramElement pe = fw.getProgramElement();
            if (pe instanceof FloatLiteral) {
                FloatLiteral fl = (FloatLiteral)pe;
                if (!fl.getValue().toLowerCase().startsWith("0x")) continue;
                this.replace(fl, this.getProgramFactory().createFloatLiteral(Float.valueOf(fl.getValue()).floatValue()));
                continue;
            }
            if (!(pe instanceof DoubleLiteral) || !(dl = (DoubleLiteral)pe).getValue().toLowerCase().startsWith("0x")) continue;
            this.replace(dl, this.getProgramFactory().createDoubleLiteral(Double.valueOf(dl.getValue())));
        }
        return this.setProblemReport(NO_PROBLEM);
    }
}

