/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.Method;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.kit.MethodKit;
import recoder.kit.MissingSources;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.service.CrossReferenceSourceInfo;

public class RenameMethod
extends TwoPassTransformation {
    private Method methodToRename;
    private String newName;
    private List<MethodDeclaration> methods;
    private List<MethodReference> refs;

    public RenameMethod(CrossReferenceServiceConfiguration sc, MethodDeclaration method, String newName) {
        super(sc);
        if (method == null) {
            throw new IllegalArgumentException("Missing method");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Missing name");
        }
        this.methodToRename = method;
        this.newName = newName;
    }

    @Override
    public ProblemReport analyze() {
        if (this.newName.equals(this.methodToRename.getName())) {
            return this.setProblemReport(IDENTITY);
        }
        CrossReferenceSourceInfo xr = this.getCrossReferenceSourceInfo();
        this.methods = new ArrayList<MethodDeclaration>();
        List<Method> relatedMethods = MethodKit.getAllRelatedMethods(xr, this.methodToRename);
        ArrayList<Method> problems = null;
        int i = relatedMethods.size() - 1;
        while (i >= 0) {
            Method m = relatedMethods.get(i);
            if (m instanceof MethodDeclaration) {
                this.methods.add((MethodDeclaration)m);
            } else {
                if (problems == null) {
                    problems = new ArrayList<Method>();
                }
                problems.add(m);
            }
            --i;
        }
        if (problems != null) {
            return this.setProblemReport(new MissingMethodDeclarations(problems));
        }
        this.refs = new ArrayList<MethodReference>();
        int j = this.methods.size() - 1;
        while (j >= 0) {
            MethodDeclaration mdecl = this.methods.get(j);
            List<MemberReference> mrefs = xr.getReferences(mdecl);
            int i2 = 0;
            int s = mrefs.size();
            while (i2 < s) {
                MemberReference mr = mrefs.get(i2);
                if (mr instanceof MethodReference) {
                    this.refs.add((MethodReference)mr);
                }
                ++i2;
            }
            --j;
        }
        return this.setProblemReport(EQUIVALENCE);
    }

    @Override
    public void transform() {
        super.transform();
        ProgramFactory pf = this.getProgramFactory();
        int i = this.methods.size() - 1;
        while (i >= 0) {
            this.replace(this.methods.get(i).getIdentifier(), pf.createIdentifier(this.newName));
            --i;
        }
        i = this.refs.size() - 1;
        while (i >= 0) {
            this.replace(this.refs.get(i).getIdentifier(), pf.createIdentifier(this.newName));
            --i;
        }
    }

    public List<MethodDeclaration> getRenamedMethods() {
        return this.methods;
    }

    public static class MissingMethodDeclarations
    extends MissingSources {
        private static final long serialVersionUID = 9214788084198236635L;
        private List<Method> nonMethodDeclarations;

        MissingMethodDeclarations(List<Method> nonMethodDeclarations) {
            this.nonMethodDeclarations = nonMethodDeclarations;
        }

        public List<Method> getNonMethodDeclarations() {
            return this.nonMethodDeclarations;
        }
    }
}

