/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.abstraction.Type;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.ExpressionContainer;
import recoder.java.ProgramElement;
import recoder.java.declaration.Throws;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.expression.Operator;
import recoder.java.expression.operator.TypeCast;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.service.SourceInfo;
import recoder.util.ProgressListener;
import recoder.util.ProgressListenerManager;

public class RemoveRedundantTypeReferences
extends TwoPassTransformation {
    private List<CompilationUnit> units;
    private List<TypeReference> references;
    private boolean removeInterfaces;
    private boolean removeExceptions;
    private boolean removeTypeCasts;
    private ProgressListenerManager listeners = new ProgressListenerManager(this);

    public RemoveRedundantTypeReferences(CrossReferenceServiceConfiguration sc) {
        this(sc, sc.getSourceFileRepository().getCompilationUnits(), true, true, true);
    }

    public RemoveRedundantTypeReferences(CrossReferenceServiceConfiguration sc, List<CompilationUnit> list, boolean removeInterfaces, boolean removeExceptions, boolean removeTypeCasts) {
        super(sc);
        if (list == null) {
            throw new IllegalArgumentException("Missing units");
        }
        this.units = list;
        this.references = new ArrayList<TypeReference>();
        this.removeInterfaces = removeInterfaces;
        this.removeExceptions = removeExceptions;
        this.removeTypeCasts = removeTypeCasts;
    }

    public void addProgressListener(ProgressListener l) {
        this.listeners.addProgressListener(l);
    }

    public void removeProgressListener(ProgressListener l) {
        this.listeners.removeProgressListener(l);
    }

    @Override
    public ProblemReport analyze() {
        SourceInfo si = this.getSourceInfo();
        this.listeners.fireProgressEvent(0, this.units.size(), "Checking Type References");
        int i = 0;
        while (i < this.units.size()) {
            TreeWalker tw = new TreeWalker(this.units.get(i));
            while (tw.next()) {
                ProgramElement p = tw.getProgramElement();
                if (this.removeInterfaces && p instanceof TypeDeclaration) {
                    this.references.addAll(TypeKit.getRedundantSuperInterfaces(si, (TypeDeclaration)p));
                    continue;
                }
                if (this.removeExceptions && p instanceof Throws) {
                    this.references.addAll(TypeKit.getRedundantExceptions(si, (Throws)p));
                    continue;
                }
                if (!this.removeTypeCasts || !(p instanceof TypeCast)) continue;
                TypeCast tc = (TypeCast)p;
                Type td = si.getType(tc.getTypeReference());
                Type te = si.getType(tc.getExpressionAt(0));
                ExpressionContainer parent = tc.getExpressionContainer();
                if (parent instanceof MethodReference || parent instanceof ConstructorReference || parent instanceof Operator) {
                    if (te != td) continue;
                    this.references.add(tc.getTypeReference());
                    continue;
                }
                if (!si.isWidening(te, td)) continue;
                this.references.add(tc.getTypeReference());
            }
            this.listeners.fireProgressEvent(i + 1);
            ++i;
        }
        return this.setProblemReport(this.references.isEmpty() ? IDENTITY : EQUIVALENCE);
    }

    @Override
    public void transform() {
        TypeReferenceContainer con;
        TypeReference tr;
        super.transform();
        int i = this.references.size() - 1;
        while (i >= 0) {
            tr = this.references.get(i);
            con = tr.getParent();
            if (!(con instanceof TypeCast)) {
                if (con.getChildCount() == 1) {
                    this.detach(con);
                } else {
                    this.detach(tr);
                }
            }
            --i;
        }
        i = this.references.size() - 1;
        while (i >= 0) {
            tr = this.references.get(i);
            con = tr.getParent();
            if (con instanceof TypeCast) {
                Expression child = ((TypeCast)con).getExpressionAt(0);
                this.replace(con, child.deepClone());
            }
            --i;
        }
    }

    public List<TypeReference> getTypeReferenceList() {
        return this.references;
    }

    public List<CompilationUnit> getCompilationUnits() {
        return this.units;
    }
}

