/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation;

import recoder.CrossReferenceServiceConfiguration;
import recoder.java.NonTerminalProgramElement;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.StatementContainer;
import recoder.java.declaration.LocalVariableDeclaration;
import recoder.kit.Conflict;
import recoder.kit.NoProblem;
import recoder.kit.ProblemReport;
import recoder.kit.StatementKit;
import recoder.kit.TwoPassTransformation;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;

public class PrepareStatementList
extends TwoPassTransformation {
    private Statement statement;
    private Statement statementRepl;
    private StatementBlock block;
    private ASTList<Statement> list;
    private boolean isVisible;

    public PrepareStatementList(CrossReferenceServiceConfiguration sc, Statement s, boolean isVisible) {
        super(sc);
        if (s == null) {
            throw new IllegalArgumentException("Missing statement");
        }
        this.statement = s;
        this.isVisible = isVisible;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public ProblemReport analyze() {
        NoProblem report = IDENTITY;
        StatementContainer con = this.statement.getStatementContainer();
        if (con == null) {
            this.list = new ASTArrayList<Statement>(this.statement);
        } else {
            this.list = StatementKit.getStatementMutableList(this.statement);
            if (this.list == null) {
                NonTerminalProgramElement parent = this.statement.getASTParent();
                this.block = this.getProgramFactory().createStatementBlock();
                this.block.setBody(new ASTArrayList<boolean>(true));
                this.list = this.block.getBody();
                if (!(parent instanceof StatementContainer)) {
                    return new IllegalParentContext(parent);
                }
                report = this.statement instanceof LocalVariableDeclaration ? NO_PROBLEM : EQUIVALENCE;
                if (this.isVisible()) {
                    this.statementRepl = this.statement.deepClone();
                }
            }
        }
        return this.setProblemReport(report);
    }

    @Override
    public void transform() {
        super.transform();
        if (this.block != null) {
            this.replace(this.statement, this.block);
            this.attach(this.statementRepl, this.block, 0);
        }
    }

    public StatementBlock getBlock() {
        return this.block;
    }

    public ASTList<Statement> getStatementList() {
        return this.list;
    }

    public Statement getStatement() {
        return this.statementRepl != null ? this.statementRepl : this.statement;
    }

    public static class IllegalParentContext
    extends Conflict {
        private static final long serialVersionUID = -1995165154877949565L;
        private NonTerminalProgramElement parent;

        public IllegalParentContext(NonTerminalProgramElement parent) {
            this.parent = parent;
        }

        public NonTerminalProgramElement getParent() {
            return this.parent;
        }
    }
}

